/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.gui.HistoryTextField;
import org.gjt.sp.jedit.gui.VariableGridLayout;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.SearchSettingsChanged;
import org.gjt.sp.jedit.search.AllBufferSet;
import org.gjt.sp.jedit.search.CurrentBufferSet;
import org.gjt.sp.jedit.search.DirectoryListSet;
import org.gjt.sp.jedit.search.SearchAndReplace;
import org.gjt.sp.jedit.search.SearchFileSet;

public class SearchDialog
extends EnhancedDialog
implements EBComponent {
    public static final int CURRENT_BUFFER = 0;
    public static final int ALL_BUFFERS = 1;
    public static final int DIRECTORY = 2;
    private static HashMap viewHash = new HashMap();
    private View view;
    private HistoryTextField find;
    private HistoryTextField replace;
    private JRadioButton stringReplace;
    private JRadioButton beanShellReplace;
    private JCheckBox keepDialog;
    private JCheckBox ignoreCase;
    private JCheckBox regexp;
    private JCheckBox hyperSearch;
    private JCheckBox wrap;
    private JRadioButton searchBack;
    private JRadioButton searchForward;
    private JRadioButton searchSelection;
    private JRadioButton searchCurrentBuffer;
    private JRadioButton searchAllBuffers;
    private JRadioButton searchDirectory;
    private HistoryTextField filter;
    private HistoryTextField directory;
    private JCheckBox searchSubDirectories;
    private JButton choose;
    private JButton synchronize;
    private JButton findBtn;
    private JButton replaceAndFindBtn;
    private JButton replaceAllBtn;
    private JButton closeBtn;
    private boolean saving;

    public static SearchDialog getSearchDialog(View view) {
        if (Debug.DISABLE_SEARCH_DIALOG_POOL) {
            return new SearchDialog(view);
        }
        return (SearchDialog)viewHash.get(view);
    }

    public static void preloadSearchDialog(View view) {
        if (Debug.DISABLE_SEARCH_DIALOG_POOL) {
            return;
        }
        SearchDialog searchDialog = new SearchDialog(view);
        viewHash.put(view, searchDialog);
    }

    public static void showSearchDialog(View view, String string, int n) {
        SearchDialog searchDialog = SearchDialog.getSearchDialog(view);
        searchDialog.setSearchString(string, n);
        GUIUtilities.requestFocus(searchDialog, searchDialog.find);
        if (OperatingSystem.isUnix() && !OperatingSystem.isMacOS()) {
            searchDialog.setVisible(false);
        }
        searchDialog.setVisible(true);
        searchDialog.toFront();
        searchDialog.requestFocus();
    }

    public void setSearchString(String string, int n) {
        this.find.setText(null);
        this.replace.setText(null);
        if (string == null) {
            this.searchCurrentBuffer.setSelected(true);
        } else if (string.indexOf(10) == -1) {
            this.find.setText(string);
            this.find.selectAll();
            this.searchCurrentBuffer.setSelected(true);
        } else if (n == 0) {
            this.searchSelection.setSelected(true);
            this.hyperSearch.setSelected(true);
        }
        if (n == 0) {
            if (!this.searchSelection.isSelected()) {
                this.searchCurrentBuffer.setSelected(true);
                this.hyperSearch.setSelected(jEdit.getBooleanProperty("search.hypersearch.toggle"));
            }
        } else if (n == 1) {
            this.searchAllBuffers.setSelected(true);
            this.hyperSearch.setSelected(true);
        } else if (n == 2) {
            SearchFileSet searchFileSet = SearchAndReplace.getSearchFileSet();
            if (searchFileSet instanceof DirectoryListSet) {
                this.filter.setText(((DirectoryListSet)searchFileSet).getFileFilter());
                this.directory.setText(((DirectoryListSet)searchFileSet).getDirectory());
                this.searchSubDirectories.setSelected(((DirectoryListSet)searchFileSet).isRecursive());
            }
            this.hyperSearch.setSelected(true);
            this.searchDirectory.setSelected(true);
        }
        this.updateEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void ok() {
        block10: {
            block9: {
                block8: {
                    try {
                        this.setCursor(Cursor.getPredefinedCursor(3));
                        if (!this.save(false)) {
                            Object var2_1 = null;
                            break block8;
                        }
                        if (this.searchSelection.isSelected() && this.view.getTextArea().getSelectionCount() == 0) {
                            GUIUtilities.error((Component)((Object)this.view), "search-no-selection", null);
                            break block9;
                        }
                        if (this.hyperSearch.isSelected() || this.searchSelection.isSelected()) {
                            if (SearchAndReplace.hyperSearch(this.view, this.searchSelection.isSelected())) {
                                this.closeOrKeepDialog();
                            }
                            break block10;
                        }
                        if (SearchAndReplace.find(this.view)) {
                            this.closeOrKeepDialog();
                            break block10;
                        } else {
                            this.toFront();
                            this.requestFocus();
                            this.find.requestFocus();
                        }
                        break block10;
                    }
                    catch (Throwable throwable) {
                        Object var2_4 = null;
                        this.setCursor(Cursor.getPredefinedCursor(0));
                        throw throwable;
                    }
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            Object var2_2 = null;
            this.setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        Object var2_3 = null;
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void cancel() {
        this.save(true);
        GUIUtilities.saveGeometry(this, "search");
        this.setVisible(false);
    }

    public void handleMessage(EBMessage eBMessage) {
        if (eBMessage instanceof SearchSettingsChanged && !this.saving) {
            this.load();
        }
    }

    public void dispose() {
        EditBus.removeFromBus(this);
        viewHash.remove(this.view);
        super.dispose();
    }

    private SearchDialog(View view) {
        super(view, jEdit.getProperty("search.title"), false);
        this.view = view;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(0, 12, 12, 12));
        this.setContentPane(jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add("North", this.createFieldPanel());
        jPanel2.add("Center", this.createSearchSettingsPanel());
        jPanel.add("Center", jPanel2);
        jPanel.add("South", this.createMultiFilePanel());
        jPanel.add("East", this.createButtonsPanel());
        this.pack();
        jEdit.unsetProperty("search.width");
        jEdit.unsetProperty("search.d-width");
        jEdit.unsetProperty("search.height");
        jEdit.unsetProperty("search.d-height");
        GUIUtilities.loadGeometry(this, "search");
        this.load();
        EditBus.addToBus(this);
    }

    private JPanel createFieldPanel() {
        ButtonActionHandler buttonActionHandler = new ButtonActionHandler();
        JPanel jPanel = new JPanel(new VariableGridLayout(2, 1));
        jPanel.setBorder(new EmptyBorder(0, 0, 12, 12));
        JLabel jLabel = new JLabel(jEdit.getProperty("search.find"));
        jLabel.setDisplayedMnemonic(jEdit.getProperty("search.find.mnemonic").charAt(0));
        this.find = new HistoryTextField("find");
        this.find.setColumns(25);
        this.find.addActionListener(buttonActionHandler);
        jLabel.setLabelFor(this.find);
        jLabel.setBorder(new EmptyBorder(12, 0, 2, 0));
        jPanel.add(jLabel);
        jPanel.add(this.find);
        jLabel = new JLabel(jEdit.getProperty("search.replace"));
        jLabel.setDisplayedMnemonic(jEdit.getProperty("search.replace.mnemonic").charAt(0));
        jLabel.setBorder(new EmptyBorder(12, 0, 0, 0));
        jPanel.add(jLabel);
        ButtonGroup buttonGroup = new ButtonGroup();
        ReplaceActionHandler replaceActionHandler = new ReplaceActionHandler();
        Box box = new Box(0);
        this.stringReplace = new MyJRadioButton(jEdit.getProperty("search.string-replace-btn"));
        this.stringReplace.addActionListener(replaceActionHandler);
        buttonGroup.add(this.stringReplace);
        box.add(this.stringReplace);
        box.add(Box.createHorizontalStrut(12));
        this.beanShellReplace = new MyJRadioButton(jEdit.getProperty("search.beanshell-replace-btn"));
        this.beanShellReplace.addActionListener(replaceActionHandler);
        buttonGroup.add(this.beanShellReplace);
        box.add(this.beanShellReplace);
        jPanel.add(box);
        jPanel.add(Box.createVerticalStrut(3));
        this.replace = new HistoryTextField("replace");
        this.replace.addActionListener(buttonActionHandler);
        jLabel.setLabelFor(this.replace);
        jPanel.add(this.replace);
        return jPanel;
    }

    private JPanel createSearchSettingsPanel() {
        JPanel jPanel = new JPanel(new VariableGridLayout(2, 3));
        jPanel.setBorder(new EmptyBorder(0, 0, 12, 12));
        SettingsActionHandler settingsActionHandler = new SettingsActionHandler();
        ButtonGroup buttonGroup = new ButtonGroup();
        ButtonGroup buttonGroup2 = new ButtonGroup();
        jPanel.add(new JLabel(jEdit.getProperty("search.fileset")));
        jPanel.add(new JLabel(jEdit.getProperty("search.settings")));
        jPanel.add(new JLabel(jEdit.getProperty("search.direction")));
        this.searchSelection = new JRadioButton(jEdit.getProperty("search.selection"));
        this.searchSelection.setMnemonic(jEdit.getProperty("search.selection.mnemonic").charAt(0));
        buttonGroup.add(this.searchSelection);
        jPanel.add(this.searchSelection);
        this.searchSelection.addActionListener(settingsActionHandler);
        this.keepDialog = new JCheckBox(jEdit.getProperty("search.keep"));
        this.keepDialog.setMnemonic(jEdit.getProperty("search.keep.mnemonic").charAt(0));
        jPanel.add(this.keepDialog);
        this.searchBack = new JRadioButton(jEdit.getProperty("search.back"));
        this.searchBack.setMnemonic(jEdit.getProperty("search.back.mnemonic").charAt(0));
        buttonGroup2.add(this.searchBack);
        jPanel.add(this.searchBack);
        this.searchBack.addActionListener(settingsActionHandler);
        this.searchCurrentBuffer = new JRadioButton(jEdit.getProperty("search.current"));
        this.searchCurrentBuffer.setMnemonic(jEdit.getProperty("search.current.mnemonic").charAt(0));
        buttonGroup.add(this.searchCurrentBuffer);
        jPanel.add(this.searchCurrentBuffer);
        this.searchCurrentBuffer.addActionListener(settingsActionHandler);
        this.ignoreCase = new JCheckBox(jEdit.getProperty("search.case"));
        this.ignoreCase.setMnemonic(jEdit.getProperty("search.case.mnemonic").charAt(0));
        jPanel.add(this.ignoreCase);
        this.ignoreCase.addActionListener(settingsActionHandler);
        this.searchForward = new JRadioButton(jEdit.getProperty("search.forward"));
        this.searchForward.setMnemonic(jEdit.getProperty("search.forward.mnemonic").charAt(0));
        buttonGroup2.add(this.searchForward);
        jPanel.add(this.searchForward);
        this.searchForward.addActionListener(settingsActionHandler);
        this.searchAllBuffers = new JRadioButton(jEdit.getProperty("search.all"));
        this.searchAllBuffers.setMnemonic(jEdit.getProperty("search.all.mnemonic").charAt(0));
        buttonGroup.add(this.searchAllBuffers);
        jPanel.add(this.searchAllBuffers);
        this.searchAllBuffers.addActionListener(settingsActionHandler);
        this.regexp = new JCheckBox(jEdit.getProperty("search.regexp"));
        this.regexp.setMnemonic(jEdit.getProperty("search.regexp.mnemonic").charAt(0));
        jPanel.add(this.regexp);
        this.regexp.addActionListener(settingsActionHandler);
        this.wrap = new JCheckBox(jEdit.getProperty("search.wrap"));
        this.wrap.setMnemonic(jEdit.getProperty("search.wrap.mnemonic").charAt(0));
        jPanel.add(this.wrap);
        this.wrap.addActionListener(settingsActionHandler);
        this.searchDirectory = new JRadioButton(jEdit.getProperty("search.directory"));
        this.searchDirectory.setMnemonic(jEdit.getProperty("search.directory.mnemonic").charAt(0));
        buttonGroup.add(this.searchDirectory);
        jPanel.add(this.searchDirectory);
        this.searchDirectory.addActionListener(settingsActionHandler);
        this.hyperSearch = new JCheckBox(jEdit.getProperty("search.hypersearch"));
        this.hyperSearch.setMnemonic(jEdit.getProperty("search.hypersearch.mnemonic").charAt(0));
        jPanel.add(this.hyperSearch);
        this.hyperSearch.addActionListener(settingsActionHandler);
        return jPanel;
    }

    private JPanel createMultiFilePanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        MultiFileActionHandler multiFileActionHandler = new MultiFileActionHandler();
        this.filter = new HistoryTextField("search.filter");
        this.filter.addActionListener(multiFileActionHandler);
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        JLabel jLabel = new JLabel(jEdit.getProperty("search.filterField"), 4);
        jLabel.setBorder(new EmptyBorder(0, 0, 0, 12));
        jLabel.setDisplayedMnemonic(jEdit.getProperty("search.filterField.mnemonic").charAt(0));
        jLabel.setLabelFor(this.filter);
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 0, 3, 6);
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.filter, gridBagConstraints);
        jPanel.add(this.filter);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.synchronize = new JButton(jEdit.getProperty("search.synchronize"));
        this.synchronize.setMnemonic(jEdit.getProperty("search.synchronize.mnemonic").charAt(0));
        this.synchronize.addActionListener(multiFileActionHandler);
        gridBagLayout.setConstraints(this.synchronize, gridBagConstraints);
        jPanel.add(this.synchronize);
        ++gridBagConstraints.gridy;
        this.directory = new HistoryTextField("search.directory");
        this.directory.setColumns(25);
        this.directory.addActionListener(multiFileActionHandler);
        jLabel = new JLabel(jEdit.getProperty("search.directoryField"), 4);
        jLabel.setBorder(new EmptyBorder(0, 0, 0, 12));
        jLabel.setDisplayedMnemonic(jEdit.getProperty("search.directoryField.mnemonic").charAt(0));
        jLabel.setLabelFor(this.directory);
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.insets = new Insets(0, 0, 3, 6);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.directory, gridBagConstraints);
        jPanel.add(this.directory);
        this.choose = new JButton(jEdit.getProperty("search.choose"));
        this.choose.setMnemonic(jEdit.getProperty("search.choose.mnemonic").charAt(0));
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.choose, gridBagConstraints);
        jPanel.add(this.choose);
        this.choose.addActionListener(multiFileActionHandler);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 3;
        this.searchSubDirectories = new JCheckBox(jEdit.getProperty("search.subdirs"));
        gridBagLayout.setConstraints(this.searchSubDirectories, gridBagConstraints);
        jPanel.add(this.searchSubDirectories);
        return jPanel;
    }

    private Box createButtonsPanel() {
        Box box = new Box(1);
        ButtonActionHandler buttonActionHandler = new ButtonActionHandler();
        box.add(Box.createVerticalStrut(12));
        JPanel jPanel = new JPanel(new GridLayout(5, 1, 0, 12));
        this.findBtn = new JButton(jEdit.getProperty("search.findBtn"));
        this.getRootPane().setDefaultButton(this.findBtn);
        jPanel.add(this.findBtn);
        this.findBtn.addActionListener(buttonActionHandler);
        this.replaceAndFindBtn = new JButton(jEdit.getProperty("search.replaceAndFindBtn"));
        this.replaceAndFindBtn.setMnemonic(jEdit.getProperty("search.replaceAndFindBtn.mnemonic").charAt(0));
        jPanel.add(this.replaceAndFindBtn);
        this.replaceAndFindBtn.addActionListener(buttonActionHandler);
        this.replaceAllBtn = new JButton(jEdit.getProperty("search.replaceAllBtn"));
        this.replaceAllBtn.setMnemonic(jEdit.getProperty("search.replaceAllBtn.mnemonic").charAt(0));
        jPanel.add(this.replaceAllBtn);
        this.replaceAllBtn.addActionListener(buttonActionHandler);
        this.closeBtn = new JButton(jEdit.getProperty("common.close"));
        jPanel.add(this.closeBtn);
        this.closeBtn.addActionListener(buttonActionHandler);
        jPanel.setMaximumSize(jPanel.getPreferredSize());
        box.add(jPanel);
        box.add(Box.createGlue());
        return box;
    }

    private void updateEnabled() {
        this.wrap.setEnabled(!this.hyperSearch.isSelected() && !this.searchSelection.isSelected());
        boolean bl = !this.hyperSearch.isSelected() && this.searchCurrentBuffer.isSelected() && !this.regexp.isSelected();
        this.searchBack.setEnabled(bl);
        this.searchForward.setEnabled(bl);
        if (!bl) {
            this.searchForward.setSelected(true);
        }
        this.filter.setEnabled(this.searchAllBuffers.isSelected() || this.searchDirectory.isSelected());
        this.directory.setEnabled(this.searchDirectory.isSelected());
        this.choose.setEnabled(this.searchDirectory.isSelected());
        this.searchSubDirectories.setEnabled(this.searchDirectory.isSelected());
        this.synchronize.setEnabled(this.searchAllBuffers.isSelected() || this.searchDirectory.isSelected());
        this.findBtn.setEnabled(!this.searchSelection.isSelected() || this.hyperSearch.isSelected());
        this.replaceAndFindBtn.setEnabled(!this.hyperSearch.isSelected() && !this.searchSelection.isSelected());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean save(boolean bl) {
        boolean bl2;
        block21: {
            boolean bl3;
            block20: {
                boolean bl4;
                block18: {
                    try {
                        this.saving = true;
                        SearchAndReplace.setIgnoreCase(this.ignoreCase.isSelected());
                        SearchAndReplace.setRegexp(this.regexp.isSelected());
                        SearchAndReplace.setReverseSearch(this.searchBack.isSelected());
                        SearchAndReplace.setAutoWrapAround(this.wrap.isSelected());
                        String string = this.filter.getText();
                        this.filter.addCurrentToHistory();
                        if (string.length() == 0) {
                            string = "*";
                        }
                        SearchFileSet searchFileSet = SearchAndReplace.getSearchFileSet();
                        boolean bl5 = this.searchSubDirectories.isSelected();
                        if (this.searchSelection.isSelected()) {
                            searchFileSet = new CurrentBufferSet();
                        } else if (this.searchCurrentBuffer.isSelected()) {
                            searchFileSet = new CurrentBufferSet();
                            jEdit.setBooleanProperty("search.hypersearch.toggle", this.hyperSearch.isSelected());
                        } else if (this.searchAllBuffers.isSelected()) {
                            searchFileSet = new AllBufferSet(string);
                        } else if (this.searchDirectory.isSelected()) {
                            String string2 = this.directory.getText();
                            this.directory.addCurrentToHistory();
                            string2 = MiscUtilities.constructPath(this.view.getBuffer().getDirectory(), string2);
                            if ((VFSManager.getVFSForPath(string2).getCapabilities() & 0x40) == 0) {
                                if (bl) {
                                    boolean bl6 = false;
                                    Object var9_11 = null;
                                    this.saving = false;
                                    return bl6;
                                }
                                int n = GUIUtilities.confirm(this, "remote-dir-search", null, 0, 2);
                                if (n != 0) {
                                    bl4 = false;
                                    break block18;
                                }
                            }
                            if (searchFileSet instanceof DirectoryListSet) {
                                DirectoryListSet directoryListSet = (DirectoryListSet)searchFileSet;
                                directoryListSet.setDirectory(string2);
                                directoryListSet.setFileFilter(string);
                                directoryListSet.setRecursive(bl5);
                                EditBus.send(new SearchSettingsChanged(null));
                            } else {
                                searchFileSet = new DirectoryListSet(string2, string, bl5);
                            }
                        } else {
                            searchFileSet = null;
                        }
                        jEdit.setBooleanProperty("search.subdirs.toggle", bl5);
                        jEdit.setBooleanProperty("search.keepDialog.toggle", this.keepDialog.isSelected());
                        SearchAndReplace.setSearchFileSet(searchFileSet);
                        this.replace.addCurrentToHistory();
                        SearchAndReplace.setReplaceString(this.replace.getText());
                        if (this.find.getText().length() == 0) {
                            if (!bl) {
                                this.getToolkit().beep();
                            }
                            bl3 = false;
                            break block20;
                        }
                        this.find.addCurrentToHistory();
                        SearchAndReplace.setSearchString(this.find.getText());
                        bl2 = true;
                        break block21;
                    }
                    catch (Throwable throwable) {
                        Object var9_15 = null;
                        this.saving = false;
                        throw throwable;
                    }
                }
                Object var9_12 = null;
                this.saving = false;
                return bl4;
            }
            Object var9_13 = null;
            this.saving = false;
            return bl3;
        }
        Object var9_14 = null;
        this.saving = false;
        return bl2;
    }

    private void synchronizeMultiFileSettings() {
        this.directory.setText(this.view.getBuffer().getDirectory());
        SearchFileSet searchFileSet = SearchAndReplace.getSearchFileSet();
        if (searchFileSet instanceof AllBufferSet) {
            this.filter.setText(((AllBufferSet)searchFileSet).getFileFilter());
        } else {
            this.filter.setText("*" + MiscUtilities.getFileExtension(this.view.getBuffer().getName()));
        }
    }

    private void closeOrKeepDialog() {
        if (this.keepDialog.isSelected()) {
            if (!this.hyperSearch.isSelected()) {
                this.toFront();
                this.requestFocus();
                this.find.requestFocus();
            }
            return;
        }
        GUIUtilities.saveGeometry(this, "search");
        this.setVisible(false);
    }

    private void load() {
        this.ignoreCase.setSelected(SearchAndReplace.getIgnoreCase());
        this.regexp.setSelected(SearchAndReplace.getRegexp());
        this.wrap.setSelected(SearchAndReplace.getAutoWrapAround());
        if (SearchAndReplace.getReverseSearch()) {
            this.searchBack.setSelected(true);
        } else {
            this.searchForward.setSelected(true);
        }
        if (SearchAndReplace.getBeanShellReplace()) {
            this.replace.setModel("replace.script");
            this.beanShellReplace.setSelected(true);
        } else {
            this.replace.setModel("replace");
            this.stringReplace.setSelected(true);
        }
        SearchFileSet searchFileSet = SearchAndReplace.getSearchFileSet();
        HistoryModel historyModel = this.filter.getModel();
        if (historyModel.getSize() != 0) {
            this.filter.setText(historyModel.getItem(0));
        } else {
            this.filter.setText("*" + MiscUtilities.getFileExtension(this.view.getBuffer().getName()));
        }
        historyModel = this.directory.getModel();
        if (historyModel.getSize() != 0) {
            this.directory.setText(historyModel.getItem(0));
        } else {
            this.directory.setText(this.view.getBuffer().getDirectory());
        }
        this.searchSubDirectories.setSelected(jEdit.getBooleanProperty("search.subdirs.toggle"));
        if (searchFileSet instanceof DirectoryListSet) {
            this.filter.setText(((DirectoryListSet)searchFileSet).getFileFilter());
            this.directory.setText(((DirectoryListSet)searchFileSet).getDirectory());
            this.searchSubDirectories.setSelected(((DirectoryListSet)searchFileSet).isRecursive());
        } else if (searchFileSet instanceof AllBufferSet) {
            this.filter.setText(((AllBufferSet)searchFileSet).getFileFilter());
        }
        this.directory.addCurrentToHistory();
        this.keepDialog.setSelected(jEdit.getBooleanProperty("search.keepDialog.toggle"));
    }

    class ButtonActionHandler
    implements ActionListener {
        ButtonActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == SearchDialog.this.closeBtn) {
                SearchDialog.this.cancel();
            } else if (object == SearchDialog.this.findBtn || object == SearchDialog.this.find || object == SearchDialog.this.replace) {
                SearchDialog.this.ok();
            } else if (object == SearchDialog.this.replaceAndFindBtn) {
                SearchDialog.this.save(false);
                if (SearchAndReplace.replace(SearchDialog.this.view)) {
                    SearchDialog.this.ok();
                } else {
                    SearchDialog.this.getToolkit().beep();
                }
            } else if (object == SearchDialog.this.replaceAllBtn) {
                if (SearchDialog.this.searchSelection.isSelected() && SearchDialog.this.view.getTextArea().getSelectionCount() == 0) {
                    GUIUtilities.error((Component)((Object)SearchDialog.this.view), "search-no-selection", null);
                    return;
                }
                SearchDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                if (!SearchDialog.this.save(false)) {
                    SearchDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                    SearchDialog.this.getToolkit().beep();
                    return;
                }
                if (SearchDialog.this.searchSelection.isSelected()) {
                    if (SearchAndReplace.replace(SearchDialog.this.view)) {
                        SearchDialog.this.closeOrKeepDialog();
                    } else {
                        SearchDialog.this.getToolkit().beep();
                    }
                } else if (SearchAndReplace.replaceAll(SearchDialog.this.view)) {
                    SearchDialog.this.closeOrKeepDialog();
                } else {
                    SearchDialog.this.getToolkit().beep();
                }
                SearchDialog.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    class MultiFileActionHandler
    implements ActionListener {
        MultiFileActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == SearchDialog.this.choose) {
                String[] stringArray = GUIUtilities.showVFSFileDialog(SearchDialog.this.view, SearchDialog.this.directory.getText(), 3, false);
                if (stringArray != null) {
                    SearchDialog.this.directory.setText(stringArray[0]);
                }
            } else if (actionEvent.getSource() == SearchDialog.this.synchronize) {
                SearchDialog.this.synchronizeMultiFileSettings();
            } else {
                SearchDialog.this.ok();
            }
        }
    }

    class SettingsActionHandler
    implements ActionListener {
        SettingsActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == SearchDialog.this.searchCurrentBuffer) {
                SearchDialog.this.hyperSearch.setSelected(false);
            } else if (object == SearchDialog.this.searchSelection || object == SearchDialog.this.searchAllBuffers || object == SearchDialog.this.searchDirectory) {
                SearchDialog.this.hyperSearch.setSelected(true);
            }
            SearchDialog.this.save(true);
            SearchDialog.this.updateEnabled();
        }
    }

    class ReplaceActionHandler
    implements ActionListener {
        ReplaceActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SearchDialog.this.replace.setModel(SearchDialog.this.beanShellReplace.isSelected() ? "replace.script" : "replace");
            SearchAndReplace.setBeanShellReplace(SearchDialog.this.beanShellReplace.isSelected());
        }
    }

    class MyJRadioButton
    extends JRadioButton {
        MyJRadioButton(String string) {
            super(string);
        }

        public boolean isFocusTraversable() {
            return false;
        }
    }
}

