/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import bsh.BshMethod;
import bsh.NameSpace;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.TextAreaDialog;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.SearchSettingsChanged;
import org.gjt.sp.jedit.search.BoyerMooreSearchMatcher;
import org.gjt.sp.jedit.search.CurrentBufferSet;
import org.gjt.sp.jedit.search.HyperSearchRequest;
import org.gjt.sp.jedit.search.HyperSearchResults;
import org.gjt.sp.jedit.search.RESearchMatcher;
import org.gjt.sp.jedit.search.SearchDialog;
import org.gjt.sp.jedit.search.SearchFileSet;
import org.gjt.sp.jedit.search.SearchMatcher;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.CharIndexedSegment;
import org.gjt.sp.util.Log;

public class SearchAndReplace {
    private static String search;
    private static String replace;
    private static BshMethod replaceMethod;
    private static NameSpace replaceNS;
    private static boolean regexp;
    private static boolean ignoreCase;
    private static boolean reverse;
    private static boolean beanshell;
    private static boolean wrap;
    private static SearchMatcher matcher;
    private static SearchFileSet fileset;

    public static void setSearchString(String string) {
        if (string.equals(search)) {
            return;
        }
        search = string;
        matcher = null;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static String getSearchString() {
        return search;
    }

    public static void setReplaceString(String string) {
        if (string.equals(replace)) {
            return;
        }
        replace = string;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static String getReplaceString() {
        return replace;
    }

    public static void setIgnoreCase(boolean bl) {
        if (bl == ignoreCase) {
            return;
        }
        ignoreCase = bl;
        matcher = null;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static boolean getIgnoreCase() {
        return ignoreCase;
    }

    public static void setRegexp(boolean bl) {
        if (bl == regexp) {
            return;
        }
        regexp = bl;
        if (bl && reverse) {
            reverse = false;
        }
        matcher = null;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static boolean getRegexp() {
        return regexp;
    }

    public static void setReverseSearch(boolean bl) {
        if (bl == reverse) {
            return;
        }
        reverse = bl;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static boolean getReverseSearch() {
        return reverse;
    }

    public static void setBeanShellReplace(boolean bl) {
        if (bl == beanshell) {
            return;
        }
        beanshell = bl;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static boolean getBeanShellReplace() {
        return beanshell;
    }

    public static void setAutoWrapAround(boolean bl) {
        if (bl == wrap) {
            return;
        }
        wrap = bl;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static boolean getAutoWrapAround() {
        return wrap;
    }

    public static void setSearchMatcher(SearchMatcher searchMatcher) {
        matcher = searchMatcher;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static SearchMatcher getSearchMatcher() throws Exception {
        if (matcher != null) {
            return matcher;
        }
        if (search == null || "".equals(search)) {
            return null;
        }
        matcher = regexp ? new RESearchMatcher(search, ignoreCase) : new BoyerMooreSearchMatcher(search, ignoreCase);
        return matcher;
    }

    public static void setSearchFileSet(SearchFileSet searchFileSet) {
        fileset = searchFileSet;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static SearchFileSet getSearchFileSet() {
        return fileset;
    }

    public static boolean getSmartCaseReplace() {
        return replace != null && TextUtilities.getStringCase(replace) == 1;
    }

    public static boolean hyperSearch(View view) {
        return SearchAndReplace.hyperSearch(view, false);
    }

    public static boolean hyperSearch(View view, boolean bl) {
        EBComponent eBComponent = SearchDialog.getSearchDialog(view);
        if (eBComponent == null) {
            eBComponent = view;
        }
        SearchAndReplace.record(view, "hyperSearch(view," + bl + ")", false, !bl);
        view.getDockableWindowManager().addDockableWindow("hypersearch-results");
        HyperSearchResults hyperSearchResults = (HyperSearchResults)view.getDockableWindowManager().getDockable("hypersearch-results");
        hyperSearchResults.searchStarted();
        try {
            Selection[] selectionArray;
            SearchMatcher searchMatcher = SearchAndReplace.getSearchMatcher();
            if (searchMatcher == null) {
                view.getToolkit().beep();
                hyperSearchResults.searchFailed();
                return false;
            }
            if (bl) {
                selectionArray = view.getTextArea().getSelection();
                if (selectionArray == null) {
                    hyperSearchResults.searchFailed();
                    return false;
                }
            } else {
                selectionArray = null;
            }
            VFSManager.runInWorkThread(new HyperSearchRequest(view, searchMatcher, hyperSearchResults, selectionArray));
            return true;
        }
        catch (Exception exception) {
            hyperSearchResults.searchFailed();
            SearchAndReplace.handleError(eBComponent, exception);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean find(View view) {
        block23: {
            boolean bl;
            block22: {
                boolean bl2;
                boolean bl3;
                EBComponent eBComponent = SearchDialog.getSearchDialog(view);
                if (eBComponent == null || !((Component)((Object)eBComponent)).isShowing()) {
                    eBComponent = view;
                }
                boolean bl4 = false;
                String string = fileset.getNextFile(view, null);
                if (string == null) {
                    GUIUtilities.error(eBComponent, "empty-fileset", null);
                    return false;
                }
                boolean bl5 = bl3 = reverse && fileset instanceof CurrentBufferSet;
                if (bl3 && regexp) {
                    GUIUtilities.error(eBComponent, "regexp-reverse", null);
                    return false;
                }
                try {
                    try {
                        view.showWaitCursor();
                        SearchMatcher searchMatcher = SearchAndReplace.getSearchMatcher();
                        if (searchMatcher == null) {
                            view.getToolkit().beep();
                            boolean bl6 = false;
                            Object var11_11 = null;
                            view.hideWaitCursor();
                            return bl6;
                        }
                        SearchAndReplace.record(view, "find(view)", false, true);
                        while (true) {
                            boolean bl7;
                            if (string != null) {
                                JEditTextArea jEditTextArea;
                                Selection selection;
                                Buffer buffer = jEdit.openTemporary(view, null, string, false);
                                string = fileset.getNextFile(view, string);
                                if (buffer == null) continue;
                                if (!buffer.isLoaded()) {
                                    VFSManager.waitForRequests();
                                }
                                int n = view.getBuffer() == buffer && !bl4 ? ((selection = (jEditTextArea = view.getTextArea()).getSelectionAtOffset(jEditTextArea.getCaretPosition())) == null ? jEditTextArea.getCaretPosition() : (bl3 ? selection.getStart() : selection.getEnd())) : (bl3 ? buffer.getLength() : 0);
                                if (!SearchAndReplace.find(view, buffer, n, bl4, bl3)) continue;
                                bl2 = true;
                                break;
                            }
                            if (bl4) {
                                if (!BeanShell.isScriptRunning()) {
                                    view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.search-not-found"));
                                    view.getToolkit().beep();
                                }
                                bl = false;
                                break block22;
                            }
                            if (wrap) {
                                if (!BeanShell.isScriptRunning()) {
                                    view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.auto-wrap"));
                                    if (jEdit.getBooleanProperty("search.beepOnSearchAutoWrap")) {
                                        view.getToolkit().beep();
                                    }
                                }
                                bl7 = true;
                            } else if (BeanShell.isScriptRunning()) {
                                bl7 = false;
                            } else {
                                Object[] objectArray = new Integer[]{new Integer(bl3 ? 1 : 0)};
                                int n = GUIUtilities.confirm(eBComponent, "keepsearching", objectArray, 0, 3);
                                boolean bl8 = bl7 = n == 0;
                            }
                            if (bl7) {
                                string = fileset.getFirstFile(view);
                                bl4 = true;
                                continue;
                            }
                            break block23;
                            break;
                        }
                    }
                    catch (Exception exception) {
                        SearchAndReplace.handleError(eBComponent, exception);
                        Object var11_15 = null;
                        view.hideWaitCursor();
                        return false;
                    }
                }
                catch (Throwable throwable) {
                    Object var11_16 = null;
                    view.hideWaitCursor();
                    throw throwable;
                }
                Object var11_12 = null;
                view.hideWaitCursor();
                return bl2;
            }
            Object var11_13 = null;
            view.hideWaitCursor();
            return bl;
        }
        Object var11_14 = null;
        view.hideWaitCursor();
        return false;
    }

    public static boolean find(View view, Buffer buffer, int n) throws Exception {
        return SearchAndReplace.find(view, buffer, n, false, false);
    }

    public static boolean find(View view, Buffer buffer, int n, boolean bl, boolean bl2) throws Exception {
        SearchMatcher searchMatcher = SearchAndReplace.getSearchMatcher();
        if (searchMatcher == null) {
            view.getToolkit().beep();
            return false;
        }
        Segment segment = new Segment();
        if (bl2) {
            buffer.getText(0, n, segment);
        } else {
            buffer.getText(n, buffer.getLength() - n, segment);
        }
        SearchMatcher.Match match = searchMatcher.nextMatch(new CharIndexedSegment(segment, bl2), n == 0, true, bl, bl2);
        if (match != null) {
            jEdit.commitTemporary(buffer);
            view.setBuffer(buffer);
            JEditTextArea jEditTextArea = view.getTextArea();
            if (bl2) {
                jEditTextArea.setSelection(new Selection.Range(n - match.end, n - match.start));
                jEditTextArea.scrollTo(n - match.start, false);
                jEditTextArea.moveCaretPosition(n - match.end);
            } else {
                jEditTextArea.setSelection(new Selection.Range(n + match.start, n + match.end));
                jEditTextArea.moveCaretPosition(n + match.end);
                jEditTextArea.scrollTo(n + match.start, false);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean replace(View view) {
        Buffer buffer;
        EBComponent eBComponent;
        block15: {
            int n;
            SearchMatcher searchMatcher;
            Selection selection;
            int n2;
            Selection[] selectionArray;
            boolean bl;
            JEditTextArea jEditTextArea;
            block14: {
                eBComponent = SearchDialog.getSearchDialog(view);
                if (eBComponent == null) {
                    eBComponent = view;
                }
                jEditTextArea = view.getTextArea();
                buffer = view.getBuffer();
                if (!buffer.isEditable()) {
                    return false;
                }
                bl = SearchAndReplace.getSmartCaseReplace();
                selectionArray = jEditTextArea.getSelection();
                if (selectionArray.length == 0) {
                    view.getToolkit().beep();
                    return false;
                }
                SearchAndReplace.record(view, "replace(view)", true, false);
                n2 = jEditTextArea.getCaretPosition();
                selection = jEditTextArea.getSelectionAtOffset(n2);
                if (selection != null) {
                    n2 = selection.getStart();
                }
                buffer.beginCompoundEdit();
                searchMatcher = SearchAndReplace.getSearchMatcher();
                if (searchMatcher != null) break block14;
                boolean bl2 = false;
                Object var13_12 = null;
                buffer.endCompoundEdit();
                return bl2;
            }
            SearchAndReplace.initReplace();
            int n3 = 0;
            for (n = 0; n < selectionArray.length; ++n) {
                selection = selectionArray[n];
                n3 += SearchAndReplace.replaceInSelection(jEditTextArea, buffer, searchMatcher, bl, selection);
            }
            int n4 = n = !regexp && reverse && fileset instanceof CurrentBufferSet ? 1 : 0;
            if (n != 0) {
                jEditTextArea.moveCaretPosition(n2);
            } else {
                selection = jEditTextArea.getSelectionAtOffset(jEditTextArea.getCaretPosition());
                if (selection != null) {
                    jEditTextArea.moveCaretPosition(selection.getEnd());
                }
            }
            if (n3 != 0) break block15;
            view.getToolkit().beep();
            boolean bl3 = false;
            Object var13_13 = null;
            buffer.endCompoundEdit();
            return bl3;
        }
        try {
            boolean bl = true;
            Object var13_14 = null;
            buffer.endCompoundEdit();
            return bl;
        }
        catch (Exception exception) {
            try {
                SearchAndReplace.handleError(eBComponent, exception);
                Object var13_15 = null;
                buffer.endCompoundEdit();
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                buffer.endCompoundEdit();
                throw throwable;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean replace(View view, Buffer buffer, int n, int n2) {
        block9: {
            boolean bl;
            if (!buffer.isEditable()) {
                return false;
            }
            EBComponent eBComponent = SearchDialog.getSearchDialog(view);
            if (eBComponent == null) {
                eBComponent = view;
            }
            boolean bl2 = SearchAndReplace.getSmartCaseReplace();
            try {
                try {
                    buffer.beginCompoundEdit();
                    SearchMatcher searchMatcher = SearchAndReplace.getSearchMatcher();
                    if (searchMatcher == null) {
                        boolean bl3 = false;
                        Object var10_10 = null;
                        buffer.endCompoundEdit();
                        return bl3;
                    }
                    SearchAndReplace.initReplace();
                    int n3 = 0;
                    if ((n3 += SearchAndReplace._replace(buffer, searchMatcher, n, n2, bl2)) == 0) break block9;
                    bl = true;
                }
                catch (Exception exception) {
                    SearchAndReplace.handleError(eBComponent, exception);
                    Object var10_13 = null;
                    buffer.endCompoundEdit();
                    return false;
                }
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                buffer.endCompoundEdit();
                throw throwable;
            }
            Object var10_11 = null;
            buffer.endCompoundEdit();
            return bl;
        }
        Object var10_12 = null;
        buffer.endCompoundEdit();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean replaceAll(View view) {
        Object[] objectArray;
        boolean bl;
        int n;
        int n2;
        EBComponent eBComponent;
        block13: {
            eBComponent = SearchDialog.getSearchDialog(view);
            if (eBComponent == null) {
                eBComponent = view;
            }
            n2 = 0;
            n = 0;
            if (fileset.getFileCount(view) == 0) {
                GUIUtilities.error(eBComponent, "empty-fileset", null);
                return false;
            }
            SearchAndReplace.record(view, "replaceAll(view)", true, true);
            view.showWaitCursor();
            bl = replace != null && TextUtilities.getStringCase(replace) == 1;
            objectArray = SearchAndReplace.getSearchMatcher();
            if (objectArray != null) break block13;
            boolean bl2 = false;
            Object var12_9 = null;
            view.hideWaitCursor();
            return bl2;
        }
        try {
            try {
                SearchAndReplace.initReplace();
                String string = fileset.getFirstFile(view);
                while (string != null) {
                    Object var10_15;
                    Buffer buffer = jEdit.openTemporary(view, null, string, false);
                    string = fileset.getNextFile(view, string);
                    if (buffer == null) continue;
                    if (buffer.isPerformingIO()) {
                        VFSManager.waitForRequests();
                    }
                    if (!buffer.isEditable()) continue;
                    int n3 = 0;
                    try {
                        buffer.beginCompoundEdit();
                        n3 = SearchAndReplace._replace(buffer, (SearchMatcher)objectArray, 0, buffer.getLength(), bl);
                        var10_15 = null;
                        buffer.endCompoundEdit();
                    }
                    catch (Throwable throwable) {
                        var10_15 = null;
                        buffer.endCompoundEdit();
                        throw throwable;
                    }
                    if (n3 == 0) continue;
                    ++n2;
                    n += n3;
                    jEdit.commitTemporary(buffer);
                }
                Object var12_10 = null;
                view.hideWaitCursor();
            }
            catch (Exception exception) {
                SearchAndReplace.handleError(eBComponent, exception);
                Object var12_11 = null;
                view.hideWaitCursor();
            }
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            view.hideWaitCursor();
            throw throwable;
        }
        if (!BeanShell.isScriptRunning()) {
            objectArray = new Object[]{new Integer(n), new Integer(n2)};
            view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.replace-all", objectArray));
            if (n == 0) {
                view.getToolkit().beep();
            }
        }
        return n2 != 0;
    }

    public static void load() {
        search = jEdit.getProperty("search.find.value");
        replace = jEdit.getProperty("search.replace.value");
        ignoreCase = jEdit.getBooleanProperty("search.ignoreCase.toggle");
        regexp = jEdit.getBooleanProperty("search.regexp.toggle");
        beanshell = jEdit.getBooleanProperty("search.beanshell.toggle");
        wrap = jEdit.getBooleanProperty("search.wrap.toggle");
        fileset = new CurrentBufferSet();
        matcher = null;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static void save() {
        jEdit.setProperty("search.find.value", search);
        jEdit.setProperty("search.replace.value", replace);
        jEdit.setBooleanProperty("search.ignoreCase.toggle", ignoreCase);
        jEdit.setBooleanProperty("search.regexp.toggle", regexp);
        jEdit.setBooleanProperty("search.beanshell.toggle", beanshell);
        jEdit.setBooleanProperty("search.wrap.toggle", wrap);
    }

    static void handleError(Component component, Exception exception) {
        Log.log(9, SearchAndReplace.class, exception);
        if (component instanceof Dialog) {
            new TextAreaDialog((Dialog)component, beanshell ? "searcherror-bsh" : "searcherror", (Throwable)exception);
        } else {
            new TextAreaDialog((Frame)component, beanshell ? "searcherror-bsh" : "searcherror", (Throwable)exception);
        }
    }

    private static void initReplace() throws Exception {
        replaceMethod = beanshell && replace.length() != 0 ? BeanShell.cacheBlock("replace", "return (" + replace + ");", true) : null;
    }

    private static void record(View view, String string, boolean bl, boolean bl2) {
        Macros.Recorder recorder = view.getMacroRecorder();
        if (recorder != null) {
            recorder.record("SearchAndReplace.setSearchString(\"" + MiscUtilities.charsToEscapes(search) + "\");");
            if (bl) {
                recorder.record("SearchAndReplace.setReplaceString(\"" + MiscUtilities.charsToEscapes(replace) + "\");");
                recorder.record("SearchAndReplace.setBeanShellReplace(" + beanshell + ");");
            } else {
                recorder.record("SearchAndReplace.setAutoWrapAround(" + wrap + ");");
                recorder.record("SearchAndReplace.setReverseSearch(" + reverse + ");");
            }
            recorder.record("SearchAndReplace.setIgnoreCase(" + ignoreCase + ");");
            recorder.record("SearchAndReplace.setRegexp(" + regexp + ");");
            if (bl2) {
                recorder.record("SearchAndReplace.setSearchFileSet(" + fileset.getCode() + ");");
            }
            recorder.record("SearchAndReplace." + string + ";");
        }
    }

    private static int replaceInSelection(JEditTextArea jEditTextArea, Buffer buffer, SearchMatcher searchMatcher, boolean bl, Selection selection) throws Exception {
        int n;
        int n2 = selection.getStart();
        if (selection instanceof Selection.Range) {
            n = SearchAndReplace._replace(buffer, searchMatcher, selection.getStart(), selection.getEnd(), bl);
            jEditTextArea.removeFromSelection(selection);
            jEditTextArea.addToSelection(new Selection.Range(n2, selection.getEnd()));
        } else if (selection instanceof Selection.Rect) {
            Selection.Rect rect = (Selection.Rect)selection;
            int n3 = rect.getStartColumn(buffer);
            int n4 = rect.getEndColumn(buffer);
            n = 0;
            for (int i = selection.getStartLine(); i <= selection.getEndLine(); ++i) {
                n += SearchAndReplace._replace(buffer, searchMatcher, SearchAndReplace.getColumnOnOtherLine(buffer, i, n3), SearchAndReplace.getColumnOnOtherLine(buffer, i, n4), bl);
            }
            jEditTextArea.addToSelection(new Selection.Rect(n2, selection.getEnd()));
        } else {
            throw new RuntimeException("Unsupported: " + selection);
        }
        return n;
    }

    private static int _replace(Buffer buffer, SearchMatcher searchMatcher, int n, int n2, boolean bl) throws Exception {
        int n3 = 0;
        boolean bl2 = buffer.getLineEndOffset(buffer.getLineOfOffset(n2)) - 1 == n2;
        Segment segment = new Segment();
        int n4 = n;
        int n5 = 0;
        while (true) {
            buffer.getText(n4, n2 - n4, segment);
            boolean bl3 = buffer.getLineStartOffset(buffer.getLineOfOffset(n4)) == n4;
            SearchMatcher.Match match = searchMatcher.nextMatch(new CharIndexedSegment(segment, false), bl3, bl2, n5 == 0, false);
            if (match == null) break;
            String string = new String(segment.array, segment.offset + match.start, match.end - match.start);
            int n6 = SearchAndReplace.replaceOne(buffer, match, n4, string, bl);
            if (n6 == -1) {
                n4 += match.end;
            } else {
                n4 += match.start + n6;
                n2 += n6 - string.length();
                ++n3;
            }
            ++n5;
        }
        return n3;
    }

    private static int replaceOne(Buffer buffer, SearchMatcher.Match match, int n, String string, boolean bl) throws Exception {
        int n2;
        String string2 = SearchAndReplace.replaceOne(match, string);
        if (bl && ignoreCase) {
            n2 = TextUtilities.getStringCase(string);
            if (n2 == 1) {
                string2 = string2.toLowerCase();
            } else if (n2 == 2) {
                string2 = string2.toUpperCase();
            } else if (n2 == 3) {
                string2 = TextUtilities.toTitleCase(string2);
            }
        }
        if (string2 != null) {
            n2 = n + match.start;
            int n3 = n + match.end;
            buffer.remove(n2, n3 - n2);
            buffer.insert(n2, string2);
            return string2.length();
        }
        return -1;
    }

    private static String replaceOne(SearchMatcher.Match match, String string) throws Exception {
        if (regexp) {
            if (replaceMethod != null) {
                return SearchAndReplace.regexpBeanShellReplace(match);
            }
            return SearchAndReplace.regexpReplace(match, string);
        }
        if (replaceMethod != null) {
            return SearchAndReplace.literalBeanShellReplace(string);
        }
        return replace;
    }

    private static String regexpBeanShellReplace(SearchMatcher.Match match) throws Exception {
        for (int i = 0; i < match.substitutions.length; ++i) {
            replaceNS.setVariable("_" + i, match.substitutions[i]);
        }
        Object object = BeanShell.runCachedBlock(replaceMethod, null, replaceNS);
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    private static String regexpReplace(SearchMatcher.Match match, String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        block8: for (int i = 0; i < replace.length(); ++i) {
            char c = replace.charAt(i);
            switch (c) {
                case '$': {
                    int n;
                    if (i == replace.length() - 1) {
                        stringBuffer.append(c);
                        continue block8;
                    }
                    if ((c = replace.charAt(++i)) == '$') {
                        stringBuffer.append('$');
                        continue block8;
                    }
                    if (c == '0') {
                        stringBuffer.append(string);
                        continue block8;
                    }
                    if (!Character.isDigit(c) || (n = c - 48) >= match.substitutions.length) continue block8;
                    stringBuffer.append(match.substitutions[n]);
                    continue block8;
                }
                case '\\': {
                    if (i == replace.length() - 1) {
                        stringBuffer.append('\\');
                        continue block8;
                    }
                    c = replace.charAt(++i);
                    switch (c) {
                        case 'n': {
                            stringBuffer.append('\n');
                            continue block8;
                        }
                        case 't': {
                            stringBuffer.append('\t');
                            continue block8;
                        }
                    }
                    stringBuffer.append(c);
                    continue block8;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    private static String literalBeanShellReplace(String string) throws Exception {
        replaceNS.setVariable("_0", string);
        Object object = BeanShell.runCachedBlock(replaceMethod, null, replaceNS);
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    private static int getColumnOnOtherLine(Buffer buffer, int n, int n2) {
        int n3 = buffer.getOffsetOfVirtualColumn(n, n2, null);
        if (n3 == -1) {
            return buffer.getLineEndOffset(n) - 1;
        }
        return buffer.getLineStartOffset(n) + n3;
    }

    static {
        replaceNS = new NameSpace(BeanShell.getNameSpace(), BeanShell.getNameSpace().getClassManager(), "search and replace");
    }
}

