/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.PluginManagerProgress;
import org.gjt.sp.util.Log;

class Roster {
    private static File downloadDir;
    private List operations = new ArrayList();
    private List toLoad = new ArrayList();

    Roster() {
    }

    void addRemove(String string) {
        this.addOperation(new Remove(string));
    }

    void addInstall(String string, String string2, String string3, int n) {
        this.addOperation(new Install(string, string2, string3, n));
    }

    public Operation getOperation(int n) {
        return (Operation)this.operations.get(n);
    }

    int getOperationCount() {
        return this.operations.size();
    }

    boolean isEmpty() {
        return this.operations.size() == 0;
    }

    void performOperationsInWorkThread(PluginManagerProgress pluginManagerProgress) {
        for (int i = 0; i < this.operations.size(); ++i) {
            Operation operation = (Operation)this.operations.get(i);
            operation.runInWorkThread(pluginManagerProgress);
            pluginManagerProgress.done();
            if (!Thread.interrupted()) continue;
            return;
        }
    }

    void performOperationsInAWTThread(Component component) {
        PluginJAR pluginJAR;
        Object object;
        int n;
        for (n = 0; n < this.operations.size(); ++n) {
            object = (Operation)this.operations.get(n);
            ((Operation)object).runInAWTThread(component);
        }
        for (n = 0; n < this.toLoad.size(); ++n) {
            object = (String)this.toLoad.get(n);
            if (jEdit.getPluginJAR((String)object) != null) {
                Log.log(7, this, "Already loaded: " + (String)object);
                continue;
            }
            jEdit.addPluginJAR((String)object);
        }
        for (n = 0; n < this.toLoad.size(); ++n) {
            object = (String)this.toLoad.get(n);
            pluginJAR = jEdit.getPluginJAR((String)object);
            if (pluginJAR == null) continue;
            pluginJAR.checkDependencies();
        }
        for (n = 0; n < this.toLoad.size(); ++n) {
            object = (String)this.toLoad.get(n);
            pluginJAR = jEdit.getPluginJAR((String)object);
            if (pluginJAR == null) continue;
            pluginJAR.activatePluginIfNecessary();
        }
    }

    private void addOperation(Operation operation) {
        for (int i = 0; i < this.operations.size(); ++i) {
            if (!this.operations.get(i).equals(operation)) continue;
            return;
        }
        this.operations.add(operation);
    }

    private static String getDownloadDir() {
        if (downloadDir == null) {
            String string = jEdit.getSettingsDirectory();
            if (string == null) {
                string = System.getProperty("user.home");
            }
            downloadDir = new File(MiscUtilities.constructPath(string, "PluginManager.download"));
            downloadDir.mkdirs();
        }
        return downloadDir.getPath();
    }

    class Install
    extends Operation {
        int size;
        private String installed;
        private String url;
        private String installDirectory;
        private String path;

        Install(String string, String string2, String string3, int n) {
            if (string2 == null) {
                throw new NullPointerException();
            }
            this.installed = string;
            this.url = string2;
            this.installDirectory = string3;
            this.size = n;
        }

        public int getMaximum() {
            return this.size;
        }

        public void runInWorkThread(PluginManagerProgress pluginManagerProgress) {
            String string = MiscUtilities.getFileName(this.url);
            this.path = this.download(pluginManagerProgress, string, this.url);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void runInAWTThread(Component component) {
            block28: {
                if (this.path == null) {
                    return;
                }
                if (this.installed != null) {
                    new Remove(this.installed).runInAWTThread(component);
                }
                ZipFile zipFile = null;
                zipFile = new ZipFile(this.path);
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = enumeration.nextElement();
                    String string = zipEntry.getName().replace('/', File.separatorChar);
                    File file = new File(this.installDirectory, string);
                    if (zipEntry.isDirectory()) {
                        file.mkdirs();
                        continue;
                    }
                    new File(file.getParent()).mkdirs();
                    this.copy(null, zipFile.getInputStream(zipEntry), new FileOutputStream(file), false);
                    if (!file.getName().toLowerCase().endsWith(".jar")) continue;
                    Roster.this.toLoad.add(file.getPath());
                }
                Object var8_11 = null;
                try {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                }
                catch (IOException iOException) {
                    Log.log(9, this, iOException);
                }
                if (jEdit.getBooleanProperty("plugin-manager.deleteDownloads")) {
                    new File(this.path).delete();
                }
                break block28;
                {
                    catch (InterruptedIOException interruptedIOException) {
                        Object var8_12 = null;
                        try {
                            if (zipFile != null) {
                                zipFile.close();
                            }
                        }
                        catch (IOException iOException) {
                            Log.log(9, this, iOException);
                        }
                        if (jEdit.getBooleanProperty("plugin-manager.deleteDownloads")) {
                            new File(this.path).delete();
                        }
                        break block28;
                    }
                    catch (IOException iOException) {
                        Log.log(9, this, iOException);
                        Object[] objectArray = new String[]{iOException.getMessage()};
                        GUIUtilities.error(null, "ioerror", objectArray);
                        Object var8_13 = null;
                        try {
                            if (zipFile != null) {
                                zipFile.close();
                            }
                        }
                        catch (IOException iOException2) {
                            Log.log(9, this, iOException2);
                        }
                        if (jEdit.getBooleanProperty("plugin-manager.deleteDownloads")) {
                            new File(this.path).delete();
                        }
                        break block28;
                    }
                    catch (Exception exception) {
                        Log.log(9, this, exception);
                        Object var8_14 = null;
                        try {
                            if (zipFile != null) {
                                zipFile.close();
                            }
                        }
                        catch (IOException iOException) {
                            Log.log(9, this, iOException);
                        }
                        if (jEdit.getBooleanProperty("plugin-manager.deleteDownloads")) {
                            new File(this.path).delete();
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var8_15 = null;
                    try {
                        if (zipFile != null) {
                            zipFile.close();
                        }
                    }
                    catch (IOException iOException) {
                        Log.log(9, this, iOException);
                    }
                    if (jEdit.getBooleanProperty("plugin-manager.deleteDownloads")) {
                        new File(this.path).delete();
                    }
                    throw throwable;
                }
            }
        }

        public boolean equals(Object object) {
            return object instanceof Install && ((Install)object).url.equals(this.url);
        }

        private String download(PluginManagerProgress pluginManagerProgress, String string, String string2) {
            try {
                URLConnection uRLConnection = new URL(string2).openConnection();
                String string3 = MiscUtilities.constructPath(Roster.getDownloadDir(), string);
                if (!this.copy(pluginManagerProgress, uRLConnection.getInputStream(), new FileOutputStream(string3), true)) {
                    return null;
                }
                return string3;
            }
            catch (InterruptedIOException interruptedIOException) {
                return null;
            }
            catch (IOException iOException) {
                Log.log(9, this, iOException);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Object[] objectArray = new String[]{iOException.getMessage()};
                        GUIUtilities.error(null, "ioerror", objectArray);
                    }
                });
                return null;
            }
            catch (Exception exception) {
                Log.log(9, this, exception);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean copy(PluginManagerProgress pluginManagerProgress, InputStream inputStream, OutputStream outputStream, boolean bl) throws Exception {
            block5: {
                boolean bl2;
                block4: {
                    inputStream = new BufferedInputStream(inputStream);
                    outputStream = new BufferedOutputStream(outputStream);
                    try {
                        int n;
                        byte[] byArray = new byte[4096];
                        int n2 = 0;
                        while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                            n2 += n;
                            if (pluginManagerProgress != null) {
                                pluginManagerProgress.setValue(n2);
                            }
                            outputStream.write(byArray, 0, n);
                            if (!bl || !Thread.interrupted()) continue;
                            inputStream.close();
                            outputStream.close();
                            bl2 = false;
                            Object var10_9 = null;
                            break block4;
                        }
                        break block5;
                    }
                    catch (Throwable throwable) {
                        Object var10_11 = null;
                        inputStream.close();
                        outputStream.close();
                        throw throwable;
                    }
                }
                inputStream.close();
                outputStream.close();
                return bl2;
            }
            Object var10_10 = null;
            inputStream.close();
            outputStream.close();
            return true;
        }
    }

    class Remove
    extends Operation {
        private String plugin;

        Remove(String string) {
            this.plugin = string;
        }

        public void runInAWTThread(Component component) {
            Object object;
            PluginJAR pluginJAR = jEdit.getPluginJAR(this.plugin);
            if (pluginJAR != null) {
                this.unloadPluginJAR(pluginJAR);
                object = pluginJAR.getCachePath();
                if (object != null) {
                    new File((String)object).delete();
                }
            }
            Roster.this.toLoad.remove(this.plugin);
            object = new File(this.plugin);
            File file = new File(this.plugin.substring(0, this.plugin.length() - 4));
            Log.log(5, this, "Deleting " + object);
            boolean bl = ((File)object).delete();
            if (file.exists()) {
                bl &= this.deleteRecursively(file);
            }
            if (!bl) {
                Object[] objectArray = new String[]{this.plugin};
                GUIUtilities.error(component, "plugin-manager.remove-failed", objectArray);
            }
        }

        private void unloadPluginJAR(PluginJAR pluginJAR) {
            String[] stringArray = pluginJAR.getDependentPlugins();
            for (int i = 0; i < stringArray.length; ++i) {
                PluginJAR pluginJAR2 = jEdit.getPluginJAR(stringArray[i]);
                if (pluginJAR2 == null) continue;
                Roster.this.toLoad.add(stringArray[i]);
                this.unloadPluginJAR(pluginJAR2);
            }
            jEdit.removePluginJAR(pluginJAR, false);
        }

        public boolean equals(Object object) {
            return object instanceof Remove && ((Remove)object).plugin.equals(this.plugin);
        }

        private boolean deleteRecursively(File file) {
            Log.log(5, this, "Deleting " + file + " recursively");
            boolean bl = true;
            if (file.isDirectory()) {
                String string = file.getPath();
                String[] stringArray = file.list();
                for (int i = 0; i < stringArray.length; ++i) {
                    bl &= this.deleteRecursively(new File(string, stringArray[i]));
                }
            }
            return bl &= file.delete();
        }
    }

    static abstract class Operation {
        Operation() {
        }

        public void runInWorkThread(PluginManagerProgress pluginManagerProgress) {
        }

        public void runInAWTThread(Component component) {
        }

        public int getMaximum() {
            return 0;
        }
    }
}

