/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import com.microstar.xml.HandlerBase;
import java.io.StringReader;
import java.util.Stack;
import org.gjt.sp.jedit.pluginmgr.PluginList;
import org.gjt.sp.util.Log;

class PluginListHandler
extends HandlerBase {
    private String path;
    private PluginList pluginList;
    private PluginList.PluginSet pluginSet;
    private String pluginSetEntry;
    private PluginList.Plugin plugin;
    private String jar;
    private String author;
    private PluginList.Branch branch;
    private boolean obsolete;
    private String version;
    private String date;
    private String download;
    private int downloadSize;
    private String downloadSource;
    private int downloadSourceSize;
    private int size;
    private String depWhat;
    private String depFrom;
    private String depTo;
    private String depPlugin;
    private String name;
    private String description;
    private Stack stateStack;

    PluginListHandler(PluginList pluginList, String string) {
        this.pluginList = pluginList;
        this.path = string;
        this.stateStack = new Stack();
    }

    public Object resolveEntity(String string, String string2) {
        if ("plugins.dtd".equals(string2)) {
            return new StringReader("<!-- -->");
        }
        return null;
    }

    public void attribute(String string, String string2, boolean bl) {
        string = string == null ? null : string.intern();
        String string3 = string2 = string2 == null ? null : string2.intern();
        if (string == "NAME") {
            this.name = string2;
        } else if (string == "JAR") {
            this.jar = string2;
        } else if (string == "VERSION") {
            this.version = string2;
        } else if (string == "DATE") {
            this.date = string2;
        } else if (string == "OBSOLETE") {
            this.obsolete = "TRUE".equals(string2);
        } else if (string == "WHAT") {
            this.depWhat = string2;
        } else if (string == "FROM") {
            this.depFrom = string2;
        } else if (string == "TO") {
            this.depTo = string2;
        } else if (string == "PLUGIN") {
            this.depPlugin = string2;
        } else if (string == "SIZE") {
            this.size = Integer.parseInt(string2);
            if (this.size == 0) {
                Log.log(7, this, "SIZE = 0");
            }
        }
    }

    public void doctypeDecl(String string, String string2, String string3) throws Exception {
        if ("PLUGINS".equals(string)) {
            return;
        }
        Log.log(9, this, this.path + ": DOCTYPE must be PLUGINS");
    }

    public void charData(char[] cArray, int n, int n2) {
        String string = this.peekElement();
        String string2 = new String(cArray, n, n2);
        if (string == "DESCRIPTION") {
            this.description = string2;
        } else if (string == "PLUGIN_SET_ENTRY") {
            this.pluginSetEntry = string2;
        } else if (string == "AUTHOR") {
            this.author = this.author != null && this.author.length() != 0 ? this.author + ", " + string2 : string2;
        } else if (string == "DOWNLOAD") {
            this.download = string2;
        } else if (string == "DOWNLOAD_SOURCE") {
            this.downloadSource = string2;
        }
    }

    public void startElement(String string) {
        if ((string = this.pushElement(string)) == "PLUGIN_SET") {
            this.description = null;
            this.pluginSet = new PluginList.PluginSet();
            this.pluginSet.name = this.name;
        } else if (string == "PLUGIN") {
            this.description = null;
            this.author = null;
            this.branch = null;
            this.plugin = new PluginList.Plugin();
        } else if (string == "BRANCH") {
            this.download = null;
            this.branch = new PluginList.Branch();
        } else if (string == "DOWNLOAD") {
            this.downloadSize = this.size;
        } else if (string == "DOWNLOAD_SOURCE") {
            this.downloadSourceSize = this.size;
        }
    }

    public void endElement(String string) {
        if (string == null) {
            return;
        }
        string = string.intern();
        this.popElement();
        if (string == "PLUGIN_SET") {
            this.pluginList.addPluginSet(this.pluginSet);
            this.pluginSet = null;
            this.pluginSetEntry = null;
        } else if (string == "PLUGIN_SET_ENTRY") {
            this.pluginSet.plugins.addElement(this.pluginSetEntry);
            this.pluginSetEntry = null;
        } else if (string == "PLUGIN") {
            this.plugin.jar = this.jar;
            this.plugin.name = this.name;
            this.plugin.author = this.author;
            this.plugin.description = this.description;
            this.pluginList.addPlugin(this.plugin);
            this.jar = null;
            this.name = null;
            this.author = null;
        } else if (string == "BRANCH") {
            this.branch.version = this.version;
            this.branch.date = this.date;
            this.branch.download = this.download;
            this.branch.downloadSize = this.downloadSize;
            this.branch.downloadSource = this.downloadSource;
            this.branch.downloadSourceSize = this.downloadSourceSize;
            this.branch.obsolete = this.obsolete;
            this.plugin.branches.addElement(this.branch);
            this.version = null;
            this.download = null;
            this.obsolete = false;
        } else if (string == "DEPEND") {
            PluginList.Dependency dependency = new PluginList.Dependency(this.depWhat, this.depFrom, this.depTo, this.depPlugin);
            this.branch.deps.addElement(dependency);
            this.depWhat = null;
            this.depFrom = null;
            this.depTo = null;
            this.depPlugin = null;
        }
    }

    public void startDocument() {
        try {
            this.pushElement(null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void endDocument() {
        this.pluginList.finished();
    }

    private String pushElement(String string) {
        string = string == null ? null : string.intern();
        this.stateStack.push(string);
        return string;
    }

    private String peekElement() {
        return (String)this.stateStack.peek();
    }

    private String popElement() {
        return (String)this.stateStack.pop();
    }
}

