/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.gui.GrabKeyDialog;
import org.gjt.sp.jedit.jEdit;

public class ShortcutsOptionPane
extends AbstractOptionPane {
    private JTable keyTable;
    private Vector models;
    private ShortcutsModel currentModel;
    private JComboBox selectModel;
    private Vector allBindings;

    public ShortcutsOptionPane() {
        super("shortcuts");
    }

    protected void _init() {
        this.allBindings = new Vector();
        this.setLayout(new BorderLayout(12, 12));
        this.initModels();
        this.selectModel = new JComboBox(this.models);
        this.selectModel.addActionListener(new ActionHandler());
        Box box = Box.createHorizontalBox();
        box.add(new JLabel(jEdit.getProperty("options.shortcuts.select.label")));
        box.add(Box.createHorizontalStrut(6));
        box.add(this.selectModel);
        this.keyTable = new JTable(this.currentModel);
        this.keyTable.getTableHeader().setReorderingAllowed(false);
        this.keyTable.getTableHeader().addMouseListener(new HeaderMouseHandler());
        this.keyTable.addMouseListener(new TableMouseHandler());
        Dimension dimension = this.keyTable.getPreferredSize();
        dimension.height = Math.min(dimension.height, 200);
        JScrollPane jScrollPane = new JScrollPane(this.keyTable);
        jScrollPane.setPreferredSize(dimension);
        this.add("North", box);
        this.add("Center", jScrollPane);
    }

    protected void _save() {
        if (this.keyTable.getCellEditor() != null) {
            this.keyTable.getCellEditor().stopCellEditing();
        }
        Enumeration enumeration = this.models.elements();
        while (enumeration.hasMoreElements()) {
            ((ShortcutsModel)enumeration.nextElement()).save();
        }
        Macros.loadMacros();
    }

    private void initModels() {
        this.models = new Vector();
        ActionSet[] actionSetArray = jEdit.getActionSets();
        for (int i = 0; i < actionSetArray.length; ++i) {
            ActionSet actionSet = actionSetArray[i];
            if (actionSet.getActionCount() == 0) continue;
            String string = actionSet.getLabel();
            if (string == null) {
                System.err.println("Empty action set: " + actionSet.getPluginJAR());
            }
            this.models.addElement(this.createModel(string, actionSet.getActionNames()));
        }
        Collections.sort(this.models, new MiscUtilities.StringICaseCompare());
        this.currentModel = (ShortcutsModel)this.models.elementAt(0);
    }

    private ShortcutsModel createModel(String string, String[] stringArray) {
        Vector vector = new Vector(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            String string3 = jEdit.getProperty(stringArray[i] + ".label");
            if (string3 == null) continue;
            string3 = GUIUtilities.prettifyMenuLabel(string3);
            this.addBindings(string2, string3, vector);
        }
        return new ShortcutsModel(string, vector);
    }

    private void addBindings(String string, String string2, Vector vector) {
        GrabKeyDialog.KeyBinding[] keyBindingArray = new GrabKeyDialog.KeyBinding[]{this.createBinding(string, string2, jEdit.getProperty(string + ".shortcut")), this.createBinding(string, string2, jEdit.getProperty(string + ".shortcut2"))};
        vector.addElement(keyBindingArray);
    }

    private GrabKeyDialog.KeyBinding createBinding(String string, String string2, String string3) {
        if (string3 != null && string3.length() == 0) {
            string3 = null;
        }
        GrabKeyDialog.KeyBinding keyBinding = new GrabKeyDialog.KeyBinding(string, string2, string3, false);
        this.allBindings.addElement(keyBinding);
        return keyBinding;
    }

    class ShortcutsModel
    extends AbstractTableModel {
        private Vector bindings;
        private String name;

        ShortcutsModel(String string, Vector vector) {
            this.name = string;
            this.bindings = vector;
            this.sort(0);
        }

        public void sort(int n) {
            MiscUtilities.quicksort(this.bindings, (MiscUtilities.Compare)new KeyCompare(n));
            this.fireTableDataChanged();
        }

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return this.bindings.size();
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.getBindingAt((int)n, (int)0).label;
                }
                case 1: {
                    return this.getBindingAt((int)n, (int)0).shortcut;
                }
                case 2: {
                    return this.getBindingAt((int)n, (int)1).shortcut;
                }
            }
            return null;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                return;
            }
            this.getBindingAt((int)n, (int)(n2 - 1)).shortcut = (String)object;
            this.fireTableDataChanged();
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return jEdit.getProperty("options.shortcuts.name");
                }
                case 1: {
                    return jEdit.getProperty("options.shortcuts.shortcut1");
                }
                case 2: {
                    return jEdit.getProperty("options.shortcuts.shortcut2");
                }
            }
            return null;
        }

        public void save() {
            Enumeration enumeration = this.bindings.elements();
            while (enumeration.hasMoreElements()) {
                GrabKeyDialog.KeyBinding[] keyBindingArray = (GrabKeyDialog.KeyBinding[])enumeration.nextElement();
                jEdit.setProperty(keyBindingArray[0].name + ".shortcut", keyBindingArray[0].shortcut);
                jEdit.setProperty(keyBindingArray[1].name + ".shortcut2", keyBindingArray[1].shortcut);
            }
        }

        public GrabKeyDialog.KeyBinding getBindingAt(int n, int n2) {
            GrabKeyDialog.KeyBinding[] keyBindingArray = (GrabKeyDialog.KeyBinding[])this.bindings.elementAt(n);
            return keyBindingArray[n2];
        }

        public String toString() {
            return this.name;
        }

        class KeyCompare
        implements MiscUtilities.Compare {
            int col;

            KeyCompare(int n) {
                this.col = n;
            }

            public int compare(Object object, Object object2) {
                String string;
                String string2;
                GrabKeyDialog.KeyBinding[] keyBindingArray = (GrabKeyDialog.KeyBinding[])object;
                GrabKeyDialog.KeyBinding[] keyBindingArray2 = (GrabKeyDialog.KeyBinding[])object2;
                String string3 = keyBindingArray[0].label.toLowerCase();
                String string4 = keyBindingArray2[0].label.toLowerCase();
                if (this.col == 0) {
                    return MiscUtilities.compareStrings(string3, string4, true);
                }
                if (this.col == 1) {
                    string2 = keyBindingArray[0].shortcut;
                    string = keyBindingArray2[0].shortcut;
                } else {
                    string2 = keyBindingArray[1].shortcut;
                    string = keyBindingArray2[1].shortcut;
                }
                if (string2 == null && string != null) {
                    return 1;
                }
                if (string == null && string2 != null) {
                    return -1;
                }
                if (string2 == null && string == null) {
                    return MiscUtilities.compareStrings(string3, string4, true);
                }
                return MiscUtilities.compareStrings(string2, string, true);
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ShortcutsModel shortcutsModel = (ShortcutsModel)ShortcutsOptionPane.this.selectModel.getSelectedItem();
            if (ShortcutsOptionPane.this.currentModel != shortcutsModel) {
                ShortcutsOptionPane.this.currentModel = shortcutsModel;
                ShortcutsOptionPane.this.keyTable.setModel(ShortcutsOptionPane.this.currentModel);
            }
        }
    }

    class TableMouseHandler
    extends MouseAdapter {
        TableMouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            GrabKeyDialog grabKeyDialog;
            int n = ShortcutsOptionPane.this.keyTable.getSelectedRow();
            int n2 = ShortcutsOptionPane.this.keyTable.getSelectedColumn();
            if (n2 != 0 && n != -1 && (grabKeyDialog = new GrabKeyDialog((Dialog)GUIUtilities.getParentDialog(ShortcutsOptionPane.this), ShortcutsOptionPane.this.currentModel.getBindingAt(n, n2 - 1), ShortcutsOptionPane.this.allBindings, null)).isOK()) {
                ShortcutsOptionPane.this.currentModel.setValueAt(grabKeyDialog.getShortcut(), n, n2);
            }
        }
    }

    class HeaderMouseHandler
    extends MouseAdapter {
        HeaderMouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            switch (ShortcutsOptionPane.this.keyTable.getTableHeader().columnAtPoint(mouseEvent.getPoint())) {
                case 0: {
                    ShortcutsOptionPane.this.currentModel.sort(0);
                    break;
                }
                case 1: {
                    ShortcutsOptionPane.this.currentModel.sort(1);
                    break;
                }
                case 2: {
                    ShortcutsOptionPane.this.currentModel.sort(2);
                }
            }
        }
    }
}

