/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.MirrorList;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.WorkRequest;

public class PluginManagerOptionPane
extends AbstractOptionPane {
    private JLabel locationLabel;
    private JLabel mirrorLabel;
    private ButtonGroup locGrp;
    private JRadioButton settingsDir;
    private JRadioButton appDir;
    private JCheckBox downloadSource;
    private JCheckBox deleteDownloads;
    private MirrorModel miraModel;
    private JList miraList;

    public PluginManagerOptionPane() {
        super("plugin-manager");
    }

    protected void _init() {
        this.setLayout(new BorderLayout());
        this.locationLabel = new JLabel(jEdit.getProperty("options.plugin-manager.location"));
        this.mirrorLabel = new JLabel(jEdit.getProperty("options.plugin-manager.mirror"));
        if (jEdit.getSettingsDirectory() != null) {
            this.settingsDir = new JRadioButton(jEdit.getProperty("options.plugin-manager.settings-dir"));
            this.settingsDir.setToolTipText(MiscUtilities.constructPath(jEdit.getSettingsDirectory(), "jars"));
        }
        this.appDir = new JRadioButton(jEdit.getProperty("options.plugin-manager.app-dir"));
        this.appDir.setToolTipText(MiscUtilities.constructPath(jEdit.getJEditHome(), "jars"));
        this.miraModel = new MirrorModel();
        this.miraList = new JList(this.miraModel);
        this.miraList.setSelectionModel(new SingleSelectionModel());
        this.add("North", this.mirrorLabel);
        this.add("Center", new JScrollPane(this.miraList));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(Box.createVerticalStrut(6));
        JButton jButton = new JButton(jEdit.getProperty("options.plugin-manager.updateMirrors"));
        jButton.addActionListener(new ActionHandler());
        jPanel.add(jButton);
        jPanel.add(Box.createVerticalStrut(6));
        this.downloadSource = new JCheckBox(jEdit.getProperty("options.plugin-manager.downloadSource"));
        this.downloadSource.setSelected(jEdit.getBooleanProperty("plugin-manager.downloadSource"));
        jPanel.add(this.downloadSource);
        jPanel.add(Box.createVerticalStrut(6));
        this.deleteDownloads = new JCheckBox(jEdit.getProperty("options.plugin-manager.deleteDownloads"));
        this.deleteDownloads.setSelected(jEdit.getBooleanProperty("plugin-manager.deleteDownloads"));
        jPanel.add(this.deleteDownloads);
        jPanel.add(Box.createVerticalStrut(6));
        this.locGrp = new ButtonGroup();
        if (jEdit.getSettingsDirectory() != null) {
            this.locGrp.add(this.settingsDir);
        }
        this.locGrp.add(this.appDir);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new EmptyBorder(3, 12, 0, 0));
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        if (jEdit.getSettingsDirectory() != null) {
            jPanel2.add(this.settingsDir);
            jPanel2.add(Box.createVerticalStrut(3));
        }
        jPanel2.add(this.appDir);
        jPanel.add(this.locationLabel);
        jPanel.add(jPanel2);
        jPanel.add(Box.createGlue());
        this.add("South", jPanel);
        if (jEdit.getBooleanProperty("plugin-manager.installUser") && jEdit.getSettingsDirectory() != null) {
            this.settingsDir.setSelected(true);
        } else {
            this.appDir.setSelected(true);
        }
    }

    protected void _save() {
        jEdit.setBooleanProperty("plugin-manager.installUser", this.settingsDir != null && this.settingsDir.isSelected());
        jEdit.setBooleanProperty("plugin-manager.downloadSource", this.downloadSource.isSelected());
        jEdit.setBooleanProperty("plugin-manager.deleteDownloads", this.deleteDownloads.isSelected());
        if (this.miraList.getSelectedIndex() != -1) {
            String string = this.miraModel.getID(this.miraList.getSelectedIndex());
            String string2 = jEdit.getProperty("plugin-manager.mirror.id");
            if (!string2.equals(string)) {
                jEdit.setProperty("plugin-manager.mirror.id", string);
            }
        }
    }

    class DownloadMirrorsThread
    extends WorkRequest {
        DownloadMirrorsThread() {
        }

        public void run() {
            this.setStatus(jEdit.getProperty("options.plugin-manager.workthread"));
            this.setProgressMaximum(1);
            this.setProgressValue(0);
            final ArrayList arrayList = new ArrayList();
            try {
                arrayList.addAll(new MirrorList().mirrors);
            }
            catch (Exception exception) {
                Log.log(9, this, exception);
                GUIUtilities.error(PluginManagerOptionPane.this, "ioerror", new String[]{exception.toString()});
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PluginManagerOptionPane.this.miraModel.setList(arrayList);
                    String string = jEdit.getProperty("plugin-manager.mirror.id");
                    int n = PluginManagerOptionPane.this.miraModel.getSize();
                    for (int i = 0; i < n; ++i) {
                        if (n != 1 && !PluginManagerOptionPane.this.miraModel.getID(i).equals(string)) continue;
                        PluginManagerOptionPane.this.miraList.setSelectedIndex(i);
                        break;
                    }
                }
            });
            this.setProgressValue(1);
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            VFSManager.runInWorkThread(new DownloadMirrorsThread());
        }
    }

    class SingleSelectionModel
    extends DefaultListSelectionModel {
        public SingleSelectionModel() {
            this.setSelectionMode(0);
        }

        public void removeSelectionInterval(int n, int n2) {
        }
    }

    class MirrorModel
    extends AbstractListModel {
        private ArrayList mirrors = new ArrayList();

        public String getID(int n) {
            return ((MirrorList.Mirror)this.mirrors.get((int)n)).id;
        }

        public int getSize() {
            return this.mirrors.size();
        }

        public Object getElementAt(int n) {
            MirrorList.Mirror mirror = (MirrorList.Mirror)this.mirrors.get(n);
            if (mirror.id.equals("NONE")) {
                return jEdit.getProperty("options.plugin-manager.none");
            }
            return mirror.continent + ": " + mirror.description + " (" + mirror.location + ")";
        }

        public void setList(ArrayList arrayList) {
            this.mirrors = arrayList;
            this.fireContentsChanged(this, 0, arrayList.size() - 1);
        }
    }
}

