/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.JARClassLoader;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.gui.ErrorListDialog;
import org.gjt.sp.jedit.io.FileVFS;
import org.gjt.sp.jedit.io.UrlVFS;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.VFSUpdate;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.WorkThreadPool;

public class VFSManager {
    public static final String SERVICE = "org.gjt.sp.jedit.io.VFS";
    private static WorkThreadPool ioThreadPool;
    private static VFS fileVFS;
    private static VFS urlVFS;
    private static Hashtable vfsHash;
    private static Hashtable protocolHash;
    private static boolean error;
    private static Object errorLock;
    private static Vector errors;
    private static Object vfsUpdateLock;
    private static List vfsUpdates;

    public static void init() {
        int n = jEdit.getIntegerProperty("ioThreadCount", 4);
        ioThreadPool = new WorkThreadPool("jEdit I/O", n);
        JARClassLoader jARClassLoader = new JARClassLoader();
        for (int i = 0; i < ioThreadPool.getThreadCount(); ++i) {
            ioThreadPool.getThread(i).setContextClassLoader(jARClassLoader);
        }
    }

    public static void start() {
        ioThreadPool.start();
    }

    public static VFS getFileVFS() {
        return fileVFS;
    }

    public static VFS getUrlVFS() {
        return urlVFS;
    }

    public static VFS getVFSByName(String string) {
        VFS vFS = (VFS)ServiceManager.getService(SERVICE, string);
        if (vFS == null) {
            return (VFS)vfsHash.get(string);
        }
        return vFS;
    }

    public static VFS getVFSForProtocol(String string) {
        if (string.equals("file")) {
            return fileVFS;
        }
        VFS vFS = (VFS)ServiceManager.getService(SERVICE, string);
        if (vFS == null) {
            vFS = (VFS)protocolHash.get(string);
        }
        if (vFS != null) {
            return vFS;
        }
        return urlVFS;
    }

    public static VFS getVFSForPath(String string) {
        if (MiscUtilities.isURL(string)) {
            return VFSManager.getVFSForProtocol(MiscUtilities.getProtocolOfURL(string));
        }
        return fileVFS;
    }

    public static void registerVFS(String string, VFS vFS) {
        Log.log(1, VFSManager.class, "Registered " + vFS.getName() + " filesystem for " + string + " protocol");
        vfsHash.put(vFS.getName(), vFS);
        protocolHash.put(string, vFS);
    }

    public static Enumeration getFilesystems() {
        return vfsHash.elements();
    }

    public static String[] getVFSs() {
        LinkedList<String> linkedList = new LinkedList<String>();
        String[] stringArray = ServiceManager.getServiceNames(SERVICE);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                linkedList.add(stringArray[i]);
            }
        }
        Enumeration enumeration = vfsHash.keys();
        while (enumeration.hasMoreElements()) {
            linkedList.add((String)enumeration.nextElement());
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public static WorkThreadPool getIOThreadPool() {
        return ioThreadPool;
    }

    public static void waitForRequests() {
        ioThreadPool.waitForRequests();
    }

    public static boolean errorOccurred() {
        return error;
    }

    public static int getRequestCount() {
        return ioThreadPool.getRequestCount();
    }

    public static void runInAWTThread(Runnable runnable) {
        ioThreadPool.addWorkRequest(runnable, true);
    }

    public static void runInWorkThread(Runnable runnable) {
        ioThreadPool.addWorkRequest(runnable, false);
    }

    public static void error(final Component component, final String string, final Object[] objectArray) {
        if (SwingUtilities.isEventDispatchThread()) {
            GUIUtilities.error(component, string, objectArray);
            return;
        }
        error = true;
        VFSManager.runInAWTThread(new Runnable(){

            public void run() {
                error = false;
                if (component == null || !component.isShowing()) {
                    GUIUtilities.error(null, string, objectArray);
                } else {
                    GUIUtilities.error(component, string, objectArray);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void error(Component component, String string, String string2, Object[] objectArray) {
        final Frame frame = JOptionPane.getFrameForComponent(component);
        Object object = errorLock;
        synchronized (object) {
            error = true;
            errors.addElement(new ErrorListDialog.ErrorEntry(string, string2, objectArray));
            if (errors.size() == 1) {
                VFSManager.runInAWTThread(new Runnable(){

                    public void run() {
                        String string = jEdit.getProperty("ioerror.caption" + (errors.size() == 1 ? "-1" : ""), new Integer[]{new Integer(errors.size())});
                        new ErrorListDialog(frame.isShowing() ? frame : jEdit.getFirstView().getFrame(), jEdit.getProperty("ioerror.title"), string, errors, false);
                        errors.removeAllElements();
                        error = false;
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendVFSUpdate(VFS vFS, String string, boolean bl) {
        if (bl) {
            VFSManager.sendVFSUpdate(vFS, vFS.getParentOfPath(string), false);
            VFSManager.sendVFSUpdate(vFS, string, false);
        } else {
            if (string.length() != 1 && (string.endsWith("/") || string.endsWith(File.separator))) {
                string = string.substring(0, string.length() - 1);
            }
            Object object = vfsUpdateLock;
            synchronized (object) {
                for (int i = 0; i < vfsUpdates.size(); ++i) {
                    VFSUpdate vFSUpdate = (VFSUpdate)vfsUpdates.get(i);
                    if (!vFSUpdate.getPath().equals(string)) continue;
                    return;
                }
                vfsUpdates.add(new VFSUpdate(string));
                if (vfsUpdates.size() == 1) {
                    VFSManager.runInAWTThread(new SendVFSUpdatesSafely());
                }
            }
        }
    }

    private VFSManager() {
    }

    static {
        errorLock = new Object();
        errors = new Vector();
        fileVFS = new FileVFS();
        urlVFS = new UrlVFS();
        vfsHash = new Hashtable();
        protocolHash = new Hashtable();
        vfsUpdateLock = new Object();
        vfsUpdates = new ArrayList(10);
    }

    static class SendVFSUpdatesSafely
    implements Runnable {
        SendVFSUpdatesSafely() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = vfsUpdateLock;
            synchronized (object) {
                Collections.sort(vfsUpdates, new MiscUtilities.StringCompare());
                for (int i = 0; i < vfsUpdates.size(); ++i) {
                    EditBus.send((VFSUpdate)vfsUpdates.get(i));
                }
                vfsUpdates.clear();
            }
        }
    }
}

