/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.help;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.help.HelpSearchPanel;
import org.gjt.sp.jedit.help.HelpTOCPanel;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.util.Log;

public class HelpViewer
extends JFrame
implements EBComponent {
    private String baseURL;
    private String shortURL;
    private JButton back;
    private JButton forward;
    private JEditorPane viewer;
    private JLabel title;
    private JSplitPane splitter;
    private String[] history;
    private int historyPos;
    private HelpTOCPanel toc;
    private boolean queuedTOCReload;

    public HelpViewer() {
        this("welcome.html");
    }

    public HelpViewer(URL uRL) {
        this(uRL.toString());
    }

    public HelpViewer(String string) {
        super(jEdit.getProperty("helpviewer.title"));
        this.setIconImage(GUIUtilities.getEditorIcon());
        try {
            this.baseURL = new File(MiscUtilities.constructPath(jEdit.getJEditHome(), "doc")).toURL().toString();
        }
        catch (MalformedURLException malformedURLException) {
            Log.log(9, this, malformedURLException);
        }
        this.history = new String[25];
        ActionHandler actionHandler = new ActionHandler();
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.toc = new HelpTOCPanel(this);
        jTabbedPane.addTab(jEdit.getProperty("helpviewer.toc.label"), this.toc);
        jTabbedPane.addTab(jEdit.getProperty("helpviewer.search.label"), new HelpSearchPanel(this));
        jTabbedPane.setMinimumSize(new Dimension(0, 0));
        JPanel jPanel = new JPanel(new BorderLayout());
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        this.title = new JLabel();
        jToolBar.add(this.title);
        jToolBar.add(Box.createGlue());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(new EmptyBorder(0, 12, 0, 0));
        this.back = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("helpviewer.back.icon")));
        this.back.setToolTipText(jEdit.getProperty("helpviewer.back.label"));
        this.back.addActionListener(actionHandler);
        jToolBar.add(this.back);
        this.forward = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("helpviewer.forward.icon")));
        this.forward.addActionListener(actionHandler);
        this.forward.setToolTipText(jEdit.getProperty("helpviewer.forward.label"));
        jToolBar.add(this.forward);
        this.back.setPreferredSize(this.forward.getPreferredSize());
        jPanel.add("North", jToolBar);
        this.viewer = new JEditorPane();
        this.viewer.setEditable(false);
        this.viewer.addHyperlinkListener(new LinkHandler());
        this.viewer.setFont(new Font("Monospaced", 0, 12));
        this.viewer.addPropertyChangeListener(new PropertyChangeHandler());
        jPanel.add("Center", new JScrollPane(this.viewer));
        this.splitter = new JSplitPane(1, jTabbedPane, jPanel);
        this.splitter.setBorder(null);
        this.getContentPane().add("Center", this.splitter);
        this.gotoURL(string, true);
        this.setDefaultCloseOperation(2);
        this.getRootPane().setPreferredSize(new Dimension(750, 500));
        this.pack();
        GUIUtilities.loadGeometry(this, "helpviewer");
        EditBus.addToBus(this);
        this.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                HelpViewer.this.splitter.setDividerLocation(jEdit.getIntegerProperty("helpviewer.splitter", 250));
                HelpViewer.this.viewer.requestFocus();
            }
        });
    }

    public void gotoURL(String string, boolean bl) {
        String string2;
        if (MiscUtilities.isURL(string)) {
            if (string.startsWith(this.baseURL)) {
                string2 = string.substring(this.baseURL.length());
                if (string2.startsWith("/")) {
                    string2 = string2.substring(1);
                }
            } else {
                string2 = string;
            }
        } else {
            string2 = string;
            string = this.baseURL.endsWith("/") ? this.baseURL + string : this.baseURL + '/' + string;
        }
        this.viewer.setCursor(Cursor.getDefaultCursor());
        URL uRL = null;
        try {
            uRL = new URL(string);
            if (!uRL.equals(this.viewer.getPage())) {
                this.title.setText(jEdit.getProperty("helpviewer.loading"));
            }
            this.viewer.setPage(uRL);
            if (bl) {
                this.history[this.historyPos] = string;
                if (this.historyPos + 1 == this.history.length) {
                    System.arraycopy(this.history, 1, this.history, 0, this.history.length - 1);
                    this.history[this.historyPos] = null;
                } else {
                    ++this.historyPos;
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            Log.log(9, this, malformedURLException);
            Object[] objectArray = new String[]{string, malformedURLException.getMessage()};
            GUIUtilities.error(this, "badurl", objectArray);
            return;
        }
        catch (IOException iOException) {
            Log.log(9, this, iOException);
            Object[] objectArray = new String[]{string, iOException.toString()};
            GUIUtilities.error(this, "read-error", objectArray);
            return;
        }
        this.shortURL = string2;
        if (string2 != null) {
            this.toc.selectNode(string2);
        }
    }

    public void dispose() {
        EditBus.removeFromBus(this);
        jEdit.setIntegerProperty("helpviewer.splitter", this.splitter.getDividerLocation());
        GUIUtilities.saveGeometry(this, "helpviewer");
        super.dispose();
    }

    public void handleMessage(EBMessage eBMessage) {
        PluginUpdate pluginUpdate;
        if (eBMessage instanceof PluginUpdate && ((pluginUpdate = (PluginUpdate)eBMessage).getWhat() == PluginUpdate.LOADED || pluginUpdate.getWhat() == PluginUpdate.UNLOADED) && !pluginUpdate.isExiting()) {
            if (!this.queuedTOCReload) {
                this.queueTOCReload();
            }
            this.queuedTOCReload = true;
        }
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    String getShortURL() {
        return this.shortURL;
    }

    public void queueTOCReload() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                HelpViewer.this.queuedTOCReload = false;
                HelpViewer.this.toc.load();
            }
        });
    }

    class PropertyChangeHandler
    implements PropertyChangeListener {
        PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("page".equals(propertyChangeEvent.getPropertyName())) {
                String string = (String)HelpViewer.this.viewer.getDocument().getProperty("title");
                if (string == null) {
                    string = MiscUtilities.getFileName(HelpViewer.this.viewer.getPage().toString());
                }
                HelpViewer.this.title.setText(string);
            }
        }
    }

    class LinkHandler
    implements HyperlinkListener {
        LinkHandler() {
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                    ((HTMLDocument)HelpViewer.this.viewer.getDocument()).processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)hyperlinkEvent);
                } else {
                    URL uRL = hyperlinkEvent.getURL();
                    if (uRL != null) {
                        HelpViewer.this.gotoURL(uRL.toString(), true);
                    }
                }
            } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                HelpViewer.this.viewer.setCursor(Cursor.getPredefinedCursor(12));
            } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
                HelpViewer.this.viewer.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == HelpViewer.this.back) {
                if (HelpViewer.this.historyPos <= 1) {
                    HelpViewer.this.getToolkit().beep();
                } else {
                    String string = HelpViewer.this.history[--HelpViewer.this.historyPos - 1];
                    HelpViewer.this.gotoURL(string, false);
                }
            } else if (object == HelpViewer.this.forward) {
                if (HelpViewer.this.history.length - HelpViewer.this.historyPos <= 1) {
                    HelpViewer.this.getToolkit().beep();
                } else {
                    String string = HelpViewer.this.history[HelpViewer.this.historyPos];
                    if (string == null) {
                        HelpViewer.this.getToolkit().beep();
                    } else {
                        HelpViewer.this.historyPos++;
                        HelpViewer.this.gotoURL(string, false);
                    }
                }
            }
        }
    }
}

