/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.MouseInputAdapter;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.jEdit;

public class HistoryTextField
extends JTextField {
    private HistoryModel historyModel;
    private JPopupMenu popup;
    private boolean instantPopups;
    private boolean enterAddsToHistory;
    private boolean selectAllOnFocus;
    private String current;
    private int index;

    public HistoryTextField() {
        this(null);
    }

    public HistoryTextField(String string) {
        this(string, false, true);
    }

    public HistoryTextField(String string, boolean bl) {
        this(string, bl, true);
    }

    public HistoryTextField(String string, boolean bl, boolean bl2) {
        this.setModel(string);
        MouseHandler mouseHandler = new MouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
        this.instantPopups = bl;
        this.enterAddsToHistory = bl2;
        this.index = -1;
    }

    public void setInstantPopups(boolean bl) {
        this.instantPopups = bl;
    }

    public boolean getInstantPopups() {
        return this.instantPopups;
    }

    public void setEnterAddsToHistory(boolean bl) {
        this.enterAddsToHistory = bl;
    }

    public boolean setEnterAddsToHistory() {
        return this.enterAddsToHistory;
    }

    public void setSelectAllOnFocus(boolean bl) {
        this.selectAllOnFocus = bl;
    }

    public boolean setSelectAllOnFocus() {
        return this.selectAllOnFocus;
    }

    public HistoryModel getModel() {
        return this.historyModel;
    }

    public void setModel(String string) {
        Border border = UIManager.getBorder("TextField.border");
        if (string == null) {
            this.historyModel = null;
            if (border != null) {
                this.setBorder(border);
            }
        } else {
            this.historyModel = HistoryModel.getModel(string);
            if (border != null) {
                this.setBorder(new CompoundBorder(border, new HistoryBorder()));
            }
        }
        this.index = -1;
        this.repaint();
    }

    public void addCurrentToHistory() {
        if (this.historyModel != null) {
            this.historyModel.addItem(this.getText());
        }
        this.index = 0;
    }

    public void setText(String string) {
        super.setText(string);
        this.index = -1;
    }

    public void fireActionPerformed() {
        super.fireActionPerformed();
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (keyEvent.getID() == 401) {
            switch (keyEvent.getKeyCode()) {
                case 10: {
                    if (this.enterAddsToHistory) {
                        this.addCurrentToHistory();
                    }
                    if (keyEvent.getModifiers() != 0) break;
                    this.fireActionPerformed();
                    keyEvent.consume();
                    break;
                }
                case 38: {
                    if (keyEvent.isShiftDown()) {
                        this.doBackwardSearch();
                    } else {
                        this.historyPrevious();
                    }
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    if (keyEvent.isShiftDown()) {
                        this.doForwardSearch();
                    } else if (keyEvent.isAltDown()) {
                        this.showPopupMenu(keyEvent.isShiftDown());
                    } else {
                        this.historyNext();
                    }
                    keyEvent.consume();
                    break;
                }
                case 9: {
                    if (!keyEvent.isControlDown()) break;
                    this.doBackwardSearch();
                    keyEvent.consume();
                }
            }
        }
        if (!keyEvent.isConsumed()) {
            super.processKeyEvent(keyEvent);
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        switch (mouseEvent.getID()) {
            case 501: {
                Border border = this.getBorder();
                Insets insets = border.getBorderInsets(this);
                if (mouseEvent.getX() >= this.getWidth() - insets.right || GUIUtilities.isPopupTrigger(mouseEvent)) {
                    this.showPopupMenu(mouseEvent.isShiftDown());
                    break;
                }
                super.processMouseEvent(mouseEvent);
                break;
            }
            case 505: {
                this.setCursor(Cursor.getDefaultCursor());
                super.processMouseEvent(mouseEvent);
                break;
            }
            default: {
                super.processMouseEvent(mouseEvent);
            }
        }
    }

    private void doBackwardSearch() {
        String string;
        if (this.historyModel == null) {
            return;
        }
        if (this.getSelectionEnd() != this.getDocument().getLength()) {
            this.setCaretPosition(this.getDocument().getLength());
        }
        if ((string = this.getText().substring(0, this.getSelectionStart())) == null) {
            this.historyPrevious();
            return;
        }
        for (int i = this.index + 1; i < this.historyModel.getSize(); ++i) {
            String string2 = this.historyModel.getItem(i);
            if (!string2.startsWith(string)) continue;
            this.replaceSelection(string2.substring(string.length()));
            this.select(string.length(), this.getDocument().getLength());
            this.index = i;
            return;
        }
        this.getToolkit().beep();
    }

    private void doForwardSearch() {
        String string;
        if (this.historyModel == null) {
            return;
        }
        if (this.getSelectionEnd() != this.getDocument().getLength()) {
            this.setCaretPosition(this.getDocument().getLength());
        }
        if ((string = this.getText().substring(0, this.getSelectionStart())) == null) {
            this.historyNext();
            return;
        }
        for (int i = this.index - 1; i >= 0; --i) {
            String string2 = this.historyModel.getItem(i);
            if (!string2.startsWith(string)) continue;
            this.replaceSelection(string2.substring(string.length()));
            this.select(string.length(), this.getDocument().getLength());
            this.index = i;
            return;
        }
        this.getToolkit().beep();
    }

    private void historyPrevious() {
        if (this.historyModel == null) {
            return;
        }
        if (this.index == this.historyModel.getSize() - 1) {
            this.getToolkit().beep();
        } else if (this.index == -1) {
            this.current = this.getText();
            this.setText(this.historyModel.getItem(0));
            this.index = 0;
        } else {
            int n = this.index + 1;
            this.setText(this.historyModel.getItem(n));
            this.index = n;
        }
    }

    private void historyNext() {
        if (this.historyModel == null) {
            return;
        }
        if (this.index == -1) {
            this.getToolkit().beep();
        } else if (this.index == 0) {
            this.setText(this.current);
        } else {
            int n = this.index - 1;
            this.setText(this.historyModel.getItem(n));
            this.index = n;
        }
    }

    private void showPopupMenu(String string, int n, int n2) {
        if (this.historyModel == null) {
            return;
        }
        this.requestFocus();
        if (this.popup != null && this.popup.isVisible()) {
            this.popup.setVisible(false);
            return;
        }
        ActionHandler actionHandler = new ActionHandler();
        this.popup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(jEdit.getProperty("history.caption"));
        jMenuItem.getModel().setEnabled(false);
        this.popup.add(jMenuItem);
        this.popup.addSeparator();
        for (int i = 0; i < this.historyModel.getSize(); ++i) {
            String string2 = this.historyModel.getItem(i);
            if (!string2.startsWith(string)) continue;
            JMenuItem jMenuItem2 = new JMenuItem(string2);
            jMenuItem2.setActionCommand(String.valueOf(i));
            jMenuItem2.addActionListener(actionHandler);
            this.popup.add(jMenuItem2);
        }
        GUIUtilities.showPopupMenu(this.popup, this, n, n2, false);
    }

    private void showPopupMenu(boolean bl) {
        if (bl) {
            this.showPopupMenu(this.getText().substring(0, this.getSelectionStart()), 0, this.getHeight());
        } else {
            this.showPopupMenu("", 0, this.getHeight());
        }
    }

    static class HistoryBorder
    extends AbstractBorder {
        static final int WIDTH = 16;

        HistoryBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n + n3 - 16, n2 - 1);
            int n5 = 8;
            int n6 = n4 / 2;
            graphics.setColor(UIManager.getColor(component.isEnabled() && ((HistoryTextField)component).getModel() != null ? "TextField.foreground" : "TextField.disabledForeground"));
            graphics.drawLine(n5 - 5, n6 - 2, n5 + 4, n6 - 2);
            graphics.drawLine(n5 - 4, n6 - 1, n5 + 3, n6 - 1);
            graphics.drawLine(n5 - 3, n6, n5 + 2, n6);
            graphics.drawLine(n5 - 2, n6 + 1, n5 + 1, n6 + 1);
            graphics.drawLine(n5 - 1, n6 + 2, n5, n6 + 2);
            graphics.translate(-(n + n3 - 16), -(n2 - 1));
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(0, 0, 0, 16);
        }
    }

    class MouseHandler
    extends MouseInputAdapter {
        boolean selectAll;

        MouseHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.selectAll = !HistoryTextField.this.hasFocus() && HistoryTextField.this.selectAllOnFocus;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (MouseHandler.this.selectAll) {
                        HistoryTextField.this.selectAll();
                    }
                }
            });
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            Border border = HistoryTextField.this.getBorder();
            Insets insets = border.getBorderInsets(HistoryTextField.this);
            if (mouseEvent.getX() >= HistoryTextField.this.getWidth() - insets.right) {
                HistoryTextField.this.setCursor(Cursor.getDefaultCursor());
            } else {
                HistoryTextField.this.setCursor(Cursor.getPredefinedCursor(2));
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.selectAll = false;
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = Integer.parseInt(actionEvent.getActionCommand());
            if (n == -1) {
                if (HistoryTextField.this.index != -1) {
                    HistoryTextField.this.setText(HistoryTextField.this.current);
                }
            } else {
                HistoryTextField.this.setText(HistoryTextField.this.historyModel.getItem(n));
                HistoryTextField.this.index = n;
            }
            if (HistoryTextField.this.instantPopups) {
                HistoryTextField.this.addCurrentToHistory();
                HistoryTextField.this.fireActionPerformed();
            }
        }
    }
}

