/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;

public class ColorWellButton
extends JButton {
    public ColorWellButton(Color color) {
        this.setIcon(new ColorWell(color));
        this.setMargin(new Insets(2, 2, 2, 2));
        this.addActionListener(new ActionHandler());
        if (OperatingSystem.isMacOSLF()) {
            this.putClientProperty("JButton.buttonType", "toolbar");
        }
    }

    public Color getSelectedColor() {
        return ((ColorWell)this.getIcon()).color;
    }

    public void setSelectedColor(Color color) {
        ((ColorWell)this.getIcon()).color = color;
        this.repaint();
    }

    private class ColorPickerDialog
    extends EnhancedDialog
    implements ActionListener {
        private JColorChooser chooser;
        private JButton ok;
        private JButton cancel;

        public ColorPickerDialog(Frame frame, String string, boolean bl) {
            super(frame, string, bl);
            this.init();
        }

        public ColorPickerDialog(Dialog dialog, String string, boolean bl) {
            super(dialog, string, bl);
            this.getContentPane().setLayout(new BorderLayout());
            this.init();
        }

        public void ok() {
            Color color = this.chooser.getColor();
            if (color != null) {
                ColorWellButton.this.setSelectedColor(color);
            }
            this.setVisible(false);
        }

        public void cancel() {
            this.setVisible(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.ok) {
                this.ok();
            } else {
                this.cancel();
            }
        }

        private void init() {
            Color color = ColorWellButton.this.getSelectedColor();
            this.chooser = color == null ? new JColorChooser() : new JColorChooser(color);
            this.getContentPane().add("Center", this.chooser);
            Box box = new Box(0);
            box.add(Box.createGlue());
            this.ok = new JButton(jEdit.getProperty("common.ok"));
            this.ok.addActionListener(this);
            box.add(this.ok);
            box.add(Box.createHorizontalStrut(6));
            this.getRootPane().setDefaultButton(this.ok);
            this.cancel = new JButton(jEdit.getProperty("common.cancel"));
            this.cancel.addActionListener(this);
            box.add(this.cancel);
            box.add(Box.createGlue());
            this.getContentPane().add("South", box);
            this.pack();
            this.setLocationRelativeTo(this.getParent());
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JDialog jDialog = GUIUtilities.getParentDialog(ColorWellButton.this);
            ColorPickerDialog colorPickerDialog = jDialog != null ? new ColorPickerDialog(jDialog, jEdit.getProperty("colorChooser.title"), true) : new ColorPickerDialog(JOptionPane.getFrameForComponent(ColorWellButton.this), jEdit.getProperty("colorChooser.title"), true);
            colorPickerDialog.pack();
            colorPickerDialog.setVisible(true);
        }
    }

    static class ColorWell
    implements Icon {
        Color color;

        ColorWell(Color color) {
            this.color = color;
        }

        public int getIconWidth() {
            return 35;
        }

        public int getIconHeight() {
            return 10;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.color == null) {
                return;
            }
            graphics.setColor(this.color);
            graphics.fillRect(n, n2, this.getIconWidth(), this.getIconHeight());
            graphics.setColor(this.color.darker());
            graphics.drawRect(n, n2, this.getIconWidth() - 1, this.getIconHeight() - 1);
        }
    }
}

