/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.jEdit;

public class BufferSwitcher
extends JComboBox {
    private EditPane editPane;
    private boolean updating;

    public BufferSwitcher(EditPane editPane) {
        this.editPane = editPane;
        this.setRenderer(new BufferCellRenderer());
        this.setMaximumRowCount(jEdit.getIntegerProperty("bufferSwitcher.maxRowCount", 10));
        this.addActionListener(new ActionHandler());
    }

    public void updateBufferList() {
        if (jEdit.getBufferCount() == 0) {
            return;
        }
        this.updating = true;
        this.setMaximumRowCount(jEdit.getIntegerProperty("bufferSwitcher.maxRowCount", 10));
        this.setModel(new DefaultComboBoxModel<Buffer>(jEdit.getBuffers()));
        this.setSelectedItem(this.editPane.getBuffer());
        this.updating = false;
    }

    class BufferCellRenderer
    extends DefaultListCellRenderer {
        BufferCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            Buffer buffer = (Buffer)object;
            if (buffer == null) {
                this.setIcon(null);
            } else {
                this.setIcon(buffer.getIcon());
            }
            return this;
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Buffer buffer;
            if (!BufferSwitcher.this.updating && (buffer = (Buffer)BufferSwitcher.this.getSelectedItem()) != null) {
                BufferSwitcher.this.editPane.setBuffer(buffer);
            }
        }
    }
}

