/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;

public class AboutDialog
extends EnhancedDialog {
    private JButton close;

    public AboutDialog(View view) {
        super(view, jEdit.getProperty("about.title"), true);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(jPanel);
        jPanel.add("Center", new AboutPanel());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(new EmptyBorder(12, 0, 0, 0));
        jPanel2.add(Box.createGlue());
        this.close = new JButton(jEdit.getProperty("common.close"));
        this.close.addActionListener(new ActionHandler());
        this.getRootPane().setDefaultButton(this.close);
        jPanel2.add(this.close);
        jPanel2.add(Box.createGlue());
        jPanel.add("South", jPanel2);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo((Component)((Object)view));
        this.setVisible(true);
    }

    public void ok() {
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }

    static class AboutPanel
    extends JComponent {
        ImageIcon image;
        Vector text;
        int scrollPosition;
        AnimationThread thread;
        int maxWidth;
        FontMetrics fm;
        public static int TOP = 120;
        public static int BOTTOM = 30;

        AboutPanel() {
            this.setFont(UIManager.getFont("Label.font"));
            this.fm = this.getFontMetrics(this.getFont());
            this.setForeground(new Color(96, 96, 96));
            this.image = new ImageIcon(this.getClass().getResource("/org/gjt/sp/jedit/icons/about.png"));
            this.setBorder(new MatteBorder(1, 1, 1, 1, Color.gray));
            this.text = new Vector(50);
            StringTokenizer stringTokenizer = new StringTokenizer(jEdit.getProperty("about.text"), "\n");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                this.text.addElement(string);
                this.maxWidth = Math.max(this.maxWidth, this.fm.stringWidth(string) + 10);
            }
            this.scrollPosition = -250;
            this.thread = new AnimationThread();
        }

        public void paintComponent(Graphics graphics) {
            graphics.setColor(new Color(96, 96, 96));
            this.image.paintIcon(this, graphics, 1, 1);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Object[] objectArray = new String[]{jEdit.getVersion()};
            String string = jEdit.getProperty("about.version", objectArray);
            graphics.drawString(string, (this.getWidth() - fontMetrics.stringWidth(string)) / 2, this.getHeight() - 5);
            graphics = graphics.create((this.getWidth() - this.maxWidth) / 2, TOP, this.maxWidth, this.getHeight() - TOP - BOTTOM);
            int n = fontMetrics.getHeight();
            int n2 = this.scrollPosition / n;
            int n3 = n - this.scrollPosition % n;
            int n4 = (this.getHeight() - TOP - BOTTOM) / n;
            int n5 = n3;
            for (int i = 0; i <= n4; ++i) {
                if (i + n2 >= 0 && i + n2 < this.text.size()) {
                    String string2 = (String)this.text.get(i + n2);
                    graphics.drawString(string2, (this.maxWidth - fontMetrics.stringWidth(string2)) / 2, n5);
                }
                n5 += fontMetrics.getHeight();
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(1 + this.image.getIconWidth(), 1 + this.image.getIconHeight());
        }

        public void addNotify() {
            super.addNotify();
            this.thread.start();
        }

        public void removeNotify() {
            super.removeNotify();
            this.thread.kill();
        }

        class AnimationThread
        extends Thread {
            private boolean running;
            private long last;

            AnimationThread() {
                super("About box animation thread");
                this.running = true;
                this.setPriority(1);
            }

            public void kill() {
                this.running = false;
            }

            public void run() {
                FontMetrics fontMetrics = AboutPanel.this.getFontMetrics(AboutPanel.this.getFont());
                int n = AboutPanel.this.text.size() * fontMetrics.getHeight();
                while (this.running) {
                    AboutPanel.this.scrollPosition += 2;
                    if (AboutPanel.this.scrollPosition > n) {
                        AboutPanel.this.scrollPosition = -250;
                    }
                    if (this.last != 0L) {
                        long l = System.currentTimeMillis() - this.last;
                        try {
                            Thread.sleep(75L - l);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.last = System.currentTimeMillis();
                    AboutPanel.this.repaint(AboutPanel.this.getWidth() / 2 - AboutPanel.this.maxWidth, TOP, AboutPanel.this.maxWidth * 2, AboutPanel.this.getHeight() - TOP - BOTTOM);
                }
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AboutDialog.this.dispose();
        }
    }
}

