/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.browser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.BrowserListener;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.browser.VFSFileNameField;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.io.FileVFS;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.WorkThreadPool;
import org.gjt.sp.util.WorkThreadProgressListener;

public class VFSFileChooserDialog
extends EnhancedDialog {
    private VFSBrowser browser;
    private VFSFileNameField filenameField;
    private String filename;
    private JButton ok;
    private JButton cancel;
    private boolean isOK;
    private WorkThreadHandler workThreadHandler;

    public VFSFileChooserDialog(View view, String string, int n, boolean bl) {
        super(view, jEdit.getProperty("vfs.browser.title"), true);
        Object object;
        String string2;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(jPanel);
        if (n == 3) {
            string2 = null;
        } else if (string == null || string.endsWith(File.separator) || string.endsWith("/")) {
            string2 = null;
        } else {
            object = VFSManager.getVFSForPath(string);
            string2 = ((VFS)object).getFileName(string);
            string = ((VFS)object).getParentOfPath(string);
        }
        this.browser = new VFSBrowser(view, string, n, bl, null);
        this.browser.getBrowserView().getTable().setRequestFocusEnabled(false);
        this.browser.getBrowserView().getParentDirectoryList().setRequestFocusEnabled(false);
        this.browser.addBrowserListener(new BrowserHandler());
        jPanel.add("Center", this.browser);
        object = new JPanel();
        ((Container)object).setLayout(new BoxLayout((Container)object, 0));
        ((JComponent)object).setBorder(new EmptyBorder(12, 0, 0, 0));
        this.filenameField = new VFSFileNameField(this.browser, null);
        this.filenameField.setText(string2);
        this.filenameField.selectAll();
        Box box = new Box(1);
        box.add(Box.createGlue());
        box.add(this.filenameField);
        box.add(Box.createGlue());
        JLabel jLabel = new JLabel(jEdit.getProperty("vfs.browser.dialog.filename"));
        jLabel.setDisplayedMnemonic(jEdit.getProperty("vfs.browser.dialog.filename.mnemonic").charAt(0));
        jLabel.setLabelFor(this.filenameField);
        ((Container)object).add(jLabel);
        ((Container)object).add(Box.createHorizontalStrut(12));
        ((Container)object).add(box);
        ((Container)object).add(Box.createHorizontalStrut(12));
        GUIUtilities.requestFocus(this, this.filenameField);
        this.ok = new JButton();
        this.getRootPane().setDefaultButton(this.ok);
        switch (n) {
            case 0: 
            case 4: {
                this.ok.setText(jEdit.getProperty("vfs.browser.dialog.open"));
                break;
            }
            case 3: {
                this.ok.setText(jEdit.getProperty("vfs.browser.dialog.choose-dir"));
                Dimension dimension = this.ok.getPreferredSize();
                this.ok.setPreferredSize(dimension);
                break;
            }
            case 1: {
                this.ok.setText(jEdit.getProperty("vfs.browser.dialog.save"));
            }
        }
        this.ok.addActionListener(new ActionHandler());
        ((Container)object).add(this.ok);
        ((Container)object).add(Box.createHorizontalStrut(6));
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        this.cancel.addActionListener(new ActionHandler());
        ((Container)object).add(this.cancel);
        jPanel.add("South", (Component)object);
        this.workThreadHandler = new WorkThreadHandler();
        VFSManager.getIOThreadPool().addProgressListener(this.workThreadHandler);
        this.pack();
        GUIUtilities.loadGeometry(this, "vfs.browser.dialog");
        this.setVisible(true);
    }

    public void dispose() {
        GUIUtilities.saveGeometry(this, "vfs.browser.dialog");
        VFSManager.getIOThreadPool().removeProgressListener(this.workThreadHandler);
        super.dispose();
    }

    public void ok() {
        VFS.DirectoryEntry[] directoryEntryArray = this.browser.getSelectedFiles();
        this.filename = this.filenameField.getText();
        if (directoryEntryArray.length != 0) {
            this.browser.filesActivated(0, false);
            return;
        }
        if (this.browser.getMode() == 3 && (this.filename == null || this.filename.length() == 0)) {
            this.isOK = true;
            this.dispose();
            return;
        }
        if (this.filename == null || this.filename.length() == 0) {
            this.getToolkit().beep();
            return;
        }
        String string = this.browser.getView().getBuffer().getDirectory();
        if (this.filename.equals("-")) {
            this.filename = string;
        } else if (this.filename.startsWith("-/") || this.filename.startsWith("-" + File.separator)) {
            this.filename = MiscUtilities.constructPath(string, this.filename.substring(2));
        }
        final int[] nArray = new int[]{-1};
        final String string2 = MiscUtilities.constructPath(this.browser.getDirectory(), this.filename);
        final VFS vFS = VFSManager.getVFSForPath(string2);
        Object object = vFS.createVFSSession(string2, this);
        if (object == null) {
            return;
        }
        VFSManager.runInWorkThread(new GetFileTypeRequest(vFS, object, string2, nArray));
        VFSManager.runInAWTThread(new Runnable(){

            public void run() {
                switch (nArray[0]) {
                    case 0: {
                        if (VFSFileChooserDialog.this.browser.getMode() == 3 || vFS instanceof FileVFS && VFSFileChooserDialog.this.doFileExistsWarning(string2)) break;
                        VFSFileChooserDialog.this.isOK = true;
                        if (VFSFileChooserDialog.this.browser.getMode() == 4) {
                            Hashtable<String, String> hashtable = new Hashtable<String, String>();
                            hashtable.put("encoding", ((VFSFileChooserDialog)VFSFileChooserDialog.this).browser.currentEncoding);
                            jEdit.openFile(VFSFileChooserDialog.this.browser.getView(), VFSFileChooserDialog.this.browser.getDirectory(), string2, false, hashtable);
                        }
                        VFSFileChooserDialog.this.dispose();
                        break;
                    }
                    case 1: 
                    case 2: {
                        VFSFileChooserDialog.this.browser.setDirectory(string2);
                    }
                }
            }
        });
    }

    public void cancel() {
        this.dispose();
    }

    public String[] getSelectedFiles() {
        if (!this.isOK) {
            return null;
        }
        if (this.browser.getMode() == 3) {
            return new String[]{this.browser.getDirectory()};
        }
        if (this.filename != null && this.filename.length() != 0) {
            String string = this.browser.getDirectory();
            return new String[]{MiscUtilities.constructPath(string, this.filename)};
        }
        Vector<String> vector = new Vector<String>();
        VFS.DirectoryEntry[] directoryEntryArray = this.browser.getSelectedFiles();
        for (int i = 0; i < directoryEntryArray.length; ++i) {
            VFS.DirectoryEntry directoryEntry = directoryEntryArray[i];
            if (directoryEntry.type != 0) continue;
            vector.addElement(directoryEntry.path);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private boolean doFileExistsWarning(String string) {
        Object[] objectArray;
        int n;
        return this.browser.getMode() == 1 && new File(string).exists() && (n = GUIUtilities.confirm(this.browser, "fileexists", objectArray = new String[]{MiscUtilities.getFileName(string)}, 0, 2)) != 0;
    }

    class GetFileTypeRequest
    implements Runnable {
        VFS vfs;
        Object session;
        String path;
        int[] type;

        GetFileTypeRequest(VFS vFS, Object object, String string, int[] nArray) {
            this.vfs = vFS;
            this.session = object;
            this.path = string;
            this.type = nArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            VFS.DirectoryEntry directoryEntry = this.vfs._getDirectoryEntry(this.session, this.path, VFSFileChooserDialog.this.browser);
            this.type[0] = directoryEntry == null ? 0 : directoryEntry.type;
            try {
                this.vfs._endVFSSession(this.session, VFSFileChooserDialog.this.browser);
            }
            catch (IOException iOException) {
                Log.log(9, this, iOException);
                VFSManager.error(VFSFileChooserDialog.this.browser, this.path, "ioerror", new String[]{iOException.toString()});
                return;
            }
            catch (IOException iOException) {
                try {
                    Log.log(9, this, iOException);
                    VFSManager.error(VFSFileChooserDialog.this.browser, this.path, "ioerror", new String[]{iOException.toString()});
                }
                catch (Throwable throwable) {
                    try {
                        this.vfs._endVFSSession(this.session, VFSFileChooserDialog.this.browser);
                    }
                    catch (IOException iOException2) {
                        Log.log(9, this, iOException2);
                        VFSManager.error(VFSFileChooserDialog.this.browser, this.path, "ioerror", new String[]{iOException2.toString()});
                        return;
                    }
                    throw throwable;
                }
                try {
                    this.vfs._endVFSSession(this.session, VFSFileChooserDialog.this.browser);
                }
                catch (IOException iOException3) {
                    Log.log(9, this, iOException3);
                    VFSManager.error(VFSFileChooserDialog.this.browser, this.path, "ioerror", new String[]{iOException3.toString()});
                    return;
                }
                return;
            }
        }
    }

    class WorkThreadHandler
    implements WorkThreadProgressListener {
        WorkThreadHandler() {
        }

        public void statusUpdate(final WorkThreadPool workThreadPool, int n) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int n = workThreadPool.getRequestCount();
                    if (n == 0) {
                        VFSFileChooserDialog.this.getContentPane().setCursor(Cursor.getDefaultCursor());
                    } else if (n >= 1) {
                        VFSFileChooserDialog.this.getContentPane().setCursor(Cursor.getPredefinedCursor(3));
                    }
                }
            });
        }

        public void progressUpdate(WorkThreadPool workThreadPool, int n) {
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        public void keyTyped(KeyEvent keyEvent) {
            switch (keyEvent.getKeyChar()) {
                case '-': 
                case '/': 
                case '~': {
                    VFSFileChooserDialog.this.filenameField.processKeyEvent(keyEvent);
                    VFSFileChooserDialog.this.filenameField.requestFocus();
                }
            }
        }
    }

    class BrowserHandler
    implements BrowserListener {
        BrowserHandler() {
        }

        public void filesSelected(VFSBrowser vFSBrowser, VFS.DirectoryEntry[] directoryEntryArray) {
            if (directoryEntryArray.length == 0) {
                if (vFSBrowser.getMode() == 3) {
                    VFSFileChooserDialog.this.ok.setText(jEdit.getProperty("vfs.browser.dialog.choose-dir"));
                }
                return;
            }
            if (directoryEntryArray.length == 1) {
                if (vFSBrowser.getMode() == 3) {
                    VFSFileChooserDialog.this.ok.setText(jEdit.getProperty("vfs.browser.dialog.open"));
                }
                VFS.DirectoryEntry directoryEntry = directoryEntryArray[0];
                if (directoryEntry.type == 0) {
                    String string = directoryEntry.path;
                    String string2 = vFSBrowser.getDirectory();
                    String string3 = MiscUtilities.getParentOfPath(string);
                    if (VFSBrowser.pathsEqual(string3, string2)) {
                        string = directoryEntry.name;
                    }
                    VFSFileChooserDialog.this.filenameField.setText(string);
                    VFSFileChooserDialog.this.filenameField.selectAll();
                }
            } else {
                if (vFSBrowser.getMode() == 3) {
                    VFSFileChooserDialog.this.ok.setText(jEdit.getProperty("vfs.browser.dialog.open"));
                }
                VFSFileChooserDialog.this.filenameField.setText(null);
            }
        }

        public void filesActivated(VFSBrowser vFSBrowser, VFS.DirectoryEntry[] directoryEntryArray) {
            VFSFileChooserDialog.this.filenameField.selectAll();
            if (directoryEntryArray.length == 0) {
                VFSFileChooserDialog.this.ok();
                return;
            }
            int n = 0;
            if (n < directoryEntryArray.length) {
                if (directoryEntryArray[n].type == 0) {
                    String string = directoryEntryArray[n].path;
                    VFS vFS = VFSManager.getVFSForPath(string);
                    if (vFSBrowser.getMode() == 1 && vFS instanceof FileVFS && VFSFileChooserDialog.this.doFileExistsWarning(string)) {
                        return;
                    }
                    VFSFileChooserDialog.this.isOK = true;
                    VFSFileChooserDialog.this.filenameField.setText(null);
                    if (vFSBrowser.getMode() != 3) {
                        VFSFileChooserDialog.this.dispose();
                    }
                    return;
                }
                return;
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == VFSFileChooserDialog.this.ok) {
                if (!VFSFileChooserDialog.this.browser.getDirectory().equals(VFSFileChooserDialog.this.browser.getDirectoryField().getText())) {
                    VFSFileChooserDialog.this.browser.setDirectory(VFSFileChooserDialog.this.browser.getDirectoryField().getText());
                } else {
                    VFSFileChooserDialog.this.ok();
                }
            } else if (actionEvent.getSource() == VFSFileChooserDialog.this.cancel) {
                VFSFileChooserDialog.this.cancel();
            }
        }
    }
}

