/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.util.StringTokenizer;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.syntax.DefaultTokenHandler;
import org.gjt.sp.jedit.syntax.Token;

public class TextUtilities {
    public static final int BRACKET_MATCH_LIMIT = 10000;
    public static final int MIXED = 0;
    public static final int LOWER_CASE = 1;
    public static final int UPPER_CASE = 2;
    public static final int TITLE_CASE = 3;
    private static final int WHITESPACE = 0;
    private static final int WORD_CHAR = 1;
    private static final int SYMBOL = 2;

    public static Token getTokenAtOffset(Token token, int n) {
        if (n == 0 && token.id == 127) {
            return token;
        }
        while (true) {
            if (token.id == 127) {
                throw new ArrayIndexOutOfBoundsException("offset > line length");
            }
            if (token.offset + token.length > n) {
                return token;
            }
            token = token.next;
        }
    }

    public static int findMatchingBracket(Buffer buffer, int n, int n2) {
        boolean bl;
        char c;
        if (n2 < 0 || n2 >= buffer.getLineLength(n)) {
            throw new ArrayIndexOutOfBoundsException(n2 + ":" + buffer.getLineLength(n));
        }
        Segment segment = new Segment();
        buffer.getLineText(n, segment);
        char c2 = segment.array[segment.offset + n2];
        switch (c2) {
            case '(': {
                c = ')';
                bl = true;
                break;
            }
            case ')': {
                c = '(';
                bl = false;
                break;
            }
            case '[': {
                c = ']';
                bl = true;
                break;
            }
            case ']': {
                c = '[';
                bl = false;
                break;
            }
            case '{': {
                c = '}';
                bl = true;
                break;
            }
            case '}': {
                c = '{';
                bl = false;
                break;
            }
            default: {
                return -1;
            }
        }
        int n3 = 1;
        DefaultTokenHandler defaultTokenHandler = new DefaultTokenHandler();
        buffer.markTokens(n, defaultTokenHandler);
        byte by = TextUtilities.getTokenAtOffset((Token)defaultTokenHandler.getTokens(), (int)n2).id;
        boolean bl2 = true;
        int n4 = n;
        if (bl) {
            ++n2;
            while (true) {
                for (int i = n2; i < segment.count; ++i) {
                    char c3 = segment.array[segment.offset + i];
                    if (c3 == c2) {
                        if (!bl2) {
                            defaultTokenHandler.init();
                            buffer.markTokens(n, defaultTokenHandler);
                            bl2 = true;
                        }
                        if (TextUtilities.getTokenAtOffset((Token)defaultTokenHandler.getTokens(), (int)i).id != by) continue;
                        ++n3;
                        continue;
                    }
                    if (c3 != c) continue;
                    if (!bl2) {
                        defaultTokenHandler.init();
                        buffer.markTokens(n, defaultTokenHandler);
                        bl2 = true;
                    }
                    if (TextUtilities.getTokenAtOffset((Token)defaultTokenHandler.getTokens(), (int)i).id != by || --n3 != 0) continue;
                    return buffer.getLineStartOffset(n) + i;
                }
                if (++n < buffer.getLineCount() && n - n4 <= 10000) {
                    buffer.getLineText(n, segment);
                    n2 = 0;
                    bl2 = false;
                    continue;
                }
                break;
            }
        } else {
            --n2;
            while (true) {
                for (int i = n2; i >= 0; --i) {
                    char c4 = segment.array[segment.offset + i];
                    if (c4 == c2) {
                        if (!bl2) {
                            defaultTokenHandler.init();
                            buffer.markTokens(n, defaultTokenHandler);
                            bl2 = true;
                        }
                        if (TextUtilities.getTokenAtOffset((Token)defaultTokenHandler.getTokens(), (int)i).id != by) continue;
                        ++n3;
                        continue;
                    }
                    if (c4 != c) continue;
                    if (!bl2) {
                        defaultTokenHandler.init();
                        buffer.markTokens(n, defaultTokenHandler);
                        bl2 = true;
                    }
                    if (TextUtilities.getTokenAtOffset((Token)defaultTokenHandler.getTokens(), (int)i).id != by || --n3 != 0) continue;
                    return buffer.getLineStartOffset(n) + i;
                }
                if (--n < 0 || n4 - n > 10000) break;
                buffer.getLineText(n, segment);
                n2 = segment.count - 1;
                bl2 = false;
            }
        }
        return -1;
    }

    public static int findWordStart(String string, int n, String string2) {
        return TextUtilities.findWordStart(string, n, string2, true, false);
    }

    public static int findWordStart(String string, int n, String string2, boolean bl) {
        return TextUtilities.findWordStart(string, n, string2, bl, false);
    }

    public static int findWordStart(String string, int n, String string2, boolean bl, boolean bl2) {
        char c = string.charAt(n);
        if (string2 == null) {
            string2 = "";
        }
        int n2 = Character.isWhitespace(c) ? 0 : (Character.isLetterOrDigit(c) || string2.indexOf(c) != -1 ? 1 : 2);
        block5: for (int i = n; i >= 0; --i) {
            c = string.charAt(i);
            switch (n2) {
                case 0: {
                    if (Character.isWhitespace(c)) continue block5;
                    return i + 1;
                }
                case 1: {
                    if (Character.isLetterOrDigit(c) || string2.indexOf(c) != -1) continue block5;
                    if (Character.isWhitespace(c) && bl2) {
                        n2 = 0;
                        continue block5;
                    }
                    return i + 1;
                }
                case 2: {
                    if (!bl && n != i) {
                        return i + 1;
                    }
                    if (Character.isWhitespace(c)) {
                        if (bl2) {
                            n2 = 0;
                            continue block5;
                        }
                        return i + 1;
                    }
                    if (!Character.isLetterOrDigit(c) && string2.indexOf(c) == -1) continue block5;
                    return i + 1;
                }
            }
        }
        return 0;
    }

    public static int findWordEnd(String string, int n, String string2) {
        return TextUtilities.findWordEnd(string, n, string2, true);
    }

    public static int findWordEnd(String string, int n, String string2, boolean bl) {
        return TextUtilities.findWordEnd(string, n, string2, bl, false);
    }

    public static int findWordEnd(String string, int n, String string2, boolean bl, boolean bl2) {
        if (n != 0) {
            --n;
        }
        char c = string.charAt(n);
        if (string2 == null) {
            string2 = "";
        }
        int n2 = Character.isWhitespace(c) ? 0 : (Character.isLetterOrDigit(c) || string2.indexOf(c) != -1 ? 1 : 2);
        block5: for (int i = n; i < string.length(); ++i) {
            c = string.charAt(i);
            switch (n2) {
                case 0: {
                    if (Character.isWhitespace(c)) continue block5;
                    return i;
                }
                case 1: {
                    if (Character.isLetterOrDigit(c) || string2.indexOf(c) != -1) continue block5;
                    if (Character.isWhitespace(c) && bl2) {
                        n2 = 0;
                        continue block5;
                    }
                    return i;
                }
                case 2: {
                    if (!bl && i != n) {
                        return i;
                    }
                    if (Character.isWhitespace(c)) {
                        if (bl2) {
                            n2 = 0;
                            continue block5;
                        }
                        return i;
                    }
                    if (!Character.isLetterOrDigit(c) && string2.indexOf(c) == -1) continue block5;
                    return i;
                }
            }
        }
        return string.length();
    }

    public static String spacesToTabs(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = 0;
        block5: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case ' ': {
                    ++n3;
                    ++n2;
                    continue block5;
                }
                case '\t': {
                    int n4 = n - n2 % n;
                    n2 += n4;
                    n3 += n4;
                    continue block5;
                }
                case '\n': {
                    if (n3 != 0) {
                        stringBuffer.append(MiscUtilities.createWhiteSpace(n3, n, n2 - n3));
                    }
                    n3 = 0;
                    n2 = 0;
                    stringBuffer.append('\n');
                    continue block5;
                }
                default: {
                    if (n3 != 0) {
                        stringBuffer.append(MiscUtilities.createWhiteSpace(n3, n, n2 - n3));
                        n3 = 0;
                    }
                    stringBuffer.append(string.charAt(i));
                    ++n2;
                }
            }
        }
        if (n3 != 0) {
            stringBuffer.append(MiscUtilities.createWhiteSpace(n3, n, n2 - n3));
        }
        return stringBuffer.toString();
    }

    public static String tabsToSpaces(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        block4: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '\t': {
                    int n3 = n - n2 % n;
                    n2 += n3;
                    while (--n3 >= 0) {
                        stringBuffer.append(' ');
                    }
                    continue block4;
                }
                case '\n': {
                    n2 = 0;
                    stringBuffer.append(string.charAt(i));
                    continue block4;
                }
                default: {
                    ++n2;
                    stringBuffer.append(string.charAt(i));
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String format(String string, int n, int n2) {
        int n3;
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        while ((n3 = string.indexOf("\n\n", n4)) != -1) {
            TextUtilities.formatParagraph(string.substring(n4, n3), n, n2, stringBuffer);
            stringBuffer.append("\n\n");
            n4 = n3 + 2;
        }
        if (n4 != string.length()) {
            TextUtilities.formatParagraph(string.substring(n4), n, n2, stringBuffer);
        }
        return stringBuffer.toString();
    }

    public static int getStringCase(String string) {
        if (string.length() == 0) {
            return 0;
        }
        int n = -1;
        char c = string.charAt(0);
        if (Character.isLetter(c)) {
            n = Character.isUpperCase(c) ? 2 : 1;
        }
        block4: for (int i = 1; i < string.length(); ++i) {
            c = string.charAt(i);
            if (!Character.isLetter(c)) continue;
            switch (n) {
                case 2: {
                    if (!Character.isLowerCase(c)) continue block4;
                    if (i == 1) {
                        n = 3;
                        continue block4;
                    }
                    return 0;
                }
                case 1: 
                case 3: {
                    if (!Character.isUpperCase(c)) continue block4;
                    return 0;
                }
            }
        }
        return n;
    }

    public static String toTitleCase(String string) {
        if (string.length() == 0) {
            return string;
        }
        return Character.toUpperCase(string.charAt(0)) + string.substring(1).toLowerCase();
    }

    private static void formatParagraph(String string, int n, int n2, StringBuffer stringBuffer) {
        int n3 = MiscUtilities.getLeadingWhiteSpace(string);
        String string2 = string.substring(0, n3);
        int n4 = MiscUtilities.getLeadingWhiteSpaceWidth(string, n2);
        stringBuffer.append(string2);
        int n5 = n4;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (n5 != n4) {
                if (n5 + string3.length() + 1 > n) {
                    stringBuffer.append('\n');
                    stringBuffer.append(string2);
                    n5 = n4;
                } else {
                    stringBuffer.append(' ');
                    ++n5;
                }
            }
            stringBuffer.append(string3);
            n5 += string3.length();
        }
    }
}

