/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import com.microstar.xml.HandlerBase;
import com.microstar.xml.XmlException;
import com.microstar.xml.XmlParser;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.Log;

public class Registers {
    private static Register[] registers = new Register[256];
    private static long registersModTime;
    private static boolean loaded;
    private static boolean loading;
    private static boolean modified;

    public static void copy(JEditTextArea jEditTextArea, char c) {
        String string = jEditTextArea.getSelectedText();
        if (string == null) {
            return;
        }
        Registers.setRegister(c, string);
        HistoryModel.getModel("clipboard").addItem(string);
    }

    public static void cut(JEditTextArea jEditTextArea, char c) {
        if (jEditTextArea.isEditable()) {
            String string = jEditTextArea.getSelectedText();
            if (string == null) {
                return;
            }
            Registers.setRegister(c, string);
            HistoryModel.getModel("clipboard").addItem(string);
            jEditTextArea.setSelectedText("");
        } else {
            jEditTextArea.getToolkit().beep();
        }
    }

    public static void append(JEditTextArea jEditTextArea, char c) {
        Registers.append(jEditTextArea, c, "\n", false);
    }

    public static void append(JEditTextArea jEditTextArea, char c, String string) {
        Registers.append(jEditTextArea, c, string, false);
    }

    public static void append(JEditTextArea jEditTextArea, char c, String string, boolean bl) {
        String string2;
        if (bl && !jEditTextArea.isEditable()) {
            jEditTextArea.getToolkit().beep();
            return;
        }
        String string3 = jEditTextArea.getSelectedText();
        if (string3 == null) {
            return;
        }
        Register register = Registers.getRegister(c);
        if (register != null && (string2 = ((Object)register).toString()) != null) {
            string3 = string2.endsWith(string) ? string2 + string3 : string2 + string + string3;
        }
        Registers.setRegister(c, string3);
        HistoryModel.getModel("clipboard").addItem(string3);
        if (bl) {
            jEditTextArea.setSelectedText("");
        }
    }

    public static void paste(JEditTextArea jEditTextArea, char c) {
        Registers.paste(jEditTextArea, c, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void paste(JEditTextArea var0, char var1_1, boolean var2_2) {
        if (!var0.isEditable()) {
            var0.getToolkit().beep();
            return;
        }
        var3_3 = Registers.getRegister(var1_1);
        if (var3_3 == null) {
            var0.getToolkit().beep();
            return;
        }
        var4_4 = var3_3.toString();
        if (var4_4 == null) {
            var0.getToolkit().beep();
            return;
        }
        if (var2_2 && var0.getSelectionCount() == 0) {
            var5_5 = var0.getBuffer();
            try {
                var5_5.beginCompoundEdit();
                var6_6 = var0.getCaretPosition();
                var7_7 = var0.getCaretLine();
                var8_8 = new Selection.Rect(var7_7, var6_6, var7_7, var6_6);
                var0.setSelectedText(var8_8, var4_4);
                var7_7 = var0.getCaretLine();
                if (var7_7 == var0.getLineCount() - 1) ** GOTO lbl34
                var9_9 = var8_8.getStartColumn(var5_5);
                var10_10 = var5_5.getOffsetOfVirtualColumn(var7_7 + 1, var9_9, null);
                if (var10_10 == -1) {
                    var5_5.insertAtColumn(var7_7 + 1, var9_9, "");
                    var0.setCaretPosition(var5_5.getLineEndOffset(var7_7 + 1) - 1);
                }
                var0.setCaretPosition(var5_5.getLineStartOffset(var7_7 + 1) + var10_10);
            }
            finally {
                var5_5.endCompoundEdit();
            }
        } else {
            var0.setSelectedText(var4_4);
        }
lbl34:
        // 4 sources

        HistoryModel.getModel("clipboard").addItem(var4_4);
    }

    public static Register getRegister(char c) {
        if (c != '$' && c != '%' && !loaded) {
            Registers.loadRegisters();
        }
        if (registers == null || c >= registers.length) {
            return null;
        }
        return registers[c];
    }

    public static void setRegister(char c, Register register) {
        if (c != '%' && c != '$') {
            if (!loaded) {
                Registers.loadRegisters();
            }
            if (!loading) {
                modified = true;
            }
        }
        if (c >= registers.length) {
            Register[] registerArray = new Register[Math.min(65536, c * 2)];
            System.arraycopy(registers, 0, registerArray, 0, registers.length);
            registers = registerArray;
        }
        Registers.registers[c] = register;
    }

    public static void setRegister(char c, String string) {
        Register register = Registers.getRegister(c);
        if (register != null) {
            register.setValue(string);
        } else {
            Registers.setRegister(c, new StringRegister(string));
        }
    }

    public static void clearRegister(char c) {
        if (c >= registers.length) {
            return;
        }
        Register register = registers[c];
        if (c == '$' || c == '%') {
            register.setValue("");
        } else {
            Registers.registers[c] = null;
        }
    }

    public static Register[] getRegisters() {
        if (!loaded) {
            Registers.loadRegisters();
        }
        return registers;
    }

    public static String getRegisterStatusPrompt(String string) {
        return jEdit.getProperty("view.status." + string, new String[]{Registers.getRegisterNameString()});
    }

    public static String getRegisterNameString() {
        if (!loaded) {
            Registers.loadRegisters();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < registers.length; ++i) {
            if (registers[i] == null) continue;
            if (stringBuffer.length() != 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append((char)i);
        }
        if (stringBuffer.length() == 0) {
            return jEdit.getProperty("view.status.no-registers");
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveRegisters() {
        if (!loaded || !modified) {
            return;
        }
        Log.log(3, Registers.class, "Saving registers.xml");
        File file = new File(MiscUtilities.constructPath(jEdit.getSettingsDirectory(), "#registers.xml#save#"));
        File file2 = new File(MiscUtilities.constructPath(jEdit.getSettingsDirectory(), "registers.xml"));
        if (file2.exists() && file2.lastModified() != registersModTime) {
            Log.log(7, Registers.class, file2 + " changed" + " on disk; will not save registers");
            return;
        }
        jEdit.backupSettingsFile(file2);
        String string = System.getProperty("line.separator");
        BufferedWriter bufferedWriter = null;
        boolean bl = false;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write("<?xml version=\"1.0\"?>");
            bufferedWriter.write(string);
            bufferedWriter.write("<!DOCTYPE REGISTERS SYSTEM \"registers.dtd\">");
            bufferedWriter.write(string);
            bufferedWriter.write("<REGISTERS>");
            bufferedWriter.write(string);
            Register[] registerArray = Registers.getRegisters();
            for (int i = 0; i < registerArray.length; ++i) {
                Register register = registerArray[i];
                if (register == null || i == 36 || i == 37) continue;
                bufferedWriter.write("<REGISTER NAME=\"");
                if (i == 34) {
                    bufferedWriter.write("&quot;");
                } else {
                    bufferedWriter.write((char)i);
                }
                bufferedWriter.write("\">");
                bufferedWriter.write(MiscUtilities.charsToEntities(((Object)register).toString()));
                bufferedWriter.write("</REGISTER>");
                bufferedWriter.write(string);
            }
            bufferedWriter.write("</REGISTERS>");
            bufferedWriter.write(string);
            bl = true;
        }
        catch (Exception exception) {
            Log.log(9, Registers.class, exception);
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (bl) {
            file2.delete();
            file.renameTo(file2);
        }
        registersModTime = file2.lastModified();
        modified = false;
    }

    private Registers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadRegisters() {
        String string = jEdit.getSettingsDirectory();
        if (string == null) {
            return;
        }
        File file = new File(MiscUtilities.constructPath(jEdit.getSettingsDirectory(), "registers.xml"));
        if (!file.exists()) {
            return;
        }
        registersModTime = file.lastModified();
        loaded = true;
        Log.log(3, jEdit.class, "Loading registers.xml");
        RegistersHandler registersHandler = new RegistersHandler();
        XmlParser xmlParser = new XmlParser();
        xmlParser.setHandler(registersHandler);
        Reader reader = null;
        try {
            loading = true;
            reader = new BufferedReader(new FileReader(file));
            xmlParser.parse(null, null, reader);
        }
        catch (XmlException xmlException) {
            int n = xmlException.getLine();
            String string2 = xmlException.getMessage();
            Log.log(9, Registers.class, file + ":" + n + ": " + string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            Log.log(9, Registers.class, exception);
        }
        finally {
            loading = false;
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {
                Log.log(9, Registers.class, iOException);
            }
        }
    }

    static {
        Registers.registers[36] = new ClipboardRegister(Toolkit.getDefaultToolkit().getSystemClipboard());
    }

    static class RegistersHandler
    extends HandlerBase {
        private String registerName;
        private String charData;

        RegistersHandler() {
        }

        public Object resolveEntity(String string, String string2) {
            if ("registers.dtd".equals(string2)) {
                return new StringReader("<!-- -->");
            }
            return null;
        }

        public void attribute(String string, String string2, boolean bl) {
            if (string.equals("NAME")) {
                this.registerName = string2;
            }
        }

        public void doctypeDecl(String string, String string2, String string3) throws Exception {
            if ("REGISTERS".equals(string)) {
                return;
            }
            Log.log(9, this, "registers.xml: DOCTYPE must be REGISTERS");
        }

        public void endElement(String string) {
            if (string.equals("REGISTER")) {
                if (this.registerName == null || this.registerName.length() != 1) {
                    Log.log(9, this, "Malformed NAME: " + this.registerName);
                } else {
                    Registers.setRegister(this.registerName.charAt(0), this.charData);
                }
            }
        }

        public void charData(char[] cArray, int n, int n2) {
            this.charData = new String(cArray, n, n2);
        }
    }

    public static class StringRegister
    implements Register {
        private String value;

        public StringRegister(String string) {
            this.value = string;
        }

        public void setValue(String string) {
            this.value = string;
        }

        public String toString() {
            return this.value;
        }

        public void dispose() {
        }
    }

    public static class ClipboardRegister
    implements Register {
        Clipboard clipboard;

        public ClipboardRegister(Clipboard clipboard) {
            this.clipboard = clipboard;
        }

        public void setValue(String string) {
            StringSelection stringSelection = new StringSelection(string);
            this.clipboard.setContents(stringSelection, null);
        }

        public String toString() {
            try {
                String string;
                String string2 = (String)this.clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor);
                boolean bl = string2.endsWith("\n") || string2.endsWith(System.getProperty("line.separator"));
                BufferedReader bufferedReader = new BufferedReader(new StringReader(string2));
                StringBuffer stringBuffer = new StringBuffer();
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.endsWith("\u0000")) {
                        string = string.substring(0, string.length() - 1);
                    }
                    stringBuffer.append(string);
                    stringBuffer.append('\n');
                }
                if (!bl && stringBuffer.length() != 0) {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
                return stringBuffer.toString();
            }
            catch (Exception exception) {
                Log.log(5, this, exception);
                return null;
            }
        }
    }

    public static interface Register {
        public String toString();

        public void setValue(String var1);
    }
}

