/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBPlugin;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.JARClassLoader;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.buffer.DummyFoldHandler;
import org.gjt.sp.jedit.buffer.FoldHandler;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.util.Log;

public class PluginJAR {
    private String path;
    private String cachePath;
    private File file;
    private JARClassLoader classLoader;
    private ZipFile zipFile;
    private Properties properties;
    private String[] classes;
    private ActionSet actions;
    private ActionSet browserActions;
    private EditPlugin plugin;
    private URL dockablesURI;
    private URL servicesURI;
    private boolean activated;
    private List theseRequireMe = new LinkedList();
    private List weRequireThese = new LinkedList();

    public String getPath() {
        return this.path;
    }

    public String getCachePath() {
        return this.cachePath;
    }

    public File getFile() {
        return this.file;
    }

    public JARClassLoader getClassLoader() {
        return this.classLoader;
    }

    public synchronized ZipFile getZipFile() throws IOException {
        if (this.zipFile == null) {
            Log.log(1, this, "Opening " + this.path);
            this.zipFile = new ZipFile(this.path);
        }
        return this.zipFile;
    }

    public ActionSet getActions() {
        return this.getActionSet();
    }

    public ActionSet getActionSet() {
        return this.actions;
    }

    public ActionSet getBrowserActionSet() {
        return this.browserActions;
    }

    public boolean checkDependencies() {
        Object object;
        Object object2;
        Object object3;
        String string;
        String string2;
        if (this.plugin == null) {
            return true;
        }
        int n = 0;
        boolean bl = true;
        boolean bl2 = false;
        String string3 = this.plugin.getClassName();
        while ((string2 = jEdit.getProperty("plugin." + string3 + ".depend." + n++)) != null) {
            int n2;
            if (string2.startsWith("optional ")) {
                bl2 = true;
                string2 = string2.substring("optional ".length());
            }
            if ((n2 = string2.indexOf(32)) == -1) {
                Log.log(9, this, string3 + " has an invalid" + " dependency: " + string2);
                bl = false;
                continue;
            }
            string = string2.substring(0, n2);
            object3 = string2.substring(n2 + 1);
            if (string.equals("jdk")) {
                if (bl2 || MiscUtilities.compareStrings(System.getProperty("java.version"), (String)object3, false) >= 0) continue;
                Object[] objectArray = new String[]{object3, System.getProperty("java.version")};
                jEdit.pluginError(this.path, "plugin-error.dep-jdk", objectArray);
                bl = false;
                continue;
            }
            if (string.equals("jedit")) {
                if (((String)object3).length() != 11) {
                    Log.log(9, this, "Invalid jEdit version number: " + (String)object3);
                    bl = false;
                }
                if (bl2 || MiscUtilities.compareStrings(jEdit.getBuild(), (String)object3, false) >= 0) continue;
                String string4 = MiscUtilities.buildToVersion((String)object3);
                object2 = new String[]{string4, jEdit.getVersion()};
                jEdit.pluginError(this.path, "plugin-error.dep-jedit", object2);
                bl = false;
                continue;
            }
            if (string.equals("plugin")) {
                Object[] objectArray;
                int n3 = ((String)object3).indexOf(32);
                if (n3 == -1) {
                    Log.log(9, this, string3 + " has an invalid dependency: " + string2 + " (version is missing)");
                    bl = false;
                    continue;
                }
                object2 = ((String)object3).substring(0, n3);
                object = ((String)object3).substring(n3 + 1);
                String string5 = jEdit.getProperty("plugin." + (String)object2 + ".version");
                EditPlugin editPlugin = jEdit.getPlugin((String)object2);
                if (editPlugin == null) {
                    if (bl2) continue;
                    objectArray = new String[]{object, object2};
                    jEdit.pluginError(this.path, "plugin-error.dep-plugin.no-version", objectArray);
                    bl = false;
                    continue;
                }
                if (MiscUtilities.compareStrings(string5, (String)object, false) < 0) {
                    if (bl2) continue;
                    objectArray = new String[]{object, object2, string5};
                    jEdit.pluginError(this.path, "plugin-error.dep-plugin", objectArray);
                    bl = false;
                    continue;
                }
                if (editPlugin instanceof EditPlugin.Broken) {
                    if (bl2) continue;
                    objectArray = new String[]{object2};
                    jEdit.pluginError(this.path, "plugin-error.dep-plugin.broken", objectArray);
                    bl = false;
                    continue;
                }
                objectArray = editPlugin.getPluginJAR();
                objectArray.theseRequireMe.add(this.path);
                this.weRequireThese.add(objectArray.getPath());
                continue;
            }
            if (string.equals("class")) {
                if (bl2) continue;
                try {
                    this.classLoader.loadClass((String)object3, false);
                }
                catch (Exception exception) {
                    object2 = new String[]{object3};
                    jEdit.pluginError(this.path, "plugin-error.dep-class", object2);
                    bl = false;
                }
                continue;
            }
            Log.log(9, this, string3 + " has unknown" + " dependency: " + string2);
            bl = false;
        }
        String string6 = jEdit.getProperty("plugin." + this.plugin.getClassName() + ".jars");
        if (string6 != null) {
            string = MiscUtilities.getParentOfPath(this.path);
            object3 = new StringTokenizer(string6);
            while (((StringTokenizer)object3).hasMoreTokens()) {
                String string7 = MiscUtilities.constructPath(string, ((StringTokenizer)object3).nextToken());
                object2 = jEdit.getPluginJAR(string7);
                if (object2 == null) {
                    object = new String[]{string7};
                    jEdit.pluginError(this.path, "plugin-error.missing-jar", object);
                    bl = false;
                    continue;
                }
                this.weRequireThese.add(string7);
                object2.theseRequireMe.add(this.path);
            }
        }
        if (!bl) {
            this.breakPlugin();
        }
        return bl;
    }

    public String[] getDependentPlugins() {
        return this.theseRequireMe.toArray(new String[this.theseRequireMe.size()]);
    }

    public EditPlugin getPlugin() {
        return this.plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activatePlugin() {
        Object object = this;
        synchronized (object) {
            if (this.activated) {
                return;
            }
            this.activated = true;
        }
        if (!(this.plugin instanceof EditPlugin.Deferred)) {
            return;
        }
        object = this.plugin.getClassName();
        try {
            Class clazz = this.classLoader.loadClass((String)object, false);
            int n = clazz.getModifiers();
            if (Modifier.isInterface(n) || Modifier.isAbstract(n) || !EditPlugin.class.isAssignableFrom(clazz)) {
                Log.log(9, this, "Plugin has properties but does not extend EditPlugin: " + (String)object);
                this.breakPlugin();
                return;
            }
            this.plugin = (EditPlugin)clazz.newInstance();
            this.plugin.jar = (EditPlugin.JAR)this;
        }
        catch (Throwable throwable) {
            this.breakPlugin();
            Log.log(9, this, "Error while starting plugin " + (String)object);
            Log.log(9, this, throwable);
            Object[] objectArray = new String[]{throwable.toString()};
            jEdit.pluginError(this.path, "plugin-error.start-error", objectArray);
            return;
        }
        if (jEdit.isMainThread() || SwingUtilities.isEventDispatchThread()) {
            this.startPlugin();
        } else {
            this.startPluginLater();
        }
        EditBus.send(new PluginUpdate(this, PluginUpdate.ACTIVATED, false));
    }

    public void activatePluginIfNecessary() {
        if (!(this.plugin instanceof EditPlugin.Deferred) || this.plugin == null) {
            return;
        }
        String string = this.plugin.getClassName();
        String string2 = jEdit.getProperty("plugin." + string + ".activate");
        if (string2 == null) {
            if (!jEdit.isMainThread()) {
                this.breakPlugin();
                jEdit.pluginError(this.path, "plugin-error.not-42", null);
            } else {
                this.activatePlugin();
            }
        } else {
            boolean bl = false;
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                boolean bl2 = jEdit.getBooleanProperty(string3);
                if (!bl2) continue;
                Log.log(1, this, "Activating " + string + " because of " + string3);
                bl = true;
                break;
            }
            if (bl) {
                this.activatePlugin();
            }
        }
    }

    public void deactivatePlugin(boolean bl) {
        Object object;
        if (!this.activated) {
            return;
        }
        if (!bl) {
            for (object = jEdit.getFirstBuffer(); object != null; object = ((Buffer)object).getNext()) {
                if (((Buffer)object).getFoldHandler() == null || ((Buffer)object).getFoldHandler().getClass().getClassLoader() != this.classLoader) continue;
                ((Buffer)object).setFoldHandler(new DummyFoldHandler());
            }
        }
        if (this.plugin != null && !(this.plugin instanceof EditPlugin.Broken)) {
            if (this.plugin instanceof EBPlugin) {
                EditBus.removeFromBus((EBPlugin)this.plugin);
            }
            try {
                this.plugin.stop();
            }
            catch (Throwable throwable) {
                Log.log(9, this, "Error while stopping plugin:");
                Log.log(9, this, throwable);
            }
            this.plugin = new EditPlugin.Deferred(this.plugin.getClassName());
            this.plugin.jar = (EditPlugin.JAR)this;
            EditBus.send(new PluginUpdate(this, PluginUpdate.DEACTIVATED, bl));
            if (!bl && (object = jEdit.getProperty("plugin." + this.plugin.getClassName() + ".activate")) == null) {
                this.breakPlugin();
                jEdit.pluginError(this.path, "plugin-error.not-42", null);
            }
        }
        this.activated = false;
    }

    public URL getDockablesURI() {
        return this.dockablesURI;
    }

    public URL getServicesURI() {
        return this.servicesURI;
    }

    public String toString() {
        if (this.plugin == null) {
            return this.path;
        }
        return this.path + ",class=" + this.plugin.getClassName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PluginCacheEntry getPluginCache(PluginJAR pluginJAR) {
        String string = pluginJAR.getCachePath();
        if (string == null) {
            return null;
        }
        FilterInputStream filterInputStream = null;
        try {
            PluginCacheEntry pluginCacheEntry = new PluginCacheEntry();
            pluginCacheEntry.plugin = pluginJAR;
            pluginCacheEntry.modTime = pluginJAR.getFile().lastModified();
            filterInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(string)));
            if (pluginCacheEntry.read((DataInputStream)filterInputStream)) {
                PluginCacheEntry pluginCacheEntry2 = pluginCacheEntry;
                return pluginCacheEntry2;
            }
            PluginCacheEntry pluginCacheEntry3 = null;
            return pluginCacheEntry3;
        }
        catch (FileNotFoundException fileNotFoundException) {
            PluginCacheEntry pluginCacheEntry = null;
            return pluginCacheEntry;
        }
        catch (IOException iOException) {
            Log.log(9, PluginJAR.class, iOException);
            PluginCacheEntry pluginCacheEntry = null;
            return pluginCacheEntry;
        }
        finally {
            try {
                if (filterInputStream != null) {
                    filterInputStream.close();
                }
            }
            catch (IOException iOException) {
                Log.log(9, PluginJAR.class, iOException);
            }
        }
    }

    static void setPluginCache(PluginJAR pluginJAR, PluginCacheEntry pluginCacheEntry) {
        String string = pluginJAR.getCachePath();
        if (string == null) {
            return;
        }
        Log.log(1, PluginJAR.class, "Writing " + string);
        DataOutputStream dataOutputStream = null;
        try {
            dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
            pluginCacheEntry.write(dataOutputStream);
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            Log.log(9, PluginJAR.class, iOException);
            try {
                if (dataOutputStream != null) {
                    dataOutputStream.close();
                }
            }
            catch (IOException iOException2) {
                Log.log(9, PluginJAR.class, iOException2);
            }
            new File(string).delete();
        }
    }

    PluginJAR(File file) {
        this.path = file.getPath();
        String string = jEdit.getJARCacheDirectory();
        if (string != null) {
            this.cachePath = MiscUtilities.constructPath(string, file.getName() + ".summary");
        }
        this.file = file;
        this.classLoader = new JARClassLoader(this);
        this.actions = new ActionSet();
    }

    void init() {
        boolean bl = false;
        PluginCacheEntry pluginCacheEntry = PluginJAR.getPluginCache(this);
        if (pluginCacheEntry != null) {
            this.loadCache(pluginCacheEntry);
            this.classLoader.activate();
            bl = true;
        } else {
            try {
                pluginCacheEntry = this.generateCache();
                if (pluginCacheEntry != null) {
                    PluginJAR.setPluginCache(this, pluginCacheEntry);
                    this.classLoader.activate();
                    bl = true;
                }
            }
            catch (IOException iOException) {
                Log.log(9, this, "Cannot load plugin " + this.path);
                Log.log(9, this, iOException);
                Object[] objectArray = new String[]{iOException.toString()};
                jEdit.pluginError(this.path, "plugin-error.load-error", objectArray);
                this.uninit(false);
            }
        }
    }

    void uninit(boolean bl) {
        this.deactivatePlugin(bl);
        if (!bl) {
            for (String string : this.weRequireThese) {
                PluginJAR pluginJAR = jEdit.getPluginJAR(string);
                if (pluginJAR == null) continue;
                pluginJAR.theseRequireMe.remove(this.path);
            }
            this.classLoader.deactivate();
            BeanShell.resetClassManager();
            if (this.actions != null) {
                jEdit.getActionContext().removeActionSet(this.actions);
            }
            if (this.browserActions != null) {
                VFSBrowser.getActionContext().removeActionSet(this.browserActions);
            }
            DockableWindowManager.unloadDockableWindows(this);
            ServiceManager.unloadServices(this);
            jEdit.removePluginProps(this.properties);
            try {
                if (this.zipFile != null) {
                    this.zipFile.close();
                    this.zipFile = null;
                }
            }
            catch (IOException iOException) {
                Log.log(9, this, iOException);
            }
        }
    }

    String[] getClasses() {
        return this.classes;
    }

    private void actionsPresentButNotCoreClass() {
        Log.log(7, this, this.getPath() + " has an actions.xml but no plugin core class");
        this.actions.setLabel("MISSING PLUGIN CORE CLASS");
    }

    private void loadCache(PluginCacheEntry pluginCacheEntry) {
        this.classes = pluginCacheEntry.classes;
        if (pluginCacheEntry.cachedProperties != null) {
            this.properties = pluginCacheEntry.cachedProperties;
            jEdit.addPluginProps(pluginCacheEntry.cachedProperties);
        }
        if (pluginCacheEntry.actionsURI != null && pluginCacheEntry.cachedActionNames != null) {
            this.actions = new ActionSet(this, pluginCacheEntry.cachedActionNames, pluginCacheEntry.cachedActionToggleFlags, pluginCacheEntry.actionsURI);
        }
        if (pluginCacheEntry.browserActionsURI != null && pluginCacheEntry.cachedBrowserActionNames != null) {
            this.browserActions = new ActionSet(this, pluginCacheEntry.cachedBrowserActionNames, pluginCacheEntry.cachedBrowserActionToggleFlags, pluginCacheEntry.browserActionsURI);
            VFSBrowser.getActionContext().addActionSet(this.browserActions);
        }
        if (pluginCacheEntry.dockablesURI != null && pluginCacheEntry.cachedDockableNames != null && pluginCacheEntry.cachedDockableActionFlags != null) {
            this.dockablesURI = pluginCacheEntry.dockablesURI;
            DockableWindowManager.cacheDockableWindows(this, pluginCacheEntry.cachedDockableNames, pluginCacheEntry.cachedDockableActionFlags);
        }
        if (this.actions.size() != 0) {
            jEdit.addActionSet(this.actions);
        }
        if (pluginCacheEntry.servicesURI != null && pluginCacheEntry.cachedServices != null) {
            this.servicesURI = pluginCacheEntry.servicesURI;
            for (int i = 0; i < pluginCacheEntry.cachedServices.length; ++i) {
                ServiceManager.Descriptor descriptor = pluginCacheEntry.cachedServices[i];
                ServiceManager.registerService(descriptor);
            }
        }
        if (pluginCacheEntry.pluginClass != null) {
            if (jEdit.getPlugin(pluginCacheEntry.pluginClass) != null) {
                jEdit.pluginError(this.path, "plugin-error.already-loaded", null);
                this.uninit(false);
            } else {
                String string = jEdit.getProperty("plugin." + pluginCacheEntry.pluginClass + ".name");
                this.actions.setLabel(jEdit.getProperty("action-set.plugin", new String[]{string}));
                this.plugin = new EditPlugin.Deferred(pluginCacheEntry.pluginClass);
                this.plugin.jar = (EditPlugin.JAR)this;
            }
        } else if (this.actions.size() != 0) {
            this.actionsPresentButNotCoreClass();
        }
    }

    /*
     * WARNING - void declaration
     */
    private PluginCacheEntry generateCache() throws IOException {
        Object object;
        Object object2;
        this.properties = new Properties();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        ZipFile zipFile = this.getZipFile();
        LinkedList<Object> linkedList2 = new LinkedList<Object>();
        PluginCacheEntry pluginCacheEntry = new PluginCacheEntry();
        pluginCacheEntry.modTime = this.file.lastModified();
        pluginCacheEntry.cachedProperties = new Properties();
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            String string = ((ZipEntry)object2).getName();
            String string2 = string.toLowerCase();
            if (string2.equals("actions.xml")) {
                pluginCacheEntry.actionsURI = this.classLoader.getResource(string);
                continue;
            }
            if (string2.equals("browser.actions.xml")) {
                pluginCacheEntry.browserActionsURI = this.classLoader.getResource(string);
                continue;
            }
            if (string2.equals("dockables.xml")) {
                pluginCacheEntry.dockablesURI = this.dockablesURI = this.classLoader.getResource(string);
                continue;
            }
            if (string2.equals("services.xml")) {
                pluginCacheEntry.servicesURI = this.servicesURI = this.classLoader.getResource(string);
                continue;
            }
            if (string2.endsWith(".props")) {
                object = this.classLoader.getResourceAsStream(string);
                this.properties.load((InputStream)object);
                ((InputStream)object).close();
                continue;
            }
            if (!string.endsWith(".class")) continue;
            object = MiscUtilities.fileToClass(string);
            if (((String)object).endsWith("Plugin")) {
                linkedList2.add(object);
            }
            linkedList.add(object);
        }
        pluginCacheEntry.cachedProperties = this.properties;
        jEdit.addPluginProps(this.properties);
        pluginCacheEntry.classes = linkedList.toArray(new String[linkedList.size()]);
        this.classes = pluginCacheEntry.classes;
        object2 = null;
        for (String i : linkedList2) {
            object = jEdit.getProperty("plugin." + i + ".name");
            String string = jEdit.getProperty("plugin." + i + ".version");
            if (object == null || string == null) {
                Log.log(7, this, "Ignoring: " + i);
                continue;
            }
            pluginCacheEntry.pluginClass = i;
            if (jEdit.getPlugin(i) != null) {
                jEdit.pluginError(this.path, "plugin-error.already-loaded", null);
                return null;
            }
            this.plugin = new EditPlugin.Deferred(i);
            this.plugin.jar = (EditPlugin.JAR)this;
            object2 = object;
            break;
        }
        if (pluginCacheEntry.actionsURI != null) {
            void var8_12;
            this.actions = new ActionSet(this, null, null, pluginCacheEntry.actionsURI);
            this.actions.load();
            pluginCacheEntry.cachedActionNames = this.actions.getCacheableActionNames();
            pluginCacheEntry.cachedActionToggleFlags = new boolean[pluginCacheEntry.cachedActionNames.length];
            boolean bl = false;
            while (var8_12 < pluginCacheEntry.cachedActionNames.length) {
                pluginCacheEntry.cachedActionToggleFlags[var8_12] = jEdit.getBooleanProperty(pluginCacheEntry.cachedActionNames[var8_12] + ".toggle");
                ++var8_12;
            }
        }
        if (pluginCacheEntry.browserActionsURI != null) {
            void var8_14;
            this.browserActions = new ActionSet(this, null, null, pluginCacheEntry.browserActionsURI);
            this.browserActions.load();
            VFSBrowser.getActionContext().addActionSet(this.browserActions);
            pluginCacheEntry.cachedBrowserActionNames = this.browserActions.getCacheableActionNames();
            pluginCacheEntry.cachedBrowserActionToggleFlags = new boolean[pluginCacheEntry.cachedBrowserActionNames.length];
            boolean bl = false;
            while (var8_14 < pluginCacheEntry.cachedBrowserActionNames.length) {
                pluginCacheEntry.cachedBrowserActionToggleFlags[var8_14] = jEdit.getBooleanProperty(pluginCacheEntry.cachedBrowserActionNames[var8_14] + ".toggle");
                ++var8_14;
            }
        }
        if (this.dockablesURI != null) {
            DockableWindowManager.loadDockableWindows(this, this.dockablesURI, pluginCacheEntry);
        }
        if (this.actions.size() != 0) {
            if (object2 != null) {
                this.actions.setLabel(jEdit.getProperty("action-set.plugin", new String[]{object2}));
            } else {
                this.actionsPresentButNotCoreClass();
            }
            jEdit.addActionSet(this.actions);
        }
        if (this.servicesURI != null) {
            ServiceManager.loadServices(this, this.servicesURI, pluginCacheEntry);
        }
        return pluginCacheEntry;
    }

    private void startPlugin() {
        Object[] objectArray;
        try {
            this.plugin.start();
        }
        catch (Throwable throwable) {
            this.breakPlugin();
            Log.log(9, this, "Error while starting plugin " + this.plugin.getClassName());
            Log.log(9, this, throwable);
            objectArray = new String[]{throwable.toString()};
            jEdit.pluginError(this.path, "plugin-error.start-error", objectArray);
        }
        if (this.plugin instanceof EBPlugin) {
            if (jEdit.getProperty("plugin." + this.plugin.getClassName() + ".activate") == null) {
                ((EBComponent)((Object)this.plugin)).handleMessage(new PropertiesChanged(null));
            }
            EditBus.addToBus((EBPlugin)this.plugin);
        }
        for (Buffer buffer = jEdit.getFirstBuffer(); buffer != null; buffer = buffer.getNext()) {
            objectArray = FoldHandler.getFoldHandler(buffer.getStringProperty("folding"));
            if (buffer.getFoldHandler() == null || objectArray == null || objectArray == buffer.getFoldHandler()) continue;
            buffer.setFoldHandler((FoldHandler)objectArray);
        }
    }

    private void startPluginLater() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (!PluginJAR.this.activated) {
                    return;
                }
                PluginJAR.this.startPlugin();
            }
        });
    }

    private void breakPlugin() {
        this.plugin = new EditPlugin.Broken(this.plugin.getClassName());
        this.plugin.jar = (EditPlugin.JAR)this;
        this.uninit(false);
        jEdit.addPluginProps(this.properties);
    }

    public static class PluginCacheEntry {
        public static final int MAGIC = -1214061536;
        public PluginJAR plugin;
        public long modTime;
        public String[] classes;
        public URL actionsURI;
        public String[] cachedActionNames;
        public boolean[] cachedActionToggleFlags;
        public URL browserActionsURI;
        public String[] cachedBrowserActionNames;
        public boolean[] cachedBrowserActionToggleFlags;
        public URL dockablesURI;
        public String[] cachedDockableNames;
        public boolean[] cachedDockableActionFlags;
        public URL servicesURI;
        public ServiceManager.Descriptor[] cachedServices;
        public Properties cachedProperties;
        public String pluginClass;

        public boolean read(DataInputStream dataInputStream) throws IOException {
            int n = dataInputStream.readInt();
            if (n != -1214061536) {
                return false;
            }
            String string = this.readString(dataInputStream);
            if (!string.equals(jEdit.getBuild())) {
                return false;
            }
            long l = dataInputStream.readLong();
            if (l != this.modTime) {
                return false;
            }
            this.actionsURI = this.readURI(dataInputStream);
            this.cachedActionNames = this.readStringArray(dataInputStream);
            this.cachedActionToggleFlags = this.readBooleanArray(dataInputStream);
            this.browserActionsURI = this.readURI(dataInputStream);
            this.cachedBrowserActionNames = this.readStringArray(dataInputStream);
            this.cachedBrowserActionToggleFlags = this.readBooleanArray(dataInputStream);
            this.dockablesURI = this.readURI(dataInputStream);
            this.cachedDockableNames = this.readStringArray(dataInputStream);
            this.cachedDockableActionFlags = this.readBooleanArray(dataInputStream);
            this.servicesURI = this.readURI(dataInputStream);
            int n2 = dataInputStream.readInt();
            if (n2 == 0) {
                this.cachedServices = null;
            } else {
                this.cachedServices = new ServiceManager.Descriptor[n2];
                for (int i = 0; i < n2; ++i) {
                    ServiceManager.Descriptor descriptor;
                    this.cachedServices[i] = descriptor = new ServiceManager.Descriptor(this.readString(dataInputStream), this.readString(dataInputStream), null, this.plugin);
                }
            }
            this.classes = this.readStringArray(dataInputStream);
            this.cachedProperties = this.readMap(dataInputStream);
            this.pluginClass = this.readString(dataInputStream);
            return true;
        }

        public void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeInt(-1214061536);
            this.writeString(dataOutputStream, jEdit.getBuild());
            dataOutputStream.writeLong(this.modTime);
            this.writeString(dataOutputStream, this.actionsURI);
            this.writeStringArray(dataOutputStream, this.cachedActionNames);
            this.writeBooleanArray(dataOutputStream, this.cachedActionToggleFlags);
            this.writeString(dataOutputStream, this.browserActionsURI);
            this.writeStringArray(dataOutputStream, this.cachedBrowserActionNames);
            this.writeBooleanArray(dataOutputStream, this.cachedBrowserActionToggleFlags);
            this.writeString(dataOutputStream, this.dockablesURI);
            this.writeStringArray(dataOutputStream, this.cachedDockableNames);
            this.writeBooleanArray(dataOutputStream, this.cachedDockableActionFlags);
            this.writeString(dataOutputStream, this.servicesURI);
            if (this.cachedServices == null) {
                dataOutputStream.writeInt(0);
            } else {
                dataOutputStream.writeInt(this.cachedServices.length);
                for (int i = 0; i < this.cachedServices.length; ++i) {
                    this.writeString(dataOutputStream, this.cachedServices[i].clazz);
                    this.writeString(dataOutputStream, this.cachedServices[i].name);
                }
            }
            this.writeStringArray(dataOutputStream, this.classes);
            this.writeMap(dataOutputStream, this.cachedProperties);
            this.writeString(dataOutputStream, this.pluginClass);
        }

        private String readString(DataInputStream dataInputStream) throws IOException {
            int n = dataInputStream.readInt();
            if (n == 0) {
                return null;
            }
            char[] cArray = new char[n];
            for (int i = 0; i < n; ++i) {
                cArray[i] = dataInputStream.readChar();
            }
            return new String(cArray);
        }

        private URL readURI(DataInputStream dataInputStream) throws IOException {
            String string = this.readString(dataInputStream);
            if (string == null) {
                return null;
            }
            return new URL(string);
        }

        private String[] readStringArray(DataInputStream dataInputStream) throws IOException {
            int n = dataInputStream.readInt();
            if (n == 0) {
                return null;
            }
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = this.readString(dataInputStream);
            }
            return stringArray;
        }

        private boolean[] readBooleanArray(DataInputStream dataInputStream) throws IOException {
            int n = dataInputStream.readInt();
            if (n == 0) {
                return null;
            }
            boolean[] blArray = new boolean[n];
            for (int i = 0; i < n; ++i) {
                blArray[i] = dataInputStream.readBoolean();
            }
            return blArray;
        }

        private Properties readMap(DataInputStream dataInputStream) throws IOException {
            Properties properties = new Properties();
            int n = dataInputStream.readInt();
            for (int i = 0; i < n; ++i) {
                String string = this.readString(dataInputStream);
                String string2 = this.readString(dataInputStream);
                if (string2 == null) {
                    string2 = "";
                }
                properties.put(string, string2);
            }
            return properties;
        }

        private void writeString(DataOutputStream dataOutputStream, Object object) throws IOException {
            if (object == null) {
                dataOutputStream.writeInt(0);
            } else {
                String string = object.toString();
                dataOutputStream.writeInt(string.length());
                dataOutputStream.writeChars(string);
            }
        }

        private void writeStringArray(DataOutputStream dataOutputStream, String[] stringArray) throws IOException {
            if (stringArray == null) {
                dataOutputStream.writeInt(0);
            } else {
                dataOutputStream.writeInt(stringArray.length);
                for (int i = 0; i < stringArray.length; ++i) {
                    this.writeString(dataOutputStream, stringArray[i]);
                }
            }
        }

        private void writeBooleanArray(DataOutputStream dataOutputStream, boolean[] blArray) throws IOException {
            if (blArray == null) {
                dataOutputStream.writeInt(0);
            } else {
                dataOutputStream.writeInt(blArray.length);
                for (int i = 0; i < blArray.length; ++i) {
                    dataOutputStream.writeBoolean(blArray[i]);
                }
            }
        }

        private void writeMap(DataOutputStream dataOutputStream, Map map) throws IOException {
            dataOutputStream.writeInt(map.size());
            for (String string : map.keySet()) {
                this.writeString(dataOutputStream, string);
                this.writeString(dataOutputStream, map.get(string));
            }
        }
    }
}

