/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Java14;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.BufferSwitcher;
import org.gjt.sp.jedit.gui.StatusBar;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.options.GlobalOptions;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.textarea.Gutter;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.TextAreaPainter;
import org.gjt.sp.util.Log;

public class EditPane
extends JPanel
implements EBComponent {
    private static Method initBufferSwitcher;
    private boolean init = true;
    private View view;
    private Buffer buffer;
    private Buffer recentBuffer;
    private BufferSwitcher bufferSwitcher;
    private JEditTextArea textArea;

    public View getView() {
        return this.view;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(final Buffer buffer) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (this.buffer == buffer) {
            return;
        }
        this.recentBuffer = this.buffer;
        if (this.recentBuffer != null) {
            this.saveCaretInfo();
        }
        this.buffer = buffer;
        this.textArea.setBuffer(buffer);
        if (!this.init) {
            this.view.updateTitle();
            if (this.bufferSwitcher != null && this.bufferSwitcher.getSelectedItem() != buffer) {
                this.bufferSwitcher.setSelectedItem(buffer);
            }
            EditBus.send(new EditPaneUpdate(this, EditPaneUpdate.BUFFER_CHANGED));
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (!(EditPane.this.view.getEditPane() != EditPane.this || EditPane.this.bufferSwitcher != null && EditPane.this.bufferSwitcher.isPopupVisible())) {
                    EditPane.this.textArea.requestFocus();
                }
            }
        });
        Runnable runnable = new Runnable(){

            public void run() {
                if (buffer == EditPane.this.getBuffer()) {
                    EditPane.this.loadCaretInfo();
                }
            }
        };
        if (buffer.isPerformingIO()) {
            VFSManager.runInAWTThread(runnable);
        } else {
            runnable.run();
        }
    }

    public void prevBuffer() {
        Buffer buffer = this.buffer.getPrev();
        if (buffer == null) {
            this.setBuffer(jEdit.getLastBuffer());
        } else {
            this.setBuffer(buffer);
        }
    }

    public void nextBuffer() {
        Buffer buffer = this.buffer.getNext();
        if (buffer == null) {
            this.setBuffer(jEdit.getFirstBuffer());
        } else {
            this.setBuffer(buffer);
        }
    }

    public void recentBuffer() {
        if (this.recentBuffer != null) {
            this.setBuffer(this.recentBuffer);
        } else {
            this.getToolkit().beep();
        }
    }

    public void focusOnTextArea() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EditPane.this.textArea.requestFocus();
            }
        });
    }

    public JEditTextArea getTextArea() {
        return this.textArea;
    }

    public BufferSwitcher getBufferSwitcher() {
        return this.bufferSwitcher;
    }

    public void showBufferSwitcher() {
        if (this.bufferSwitcher == null) {
            this.getToolkit().beep();
        } else {
            this.bufferSwitcher.requestFocus();
            this.bufferSwitcher.showPopup();
        }
    }

    public void saveCaretInfo() {
        if (!this.buffer.isLoaded()) {
            return;
        }
        this.buffer.setIntegerProperty("Buffer__caret", this.textArea.getCaretPosition());
        this.buffer.setIntegerProperty("Buffer__scrollVert", this.textArea.getFirstPhysicalLine());
        this.buffer.setIntegerProperty("Buffer__scrollHoriz", this.textArea.getHorizontalOffset());
    }

    public void loadCaretInfo() {
        Integer n = (Integer)this.buffer.getProperty("Buffer__caret");
        Integer n2 = (Integer)this.buffer.getProperty("Buffer__scrollVert");
        Integer n3 = (Integer)this.buffer.getProperty("Buffer__scrollHoriz");
        if (n != null) {
            this.textArea.setCaretPosition(Math.min(n, this.buffer.getLength()));
        }
        if (n2 != null) {
            this.textArea.setFirstPhysicalLine(n2);
        }
        if (n3 != null) {
            this.textArea.setHorizontalOffset(n3);
        }
        this.view.getStatus().setMessage(null);
    }

    public void handleMessage(EBMessage eBMessage) {
        if (eBMessage instanceof PropertiesChanged) {
            this.propertiesChanged();
            this.loadBufferSwitcher();
        } else if (eBMessage instanceof BufferUpdate) {
            this.handleBufferUpdate((BufferUpdate)eBMessage);
        }
    }

    public final Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public String toString() {
        return this.getClass().getName() + "[" + (this.view.getEditPane() == this ? "active" : "inactive") + "]";
    }

    EditPane(View view, Buffer buffer) {
        super(new BorderLayout());
        this.view = view;
        EditBus.addToBus(this);
        this.textArea = new JEditTextArea(view);
        this.add("Center", this.textArea);
        this.propertiesChanged();
        if (buffer == null) {
            this.setBuffer(jEdit.getFirstBuffer());
        } else {
            this.setBuffer(buffer);
        }
        this.loadBufferSwitcher();
        this.init = false;
    }

    void close() {
        this.saveCaretInfo();
        EditBus.send(new EditPaneUpdate(this, EditPaneUpdate.DESTROYED));
        EditBus.removeFromBus(this);
        this.textArea.dispose();
    }

    private void propertiesChanged() {
        TextAreaPainter textAreaPainter = this.textArea.getPainter();
        textAreaPainter.setFont(jEdit.getFontProperty("view.font"));
        textAreaPainter.setStructureHighlightEnabled(jEdit.getBooleanProperty("view.structureHighlight"));
        textAreaPainter.setStructureHighlightColor(jEdit.getColorProperty("view.structureHighlightColor"));
        textAreaPainter.setEOLMarkersPainted(jEdit.getBooleanProperty("view.eolMarkers"));
        textAreaPainter.setEOLMarkerColor(jEdit.getColorProperty("view.eolMarkerColor"));
        textAreaPainter.setWrapGuidePainted(jEdit.getBooleanProperty("view.wrapGuide"));
        textAreaPainter.setWrapGuideColor(jEdit.getColorProperty("view.wrapGuideColor"));
        textAreaPainter.setCaretColor(jEdit.getColorProperty("view.caretColor"));
        textAreaPainter.setSelectionColor(jEdit.getColorProperty("view.selectionColor"));
        textAreaPainter.setMultipleSelectionColor(jEdit.getColorProperty("view.multipleSelectionColor"));
        textAreaPainter.setBackground(jEdit.getColorProperty("view.bgColor"));
        textAreaPainter.setForeground(jEdit.getColorProperty("view.fgColor"));
        textAreaPainter.setBlockCaretEnabled(jEdit.getBooleanProperty("view.blockCaret"));
        textAreaPainter.setLineHighlightEnabled(jEdit.getBooleanProperty("view.lineHighlight"));
        textAreaPainter.setLineHighlightColor(jEdit.getColorProperty("view.lineHighlightColor"));
        textAreaPainter.setAntiAliasEnabled(jEdit.getBooleanProperty("view.antiAlias"));
        textAreaPainter.setFractionalFontMetricsEnabled(jEdit.getBooleanProperty("view.fracFontMetrics"));
        String string = jEdit.getProperty("view.font");
        int n = jEdit.getIntegerProperty("view.fontsize", 12);
        textAreaPainter.setStyles(GUIUtilities.loadStyles(string, n));
        SyntaxStyle[] syntaxStyleArray = new SyntaxStyle[4];
        for (int i = 0; i <= 3; ++i) {
            syntaxStyleArray[i] = GUIUtilities.parseStyle(jEdit.getProperty("view.style.foldLine." + i), string, n);
        }
        textAreaPainter.setFoldLineStyle(syntaxStyleArray);
        Gutter gutter = this.textArea.getGutter();
        gutter.setExpanded(jEdit.getBooleanProperty("view.gutter.lineNumbers"));
        int n2 = jEdit.getIntegerProperty("view.gutter.highlightInterval", 5);
        gutter.setHighlightInterval(n2);
        gutter.setCurrentLineHighlightEnabled(jEdit.getBooleanProperty("view.gutter.highlightCurrentLine"));
        gutter.setStructureHighlightEnabled(jEdit.getBooleanProperty("view.gutter.structureHighlight"));
        gutter.setStructureHighlightColor(jEdit.getColorProperty("view.gutter.structureHighlightColor"));
        gutter.setBackground(jEdit.getColorProperty("view.gutter.bgColor"));
        gutter.setForeground(jEdit.getColorProperty("view.gutter.fgColor"));
        gutter.setHighlightedForeground(jEdit.getColorProperty("view.gutter.highlightColor"));
        gutter.setFoldColor(jEdit.getColorProperty("view.gutter.foldColor"));
        gutter.setMarkerHighlightColor(jEdit.getColorProperty("view.gutter.markerColor"));
        gutter.setMarkerHighlightEnabled(jEdit.getBooleanProperty("view.gutter.markerHighlight"));
        gutter.setCurrentLineForeground(jEdit.getColorProperty("view.gutter.currentLineColor"));
        String string2 = jEdit.getProperty("view.gutter.numberAlignment");
        if ("right".equals(string2)) {
            gutter.setLineNumberAlignment(4);
        } else if ("center".equals(string2)) {
            gutter.setLineNumberAlignment(0);
        } else {
            gutter.setLineNumberAlignment(2);
        }
        gutter.setFont(jEdit.getFontProperty("view.gutter.font"));
        int n3 = jEdit.getIntegerProperty("view.gutter.borderWidth", 3);
        gutter.setBorder(n3, jEdit.getColorProperty("view.gutter.focusBorderColor"), jEdit.getColorProperty("view.gutter.noFocusBorderColor"), this.textArea.getPainter().getBackground());
        this.textArea.setCaretBlinkEnabled(jEdit.getBooleanProperty("view.caretBlink"));
        this.textArea.setElectricScroll(jEdit.getIntegerProperty("view.electricBorders", 0));
        JPopupMenu jPopupMenu = GUIUtilities.loadPopupMenu("view.context");
        JMenuItem jMenuItem = new JMenuItem(jEdit.getProperty("view.context.customize"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new GlobalOptions(EditPane.this.view.getFrame(), "context");
            }
        });
        jPopupMenu.addSeparator();
        jPopupMenu.add(jMenuItem);
        this.textArea.setRightClickPopup(jPopupMenu);
        this.textArea.setQuickCopyEnabled(jEdit.getBooleanProperty("view.middleMousePaste"));
        this.textArea.setDragEnabled(jEdit.getBooleanProperty("view.dragAndDrop"));
        this.textArea.propertiesChanged();
    }

    private void loadBufferSwitcher() {
        if (jEdit.getBooleanProperty("view.showBufferSwitcher")) {
            if (this.bufferSwitcher == null) {
                this.bufferSwitcher = new BufferSwitcher(this);
                if (initBufferSwitcher != null) {
                    try {
                        initBufferSwitcher.invoke(null, this, this.bufferSwitcher);
                    }
                    catch (Exception exception) {
                        Log.log(9, this, exception);
                    }
                }
                this.add("North", this.bufferSwitcher);
                this.bufferSwitcher.updateBufferList();
                this.revalidate();
            }
        } else if (this.bufferSwitcher != null) {
            this.remove(this.bufferSwitcher);
            this.revalidate();
            this.bufferSwitcher = null;
        }
    }

    private void handleBufferUpdate(BufferUpdate bufferUpdate) {
        Buffer buffer = bufferUpdate.getBuffer();
        if (bufferUpdate.getWhat() == BufferUpdate.CREATED) {
            if (this.bufferSwitcher != null) {
                this.bufferSwitcher.updateBufferList();
            }
            if (this.buffer.isClosed()) {
                this.setBuffer(jEdit.getFirstBuffer());
                this.recentBuffer = null;
            }
        } else if (bufferUpdate.getWhat() == BufferUpdate.CLOSED) {
            if (this.bufferSwitcher != null) {
                this.bufferSwitcher.updateBufferList();
            }
            if (buffer == this.buffer) {
                Buffer buffer2;
                Buffer buffer3 = buffer2 = this.recentBuffer != null ? this.recentBuffer : buffer.getPrev();
                if (buffer2 != null && !buffer2.isClosed()) {
                    this.setBuffer(buffer2);
                } else if (jEdit.getBufferCount() != 0) {
                    this.setBuffer(jEdit.getFirstBuffer());
                }
                this.recentBuffer = null;
            } else if (buffer == this.recentBuffer) {
                this.recentBuffer = null;
            }
        } else if (bufferUpdate.getWhat() == BufferUpdate.LOAD_STARTED) {
            if (buffer == this.buffer) {
                this.textArea.setCaretPosition(0);
                this.textArea.getPainter().repaint();
            }
        } else if (bufferUpdate.getWhat() == BufferUpdate.LOADED) {
            if (buffer == this.buffer) {
                this.textArea.repaint();
                if (this.bufferSwitcher != null) {
                    this.bufferSwitcher.updateBufferList();
                }
                if (this.view.getEditPane() == this) {
                    StatusBar statusBar = this.view.getStatus();
                    statusBar.updateCaretStatus();
                    statusBar.updateBufferStatus();
                    statusBar.updateMiscStatus();
                }
                this.loadCaretInfo();
            }
        } else if (bufferUpdate.getWhat() == BufferUpdate.DIRTY_CHANGED) {
            if (buffer == this.buffer && this.bufferSwitcher != null) {
                if (this.buffer.isDirty()) {
                    this.bufferSwitcher.repaint();
                } else {
                    this.bufferSwitcher.updateBufferList();
                }
            }
        } else if (bufferUpdate.getWhat() == BufferUpdate.MARKERS_CHANGED) {
            if (buffer == this.buffer) {
                this.textArea.getGutter().repaint();
            }
        } else if (bufferUpdate.getWhat() == BufferUpdate.PROPERTIES_CHANGED) {
            if (buffer == this.buffer) {
                this.textArea.propertiesChanged();
                if (this.view.getEditPane() == this) {
                    this.view.getStatus().updateBufferStatus();
                }
            }
        } else if (bufferUpdate.getWhat() == BufferUpdate.SAVED && buffer == this.buffer) {
            this.textArea.propertiesChanged();
        }
    }

    static {
        if (OperatingSystem.hasJava14()) {
            try {
                initBufferSwitcher = Java14.class.getMethod("initBufferSwitcher", EditPane.class, BufferSwitcher.class);
            }
            catch (Exception exception) {
                Log.log(9, EditPane.class, exception);
            }
        }
    }
}

