/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

class CharIndexedReader
implements CharIndexed {
    private static final int BUFFER_INCREMENT = 1024;
    private static final int UNKNOWN = Integer.MAX_VALUE;
    private final BufferedReader br;
    private int index = -1;
    private int bufsize = 1024;
    private int end = Integer.MAX_VALUE;
    private char cached = (char)65535;
    private char[] lookBehind = new char[]{'\uffff', '\uffff'};

    CharIndexedReader(Reader reader, int n) {
        this.br = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, 1024);
        this.next();
        if (n > 0) {
            this.move(n);
        }
    }

    private boolean next() {
        this.lookBehind[1] = this.lookBehind[0];
        this.lookBehind[0] = this.cached;
        if (this.end == 1) {
            this.cached = (char)65535;
            return false;
        }
        --this.end;
        try {
            if (this.index != -1) {
                this.br.reset();
            }
            int n = this.br.read();
            this.br.mark(this.bufsize);
            if (n == -1) {
                this.end = 1;
                this.cached = (char)65535;
                return false;
            }
            this.cached = (char)n;
            this.index = 1;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.cached = (char)65535;
            return false;
        }
        return true;
    }

    public char charAt(int n) {
        if (n == 0) {
            return this.cached;
        }
        if (n >= this.end) {
            return '\uffff';
        }
        if (n >= this.bufsize) {
            try {
                while (this.bufsize <= n) {
                    this.bufsize += 1024;
                }
                this.br.reset();
                this.br.mark(this.bufsize);
                this.br.skip(n - 1);
            }
            catch (IOException iOException) {}
        } else if (this.index != n) {
            try {
                this.br.reset();
                this.br.skip(n - 1);
            }
            catch (IOException iOException) {}
        } else {
            if (n == -1) {
                return this.lookBehind[0];
            }
            if (n == -2) {
                return this.lookBehind[1];
            }
            if (n < -2) {
                return '\uffff';
            }
        }
        char c = '\uffff';
        try {
            int n2 = this.br.read();
            this.index = n + 1;
            if (n2 == -1) {
                this.end = n;
                return c;
            }
            c = (char)n2;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return c;
    }

    public boolean move(int n) {
        boolean bl = true;
        while (bl && n-- > 0) {
            bl = this.next();
        }
        return bl;
    }

    public boolean isValid() {
        return this.cached != '\uffff';
    }
}

