/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.jedit;

import de.grogra.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.StringTokenizer;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.buffer.FoldHandler;

public class StringFoldHandler
extends FoldHandler {
    private final String[] opening;
    private final String[] closing;
    private final boolean javaEscaping;

    public StringFoldHandler(String string, String[] stringArray, String[] stringArray2, boolean bl) {
        super(string);
        this.opening = stringArray;
        this.closing = stringArray2;
        this.javaEscaping = bl;
    }

    public StringFoldHandler(String string, String string2, String string3, boolean bl) {
        this(string, StringFoldHandler.toArray(string2), StringFoldHandler.toArray(string3), bl);
    }

    private static String[] toArray(String string) {
        ArrayList<Object> arrayList = Collections.list(new StringTokenizer(string));
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static int find(String[] stringArray, char[] cArray, int n, int n2) {
        block0: for (int i = stringArray.length - 1; i >= 0; --i) {
            String string = stringArray[i];
            int n3 = string.length();
            if (n + n3 > n2) continue;
            for (int j = 0; j < n3; ++j) {
                if (string.charAt(j) != cArray[n + j]) continue block0;
            }
            return n3;
        }
        return 0;
    }

    public int getFoldLevel(Buffer buffer, int n, Segment segment) {
        if (n == 0) {
            return 0;
        }
        buffer.getLineText(n - 1, segment);
        int n2 = buffer.getFoldLevel(n - 1);
        int n3 = segment.offset;
        int n4 = segment.offset + segment.count;
        boolean bl = false;
        block4: while (n3 < n4) {
            int n5;
            if (this.javaEscaping) {
                switch (segment.array[n3]) {
                    case '\\': {
                        n3 += 2;
                        continue block4;
                    }
                    case '\"': 
                    case '\'': {
                        bl = !bl;
                        ++n3;
                        continue block4;
                    }
                }
                if (bl) {
                    ++n3;
                    continue;
                }
            }
            if ((n5 = StringFoldHandler.find(this.opening, segment.array, n3, n4)) > 0) {
                n3 += n5;
                ++n2;
                continue;
            }
            n5 = StringFoldHandler.find(this.closing, segment.array, n3, n4);
            if (n5 > 0) {
                n3 += n5;
                if (n2 <= 0) continue;
                --n2;
                continue;
            }
            ++n3;
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof StringFoldHandler)) {
            return false;
        }
        StringFoldHandler stringFoldHandler = (StringFoldHandler)object;
        return Arrays.equals(this.opening, stringFoldHandler.opening) && Arrays.equals(this.closing, stringFoldHandler.closing) && this.javaEscaping == stringFoldHandler.javaEscaping;
    }

    public int hashCode() {
        return Utils.hashCode((Object[])this.opening) ^ Utils.hashCode((Object[])this.closing);
    }
}

