/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp.net;

import de.grogra.imp.net.Connection;
import de.grogra.imp.net.ResponseHandler;
import de.grogra.util.IOWrapException;
import java.io.IOException;

public class SimpleResponseHandler
implements ResponseHandler {
    public static final int INT = 0;
    public static final int LONG = 1;
    public static final int STRING = 2;
    public static final int USER = 3;
    private final int type;
    private boolean haveResult;
    private int intResult;
    private long longResult;
    private String stringResult;

    public SimpleResponseHandler(int n) {
        this.type = n;
    }

    public synchronized void handleResponse(Connection connection, long l, long l2) throws IOException {
        this.haveResult = true;
        this.notifyAll();
        switch (this.type) {
            case 0: {
                this.intResult = connection.getIn().readInt();
                break;
            }
            case 1: {
                this.longResult = connection.getIn().readLong();
                break;
            }
            case 2: {
                this.stringResult = connection.getIn().readUTF();
                break;
            }
            case 3: {
                this.handleUserResponse(connection, l, l2);
                break;
            }
            default: {
                throw new IOException("Illegal type " + this.type);
            }
        }
    }

    protected void handleUserResponse(Connection connection, long l, long l2) throws IOException {
    }

    public synchronized void waitForResult() throws InterruptedException {
        while (!this.haveResult) {
            this.wait();
        }
    }

    public void waitForResultWrapInterruption() throws IOException {
        try {
            this.waitForResult();
        }
        catch (InterruptedException interruptedException) {
            throw new IOWrapException((Throwable)interruptedException);
        }
    }

    public int getInt() throws InterruptedException {
        if (this.type != 0) {
            throw new IllegalStateException();
        }
        this.waitForResult();
        return this.intResult;
    }

    public void consume(int n) throws InterruptedException, IOException {
        int n2 = this.getInt();
        if (n2 != n) {
            throw new IOException("Expected " + n + " instead of " + n2);
        }
    }

    public long getLong() throws InterruptedException {
        if (this.type != 1) {
            throw new IllegalStateException();
        }
        this.waitForResult();
        return this.longResult;
    }

    public String getString() throws InterruptedException {
        if (this.type != 2) {
            throw new IllegalStateException();
        }
        this.waitForResult();
        return this.stringResult;
    }
}

