/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp.net;

import de.grogra.http.Request;
import de.grogra.http.Server;
import de.grogra.imp.net.HttpResponse;
import de.grogra.pf.boot.Main;
import de.grogra.pf.io.FileSource;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IO;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.PluginDescriptor;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.Workbench;
import de.grogra.util.Map;
import de.grogra.util.MimeType;
import de.grogra.util.StringMap;
import de.grogra.util.Utils;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Level;

public class HttpServer
extends Server {
    public static final String HTTP_RESPONSE = "http-response";
    protected final Workbench workbench;

    public HttpServer(Workbench workbench, ServerSocket serverSocket) {
        super(serverSocket, workbench.getLogger(), Workbench.GUI_INFO, Level.WARNING);
        this.workbench = workbench;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleRequest(Request request, Socket socket) throws IOException {
        HttpResponse httpResponse = new HttpResponse(this, request, socket);
        this.workbench.getJobManager().runLater((Command)httpResponse, null, (Context)this.workbench, 10000);
        HttpResponse httpResponse2 = httpResponse;
        synchronized (httpResponse2) {
            try {
                while (!httpResponse.done) {
                    if (this.isClosed()) {
                        return false;
                    }
                    httpResponse.wait(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        if (httpResponse.ex != null) {
            throw httpResponse.ex;
        }
        return httpResponse.cont;
    }

    public static void openProject(Item item, Object object, Context context) throws UnsupportedEncodingException {
        HttpResponse httpResponse = (HttpResponse)object;
        String string = httpResponse.getRequest().getQuery();
        if ("GET".equals(httpResponse.getRequest().getMethod()) && string != null) {
            File file;
            File file2;
            String string2;
            int n = string.indexOf(38);
            if (n >= 0) {
                string = string.substring(0, n);
            }
            if ((string2 = (String)Utils.getObject((Map)item, (Object)"directory")) == null) {
                string2 = System.getProperty("user.home");
            }
            if ((file2 = new File(file = new File(string2), string)).exists()) {
                try {
                    if (file2.getCanonicalPath().startsWith(file.getCanonicalPath())) {
                        StringMap stringMap = new StringMap().putObject(HTTP_RESPONSE, (Object)httpResponse);
                        context.getWorkbench().open((FilterSource)FileSource.createFileSource((String)file2.getAbsolutePath(), (MimeType)IO.getMimeType((String)string), (RegistryContext)context.getWorkbench(), null), (Map)stringMap);
                        return;
                    }
                }
                catch (IOException iOException) {
                    httpResponse.getServer().getLogger().log(httpResponse.getServer().getWarningLevel(), "Exception occured", iOException);
                }
                httpResponse.setContent("text/plain", "UTF-8", "Access forbidden for " + string + '\n');
                httpResponse.send(true, 403, "Access Forbidden");
                return;
            }
        }
        httpResponse.setContent("text/plain", "UTF-8", "Project file " + string + " not found\n");
        httpResponse.send(true, 404, "Not Found");
    }

    public static void about(Item item, Object object, Context context) throws IOException {
        PluginDescriptor pluginDescriptor;
        HttpResponse httpResponse = (HttpResponse)object;
        StringBuffer stringBuffer = new StringBuffer("<html><head><title>HTTP Server - GroIMP</title></head><body>");
        stringBuffer.append("GroIMP version ").append(Main.getVersion()).append("<br>");
        stringBuffer.append("<table border=\"1\"><caption>Installed Plugins</caption><tr><th>Name</th><th>Version</th><th>Plugin-Id</th></tr>");
        for (pluginDescriptor = (PluginDescriptor)context.getWorkbench().getRegistry().getPluginDirectory().getBranch(); pluginDescriptor != null; pluginDescriptor = (PluginDescriptor)pluginDescriptor.getSuccessor()) {
            stringBuffer.append("<tr><td>").append(pluginDescriptor.getPluginName()).append("</td><td>").append(pluginDescriptor.getPluginVersion()).append("</td><td>").append(pluginDescriptor.getName()).append("</td></tr>");
        }
        stringBuffer.append("</table><br><table border=\"1\"><caption>Available commands</caption><tr><th>Command</th><th>Description</th></tr>");
        for (pluginDescriptor = Item.resolveItem((RegistryContext)context.getWorkbench(), (String)"/http/commands").getBranch(); pluginDescriptor != null; pluginDescriptor = pluginDescriptor.getSuccessor()) {
            if (!(pluginDescriptor instanceof Command)) continue;
            stringBuffer.append("<tr><td>").append(((Item)pluginDescriptor).getName()).append("</td><td>").append(((Item)pluginDescriptor).getDescription("ShortDescription")).append("</td></tr>");
        }
        stringBuffer.append("</table><br>HTTP Request:<pre>").append(httpResponse.getRequest()).append("</pre></body></html>");
        httpResponse.setContent("text/html", "UTF-8", stringBuffer.toString());
        httpResponse.send(true);
    }
}

