/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp.io;

import de.grogra.imp.io.ImageWriter;
import de.grogra.imp.objects.FixedImageAdapter;
import de.grogra.pf.boot.Main;
import de.grogra.pf.io.ExtensionItem;
import de.grogra.pf.io.FilterBase;
import de.grogra.pf.io.FilterItem;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.InputStreamSource;
import de.grogra.pf.io.MimeTypeItem;
import de.grogra.pf.io.ObjectSource;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.registry.FileFactory;
import de.grogra.util.MimeType;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageReader
extends FilterBase
implements ObjectSource {
    public static final IOFlavor FLAVOR = IOFlavor.valueOf(FixedImageAdapter.class);

    public ImageReader(FilterItem filterItem, FilterSource filterSource) {
        super(filterItem, filterSource);
        this.setFlavor(FLAVOR);
    }

    public static FileFactory getFactory(RegistryContext registryContext) {
        return (FileFactory)Item.resolveItem((RegistryContext)registryContext, (String)"/objects/images/file");
    }

    public Object getObject() throws IOException {
        InputStream inputStream = ((InputStreamSource)this.source).getInputStream();
        javax.imageio.ImageReader imageReader = ImageReader.createImageIOReader(inputStream, this.source.getFlavor().getMimeType());
        ImageInputStream imageInputStream = (ImageInputStream)imageReader.getInput();
        BufferedImage bufferedImage = imageReader.read(0, imageReader.getDefaultReadParam());
        imageReader.dispose();
        try {
            imageInputStream.close();
        }
        catch (IOException iOException) {
            Main.logWarning((Throwable)iOException);
        }
        inputStream.close();
        return new FixedImageAdapter(bufferedImage);
    }

    public static javax.imageio.ImageReader createImageIOReader(InputStream inputStream, MimeType mimeType) throws IOException {
        Iterator<javax.imageio.ImageReader> iterator = ImageIO.getImageReadersByMIMEType(mimeType.getMediaType());
        if (!iterator.hasNext()) {
            throw new IOException("Unsupported image MIME-type " + mimeType);
        }
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
        javax.imageio.ImageReader imageReader = iterator.next();
        imageReader.setInput(imageInputStream, true);
        return imageReader;
    }

    static void getSupport(Iterator<? extends ImageReaderWriterSpi> iterator, HashMap<MimeType, Extension> hashMap, HashSet<MimeType> hashSet) {
        Logger logger = Main.getLogger();
        while (iterator.hasNext()) {
            ImageReaderWriterSpi imageReaderWriterSpi = iterator.next();
            logger.config(imageReaderWriterSpi + ": " + imageReaderWriterSpi.getDescription(Locale.getDefault()));
            String[] stringArray = imageReaderWriterSpi.getMIMETypes();
            MimeType mimeType = null;
            if (stringArray == null) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                try {
                    MimeType mimeType2 = new MimeType(string);
                    if (mimeType == null) {
                        mimeType = mimeType2;
                    }
                    logger.config("MIME-type " + mimeType2);
                    hashSet.add(mimeType2);
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    logger.config("Illegal MIME-type " + string);
                }
            }
            stringArray = imageReaderWriterSpi.getFileSuffixes();
            if (stringArray == null || mimeType == null) continue;
            Extension extension = new Extension();
            extension.name = imageReaderWriterSpi.getDescription(Locale.getDefault());
            if (extension.name.toLowerCase().endsWith("reader")) {
                extension.name = extension.name.substring(0, extension.name.length() - 6);
            } else if (extension.name.toLowerCase().endsWith("writer")) {
                extension.name = extension.name.substring(0, extension.name.length() - 6);
            }
            extension.name = extension.name.trim();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].length() <= 0) continue;
                logger.config("File extension " + stringArray[i] + " for " + mimeType);
                extension.extensions.add('.' + stringArray[i].toLowerCase());
            }
            hashMap.put(mimeType, extension);
        }
    }

    public static void installImageIO(Registry registry) {
        MimeTypeItem mimeTypeItem;
        Thread.currentThread().setContextClassLoader(Main.getLoaderForAll());
        ImageIO.scanForPlugins();
        IIORegistry iIORegistry = IIORegistry.getDefaultInstance();
        HashMap<MimeType, Extension> hashMap = new HashMap<MimeType, Extension>();
        HashSet<MimeType> hashSet = new HashSet<MimeType>();
        ImageReader.getSupport(iIORegistry.getServiceProviders(ImageReaderSpi.class, true), hashMap, hashSet);
        HashSet<MimeType> hashSet2 = new HashSet<MimeType>();
        ImageReader.getSupport(iIORegistry.getServiceProviders(ImageWriterSpi.class, true), hashMap, hashSet2);
        Item item = registry.getDirectory("/io/filetypes", null);
        for (Map.Entry<MimeType, Extension> mimeType : hashMap.entrySet()) {
            ImageReader.addExtensionItem(item, mimeType.getKey(), mimeType.getValue().extensions.toArray(new String[0]), mimeType.getValue().name);
        }
        item = registry.getDirectory("/io/mimetypes", null);
        for (MimeType mimeType : hashSet) {
            mimeTypeItem = (MimeTypeItem)item.getItem((CharSequence)mimeType.getMediaType());
            if (mimeTypeItem == null) {
                mimeTypeItem = new MimeTypeItem(mimeType.getMediaType());
                item.add((Item)mimeTypeItem);
            }
            FilterItem filterItem = new FilterItem(null, new IOFlavor(mimeType, 1, null), IOFlavor.valueOf(FixedImageAdapter.class), ImageReader.class.getName());
            mimeTypeItem.add((Item)filterItem);
        }
        item = registry.getDirectory("/io/mimetypes/application\\/x-java-jvm-local-objectref", null);
        for (MimeType mimeType : hashSet2) {
            mimeTypeItem = new FilterItem(null, ImageWriter.RENDERED_IMAGE_FLAVOR, new IOFlavor(mimeType, 2, null), ImageWriter.class.getName());
            item.add((Item)mimeTypeItem);
        }
    }

    private static void addExtensionItem(Item item, MimeType mimeType, String[] stringArray, String string) {
        ExtensionItem extensionItem = new ExtensionItem(null, mimeType, stringArray);
        extensionItem.setDescription("Name", (Object)string);
        extensionItem.setDescription("Icon", UI.I18N.getObject("registry.image.Icon"));
        item.add((Item)extensionItem);
    }

    static class Extension {
        String name;
        HashSet<String> extensions = new HashSet();

        Extension() {
        }
    }
}

