/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp.awt;

import de.grogra.graph.GraphState;
import de.grogra.imp.IMP;
import de.grogra.imp.Renderer;
import de.grogra.imp.View;
import de.grogra.imp.ViewComponent;
import de.grogra.pf.registry.Item;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.Workbench;
import de.grogra.pf.ui.awt.EventAdapter;
import de.grogra.pf.ui.edit.OptionsSelection;
import de.grogra.pf.ui.edit.Selectable;
import de.grogra.pf.ui.edit.Selection;
import de.grogra.util.EventListener;
import de.grogra.util.ThreadContext;
import de.grogra.util.WrapException;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.image.ImageObserver;
import java.io.IOException;
import javax.vecmath.Tuple3f;

public abstract class ViewComponentAdapter
implements ViewComponent,
Runnable,
Selectable {
    protected static final int RENDERING = 256;
    protected static final int DISPOSING = 512;
    protected static final int DISPOSED = 1024;
    protected static final int RENDERED_IMAGE = 2048;
    protected static final int REPAINT_MASK = 2063;
    final Object renderFlagsLock = new Object();
    private volatile int renderFlags = 0;
    private View view;
    private EventAdapter eventAdapter;
    private ThreadContext controlContext;
    private GraphState renderGraphState;
    private Item factory;
    private int maxLod;
    private int lod = this.maxLod = View.LOD_MAX - 1;
    private int drawLod;
    private int lodIncrementTime = 500;
    private boolean checkForInterruption;
    private boolean interruptionRequested;
    private long drawStartTime;
    private long renderAbortTime = 300L;
    private int drawCount;
    private Renderer currentRenderer = null;
    private static final InterruptedException ABORT_RENDER = new InterruptedException();
    private static final WrapException ABORT_RENDER_WRAPPED = new WrapException((Throwable)ABORT_RENDER);
    static MyEventQueue eq = new MyEventQueue();

    public static Color getColor(int n, Color color) {
        if (color == null || n != color.getRGB()) {
            color = new Color(n, true);
        }
        return color;
    }

    private static int f2i(float f) {
        int n = (int)(256.0f * f);
        return n <= 0 ? 0 : (n >= 255 ? 255 : n);
    }

    public static int getIntColor(Tuple3f tuple3f) {
        return (ViewComponentAdapter.f2i(tuple3f.x) << 16) + (ViewComponentAdapter.f2i(tuple3f.y) << 8) + ViewComponentAdapter.f2i(tuple3f.z) + -16777216;
    }

    public static Color getColor(Tuple3f tuple3f, Color color) {
        int n = ViewComponentAdapter.getIntColor(tuple3f);
        if (color != null && color.getRGB() == n) {
            return color;
        }
        return new Color(n);
    }

    public void initFactory(Item item) {
        this.factory = item;
    }

    public void initView(View view, EventListener eventListener) {
        this.eventAdapter = new EventAdapter((Context)view, eventListener, 70536);
        this.view = view;
        this.lod = this.maxLod = ((Number)this.getOption("lod", 1)).intValue();
        Thread thread = new Thread((Runnable)this, "ViewThread@" + this);
        thread.setPriority(2);
        thread.start();
    }

    protected void installListeners(Component component) {
        this.eventAdapter.install(component);
    }

    protected void uninstallListeners(Component component) {
        this.eventAdapter.uninstall(component);
    }

    public View getView() {
        return this.view;
    }

    public Item getFactory() {
        return this.factory;
    }

    public Object getOption(String string, Object object) {
        return this.getFactory().get((Object)string, object);
    }

    public Selection toSelection(Context context) {
        return new OptionsSelection(context, this.getFactory(), false){

            protected void valueChanged(String string, Object object) {
                ViewComponentAdapter.this.optionValueChanged(string, object);
            }
        };
    }

    protected void optionValueChanged(String string, Object object) {
        if ("lod".equals(string)) {
            this.lod = this.maxLod = ((Number)object).intValue();
            this.repaint(7);
        }
    }

    public GraphState getRenderGraphState() {
        if (this.renderGraphState == null || this.renderGraphState.getGraph() != this.view.getGraph() || this.renderGraphState.getContext() != ThreadContext.current()) {
            this.renderGraphState = this.view.getWorkbenchGraphState().forContext(ThreadContext.current());
            this.renderGraphState.getContext().setPriority((short)Short.MAX_VALUE);
        }
        return this.renderGraphState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.disposeRenderer(null);
        Object object = this.renderFlagsLock;
        synchronized (object) {
            this.renderFlags |= 0x200;
            while ((this.renderFlags & 0x100) != 0) {
                try {
                    this.renderFlagsLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.renderFlags |= 0x400;
            this.renderFlagsLock.notifyAll();
        }
    }

    public FontMetrics getFontMetrics(Font font) {
        return ((Component)this.getComponent()).getFontMetrics(font);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint(int n) {
        if ((n & 9) == 9) {
            this.disposeRenderer(null);
        }
        if ((n & 0x80F & ~this.renderFlags) != 0) {
            Object object = this.renderFlagsLock;
            synchronized (object) {
                this.renderFlags |= n & 0x80F;
                this.renderFlagsLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void run() {
        this.controlContext = ThreadContext.current();
        this.controlContext.setPriority((short)Short.MAX_VALUE);
        Workbench.setCurrent((Workbench)this.view.getWorkbench());
        while (true) {
            Object object;
            Object var8_5;
            Object object2 = this.renderFlagsLock;
            // MONITORENTER : object2
            if ((this.renderFlags & 0xC0F) == 0) {
                try {
                    long l = System.currentTimeMillis();
                    this.renderFlagsLock.wait(Math.max(this.lodIncrementTime, 300));
                    if (this.lod < this.maxLod && System.currentTimeMillis() - l >= (long)(this.lodIncrementTime * 9 / 10) && (this.renderFlags & 0xC0F) == 0) {
                        ++this.lod;
                        this.repaint(7);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            int n = this.renderFlags;
            // MONITOREXIT : object2
            if ((n & 0x400) != 0) {
                Workbench.setCurrent(null);
                return;
            }
            if ((n & 0x80F) == 0) continue;
            try {
                object2 = this.renderFlagsLock;
                // MONITORENTER : object2
                n = this.renderFlags;
                this.renderFlags = n & 0xFFFFF7F0 | 0x100;
                if ((n & 0x200) == 0) {
                    this.initRender(n);
                }
                // MONITOREXIT : object2
                if ((n & 0x200) == 0) {
                    this.invokeRender(n);
                }
                var8_5 = null;
                object = this.renderFlagsLock;
                // MONITORENTER : object
                this.renderFlags &= 0xFFFFFEFF;
                this.renderFlagsLock.notifyAll();
                // MONITOREXIT : object
            }
            catch (Throwable throwable) {
                var8_5 = null;
                object = this.renderFlagsLock;
                // MONITORENTER : object
                this.renderFlags &= 0xFFFFFEFF;
                this.renderFlagsLock.notifyAll();
                // MONITOREXIT : object
                throw throwable;
            }
        }
    }

    public int getGlobalLOD() {
        return this.drawLod;
    }

    public void checkRepaint() throws InterruptedException {
        InterruptedException interruptedException = this.getInterruptedException();
        if (interruptedException != null) {
            throw interruptedException;
        }
    }

    public void checkRepaintWrapException() {
        InterruptedException interruptedException = this.getInterruptedException();
        if (interruptedException != null) {
            throw interruptedException == ABORT_RENDER ? ABORT_RENDER_WRAPPED : new WrapException((Throwable)interruptedException);
        }
    }

    public InterruptedException getInterruptedException() {
        if (this.checkForInterruption && ((this.renderFlags & 7) != 0 || (++this.drawCount & 0x3F) == 0 && this.controlContext.getThread().isInterrupted())) {
            this.interruptionRequested = true;
            this.checkForInterruption = false;
            this.drawCount = 0;
        } else if (this.interruptionRequested && ++this.drawCount > 100) {
            if (System.currentTimeMillis() - this.drawStartTime > this.renderAbortTime) {
                return ABORT_RENDER;
            }
            this.drawCount = 0;
        }
        return null;
    }

    public void disposeRenderer(Renderer renderer) {
        Renderer renderer2 = this.currentRenderer;
        if (renderer2 != null && (renderer2 == renderer || renderer == null)) {
            this.currentRenderer = null;
            renderer2.dispose();
        }
    }

    public void render(Renderer renderer) {
        ImageObserver imageObserver = this.getObserverForRenderer();
        if (imageObserver == null) {
            return;
        }
        this.disposeRenderer(null);
        this.currentRenderer = renderer;
        Component component = (Component)this.getComponent();
        renderer.initialize(this.view, component.getWidth(), component.getHeight());
        renderer.addImageObserver(imageObserver);
        eq.set(this.view);
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        ViewComponentAdapter.this.currentRenderer.waitForImage();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                        Object var3_2 = null;
                        eq.setActive(false);
                    }
                    Object var3_1 = null;
                    eq.setActive(false);
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    eq.setActive(false);
                    throw throwable;
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
        try {
            eq.setActive(true);
            renderer.render();
        }
        catch (IOException iOException) {
            this.view.getWorkbench().logGUIInfo(IMP.I18N.msg("renderer.error", (Object)renderer.getName()), (Throwable)iOException);
            eq.setActive(false);
        }
    }

    public void render(Renderer renderer, int n, int n2) {
        ImageObserver imageObserver = this.getObserverForRenderer();
        if (imageObserver == null) {
            return;
        }
        this.disposeRenderer(null);
        this.currentRenderer = renderer;
        renderer.initialize(this.view, n, n2);
        renderer.addImageObserver(imageObserver);
        try {
            renderer.render();
        }
        catch (IOException iOException) {
            this.view.getWorkbench().logGUIInfo(IMP.I18N.msg("renderer.error", (Object)renderer.getName()), (Throwable)iOException);
        }
    }

    protected abstract ImageObserver getObserverForRenderer();

    protected abstract void initRender(int var1);

    protected abstract void invokeRender(int var1);

    protected void invokeRenderSync(final int n) {
        if (this.view.getGraph() == null) {
            return;
        }
        this.drawLod = this.lod;
        this.checkForInterruption = true;
        this.interruptionRequested = false;
        this.drawStartTime = System.currentTimeMillis();
        boolean bl = false;
        if (Workbench.current() == this.getView().getWorkbench()) {
            try {
                View.set(this.getRenderGraphState(), this.getView());
                this.render(n);
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
            View.set(this.getRenderGraphState(), null);
        } else {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class Run
            implements Runnable {
                InterruptedException iex = null;

                Run() {
                }

                @Override
                public void run() {
                    try {
                        View.set(ViewComponentAdapter.this.getRenderGraphState(), ViewComponentAdapter.this.getView());
                        ViewComponentAdapter.this.render(n);
                    }
                    catch (InterruptedException interruptedException) {
                        this.iex = interruptedException;
                    }
                    View.set(ViewComponentAdapter.this.getRenderGraphState(), null);
                }
            }
            Run run = new Run();
            this.getView().getWorkbench().runAsCurrent((Runnable)run);
            boolean bl2 = bl = run.iex != null;
        }
        if (bl) {
            if (this.lod > View.LOD_MIN && (n & 1) != 0) {
                --this.lod;
            }
            this.repaint(n);
        }
    }

    protected abstract void render(int var1) throws InterruptedException;

    protected void renderUninterruptibly() {
        this.checkForInterruption = false;
        this.interruptionRequested = false;
    }

    static class MyEventQueue
    extends EventQueue {
        boolean active = false;
        boolean set = false;
        View view = null;

        MyEventQueue() {
        }

        public void setActive(boolean bl) {
            this.active = bl;
        }

        protected void dispatchEvent(AWTEvent aWTEvent) {
            KeyEvent keyEvent;
            if (aWTEvent instanceof KeyEvent && this.active && (keyEvent = (KeyEvent)aWTEvent).getID() == 401 && keyEvent.getKeyCode() == 27) {
                this.view.getViewComponent().disposeRenderer(null);
            }
            super.dispatchEvent(aWTEvent);
        }

        void set(View view) {
            if (!this.set) {
                Toolkit.getDefaultToolkit().getSystemEventQueue().push(this);
                this.set = true;
            }
            this.view = view;
        }
    }
}

