/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp;

import de.grogra.graph.GraphState;
import de.grogra.imp.IMP;
import de.grogra.imp.IMPJobManager;
import de.grogra.imp.net.Commands;
import de.grogra.imp.net.Connection;
import de.grogra.imp.net.MessageHandler;
import de.grogra.pf.boot.Main;
import de.grogra.pf.io.FileSource;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IO;
import de.grogra.pf.registry.Executable;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.JobManager;
import de.grogra.pf.ui.Panel;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.Window;
import de.grogra.pf.ui.Workbench;
import de.grogra.util.Map;
import de.grogra.util.MimeType;
import de.grogra.util.StringMap;
import de.grogra.util.ThreadContext;
import de.grogra.util.Utils;
import de.grogra.vfs.FileSystem;
import de.grogra.xl.util.ObjectList;
import java.io.File;
import java.util.concurrent.Executor;
import java.util.logging.Filter;
import java.util.logging.LogRecord;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;

public final class IMPWorkbench
extends Workbench
implements TreeModelListener {
    private Window window;
    private GraphState regState;
    private Filter logFilter;
    private ObjectList pendingLogs;
    private ObjectList connections;
    private final MessageHandler msgHandler = new Commands(this);

    public IMPWorkbench(Registry registry, Map map) {
        super(registry, (JobManager)new IMPJobManager(), IMP.getInstance().getToolkit(), map);
        this.logFilter = this.getLogger().getFilter();
        this.pendingLogs = new ObjectList();
        this.connections = new ObjectList();
        this.getLogger().setFilter(new Filter(){

            public boolean isLoggable(LogRecord logRecord) {
                if (IMPWorkbench.this.logFilter == null || IMPWorkbench.this.logFilter.isLoggable(logRecord)) {
                    IMPWorkbench.this.pendingLogs.add((Object)logRecord);
                }
                return false;
            }
        });
        this.getIMPJobManager().initialize(this);
        IMP.getInstance().registerWorkbench(this);
    }

    IMPJobManager getIMPJobManager() {
        return (IMPJobManager)this.getJobManager();
    }

    public static IMPWorkbench get(Context context) {
        return (IMPWorkbench)context.getWorkbench();
    }

    public Workbench getMainWorkbench() {
        return IMP.getInstance().getMainWorkbench();
    }

    void close(final Command command) {
        if (this.getWindow() != null) {
            final Panel[] panelArray = this.getWindow().getPanels(null);
            new Command(){

                public void run(Object object, Context context) {
                    for (int i = 0; i < panelArray.length; ++i) {
                        Panel panel = panelArray[i];
                        if (panel == null) continue;
                        panelArray[i] = null;
                        panel.checkClose((Command)this);
                        return;
                    }
                    IMPWorkbench.this.close0(command);
                }

                public String getCommandName() {
                    return null;
                }
            }.run(null, (Context)this);
        } else {
            this.close0(command);
        }
    }

    void close0(Command command) {
        if (this.isModified() && this.getWindow() != null) {
            int n = this.getWindow().showDialog(UI.I18N.msg("project.savequestion.title"), (Object)UI.I18N.msg("project.savequestion.msg", (Object)this.getName()), 100);
            if (n == 2) {
                return;
            }
            if (n == 0 && !this.save(true)) {
                return;
            }
        }
        Registry registry = this.getRegistry().getRootRegistry();
        Executable.runExecutables((Registry)registry, (String)"/hooks/close", (RegistryContext)registry, (StringMap)UI.getArgs((Context)this, null));
        this.getIMPJobManager().stop(command);
    }

    void disposeWhenNotInitialized() {
        this.getRegistry().dispose();
        IMP.getInstance().deregisterWorkbench(this, this.window);
    }

    void dispose(Command command) {
        if (this.window != null) {
            this.window.dispose();
        }
        this.getRegistry().removeFileSystemListener((TreeModelListener)this);
        this.disposeWhenNotInitialized();
        if (command != null) {
            command.run(null, (Context)this);
        }
        IMPWorkbench.setCurrent(null);
        this.window = null;
    }

    void initialize() {
        ThreadContext threadContext = this.getJobManager().getThreadContext();
        this.regState = this.getRegistry().getRegistryGraph().createStaticState(threadContext);
        this.getRegistry().getProjectGraph().initMainState((Executor)((IMPJobManager)this.getJobManager()));
        IMPWorkbench.setCurrent((Workbench)this);
        this.getRegistry().startup();
        this.getRegistry().addFileSystemListener((TreeModelListener)this);
        this.updateName();
        Map map = Map.EMPTY_MAP;
        Object object = this.getRegistry().getRootRegistry().getUserProperty(Main.SCREEN_PROPERTY_ID.intValue());
        if (object != null) {
            map = new StringMap().putInt("screen", ((Integer)object).intValue());
        }
        this.window = this.getToolkit().createWindow(IMP.CLOSE, map);
        if (this.window != null) {
            this.initializeWindow();
            this.window.show(true, null);
        }
        Main.closeSplashScreen();
        this.getLogger().setFilter(null);
        for (int i = 0; i < this.pendingLogs.size(); ++i) {
            this.getLogger().log((LogRecord)this.pendingLogs.get(i));
        }
        this.getLogger().setFilter(this.logFilter);
        this.pendingLogs = null;
        this.logFilter = null;
        StringMap stringMap = new StringMap().putObject("registry", (Object)this.getRegistry());
        stringMap.putObject("workbench", (Object)this);
        stringMap.putObject("filesystem", (Object)this.getRegistry().getFileSystem());
        Executable.runExecutables((Registry)this.getRegistry().getRootRegistry(), (String)"/hooks/projectloaded", (RegistryContext)this.getRegistry(), (StringMap)stringMap);
        if (this == IMP.getInstance().getMainWorkbench()) {
            this.getJobManager().runLater(new Command(){

                public void run(Object object, Context context) {
                    IMPWorkbench.this.executeCommandLine();
                }

                public String getCommandName() {
                    return null;
                }
            }, null, (Context)this, 10000);
        }
    }

    void executeCommandLine() {
        int n = Main.getArgCount();
        int n2 = 0;
        while (n2 < n) {
            Object object;
            String string = Main.getArg((int)n2);
            if (string.equals("-cmd")) {
                if (n2 + 1 < n) {
                    Item item;
                    object = Main.getArg((int)(n2 + 1));
                    String string2 = null;
                    int n3 = ((String)object).indexOf(61);
                    if (n3 > 0) {
                        string2 = ((String)object).substring(n3 + 1);
                        object = ((String)object).substring(0, n3);
                    }
                    if ((item = Item.resolveItem((RegistryContext)this, (String)object)) instanceof Command) {
                        ((Command)item).run((Object)string2, (Context)this);
                    }
                }
                n2 += 2;
                continue;
            }
            if (n2 + 1 == n) {
                object = new File(string);
                if (((File)object).isFile()) {
                    this.open((FilterSource)FileSource.createFileSource((String)IO.toSystemId((File)object), (MimeType)IO.getMimeType((String)((File)object).getName()), (RegistryContext)this, null), null);
                }
                ++n2;
                continue;
            }
            ++n2;
        }
    }

    void initializeWindow() {
        this.initializeWindow(this.window);
    }

    public Item getRegistryItem(String string) {
        return this.getRegistry().getItem(string);
    }

    public Window getWindow() {
        return this.window;
    }

    public Workbench open(FilterSource filterSource, Map map) {
        IMPWorkbench iMPWorkbench = IMP.getInstance().openWorkbench(this, filterSource, map);
        if (Utils.getBoolean((Map)map, (Object)"start-as-demo") && iMPWorkbench != null) {
            iMPWorkbench.ignoreIfModified();
            iMPWorkbench.setFile(null, null);
        }
        return iMPWorkbench;
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        this.treeStructureChanged(treeModelEvent);
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        this.treeStructureChanged(treeModelEvent);
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        this.treeStructureChanged(treeModelEvent);
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        if (!((FileSystem)treeModelEvent.getSource()).isPersistent()) {
            this.setModified();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(Connection connection) {
        connection.addMessageHandler(this.msgHandler);
        ObjectList objectList = this.connections;
        synchronized (objectList) {
            this.connections.add((Object)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(Connection connection) {
        connection.removeMessageHandler(this.msgHandler);
        ObjectList objectList = this.connections;
        synchronized (objectList) {
            this.connections.remove((Object)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection[] getConnections() {
        ObjectList objectList = this.connections;
        synchronized (objectList) {
            for (int i = this.connections.size() - 1; i >= 0; --i) {
                if (!((Connection)this.connections.get(i)).isClosed()) continue;
                this.connections.remove(i);
            }
            return (Connection[])this.connections.toArray((Object[])new Connection[this.connections.size()]);
        }
    }
}

