/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.LiquidLookAndFeel;
import com.birosoft.liquid.skin.Skin;
import com.birosoft.liquid.skin.SkinSimpleButtonIndexModel;
import com.birosoft.liquid.util.Colors;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;

public class LiquidTabbedPaneUI
extends BasicTabbedPaneUI {
    static Skin skinTop;
    static Skin skinLeft;
    static Skin skinRight;
    static Skin skinBottom;
    static Skin skinBorder;
    static Skin skinBorderRight;
    SkinSimpleButtonIndexModel indexModel = new SkinSimpleButtonIndexModel();
    int rollover = -1;
    private final Insets cbInsets = new Insets(0, 0, 0, 0);

    public static ComponentUI createUI(JComponent jComponent) {
        return new LiquidTabbedPaneUI();
    }

    protected void installListeners() {
        super.installListeners();
        this.tabPane.addMouseMotionListener((MouseMotionListener)((Object)this.mouseListener));
    }

    protected MouseListener createMouseListener() {
        return new MyMouseHandler();
    }

    private void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            BasicTabbedPaneUI.TabbedPaneLayout tabbedPaneLayout = (BasicTabbedPaneUI.TabbedPaneLayout)this.tabPane.getLayout();
            tabbedPaneLayout.calculateLayoutInfo();
        }
    }

    private int getTabAtLocation(int n, int n2) {
        this.ensureCurrentLayout();
        int n3 = this.tabPane.getTabCount();
        for (int i = 0; i < n3; ++i) {
            if (!this.rects[i].contains(n, n2)) continue;
            return i;
        }
        return -1;
    }

    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
    }

    protected void paintFocusIndicator(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
    }

    protected void paintContentBorder(Graphics graphics, int n, int n2) {
    }

    protected Insets getContentBorderInsets(int n) {
        this.cbInsets.bottom = n == 3 ? 5 : 0;
        this.cbInsets.top = n == 1 ? 5 : 0;
        this.cbInsets.left = 0;
        this.cbInsets.right = 0;
        return this.cbInsets;
    }

    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Insets insets = this.getContentBorderInsets(n);
        int n7 = this.indexModel.getIndexForState(this.tabPane.isEnabledAt(n2), this.rollover == n2, bl);
        switch (n) {
            case 2: {
                this.getSkinLeft().draw(graphics, n7, n3, n4, n5, n6 - 1);
                break;
            }
            case 4: {
                this.getSkinRight().draw(graphics, n7, n3 - 2, n4, n5, n6 - 1);
                break;
            }
            case 3: {
                this.getSkinBottom().draw(graphics, n7, n3, n4, n5, n6);
                break;
            }
            default: {
                this.getSkinTop().draw(graphics, n7, n3, n4, n5, n6);
            }
        }
    }

    protected void paintText(Graphics graphics, int n, Font font, FontMetrics fontMetrics, int n2, String string, Rectangle rectangle, boolean bl) {
        int n3 = 0;
        if (n == 1 && bl) {
            n3 = 1;
        }
        if (n == 3) {
            n3 = bl ? -2 : -1;
        }
        graphics.setFont(font);
        View view = this.getTextViewForTab(n2);
        if (view != null) {
            rectangle.y += n3;
            view.paint(graphics, rectangle);
        } else {
            int n4 = this.tabPane.getDisplayedMnemonicIndexAt(n2);
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(n2)) {
                graphics.setColor(this.tabPane.getForegroundAt(n2));
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n4, rectangle.x, rectangle.y + fontMetrics.getAscent() + n3);
            } else {
                graphics.setColor(this.tabPane.getBackgroundAt(n2).brighter());
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n4, rectangle.x, rectangle.y + fontMetrics.getAscent());
                graphics.setColor(this.tabPane.getBackgroundAt(n2).darker());
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n4, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
            }
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Insets insets = this.getContentBorderInsets(this.tabPane.getTabPlacement());
        int n = this.tabPane.getWidth();
        int n2 = this.tabPane.getHeight();
        Insets insets2 = this.tabPane.getInsets();
        int n3 = insets2.left;
        int n4 = insets2.top;
        int n5 = n - insets2.right - insets2.left;
        int n6 = n2 - insets2.top - insets2.bottom;
        int n7 = this.tabPane.getTabPlacement();
        if (n7 == 3) {
            Color color = LiquidLookAndFeel.getBackgroundColor();
            if (jComponent.isOpaque()) {
                graphics.setColor(color);
                graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
            }
            if (LiquidLookAndFeel.areStipplesUsed()) {
                Colors.drawStipples(graphics, jComponent, color);
            }
        }
        if (n7 == 1 && LiquidLookAndFeel.areStipplesUsed()) {
            jComponent.setOpaque(false);
        }
        switch (n7) {
            case 2: {
                n5 -= (n3 += this.calculateTabAreaWidth(n7, this.runCount, this.maxTabWidth)) - insets2.left;
                break;
            }
            case 4: {
                n5 -= this.calculateTabAreaWidth(n7, this.runCount, this.maxTabWidth);
                break;
            }
            default: {
                n6 -= (n4 += this.calculateTabAreaHeight(n7, this.runCount, this.maxTabHeight)) - insets2.top;
            }
        }
        graphics.drawLine(n3, n4, n3, n4 + n6 - 3);
        graphics.drawLine(n3, n4, n3 + n5 - 3, n4);
        if (n7 == 3) {
            this.getSkinBorder().draw(graphics, 0, n3, n6 - 5, n5, 5);
        }
        if (n7 == 1) {
            this.getSkinBorder().draw(graphics, 0, n3, n4, n5, 5);
        }
        super.paint(graphics, jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        this.paint(graphics, jComponent);
    }

    protected int getTabLabelShiftX(int n, int n2, boolean bl) {
        Rectangle rectangle = this.rects[n2];
        int n3 = 0;
        switch (n) {
            case 2: {
                n3 = bl ? -1 : 1;
                break;
            }
            case 4: {
                n3 = bl ? 1 : -1;
                break;
            }
            default: {
                n3 = 0;
            }
        }
        return n3;
    }

    protected int getTabLabelShiftY(int n, int n2, boolean bl) {
        Rectangle rectangle = this.rects[n2];
        int n3 = 0;
        switch (n) {
            case 3: {
                n3 = bl ? 1 : -1;
                break;
            }
            case 2: 
            case 4: {
                n3 = rectangle.height % 2;
                break;
            }
            default: {
                n3 = bl ? -1 : 1;
            }
        }
        return n3;
    }

    public Skin getSkinTop() {
        if (skinTop == null) {
            skinTop = new Skin("tabtop.png", 4, 7, 6, 7, 2);
        }
        return skinTop;
    }

    public Skin getSkinLeft() {
        if (skinLeft == null) {
            skinLeft = new Skin("tableft.png", 4, 6, 7, 2, 7);
        }
        return skinLeft;
    }

    public Skin getSkinRight() {
        if (skinRight == null) {
            skinRight = new Skin("tabright.png", 4, 2, 7, 6, 7);
        }
        return skinRight;
    }

    public Skin getSkinBottom() {
        if (skinBottom == null) {
            skinBottom = new Skin("tabbottom.png", 4, 6, 7, 6, 2);
        }
        return skinBottom;
    }

    public Skin getSkinBorder() {
        if (skinBorder == null) {
            skinBorder = new Skin("tabborderh.png", 1, 5, 2, 5, 2);
        }
        return skinBorder;
    }

    public Skin getSkinBorderRight() {
        if (skinBorderRight == null) {
            skinBorderRight = new Skin("tabborderright.png", 1, 0, 5, 0, 5);
        }
        return skinBorderRight;
    }

    public class MyMouseHandler
    implements MouseListener,
    MouseMotionListener {
        public void mousePressed(MouseEvent mouseEvent) {
            if (!LiquidTabbedPaneUI.this.tabPane.isEnabled()) {
                return;
            }
            int n = LiquidTabbedPaneUI.this.getTabAtLocation(mouseEvent.getX(), mouseEvent.getY());
            if (n >= 0 && LiquidTabbedPaneUI.this.tabPane.isEnabledAt(n)) {
                if (n == LiquidTabbedPaneUI.this.tabPane.getSelectedIndex()) {
                    if (LiquidTabbedPaneUI.this.tabPane.isRequestFocusEnabled()) {
                        LiquidTabbedPaneUI.this.tabPane.requestFocus();
                        LiquidTabbedPaneUI.this.tabPane.repaint(LiquidTabbedPaneUI.this.getTabBounds(LiquidTabbedPaneUI.this.tabPane, n));
                    }
                } else {
                    LiquidTabbedPaneUI.this.tabPane.setSelectedIndex(n);
                }
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (LiquidTabbedPaneUI.this.rollover != -1 && LiquidTabbedPaneUI.this.rollover < LiquidTabbedPaneUI.this.tabPane.getTabCount()) {
                LiquidTabbedPaneUI.this.tabPane.repaint(LiquidTabbedPaneUI.this.getTabBounds(LiquidTabbedPaneUI.this.tabPane, LiquidTabbedPaneUI.this.rollover));
                LiquidTabbedPaneUI.this.rollover = -1;
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (LiquidTabbedPaneUI.this.tabPane == null) {
                return;
            }
            if (!LiquidTabbedPaneUI.this.tabPane.isEnabled()) {
                return;
            }
            int n = LiquidTabbedPaneUI.this.getTabAtLocation(mouseEvent.getX(), mouseEvent.getY());
            if (n >= 0 && n != LiquidTabbedPaneUI.this.rollover && LiquidTabbedPaneUI.this.rollover != -1) {
                if (LiquidTabbedPaneUI.this.rollover >= 0 && LiquidTabbedPaneUI.this.rollover < LiquidTabbedPaneUI.this.tabPane.getTabCount()) {
                    LiquidTabbedPaneUI.this.tabPane.repaint(LiquidTabbedPaneUI.this.getTabBounds(LiquidTabbedPaneUI.this.tabPane, LiquidTabbedPaneUI.this.rollover));
                }
                if (n == -1) {
                    LiquidTabbedPaneUI.this.rollover = -1;
                }
            }
            if (n >= 0 && LiquidTabbedPaneUI.this.tabPane.isEnabledAt(n) && n < LiquidTabbedPaneUI.this.tabPane.getTabCount() && n != LiquidTabbedPaneUI.this.rollover) {
                LiquidTabbedPaneUI.this.rollover = n;
                LiquidTabbedPaneUI.this.tabPane.repaint(LiquidTabbedPaneUI.this.getTabBounds(LiquidTabbedPaneUI.this.tabPane, n));
            }
        }
    }
}

