/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.LiquidLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.OptionPaneUI;
import javax.swing.text.JTextComponent;

public class LiquidOptionPaneUI
extends OptionPaneUI {
    public static final int MinimumWidth = 262;
    public static final int MinimumHeight = 90;
    private static String newline;
    private int[] mnemonics;
    protected JOptionPane optionPane;
    protected Dimension minimumSize;
    protected JComponent inputComponent;
    protected Component initialFocusComponent;
    protected boolean hasCustomComponents;
    protected PropertyChangeListener propertyChangeListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new LiquidOptionPaneUI();
    }

    public void installUI(JComponent jComponent) {
        this.optionPane = (JOptionPane)jComponent;
        this.installDefaults();
        this.optionPane.setLayout(this.createLayoutManager());
        this.installComponents();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallComponents();
        this.optionPane.setLayout(null);
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.optionPane = null;
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.optionPane, "OptionPane.background", "OptionPane.foreground", "OptionPane.font");
        LookAndFeel.installBorder(this.optionPane, "OptionPane.border");
        this.minimumSize = UIManager.getDimension("OptionPane.minimumSize");
        if (LiquidLookAndFeel.areStipplesUsed()) {
            this.optionPane.setOpaque(false);
        }
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.optionPane);
    }

    protected void installComponents() {
        this.optionPane.add(this.createMessageArea());
        Container container = this.createSeparator();
        if (container != null) {
            this.optionPane.add(container);
        }
        this.optionPane.add(this.createButtonArea());
        this.optionPane.applyComponentOrientation(this.optionPane.getComponentOrientation());
    }

    protected void uninstallComponents() {
        this.hasCustomComponents = false;
        this.inputComponent = null;
        this.initialFocusComponent = null;
        this.optionPane.removeAll();
    }

    protected LayoutManager createLayoutManager() {
        return new BoxLayout(this.optionPane, 1);
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.optionPane.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    protected void uninstallListeners() {
        if (this.propertyChangeListener != null) {
            this.optionPane.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(2);
        SwingUtilities.replaceUIInputMap(this.optionPane, 2, inputMap);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.optionPane, actionMap);
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.optionPane, 2, null);
        SwingUtilities.replaceUIActionMap(this.optionPane, null);
    }

    InputMap getInputMap(int n) {
        Object[] objectArray;
        if (n == 2 && (objectArray = (Object[])UIManager.get("OptionPane.windowBindings")) != null) {
            return LookAndFeel.makeComponentInputMap(this.optionPane, objectArray);
        }
        return null;
    }

    ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("OptionPane.actionMap");
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("OptionPane.actionMap", actionMap);
        }
        return actionMap;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("close", new CloseAction());
        return actionMapUIResource;
    }

    public Dimension getMinimumOptionPaneSize() {
        if (this.minimumSize == null) {
            return new Dimension(262, 90);
        }
        return new Dimension(this.minimumSize.width, this.minimumSize.height);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        if ((JOptionPane)jComponent == this.optionPane) {
            Dimension dimension = this.getMinimumOptionPaneSize();
            LayoutManager layoutManager = jComponent.getLayout();
            if (layoutManager != null) {
                Dimension dimension2 = layoutManager.preferredLayoutSize(jComponent);
                if (dimension != null) {
                    return new Dimension(Math.max(dimension2.width, dimension.width), Math.max(dimension2.height, dimension.height));
                }
                return dimension2;
            }
            return dimension;
        }
        return null;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    protected Container createMessageArea() {
        Serializable serializable;
        JPanel jPanel = new JPanel();
        jPanel.setBorder(UIManager.getBorder("OptionPane.messageAreaBorder"));
        jPanel.setLayout(new BorderLayout());
        if (LiquidLookAndFeel.areStipplesUsed()) {
            jPanel.setOpaque(false);
        }
        JPanel jPanel2 = new JPanel(){};
        JPanel jPanel3 = new JPanel(){};
        jPanel3.setLayout(new BorderLayout());
        if (LiquidLookAndFeel.areStipplesUsed()) {
            ((JPanel)jPanel3).setOpaque(false);
            ((JPanel)jPanel2).setOpaque(false);
        }
        if (this.getIcon() != null) {
            serializable = new JPanel(){

                public Dimension getPreferredSize() {
                    return new Dimension(15, 1);
                }
            };
            if (LiquidLookAndFeel.areStipplesUsed()) {
                ((JPanel)serializable).setOpaque(false);
            }
            jPanel3.add((Component)serializable, "Before");
        }
        jPanel3.add((Component)jPanel2, "Center");
        jPanel2.setLayout(new GridBagLayout());
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).gridheight = 1;
        ((GridBagConstraints)serializable).anchor = 21;
        ((GridBagConstraints)serializable).insets = new Insets(0, 0, 3, 0);
        this.addMessageComponents(jPanel2, (GridBagConstraints)serializable, this.getMessage(), this.getMaxCharactersPerLineCount(), false);
        jPanel.add((Component)jPanel3, "Center");
        this.addIcon(jPanel);
        return jPanel;
    }

    protected void addMessageComponents(Container container, GridBagConstraints gridBagConstraints, Object object, int n, boolean bl) {
        if (object == null) {
            return;
        }
        if (object instanceof Component) {
            if (object instanceof JScrollPane || object instanceof JPanel) {
                gridBagConstraints.fill = 1;
                gridBagConstraints.weighty = 1.0;
            } else {
                gridBagConstraints.fill = 2;
            }
            gridBagConstraints.weightx = 1.0;
            container.add((Component)object, gridBagConstraints);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            ++gridBagConstraints.gridy;
            if (!bl) {
                this.hasCustomComponents = true;
            }
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < objectArray.length; ++i) {
                this.addMessageComponents(container, gridBagConstraints, objectArray[i], n, false);
            }
        } else if (object instanceof Icon) {
            JLabel jLabel = new JLabel((Icon)object, 0);
            this.configureMessageLabel(jLabel);
            this.addMessageComponents(container, gridBagConstraints, jLabel, n, true);
        } else {
            String string = object.toString();
            int n2 = string.length();
            if (n2 <= 0) {
                return;
            }
            int n3 = -1;
            int n4 = 0;
            n3 = string.indexOf(newline);
            if (n3 >= 0) {
                n4 = newline.length();
            } else {
                n3 = string.indexOf("\r\n");
                if (n3 >= 0) {
                    n4 = 2;
                } else {
                    n3 = string.indexOf(10);
                    if (n3 >= 0) {
                        n4 = 1;
                    }
                }
            }
            if (n3 >= 0) {
                if (n3 == 0) {
                    this.addMessageComponents(container, gridBagConstraints, new Component(){

                        public Dimension getPreferredSize() {
                            Font font = this.getFont();
                            if (font != null) {
                                return new Dimension(1, font.getSize() + 2);
                            }
                            return new Dimension(0, 0);
                        }
                    }, n, true);
                } else {
                    this.addMessageComponents(container, gridBagConstraints, string.substring(0, n3), n, false);
                }
                this.addMessageComponents(container, gridBagConstraints, string.substring(n3 + n4), n, false);
            } else if (n2 > n) {
                Box box = Box.createVerticalBox();
                this.burstStringInto(box, string, n);
                this.addMessageComponents(container, gridBagConstraints, box, n, true);
            } else {
                JLabel jLabel = new JLabel(string, 10);
                this.configureMessageLabel(jLabel);
                this.addMessageComponents(container, gridBagConstraints, jLabel, n, true);
            }
        }
    }

    protected Object getMessage() {
        this.inputComponent = null;
        if (this.optionPane != null) {
            if (this.optionPane.getWantsInput()) {
                JComponent jComponent;
                JComponent jComponent2;
                Object object = this.optionPane.getMessage();
                Object[] objectArray = this.optionPane.getSelectionValues();
                Object object2 = this.optionPane.getInitialSelectionValue();
                if (objectArray != null) {
                    if (objectArray.length < 20) {
                        jComponent2 = new JComboBox();
                        int n = objectArray.length;
                        for (int i = 0; i < n; ++i) {
                            ((JComboBox)jComponent2).addItem(objectArray[i]);
                        }
                        if (object2 != null) {
                            ((JComboBox)jComponent2).setSelectedItem(object2);
                        }
                        this.inputComponent = jComponent2;
                        jComponent = jComponent2;
                    } else {
                        jComponent2 = new JList<Object>(objectArray);
                        JScrollPane jScrollPane = new JScrollPane(jComponent2);
                        ((JList)jComponent2).setVisibleRowCount(10);
                        ((JList)jComponent2).setSelectionMode(0);
                        if (object2 != null) {
                            ((JList)jComponent2).setSelectedValue(object2, true);
                        }
                        jComponent2.addMouseListener(new ListSelectionListener());
                        jComponent = jScrollPane;
                        this.inputComponent = jComponent2;
                    }
                } else {
                    jComponent2 = new MultiplexingTextField(20);
                    ((MultiplexingTextField)jComponent2).setKeyStrokes(new KeyStroke[]{KeyStroke.getKeyStroke("ENTER")});
                    if (object2 != null) {
                        String string = object2.toString();
                        ((JTextComponent)jComponent2).setText(string);
                        ((JTextComponent)jComponent2).setSelectionStart(0);
                        ((JTextComponent)jComponent2).setSelectionEnd(string.length());
                    }
                    ((JTextField)jComponent2).addActionListener(new TextFieldActionListener());
                    jComponent = this.inputComponent = jComponent2;
                }
                jComponent2 = object == null ? new Object[]{jComponent} : new Object[]{object, jComponent};
                return jComponent2;
            }
            return this.optionPane.getMessage();
        }
        return null;
    }

    protected void addIcon(Container container) {
        Icon icon = this.getIcon();
        if (icon != null) {
            JLabel jLabel = new JLabel(icon);
            jLabel.setVerticalAlignment(1);
            container.add((Component)jLabel, "Before");
        }
    }

    protected Icon getIcon() {
        Icon icon;
        Icon icon2 = icon = this.optionPane == null ? null : this.optionPane.getIcon();
        if (icon == null && this.optionPane != null) {
            icon = this.getIconForType(this.optionPane.getMessageType());
        }
        return icon;
    }

    protected Icon getIconForType(int n) {
        if (n < 0 || n > 3) {
            return null;
        }
        switch (n) {
            case 0: {
                return UIManager.getIcon("OptionPane.errorIcon");
            }
            case 1: {
                return UIManager.getIcon("OptionPane.informationIcon");
            }
            case 2: {
                return UIManager.getIcon("OptionPane.warningIcon");
            }
            case 3: {
                return UIManager.getIcon("OptionPane.questionIcon");
            }
        }
        return null;
    }

    protected int getMaxCharactersPerLineCount() {
        return this.optionPane.getMaxCharactersPerLineCount();
    }

    protected void burstStringInto(Container container, String string, int n) {
        int n2 = string.length();
        if (n2 <= 0) {
            return;
        }
        if (n2 > n) {
            int n3 = string.lastIndexOf(32, n);
            if (n3 <= 0) {
                n3 = string.indexOf(32, n);
            }
            if (n3 > 0 && n3 < n2) {
                this.burstStringInto(container, string.substring(0, n3), n);
                this.burstStringInto(container, string.substring(n3 + 1), n);
                return;
            }
        }
        JLabel jLabel = new JLabel(string, 2);
        this.configureMessageLabel(jLabel);
        container.add(jLabel);
    }

    protected Container createSeparator() {
        return null;
    }

    protected Container createButtonArea() {
        JPanel jPanel = new JPanel();
        if (LiquidLookAndFeel.areStipplesUsed()) {
            jPanel.setOpaque(false);
        }
        jPanel.setBorder(UIManager.getBorder("OptionPane.buttonAreaBorder"));
        jPanel.setLayout(new ButtonAreaLayout(true, 6));
        this.addButtonComponents(jPanel, this.getButtons(), this.getInitialValueIndex());
        this.mnemonics = null;
        return jPanel;
    }

    protected void addButtonComponents(Container container, Object[] objectArray, int n) {
        if (objectArray != null && objectArray.length > 0) {
            boolean bl = this.getSizeButtonsToSameWidth();
            boolean bl2 = true;
            int n2 = objectArray.length;
            JButton[] jButtonArray = null;
            int n3 = 0;
            int[] nArray = this.mnemonics;
            if (nArray != null && nArray.length != objectArray.length) {
                nArray = null;
            }
            if (bl) {
                jButtonArray = new JButton[n2];
            }
            for (int i = 0; i < n2; ++i) {
                JButton jButton;
                Component component;
                Object object = objectArray[i];
                if (object instanceof Component) {
                    bl2 = false;
                    component = (Component)object;
                    container.add(component);
                    this.hasCustomComponents = true;
                } else {
                    jButton = object instanceof Icon ? new JButton((Icon)object) : new JButton(object.toString());
                    jButton.setMultiClickThreshhold(UIManager.getInt("OptionPane.buttonClickThreshhold"));
                    this.configureButton(jButton);
                    container.add(jButton);
                    ActionListener actionListener = this.createButtonActionListener(i);
                    if (actionListener != null) {
                        jButton.addActionListener(actionListener);
                    }
                    component = jButton;
                    if (nArray != null) {
                        jButton.setMnemonic(nArray[i]);
                    }
                }
                if (bl && bl2 && component instanceof JButton) {
                    jButtonArray[i] = (JButton)component;
                    n3 = Math.max(n3, component.getMinimumSize().width);
                }
                if (i != n) continue;
                this.initialFocusComponent = component;
                if (!(this.initialFocusComponent instanceof JButton)) continue;
                jButton = (JButton)this.initialFocusComponent;
                jButton.addAncestorListener(new AncestorListener(){

                    public void ancestorAdded(AncestorEvent ancestorEvent) {
                        JButton jButton = (JButton)ancestorEvent.getComponent();
                        JRootPane jRootPane = SwingUtilities.getRootPane(jButton);
                        if (jRootPane != null) {
                            jRootPane.setDefaultButton(jButton);
                        }
                    }

                    public void ancestorRemoved(AncestorEvent ancestorEvent) {
                    }

                    public void ancestorMoved(AncestorEvent ancestorEvent) {
                    }
                });
            }
            ((ButtonAreaLayout)container.getLayout()).setSyncAllWidths(bl && bl2);
            if (bl && bl2) {
                int n4 = n2 <= 2 ? 8 : 4;
                for (int i = 0; i < n2; ++i) {
                    JButton jButton = jButtonArray[i];
                    jButton.setMargin(new Insets(2, n4, 2, n4));
                }
            }
        }
    }

    protected ActionListener createButtonActionListener(int n) {
        return new ButtonActionListener(n);
    }

    protected Object[] getButtons() {
        if (this.optionPane != null) {
            Object[] objectArray = this.optionPane.getOptions();
            if (objectArray == null) {
                Object[] objectArray2;
                int n = this.optionPane.getOptionType();
                Locale locale = this.optionPane.getLocale();
                if (n == 0) {
                    objectArray2 = new String[]{UIManager.get("OptionPane.yesButtonText", locale), UIManager.get("OptionPane.noButtonText", locale)};
                    this.mnemonics = new int[2];
                    this.mnemonics[0] = this.getMnemonic("OptionPane.yesButtonMnemonic", locale);
                    this.mnemonics[1] = this.getMnemonic("OptionPane.noButtonMnemonic", locale);
                } else if (n == 1) {
                    objectArray2 = new String[]{UIManager.get("OptionPane.yesButtonText", locale), UIManager.get("OptionPane.noButtonText", locale), UIManager.get("OptionPane.cancelButtonText", locale)};
                    this.mnemonics = new int[3];
                    this.mnemonics[0] = this.getMnemonic("OptionPane.yesButtonMnemonic", locale);
                    this.mnemonics[1] = this.getMnemonic("OptionPane.noButtonMnemonic", locale);
                    this.mnemonics[2] = this.getMnemonic("OptionPane.cancelButtonMnemonic", locale);
                } else if (n == 2) {
                    objectArray2 = new String[]{UIManager.get("OptionPane.okButtonText", locale), UIManager.get("OptionPane.cancelButtonText", locale)};
                    this.mnemonics = new int[2];
                    this.mnemonics[0] = this.getMnemonic("OptionPane.okButtonMnemonic", locale);
                    this.mnemonics[1] = this.getMnemonic("OptionPane.cancelButtonMnemonic", locale);
                } else {
                    objectArray2 = new String[]{UIManager.get("OptionPane.okButtonText", locale)};
                    this.mnemonics = new int[1];
                    this.mnemonics[0] = this.getMnemonic("OptionPane.okButtonMnemonic", locale);
                }
                return objectArray2;
            }
            return objectArray;
        }
        return null;
    }

    private int getMnemonic(String string, Locale locale) {
        String string2 = (String)UIManager.get(string, locale);
        if (string2 == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    protected boolean getSizeButtonsToSameWidth() {
        return true;
    }

    protected int getInitialValueIndex() {
        if (this.optionPane != null) {
            Object object = this.optionPane.getInitialValue();
            Object[] objectArray = this.optionPane.getOptions();
            if (objectArray == null) {
                return 0;
            }
            if (object != null) {
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    if (!objectArray[i].equals(object)) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    protected void resetInputValue() {
        if (this.inputComponent != null && this.inputComponent instanceof JTextField) {
            this.optionPane.setInputValue(((JTextField)this.inputComponent).getText());
        } else if (this.inputComponent != null && this.inputComponent instanceof JComboBox) {
            this.optionPane.setInputValue(((JComboBox)this.inputComponent).getSelectedItem());
        } else if (this.inputComponent != null) {
            this.optionPane.setInputValue(((JList)this.inputComponent).getSelectedValue());
        }
    }

    public void selectInitialValue(JOptionPane jOptionPane) {
        if (this.inputComponent != null) {
            this.inputComponent.requestFocus();
        } else {
            JRootPane jRootPane;
            if (this.initialFocusComponent != null) {
                this.initialFocusComponent.requestFocus();
            }
            if (this.initialFocusComponent instanceof JButton && (jRootPane = SwingUtilities.getRootPane(this.initialFocusComponent)) != null) {
                jRootPane.setDefaultButton((JButton)this.initialFocusComponent);
            }
        }
    }

    public boolean containsCustomComponents(JOptionPane jOptionPane) {
        return this.hasCustomComponents;
    }

    private void fireAudioAction(String string) {
        Action action;
        ActionMap actionMap = this.optionPane.getActionMap();
        if (actionMap == null || (action = actionMap.get(string)) != null) {
            // empty if block
        }
    }

    private void configureMessageLabel(JLabel jLabel) {
        jLabel.setForeground(UIManager.getColor("OptionPane.messageForeground"));
        Font font = UIManager.getFont("OptionPane.messageFont");
        if (font != null) {
            jLabel.setFont(font);
        }
    }

    private void configureButton(JButton jButton) {
        Font font = UIManager.getFont("OptionPane.buttonFont");
        if (font != null) {
            jButton.setFont(font);
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                newline = System.getProperty("line.separator");
                if (newline == null) {
                    newline = "\n";
                }
                return null;
            }
        });
    }

    private static class CloseAction
    extends AbstractAction {
        private CloseAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JOptionPane jOptionPane = (JOptionPane)actionEvent.getSource();
            jOptionPane.setValue(new Integer(-1));
        }
    }

    private static class MultiplexingTextField
    extends JTextField {
        private KeyStroke[] strokes;

        MultiplexingTextField(int n) {
            super(n);
        }

        void setKeyStrokes(KeyStroke[] keyStrokeArray) {
            this.strokes = keyStrokeArray;
        }

        protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
            boolean bl2 = super.processKeyBinding(keyStroke, keyEvent, n, bl);
            if (bl2 && n != 2) {
                for (int i = this.strokes.length - 1; i >= 0; --i) {
                    if (!this.strokes[i].equals(keyStroke)) continue;
                    return false;
                }
            }
            return bl2;
        }
    }

    private class TextFieldActionListener
    implements ActionListener {
        private TextFieldActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LiquidOptionPaneUI.this.optionPane.setInputValue(((JTextField)actionEvent.getSource()).getText());
        }
    }

    private class ListSelectionListener
    extends MouseAdapter {
        private ListSelectionListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                JList jList = (JList)mouseEvent.getSource();
                int n = jList.locationToIndex(mouseEvent.getPoint());
                LiquidOptionPaneUI.this.optionPane.setInputValue(jList.getModel().getElementAt(n));
            }
        }
    }

    public class ButtonActionListener
    implements ActionListener {
        protected int buttonIndex;

        public ButtonActionListener(int n) {
            this.buttonIndex = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (LiquidOptionPaneUI.this.optionPane != null) {
                int n = LiquidOptionPaneUI.this.optionPane.getOptionType();
                Object[] objectArray = LiquidOptionPaneUI.this.optionPane.getOptions();
                if (LiquidOptionPaneUI.this.inputComponent != null && (objectArray != null || n == -1 || (n == 0 || n == 1 || n == 2) && this.buttonIndex == 0)) {
                    LiquidOptionPaneUI.this.resetInputValue();
                }
                if (objectArray == null) {
                    if (n == 2 && this.buttonIndex == 1) {
                        LiquidOptionPaneUI.this.optionPane.setValue(new Integer(2));
                    } else {
                        LiquidOptionPaneUI.this.optionPane.setValue(new Integer(this.buttonIndex));
                    }
                } else {
                    LiquidOptionPaneUI.this.optionPane.setValue(objectArray[this.buttonIndex]);
                }
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == LiquidOptionPaneUI.this.optionPane) {
                Object object;
                if ("ancestor" == propertyChangeEvent.getPropertyName()) {
                    object = (JOptionPane)propertyChangeEvent.getSource();
                    boolean bl = propertyChangeEvent.getOldValue() == null;
                    switch (((JOptionPane)object).getMessageType()) {
                        case -1: {
                            if (!bl) break;
                            LiquidOptionPaneUI.this.fireAudioAction("OptionPane.informationSound");
                            break;
                        }
                        case 3: {
                            if (!bl) break;
                            LiquidOptionPaneUI.this.fireAudioAction("OptionPane.questionSound");
                            break;
                        }
                        case 1: {
                            if (!bl) break;
                            LiquidOptionPaneUI.this.fireAudioAction("OptionPane.informationSound");
                            break;
                        }
                        case 2: {
                            if (!bl) break;
                            LiquidOptionPaneUI.this.fireAudioAction("OptionPane.warningSound");
                            break;
                        }
                        case 0: {
                            if (!bl) break;
                            LiquidOptionPaneUI.this.fireAudioAction("OptionPane.errorSound");
                            break;
                        }
                        default: {
                            System.err.println("Undefined JOptionPane type: " + ((JOptionPane)object).getMessageType());
                        }
                    }
                }
                if (((String)(object = propertyChangeEvent.getPropertyName())).equals("options") || ((String)object).equals("initialValue") || ((String)object).equals("icon") || ((String)object).equals("messageType") || ((String)object).equals("optionType") || ((String)object).equals("message") || ((String)object).equals("selectionValues") || ((String)object).equals("initialSelectionValue") || ((String)object).equals("wantsInput")) {
                    LiquidOptionPaneUI.this.uninstallComponents();
                    LiquidOptionPaneUI.this.installComponents();
                    LiquidOptionPaneUI.this.optionPane.validate();
                } else if (((String)object).equals("componentOrientation")) {
                    ComponentOrientation componentOrientation = (ComponentOrientation)propertyChangeEvent.getNewValue();
                    JOptionPane jOptionPane = (JOptionPane)propertyChangeEvent.getSource();
                    if (componentOrientation != (ComponentOrientation)propertyChangeEvent.getOldValue()) {
                        jOptionPane.applyComponentOrientation(componentOrientation);
                    }
                }
            }
        }
    }

    public static class ButtonAreaLayout
    implements LayoutManager {
        protected boolean syncAllWidths;
        protected int padding;
        protected boolean centersChildren;

        public ButtonAreaLayout(boolean bl, int n) {
            this.syncAllWidths = bl;
            this.padding = n;
            this.centersChildren = true;
        }

        public void setSyncAllWidths(boolean bl) {
            this.syncAllWidths = bl;
        }

        public boolean getSyncAllWidths() {
            return this.syncAllWidths;
        }

        public void setPadding(int n) {
            this.padding = n;
        }

        public int getPadding() {
            return this.padding;
        }

        public void setCentersChildren(boolean bl) {
            this.centersChildren = bl;
        }

        public boolean getCentersChildren() {
            return this.centersChildren;
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            block18: {
                Component[] componentArray = container.getComponents();
                if (componentArray == null || componentArray.length <= 0) break block18;
                int n = componentArray.length;
                Dimension[] dimensionArray = new Dimension[n];
                Insets insets = container.getInsets();
                int n2 = insets.top;
                boolean bl = container.getComponentOrientation().isLeftToRight();
                if (this.syncAllWidths) {
                    int n3;
                    int n4;
                    int n5;
                    int n6 = 0;
                    for (n5 = 0; n5 < n; ++n5) {
                        dimensionArray[n5] = componentArray[n5].getPreferredSize();
                        n6 = Math.max(n6, dimensionArray[n5].width);
                    }
                    if (this.getCentersChildren()) {
                        n4 = (container.getSize().width - insets.left - insets.right - (n6 * n + (n - 1) * this.padding)) / 2;
                        n3 = this.padding + n6;
                    } else if (n > 1) {
                        n4 = insets.left;
                        n3 = (container.getSize().width - insets.left - insets.right - n6 * n) / (n - 1) + n6;
                    } else {
                        n4 = insets.left + (container.getSize().width - insets.left - insets.right - n6) / 2;
                        n3 = 0;
                    }
                    if (!bl) {
                        n4 = container.getSize().width - insets.right - (n4 - insets.left) - n6;
                        n3 = -n3;
                    }
                    for (n5 = 0; n5 < n; ++n5) {
                        componentArray[n5].setBounds(n4, n2, n6, dimensionArray[n5].height);
                        n4 += n3;
                    }
                } else {
                    int n7;
                    int n8;
                    int n9;
                    int n10 = 0;
                    for (n9 = 0; n9 < n; ++n9) {
                        dimensionArray[n9] = componentArray[n9].getPreferredSize();
                        n10 += dimensionArray[n9].width;
                    }
                    n10 += (n - 1) * this.padding;
                    boolean bl2 = this.getCentersChildren();
                    if (bl2) {
                        n8 = insets.left + (container.getSize().width - insets.left - insets.right - n10) / 2;
                        n7 = this.padding;
                    } else if (n > 1) {
                        n7 = (container.getSize().width - insets.left - insets.right - n10) / (n - 1);
                        n8 = insets.left;
                    } else {
                        n8 = insets.left + (container.getSize().width - insets.left - insets.right - n10) / 2;
                        n7 = 0;
                    }
                    if (bl) {
                        for (n9 = 0; n9 < n; ++n9) {
                            componentArray[n9].setBounds(n8, n2, dimensionArray[n9].width, dimensionArray[n9].height);
                            n8 += n7 + dimensionArray[n9].width;
                        }
                    } else {
                        n8 = container.getSize().width - insets.right - (n8 - insets.left);
                        for (n9 = 0; n9 < n; ++n9) {
                            componentArray[n9].setBounds(n8 -= n7 + dimensionArray[n9].width, n2, dimensionArray[n9].width, dimensionArray[n9].height);
                        }
                    }
                }
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            Component[] componentArray;
            if (container != null && (componentArray = container.getComponents()) != null && componentArray.length > 0) {
                int n = componentArray.length;
                int n2 = 0;
                Insets insets = container.getInsets();
                int n3 = insets.top + insets.bottom;
                int n4 = insets.left + insets.right;
                if (this.syncAllWidths) {
                    int n5 = 0;
                    for (int i = 0; i < n; ++i) {
                        Dimension dimension = componentArray[i].getPreferredSize();
                        n2 = Math.max(n2, dimension.height);
                        n5 = Math.max(n5, dimension.width);
                    }
                    return new Dimension(n4 + n5 * n + (n - 1) * this.padding, n3 + n2);
                }
                int n6 = 0;
                for (int i = 0; i < n; ++i) {
                    Dimension dimension = componentArray[i].getPreferredSize();
                    n2 = Math.max(n2, dimension.height);
                    n6 += dimension.width;
                }
                return new Dimension(n4 + (n6 += (n - 1) * this.padding), n3 + n2);
            }
            return new Dimension(0, 0);
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        public void removeLayoutComponent(Component component) {
        }
    }
}

