/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.LiquidLookAndFeel;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Robot;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;

public class LiquidFrameBorder
extends AbstractBorder
implements UIResource {
    private static LiquidFrameBorder onlyInstance;
    private static Robot robot;
    private static boolean robotsSupported;
    private static final Insets insets;
    private boolean prevState = false;
    private Window window;
    private int titleHeight;
    private boolean isActive = true;

    public static LiquidFrameBorder getInstance() {
        if (onlyInstance == null) {
            onlyInstance = new LiquidFrameBorder();
            if (robot == null && robotsSupported) {
                try {
                    robot = new Robot();
                }
                catch (AWTException aWTException) {
                    robotsSupported = false;
                }
            }
        }
        return onlyInstance;
    }

    private void isWindowRealActive(Window window) {
        this.isActive = window.isActive();
        if (this.isActive) {
            this.prevState = true;
        }
        if (!this.prevState && !this.isActive) {
            this.isActive = true;
        }
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        this.window = SwingUtilities.getWindowAncestor(component);
        if (this.window instanceof JDialog) {
            JDialog jDialog = (JDialog)this.window;
            if (jDialog.isModal()) {
                this.isActive = true;
            } else {
                this.isWindowRealActive(this.window);
            }
        } else {
            this.isWindowRealActive(this.window);
        }
        int n5 = UIManager.getInt("InternalFrame.frameTitleHeight");
        boolean bl = !this.isActive;
        this.drawLeftTop(graphics, this.isActive, 4, n5);
        graphics.translate(0, n5);
        this.drawLeft(graphics, this.isActive, 4, n4 - n5 - 4);
        graphics.translate(0, -n5);
        graphics.translate(0, n4 - 4);
        this.drawBottom(graphics, this.isActive, n3, 4);
        graphics.translate(0, -(n4 - 4));
        graphics.translate(n3 - 4, 0);
        this.drawRightTop(graphics, this.isActive, 4, n5);
        graphics.translate(0, n5);
        this.drawRight(graphics, this.isActive, 4, n4 - n5 - 4);
        graphics.translate(0, -n5);
        graphics.translate(-(n3 - 4), 0);
    }

    private void drawLeftTop(Graphics graphics, boolean bl, int n, int n2) {
        if (LiquidLookAndFeel.winDecoPanther) {
            Color color = new Color(198, 198, 198);
            graphics.setColor(color);
            graphics.fillRect(0, 0, n, n2);
            return;
        }
        Color color = bl ? new Color(62, 145, 235) : new Color(175, 214, 255);
        graphics.setColor(color);
        graphics.fillRect(0, 0, n, n2);
        color = bl ? new Color(94, 172, 255) : new Color(226, 240, 255);
        graphics.setColor(color);
        graphics.drawLine(0, 0, n, 0);
        graphics.drawLine(0, 0, 0, n2);
        color = bl ? new Color(60, 141, 228) : new Color(170, 207, 247);
        graphics.setColor(color);
        graphics.drawLine(1, 1, n, 1);
        for (int i = 4; i < n2; i += 4) {
            color = bl ? new Color(59, 138, 223) : new Color(166, 203, 242);
            graphics.setColor(color);
            graphics.drawLine(1, i, n, i);
            color = bl ? new Color(60, 141, 228) : new Color(170, 207, 247);
            graphics.setColor(color);
            graphics.drawLine(1, i + 1, n, i + 1);
        }
        color = bl ? new Color(47, 111, 180) : new Color(135, 164, 196);
        graphics.setColor(color);
        graphics.drawLine(n - 1, n2 - 1, n - 1, n2 - 1);
    }

    private void drawLeft(Graphics graphics, boolean bl, int n, int n2) {
        if (LiquidLookAndFeel.winDecoPanther) {
            Color color = new Color(198, 198, 198);
            graphics.setColor(color);
            graphics.fillRect(0, 0, n, n2);
            return;
        }
        Color color = bl ? new Color(62, 145, 235) : new Color(175, 214, 255);
        graphics.setColor(color);
        graphics.fillRect(0, 0, n, n2);
        color = bl ? new Color(94, 172, 255) : new Color(226, 240, 255);
        graphics.setColor(color);
        graphics.drawLine(0, 0, 0, n2);
        color = bl ? new Color(59, 138, 223) : new Color(166, 203, 242);
        graphics.setColor(color);
        graphics.drawLine(1, 0, n, 0);
        for (int i = 3; i < n2; i += 4) {
            color = bl ? new Color(59, 138, 223) : new Color(166, 203, 242);
            graphics.setColor(color);
            graphics.drawLine(1, i, n, i);
            color = bl ? new Color(60, 141, 228) : new Color(170, 207, 247);
            graphics.setColor(color);
            graphics.drawLine(1, i + 1, n, i + 1);
        }
        color = bl ? new Color(47, 111, 180) : new Color(135, 164, 196);
        graphics.setColor(color);
        graphics.drawLine(n - 1, 0, n - 1, n2);
    }

    private void drawRightTop(Graphics graphics, boolean bl, int n, int n2) {
        if (LiquidLookAndFeel.winDecoPanther) {
            Color color = new Color(198, 198, 198);
            graphics.setColor(color);
            graphics.fillRect(0, 0, n, n2);
            return;
        }
        Color color = bl ? new Color(62, 145, 235) : new Color(175, 214, 255);
        graphics.setColor(color);
        graphics.fillRect(0, 0, n, n2);
        color = bl ? new Color(94, 172, 255) : new Color(226, 240, 255);
        graphics.setColor(color);
        graphics.drawLine(0, 0, n - 2, 0);
        color = bl ? new Color(60, 141, 228) : new Color(170, 207, 247);
        graphics.setColor(color);
        graphics.drawLine(0, 1, n - 2, 1);
        for (int i = 4; i < n2; i += 4) {
            color = bl ? new Color(59, 138, 223) : new Color(166, 203, 242);
            graphics.setColor(color);
            graphics.drawLine(0, i, n - 2, i);
            color = bl ? new Color(60, 141, 228) : new Color(170, 207, 247);
            graphics.setColor(color);
            graphics.drawLine(0, i + 1, n - 2, i + 1);
        }
        color = bl ? new Color(94, 172, 255) : new Color(226, 240, 255);
        graphics.setColor(color);
        graphics.drawLine(0, n2 - 1, 0, n2 - 1);
        color = bl ? new Color(47, 111, 180) : new Color(135, 164, 196);
        graphics.setColor(color);
        graphics.drawLine(n - 1, 0, n - 1, n2);
    }

    private void drawRight(Graphics graphics, boolean bl, int n, int n2) {
        if (LiquidLookAndFeel.winDecoPanther) {
            Color color = new Color(198, 198, 198);
            graphics.setColor(color);
            graphics.fillRect(0, 0, n, n2);
            return;
        }
        Color color = bl ? new Color(62, 145, 235) : new Color(175, 214, 255);
        graphics.setColor(color);
        graphics.fillRect(0, 0, n, n2);
        color = bl ? new Color(94, 172, 255) : new Color(226, 240, 255);
        graphics.setColor(color);
        graphics.drawLine(0, 0, 0, n2);
        color = bl ? new Color(59, 138, 223) : new Color(166, 203, 242);
        graphics.setColor(color);
        graphics.drawLine(1, 0, n, 0);
        for (int i = 3; i < n2; i += 4) {
            color = bl ? new Color(59, 138, 223) : new Color(166, 203, 242);
            graphics.setColor(color);
            graphics.drawLine(1, i, n, i);
            color = bl ? new Color(60, 141, 228) : new Color(170, 207, 247);
            graphics.setColor(color);
            graphics.drawLine(1, i + 1, n, i + 1);
        }
        color = bl ? new Color(47, 111, 180) : new Color(135, 164, 196);
        graphics.setColor(color);
        graphics.drawLine(n - 1, 0, n - 1, n2);
    }

    private void drawBottom(Graphics graphics, boolean bl, int n, int n2) {
        if (LiquidLookAndFeel.winDecoPanther) {
            Color color = new Color(198, 198, 198);
            graphics.setColor(color);
            graphics.fillRect(0, 0, n, n2);
            return;
        }
        Color color = bl ? new Color(62, 145, 235) : new Color(175, 214, 255);
        graphics.setColor(color);
        graphics.fillRect(1, 0, n - 1, n2 - 1);
        color = bl ? new Color(94, 172, 255) : new Color(226, 240, 255);
        graphics.setColor(color);
        graphics.drawLine(3, 0, n - 4, 0);
        graphics.drawLine(0, 0, 0, n2 - 2);
        color = bl ? new Color(47, 111, 180) : new Color(135, 164, 196);
        graphics.setColor(color);
        graphics.drawLine(0, n2 - 1, n, n2 - 1);
        graphics.drawLine(n - 1, 0, n - 1, n2 - 1);
    }

    public Insets getBorderInsets(Component component) {
        if (LiquidLookAndFeel.winDecoPanther) {
            return new Insets(0, 1, 1, 1);
        }
        return new Insets(0, 4, 4, 4);
    }

    public void setActive(boolean bl) {
        this.isActive = bl;
    }

    static {
        robotsSupported = true;
        insets = new Insets(0, 4, 4, 4);
    }
}

