/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPCellEvent;
import java.awt.Color;

public class PdfPRow {
    public static final float BOTTOM_LIMIT = -1.0737418E9f;
    protected PdfPCell[] cells;
    protected float[] widths;
    protected float maxHeight = 0.0f;
    protected boolean calculated = false;
    private int[] canvasesPos;

    public PdfPRow(PdfPCell[] pdfPCellArray) {
        this.cells = pdfPCellArray;
        this.widths = new float[pdfPCellArray.length];
    }

    public PdfPRow(PdfPRow pdfPRow) {
        this.maxHeight = pdfPRow.maxHeight;
        this.calculated = pdfPRow.calculated;
        this.cells = new PdfPCell[pdfPRow.cells.length];
        for (int i = 0; i < this.cells.length; ++i) {
            if (pdfPRow.cells[i] == null) continue;
            this.cells[i] = new PdfPCell(pdfPRow.cells[i]);
        }
        this.widths = new float[this.cells.length];
        System.arraycopy(pdfPRow.widths, 0, this.widths, 0, this.cells.length);
    }

    public boolean setWidths(float[] fArray) {
        if (fArray.length != this.cells.length) {
            return false;
        }
        System.arraycopy(fArray, 0, this.widths, 0, this.cells.length);
        float f = 0.0f;
        this.calculated = false;
        for (int i = 0; i < fArray.length; ++i) {
            PdfPCell pdfPCell = this.cells[i];
            pdfPCell.setLeft(f);
            int n = i + pdfPCell.getColspan();
            while (i < n) {
                f += fArray[i];
                ++i;
            }
            --i;
            pdfPCell.setRight(f);
            pdfPCell.setTop(0.0f);
        }
        return true;
    }

    public float calculateHeights() {
        this.maxHeight = 0.0f;
        for (int i = 0; i < this.cells.length; ++i) {
            float f;
            float f2;
            PdfPCell pdfPCell = this.cells[i];
            if (pdfPCell == null) continue;
            Image image = pdfPCell.getImage();
            if (image != null) {
                image.scalePercent(100.0f);
                f2 = image.scaledWidth();
                if (pdfPCell.getRotation() == 90 || pdfPCell.getRotation() == 270) {
                    f2 = image.scaledHeight();
                }
                f = (pdfPCell.right() - pdfPCell.getEffectivePaddingRight() - pdfPCell.getEffectivePaddingLeft() - pdfPCell.left()) / f2;
                image.scalePercent(f * 100.0f);
                float f3 = image.scaledHeight();
                if (pdfPCell.getRotation() == 90 || pdfPCell.getRotation() == 270) {
                    f3 = image.scaledWidth();
                }
                pdfPCell.setBottom(pdfPCell.top() - pdfPCell.getEffectivePaddingTop() - pdfPCell.getEffectivePaddingBottom() - f3);
            } else if (pdfPCell.getRotation() == 0 || pdfPCell.getRotation() == 180) {
                f2 = pdfPCell.isNoWrap() ? 20000.0f : pdfPCell.right() - pdfPCell.getEffectivePaddingRight();
                f = pdfPCell.getFixedHeight() > 0.0f ? pdfPCell.top() - pdfPCell.getEffectivePaddingTop() + pdfPCell.getEffectivePaddingBottom() - pdfPCell.getFixedHeight() : -1.0737418E9f;
                ColumnText columnText = ColumnText.duplicate(pdfPCell.getColumn());
                columnText.setSimpleColumn(pdfPCell.left() + pdfPCell.getEffectivePaddingLeft(), f, f2, pdfPCell.top() - pdfPCell.getEffectivePaddingTop());
                try {
                    columnText.go(true);
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
                float f4 = columnText.getYLine();
                if (pdfPCell.isUseDescender()) {
                    f4 += columnText.getDescender();
                }
                pdfPCell.setBottom(f4 - pdfPCell.getEffectivePaddingBottom());
            } else if (pdfPCell.getFixedHeight() > 0.0f) {
                pdfPCell.setBottom(pdfPCell.top() - pdfPCell.getFixedHeight());
            } else {
                ColumnText columnText = ColumnText.duplicate(pdfPCell.getColumn());
                columnText.setSimpleColumn(0.0f, pdfPCell.left() + pdfPCell.getEffectivePaddingLeft(), 20000.0f, pdfPCell.right() - pdfPCell.getEffectivePaddingRight());
                try {
                    columnText.go(true);
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
                pdfPCell.setBottom(pdfPCell.top() - pdfPCell.getEffectivePaddingTop() - pdfPCell.getEffectivePaddingBottom() - columnText.getFilledWidth());
            }
            f2 = pdfPCell.getFixedHeight();
            if (f2 <= 0.0f) {
                f2 = pdfPCell.height();
            }
            if (f2 < pdfPCell.getFixedHeight()) {
                f2 = pdfPCell.getFixedHeight();
            } else if (f2 < pdfPCell.getMinimumHeight()) {
                f2 = pdfPCell.getMinimumHeight();
            }
            if (!(f2 > this.maxHeight)) continue;
            this.maxHeight = f2;
        }
        this.calculated = true;
        return this.maxHeight;
    }

    public void writeBorderAndBackground(float f, float f2, PdfPCell pdfPCell, PdfContentByte[] pdfContentByteArray) {
        PdfContentByte pdfContentByte = pdfContentByteArray[2];
        PdfContentByte pdfContentByte2 = pdfContentByteArray[1];
        float f3 = pdfPCell.left() + f;
        float f4 = pdfPCell.top() + f2;
        float f5 = pdfPCell.right() + f;
        float f6 = f4 - this.maxHeight;
        Color color = pdfPCell.backgroundColor();
        if (color != null) {
            pdfContentByte2.setColorFill(color);
            pdfContentByte2.rectangle(f3, f6, f5 - f3, f4 - f6);
            pdfContentByte2.fill();
        }
        if (pdfPCell.hasBorders()) {
            if (pdfPCell.isUseVariableBorders()) {
                Rectangle rectangle = new Rectangle(pdfPCell.left() + f, pdfPCell.top() - this.maxHeight + f2, pdfPCell.right() + f, pdfPCell.top() + f2);
                rectangle.cloneNonPositionParameters(pdfPCell);
                rectangle.setBackgroundColor(null);
                pdfContentByte.rectangle(rectangle);
            } else {
                Color color2;
                if (pdfPCell.borderWidth() != -1.0f) {
                    pdfContentByte.setLineWidth(pdfPCell.borderWidth());
                }
                if ((color2 = pdfPCell.borderColor()) != null) {
                    pdfContentByte.setColorStroke(color2);
                }
                if (pdfPCell.hasBorder(15)) {
                    pdfContentByte.rectangle(f3, f6, f5 - f3, f4 - f6);
                } else {
                    if (pdfPCell.hasBorder(8)) {
                        pdfContentByte.moveTo(f5, f6);
                        pdfContentByte.lineTo(f5, f4);
                    }
                    if (pdfPCell.hasBorder(4)) {
                        pdfContentByte.moveTo(f3, f6);
                        pdfContentByte.lineTo(f3, f4);
                    }
                    if (pdfPCell.hasBorder(2)) {
                        pdfContentByte.moveTo(f3, f6);
                        pdfContentByte.lineTo(f5, f6);
                    }
                    if (pdfPCell.hasBorder(1)) {
                        pdfContentByte.moveTo(f3, f4);
                        pdfContentByte.lineTo(f5, f4);
                    }
                }
                pdfContentByte.stroke();
                if (color2 != null) {
                    pdfContentByte.resetRGBColorStroke();
                }
            }
        }
    }

    private void saveAndRotateCanvases(PdfContentByte[] pdfContentByteArray, float f, float f2, float f3, float f4, float f5, float f6) {
        int n = 4;
        if (this.canvasesPos == null) {
            this.canvasesPos = new int[n * 2];
        }
        for (int i = 0; i < n; ++i) {
            ByteBuffer byteBuffer = pdfContentByteArray[i].getInternalBuffer();
            this.canvasesPos[i * 2] = byteBuffer.size();
            pdfContentByteArray[i].saveState();
            pdfContentByteArray[i].concatCTM(f, f2, f3, f4, f5, f6);
            this.canvasesPos[i * 2 + 1] = byteBuffer.size();
        }
    }

    private void restoreCanvases(PdfContentByte[] pdfContentByteArray) {
        int n = 4;
        for (int i = 0; i < n; ++i) {
            ByteBuffer byteBuffer = pdfContentByteArray[i].getInternalBuffer();
            int n2 = byteBuffer.size();
            pdfContentByteArray[i].restoreState();
            if (n2 != this.canvasesPos[i * 2 + 1]) continue;
            byteBuffer.setSize(this.canvasesPos[i * 2]);
        }
    }

    public void writeCells(int n, int n2, float f, float f2, PdfContentByte[] pdfContentByteArray) {
        int n3;
        if (!this.calculated) {
            this.calculateHeights();
        }
        if (n2 < 0) {
            n2 = this.cells.length;
        }
        n2 = Math.min(n2, this.cells.length);
        if (n < 0) {
            n = 0;
        }
        if (n >= n2) {
            return;
        }
        for (n3 = n; n3 >= 0 && this.cells[n3] == null; --n3) {
            f -= this.widths[n3 - 1];
        }
        f -= this.cells[n3].left();
        for (int i = n3; i < n2; ++i) {
            float f3;
            float f4;
            float f5;
            PdfPCell pdfPCell = this.cells[i];
            if (pdfPCell == null) continue;
            this.writeBorderAndBackground(f, f2, pdfPCell, pdfContentByteArray);
            Image image = pdfPCell.getImage();
            float f6 = 0.0f;
            switch (pdfPCell.getVerticalAlignment()) {
                case 6: {
                    f6 = pdfPCell.top() + f2 - this.maxHeight + pdfPCell.height() - pdfPCell.getEffectivePaddingTop();
                    break;
                }
                case 5: {
                    f6 = pdfPCell.top() + f2 + (pdfPCell.height() - this.maxHeight) / 2.0f - pdfPCell.getEffectivePaddingTop();
                    break;
                }
                default: {
                    f6 = pdfPCell.top() + f2 - pdfPCell.getEffectivePaddingTop();
                }
            }
            if (image != null) {
                if (pdfPCell.getRotation() != 0) {
                    image = Image.getInstance(image);
                    image.setRotation(image.getImageRotation() + (float)((double)pdfPCell.getRotation() * Math.PI / 180.0));
                }
                boolean bl = false;
                if (pdfPCell.height() > this.maxHeight) {
                    image.scalePercent(100.0f);
                    f5 = (this.maxHeight - pdfPCell.getEffectivePaddingTop() - pdfPCell.getEffectivePaddingBottom()) / image.scaledHeight();
                    image.scalePercent(f5 * 100.0f);
                    bl = true;
                }
                f5 = pdfPCell.left() + f + pdfPCell.getEffectivePaddingLeft();
                if (bl) {
                    switch (pdfPCell.getHorizontalAlignment()) {
                        case 1: {
                            f5 = f + (pdfPCell.left() + pdfPCell.getEffectivePaddingLeft() + pdfPCell.right() - pdfPCell.getEffectivePaddingRight() - image.scaledWidth()) / 2.0f;
                            break;
                        }
                        case 2: {
                            f5 = f + pdfPCell.right() - pdfPCell.getEffectivePaddingRight() - image.scaledWidth();
                            break;
                        }
                    }
                    f6 = pdfPCell.top() + f2 - pdfPCell.getEffectivePaddingTop();
                }
                image.setAbsolutePosition(f5, f6 - image.scaledHeight());
                try {
                    pdfContentByteArray[3].addImage(image);
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
            }
            if (pdfPCell.getRotation() == 90 || pdfPCell.getRotation() == 270) {
                float f7 = this.maxHeight - pdfPCell.getEffectivePaddingTop() - pdfPCell.getEffectivePaddingBottom();
                f5 = pdfPCell.width() - pdfPCell.getEffectivePaddingLeft() - pdfPCell.getEffectivePaddingRight();
                ColumnText columnText = ColumnText.duplicate(pdfPCell.getColumn());
                columnText.setCanvases(pdfContentByteArray);
                columnText.setSimpleColumn(0.0f, 0.0f, f7 + 0.001f, -f5);
                try {
                    columnText.go(true);
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
                float f8 = -columnText.getYLine();
                if (f8 > 0.0f) {
                    if (pdfPCell.isUseDescender()) {
                        f8 -= columnText.getDescender();
                    }
                    columnText = ColumnText.duplicate(pdfPCell.getColumn());
                    columnText.setCanvases(pdfContentByteArray);
                    columnText.setSimpleColumn(0.0f, -0.001f, f7 + 0.001f, f8);
                    if (pdfPCell.getRotation() == 90) {
                        f4 = pdfPCell.top() + f2 - this.maxHeight + pdfPCell.getEffectivePaddingBottom();
                        switch (pdfPCell.getVerticalAlignment()) {
                            case 6: {
                                f3 = pdfPCell.left() + f + pdfPCell.width() - pdfPCell.getEffectivePaddingRight();
                                break;
                            }
                            case 5: {
                                f3 = pdfPCell.left() + f + (pdfPCell.width() + pdfPCell.getEffectivePaddingLeft() - pdfPCell.getEffectivePaddingRight() + f8) / 2.0f;
                                break;
                            }
                            default: {
                                f3 = pdfPCell.left() + f + pdfPCell.getEffectivePaddingLeft() + f8;
                            }
                        }
                        this.saveAndRotateCanvases(pdfContentByteArray, 0.0f, 1.0f, -1.0f, 0.0f, f3, f4);
                    } else {
                        f4 = pdfPCell.top() + f2 - pdfPCell.getEffectivePaddingTop();
                        switch (pdfPCell.getVerticalAlignment()) {
                            case 6: {
                                f3 = pdfPCell.left() + f + pdfPCell.getEffectivePaddingLeft();
                                break;
                            }
                            case 5: {
                                f3 = pdfPCell.left() + f + (pdfPCell.width() + pdfPCell.getEffectivePaddingLeft() - pdfPCell.getEffectivePaddingRight() - f8) / 2.0f;
                                break;
                            }
                            default: {
                                f3 = pdfPCell.left() + f + pdfPCell.width() - pdfPCell.getEffectivePaddingRight() - f8;
                            }
                        }
                        this.saveAndRotateCanvases(pdfContentByteArray, 0.0f, -1.0f, 1.0f, 0.0f, f3, f4);
                    }
                    try {
                        columnText.go();
                    }
                    catch (DocumentException documentException) {
                        throw new ExceptionConverter(documentException);
                    }
                    finally {
                        this.restoreCanvases(pdfContentByteArray);
                    }
                }
            } else {
                float f9 = pdfPCell.getFixedHeight();
                f5 = pdfPCell.right() + f - pdfPCell.getEffectivePaddingRight();
                float f10 = pdfPCell.left() + f + pdfPCell.getEffectivePaddingLeft();
                if (pdfPCell.isNoWrap()) {
                    switch (pdfPCell.getHorizontalAlignment()) {
                        case 1: {
                            f5 += 10000.0f;
                            f10 -= 10000.0f;
                            break;
                        }
                        case 2: {
                            f10 -= 20000.0f;
                            break;
                        }
                        default: {
                            f5 += 20000.0f;
                        }
                    }
                }
                ColumnText columnText = ColumnText.duplicate(pdfPCell.getColumn());
                columnText.setCanvases(pdfContentByteArray);
                f3 = f6 - (this.maxHeight - pdfPCell.getEffectivePaddingTop() - pdfPCell.getEffectivePaddingBottom());
                if (f9 > 0.0f && pdfPCell.height() > this.maxHeight) {
                    f6 = pdfPCell.top() + f2 - pdfPCell.getEffectivePaddingTop();
                    f3 = pdfPCell.top() + f2 - this.maxHeight + pdfPCell.getEffectivePaddingBottom();
                }
                if ((f6 > f3 || columnText.zeroHeightElement()) && f10 < f5) {
                    columnText.setSimpleColumn(f10, f3 - 0.001f, f5, f6);
                    if (pdfPCell.getRotation() == 180) {
                        f4 = f10 + f5;
                        float f11 = f3 - 0.001f + f6;
                        this.saveAndRotateCanvases(pdfContentByteArray, -1.0f, 0.0f, 0.0f, -1.0f, f4, f11);
                    }
                    try {
                        columnText.go();
                    }
                    catch (DocumentException documentException) {
                        throw new ExceptionConverter(documentException);
                    }
                    finally {
                        if (pdfPCell.getRotation() == 180) {
                            this.restoreCanvases(pdfContentByteArray);
                        }
                    }
                }
            }
            PdfPCellEvent pdfPCellEvent = pdfPCell.getCellEvent();
            if (pdfPCellEvent == null) continue;
            Rectangle rectangle = new Rectangle(pdfPCell.left() + f, pdfPCell.top() + f2 - this.maxHeight, pdfPCell.right() + f, pdfPCell.top() + f2);
            pdfPCellEvent.cellLayout(pdfPCell, rectangle, pdfContentByteArray);
        }
    }

    public boolean isCalculated() {
        return this.calculated;
    }

    public float getMaxHeights() {
        if (this.calculated) {
            return this.maxHeight;
        }
        return this.calculateHeights();
    }

    public void setMaxHeights(float f) {
        this.maxHeight = f;
    }

    float[] getEventWidth(float f) {
        int n = 0;
        for (int i = 0; i < this.cells.length; ++i) {
            if (this.cells[i] == null) continue;
            ++n;
        }
        float[] fArray = new float[n + 1];
        n = 0;
        fArray[n++] = f;
        for (int i = 0; i < this.cells.length; ++i) {
            if (this.cells[i] == null) continue;
            fArray[n] = fArray[n - 1] + this.cells[i].width();
            ++n;
        }
        return fArray;
    }

    public PdfPRow splitRow(float f) {
        PdfPCell pdfPCell;
        int n;
        PdfPCell[] pdfPCellArray = new PdfPCell[this.cells.length];
        float[] fArray = new float[this.cells.length * 2];
        boolean bl = true;
        for (n = 0; n < this.cells.length; ++n) {
            pdfPCell = this.cells[n];
            if (pdfPCell == null) continue;
            fArray[n * 2] = pdfPCell.getFixedHeight();
            fArray[n * 2 + 1] = pdfPCell.getMinimumHeight();
            Image image = pdfPCell.getImage();
            PdfPCell pdfPCell2 = new PdfPCell(pdfPCell);
            if (image != null) {
                if (f > pdfPCell.getEffectivePaddingBottom() + pdfPCell.getEffectivePaddingTop() + 2.0f) {
                    pdfPCell2.setPhrase(null);
                    bl = false;
                }
            } else {
                boolean bl2;
                int n2;
                float f2;
                ColumnText columnText = ColumnText.duplicate(pdfPCell.getColumn());
                if (pdfPCell.getRotation() == 90 || pdfPCell.getRotation() == 270) {
                    f2 = pdfPCell.right() - pdfPCell.getEffectivePaddingRight();
                    columnText.setSimpleColumn(pdfPCell.top() - f + pdfPCell.getEffectivePaddingBottom(), pdfPCell.left() + pdfPCell.getEffectivePaddingLeft(), pdfPCell.top() - pdfPCell.getEffectivePaddingTop(), f2);
                } else {
                    float f3 = pdfPCell.isNoWrap() ? 20000.0f : pdfPCell.right() - pdfPCell.getEffectivePaddingRight();
                    float f4 = pdfPCell.top() - f + pdfPCell.getEffectivePaddingBottom();
                    float f5 = pdfPCell.top() - pdfPCell.getEffectivePaddingTop();
                    f2 = Math.max(f4, f5);
                    columnText.setSimpleColumn(pdfPCell.left() + pdfPCell.getEffectivePaddingLeft(), f4, f3, f5);
                }
                try {
                    n2 = columnText.go(true);
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
                boolean bl3 = bl2 = columnText.getYLine() == f2;
                if (bl2) {
                    columnText = ColumnText.duplicate(pdfPCell.getColumn());
                }
                boolean bl4 = bl = bl && bl2;
                if ((n2 & 1) == 0 || bl2) {
                    pdfPCell2.setColumn(columnText);
                    columnText.setFilledWidth(0.0f);
                } else {
                    pdfPCell2.setPhrase(null);
                }
            }
            pdfPCellArray[n] = pdfPCell2;
            pdfPCell.setFixedHeight(f);
        }
        if (bl) {
            for (n = 0; n < this.cells.length; ++n) {
                pdfPCell = this.cells[n];
                if (pdfPCell == null) continue;
                float f6 = fArray[n * 2];
                float f7 = fArray[n * 2 + 1];
                if (f6 <= 0.0f) {
                    pdfPCell.setMinimumHeight(f7);
                    continue;
                }
                pdfPCell.setFixedHeight(f6);
            }
            return null;
        }
        this.calculateHeights();
        PdfPRow pdfPRow = new PdfPRow(pdfPCellArray);
        pdfPRow.widths = (float[])this.widths.clone();
        pdfPRow.calculateHeights();
        return pdfPRow;
    }
}

