/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid.util;

import com.birosoft.liquid.skin.SkinImageCache;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import javax.swing.JComponent;

public class Colors {
    static Image image;
    static Image newImage;
    static BufferedImage clearFill;
    static Color buttonBg;
    static Color bg;

    public static Image getImage() {
        return newImage;
    }

    public static BufferedImage getClearFill() {
        return clearFill;
    }

    public static void drawStipples(Graphics graphics, JComponent jComponent, Color color) {
        graphics.setColor(Colors.dark(color, 103));
        int n = jComponent.getHeight();
        for (int i = 0; i < n; i += 3) {
            graphics.drawLine(0, i, jComponent.getWidth() - 1, i);
            graphics.drawLine(0, ++i, jComponent.getWidth() - 1, i);
        }
    }

    static Color handlesinglepixel(int n, int n2, int n3, Color color) {
        int n4 = n3 >> 24 & 0xFF;
        int n5 = n3 >> 16 & 0xFF;
        int n6 = n3 >> 8 & 0xFF;
        int n7 = n3 & 0xFF;
        return Colors.liquidAlpha(color, new Color(n5, n6, n7, n4));
    }

    public static void getPixels() {
        SkinImageCache skinImageCache = SkinImageCache.getInstance();
        image = skinImageCache.getAutomaticImage("button.png");
        clearFill = skinImageCache.getBufferedImage("clear_fill.png");
        int n = 0;
        int n2 = 0;
        int n3 = image.getWidth(null);
        int n4 = image.getHeight(null);
        newImage = new BufferedImage(n3, n4, 6);
        int[] nArray = new int[n3 * n4];
        PixelGrabber pixelGrabber = new PixelGrabber(image, n, n2, n3, n4, nArray, 0, n3);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("interrupted waiting for pixels!");
            return;
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return;
        }
        Graphics graphics = newImage.getGraphics();
        Color color = null;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                if (j == 0 || j == 117) {
                    color = bg;
                } else if (j == 39 || j == 156) {
                    color = buttonBg;
                } else if (j == 78) {
                    color = Colors.dark(buttonBg, 115);
                }
                graphics.setColor(Colors.handlesinglepixel(n + j, n2 + i, nArray[i * n3 + j], color));
                graphics.drawLine(n + j, n2 + i, n + j, n2 + i);
            }
        }
    }

    public static Color dark(Color color, int n) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        if (n <= 0 || color.getAlpha() < 255) {
            return color;
        }
        if (n < 100) {
            return Colors.light(color, 10000 / n);
        }
        int n2 = (int)(fArray[2] * 255.0f);
        n2 = 100 * n2 / n;
        float f = (float)n2 / 255.0f;
        return Color.getHSBColor(fArray[0], fArray[1], f);
    }

    public static Color light(Color color, int n) {
        if (n <= 0) {
            return color;
        }
        if (n < 100) {
            return Colors.dark(color, 10000 / n);
        }
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float f = fArray[1];
        float f2 = fArray[2];
        System.out.print("LIGHT V : " + f2);
        f2 = (float)n * f2 / 100.0f;
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        if (f2 > 255.0f) {
            if ((f -= f2 - 255.0f) < 0.0f) {
                f = 0.0f;
            }
            f2 = 255.0f;
        }
        return Color.getHSBColor(fArray[0], fArray[1], f2);
    }

    public static Color liquidAlpha(Color color, Color color2) {
        boolean bl = false;
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = color2.getAlpha();
        int n5 = 255 - color2.getRed();
        int n6 = (n += 20) - n5;
        int n7 = (n2 += 20) - n5;
        int n8 = (n3 += 20) - n5;
        if (n6 < 0) {
            n6 = 0;
        }
        if (n7 < 0) {
            n7 = 0;
        }
        if (n8 < 0) {
            n8 = 0;
        }
        if (n6 > 255) {
            n6 = 255;
        }
        if (n7 > 255) {
            n7 = 255;
        }
        if (n8 > 255) {
            n8 = 255;
        }
        if (bl && n4 != 255 && n4 != 0) {
            float f = (float)n4 / 255.0f;
            float f2 = 1.0f - f;
            n6 = (int)(f * (float)n6 + f2 * (float)color2.getRed());
            n7 = (int)(f * (float)n7 + f2 * (float)color2.getGreen());
            n8 = (int)(f * (float)n8 + f2 * (float)color2.getBlue());
            n4 = 255;
        }
        return new Color(n6, n7, n8, n4);
    }

    static {
        buttonBg = new Color(215, 231, 249);
        bg = new Color(246, 245, 244);
    }
}

