/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.skin.Skin;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class LiquidTableHeaderUI
extends TableHeaderUI {
    private static Cursor resizeCursor = Cursor.getPredefinedCursor(11);
    protected static final int HEADER_HEIGHT = 22;
    private int columnSelected = -1;
    private Skin skin;
    protected JTableHeader header;
    protected CellRendererPane rendererPane;
    protected MouseInputListener mouseInputListener;

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new LiquidTableHeaderUI();
    }

    public void installUI(JComponent jComponent) {
        this.header = (JTableHeader)jComponent;
        this.rendererPane = new CellRendererPane();
        this.header.add(this.rendererPane);
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.header, "TableHeader.background", "TableHeader.foreground", "TableHeader.font");
    }

    protected void installListeners() {
        this.mouseInputListener = this.createMouseInputListener();
        this.header.addMouseListener(this.mouseInputListener);
        this.header.addMouseMotionListener(this.mouseInputListener);
    }

    protected void installKeyboardActions() {
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.header.remove(this.rendererPane);
        this.rendererPane = null;
        this.header = null;
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallListeners() {
        this.header.removeMouseListener(this.mouseInputListener);
        this.header.removeMouseMotionListener(this.mouseInputListener);
        this.mouseInputListener = null;
    }

    protected void uninstallKeyboardActions() {
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        int n;
        if (this.header.getColumnModel().getColumnCount() <= 0) {
            return;
        }
        boolean bl = this.header.getComponentOrientation().isLeftToRight();
        Rectangle rectangle = graphics.getClipBounds();
        Point point = rectangle.getLocation();
        Point point2 = new Point(rectangle.x + rectangle.width - 1, rectangle.y);
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        int n2 = this.header.columnAtPoint(bl ? point : point2);
        int n3 = this.header.columnAtPoint(bl ? point2 : point);
        if (n2 == -1) {
            n2 = 0;
        }
        if (n3 == -1) {
            n3 = tableColumnModel.getColumnCount() - 1;
        }
        TableColumn tableColumn = this.header.getDraggedColumn();
        int n4 = tableColumnModel.getColumnMargin();
        Rectangle rectangle2 = this.header.getHeaderRect(n2);
        if (bl) {
            for (n = n2; n <= n3; ++n) {
                TableColumn tableColumn2 = tableColumnModel.getColumn(n);
                int n5 = tableColumn2.getWidth();
                rectangle2.width = n5 - n4;
                if (tableColumn2 != tableColumn) {
                    this.paintCell(graphics, rectangle2, n);
                }
                rectangle2.x += n5;
            }
        } else {
            int n6;
            TableColumn tableColumn3 = tableColumnModel.getColumn(n2);
            if (tableColumn3 != tableColumn) {
                n6 = tableColumn3.getWidth();
                rectangle2.width = n6 - n4;
                rectangle2.x += n4;
                this.paintCell(graphics, rectangle2, n2);
            }
            for (n = n2 + 1; n <= n3; ++n) {
                tableColumn3 = tableColumnModel.getColumn(n);
                n6 = tableColumn3.getWidth();
                rectangle2.width = n6 - n4;
                rectangle2.x -= n6;
                if (tableColumn3 == tableColumn) continue;
                this.paintCell(graphics, rectangle2, n);
            }
        }
        if (tableColumn != null) {
            n = this.viewIndexForColumn(tableColumn);
            Rectangle rectangle3 = this.header.getHeaderRect(n);
            graphics.setColor(this.header.getParent().getBackground());
            graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            rectangle3.x += this.header.getDraggedDistance();
            graphics.setColor(this.header.getBackground());
            graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            this.paintCell(graphics, rectangle3, n);
        }
        this.rendererPane.removeAll();
    }

    private Component getHeaderRenderer(int n) {
        TableColumn tableColumn = this.header.getColumnModel().getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.header.getDefaultRenderer();
        }
        return tableCellRenderer.getTableCellRendererComponent(this.header.getTable(), tableColumn.getHeaderValue(), false, false, -1, n);
    }

    private void paintCell(Graphics graphics, Rectangle rectangle, int n) {
        int n2 = 0;
        Component component = this.getHeaderRenderer(n);
        if (n == this.columnSelected) {
            n2 = 1;
        }
        this.getSkin().draw(graphics, n2, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.rendererPane.paintComponent(graphics, component, this.header, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
    }

    private int viewIndexForColumn(TableColumn tableColumn) {
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            if (tableColumnModel.getColumn(i) != tableColumn) continue;
            return i;
        }
        return -1;
    }

    private int getHeaderHeight() {
        return 22;
    }

    private Dimension createHeaderSize(long l) {
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        if (l > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        return new Dimension((int)l, this.getHeaderHeight());
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        long l = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            l += (long)tableColumn.getMinWidth();
        }
        return this.createHeaderSize(l);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        long l = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            l += (long)tableColumn.getPreferredWidth();
        }
        return this.createHeaderSize(l);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        long l = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            l += (long)tableColumn.getMaxWidth();
        }
        return this.createHeaderSize(l);
    }

    public Skin getSkin() {
        if (this.skin == null) {
            this.skin = new Skin("tableheader.png", 8, 4, 13, 4, 10);
        }
        return this.skin;
    }

    public class MouseInputHandler
    implements MouseInputListener {
        private int mouseXOffset;
        private Cursor otherCursor = LiquidTableHeaderUI.access$000();

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        private boolean canResize(TableColumn tableColumn) {
            return tableColumn != null && LiquidTableHeaderUI.this.header.getResizingAllowed() && tableColumn.getResizable();
        }

        private TableColumn getResizingColumn(Point point) {
            return this.getResizingColumn(point, LiquidTableHeaderUI.this.header.columnAtPoint(point));
        }

        private TableColumn getResizingColumn(Point point, int n) {
            int n2;
            if (n == -1) {
                return null;
            }
            Rectangle rectangle = LiquidTableHeaderUI.this.header.getHeaderRect(n);
            rectangle.grow(-3, 0);
            if (rectangle.contains(point)) {
                return null;
            }
            int n3 = rectangle.x + rectangle.width / 2;
            if (LiquidTableHeaderUI.this.header.getComponentOrientation().isLeftToRight()) {
                n2 = point.x < n3 ? n - 1 : n;
            } else {
                int n4 = n2 = point.x < n3 ? n : n - 1;
            }
            if (n2 == -1) {
                return null;
            }
            return LiquidTableHeaderUI.this.header.getColumnModel().getColumn(n2);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            LiquidTableHeaderUI.this.header.setDraggedColumn(null);
            LiquidTableHeaderUI.this.header.setResizingColumn(null);
            LiquidTableHeaderUI.this.header.setDraggedDistance(0);
            Point point = mouseEvent.getPoint();
            TableColumnModel tableColumnModel = LiquidTableHeaderUI.this.header.getColumnModel();
            int n = LiquidTableHeaderUI.this.header.columnAtPoint(point);
            if (n != -1) {
                TableColumn tableColumn = this.getResizingColumn(point, n);
                if (this.canResize(tableColumn)) {
                    LiquidTableHeaderUI.this.header.setResizingColumn(tableColumn);
                    this.mouseXOffset = LiquidTableHeaderUI.this.header.getComponentOrientation().isLeftToRight() ? point.x - tableColumn.getWidth() : point.x + tableColumn.getWidth();
                } else if (LiquidTableHeaderUI.this.header.getReorderingAllowed()) {
                    TableColumn tableColumn2 = tableColumnModel.getColumn(n);
                    LiquidTableHeaderUI.this.header.setDraggedColumn(tableColumn2);
                    this.mouseXOffset = point.x;
                }
            }
        }

        private void swapCursor() {
            Cursor cursor = LiquidTableHeaderUI.this.header.getCursor();
            LiquidTableHeaderUI.this.header.setCursor(this.otherCursor);
            this.otherCursor = cursor;
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (this.canResize(this.getResizingColumn(mouseEvent.getPoint())) != (LiquidTableHeaderUI.this.header.getCursor() == resizeCursor)) {
                this.swapCursor();
            }
            Point point = mouseEvent.getPoint();
            TableColumnModel tableColumnModel = LiquidTableHeaderUI.this.header.getColumnModel();
            int n = LiquidTableHeaderUI.this.header.columnAtPoint(point);
            if (n != LiquidTableHeaderUI.this.columnSelected) {
                LiquidTableHeaderUI.this.columnSelected = n;
                LiquidTableHeaderUI.this.header.repaint();
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            TableColumn tableColumn = LiquidTableHeaderUI.this.header.getResizingColumn();
            TableColumn tableColumn2 = LiquidTableHeaderUI.this.header.getDraggedColumn();
            boolean bl = LiquidTableHeaderUI.this.header.getComponentOrientation().isLeftToRight();
            if (tableColumn != null) {
                JTable jTable;
                Container container;
                int n2 = tableColumn.getWidth();
                int n3 = bl ? n - this.mouseXOffset : this.mouseXOffset - n;
                tableColumn.setWidth(n3);
                if (LiquidTableHeaderUI.this.header.getParent() == null || (container = LiquidTableHeaderUI.this.header.getParent().getParent()) == null || !(container instanceof JScrollPane)) {
                    return;
                }
                if (!container.getComponentOrientation().isLeftToRight() && !bl && (jTable = LiquidTableHeaderUI.this.header.getTable()) != null) {
                    JViewport jViewport = ((JScrollPane)container).getViewport();
                    int n4 = jViewport.getWidth();
                    int n5 = n3 - n2;
                    int n6 = jTable.getWidth() + n5;
                    Dimension dimension = jTable.getSize();
                    dimension.width += n5;
                    jTable.setSize(dimension);
                    if (n6 >= n4 && jTable.getAutoResizeMode() == 0) {
                        Point point = jViewport.getViewPosition();
                        point.x = Math.max(0, Math.min(n6 - n4, point.x + n5));
                        jViewport.setViewPosition(point);
                        this.mouseXOffset += n5;
                    }
                }
            } else if (tableColumn2 != null) {
                TableColumnModel tableColumnModel = LiquidTableHeaderUI.this.header.getColumnModel();
                int n7 = n - this.mouseXOffset;
                int n8 = n7 < 0 ? -1 : 1;
                int n9 = LiquidTableHeaderUI.this.viewIndexForColumn(tableColumn2);
                int n10 = n9 + (bl ? n8 : -n8);
                if (0 <= n10 && n10 < tableColumnModel.getColumnCount()) {
                    int n11 = tableColumnModel.getColumn(n10).getWidth();
                    if (Math.abs(n7) > n11 / 2) {
                        this.mouseXOffset += n8 * n11;
                        LiquidTableHeaderUI.this.header.setDraggedDistance(n7 - n8 * n11);
                        tableColumnModel.moveColumn(n9, n10);
                        return;
                    }
                }
                this.setDraggedDistance(n7, n9);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.setDraggedDistance(0, LiquidTableHeaderUI.this.viewIndexForColumn(LiquidTableHeaderUI.this.header.getDraggedColumn()));
            LiquidTableHeaderUI.this.header.setResizingColumn(null);
            LiquidTableHeaderUI.this.header.setDraggedColumn(null);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            LiquidTableHeaderUI.this.columnSelected = -1;
            LiquidTableHeaderUI.this.header.repaint();
        }

        private void setDraggedDistance(int n, int n2) {
            LiquidTableHeaderUI.this.header.setDraggedDistance(n);
            if (n2 != -1) {
                LiquidTableHeaderUI.this.header.getColumnModel().moveColumn(n2, n2);
            }
        }
    }
}

