/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.LiquidLookAndFeel;
import com.birosoft.liquid.skin.Skin;
import com.birosoft.liquid.skin.SkinToggleButtonIndexModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;

public class LiquidButtonUI
extends BasicButtonUI {
    public static final boolean HINT_DO_NOT_PAINT_TOOLBARBUTTON_IF_NO_MOUSE_OVER = true;
    private static final LiquidButtonUI buttonUI = new LiquidButtonUI();
    static Skin skinButton;
    private static Skin skinToolbar;
    private static Skin skinSmallButton;
    static BasicStroke focusStroke;
    SkinToggleButtonIndexModel buttonIndexModel = new SkinToggleButtonIndexModel(true);
    SkinToggleButtonIndexModel toolbarIndexModel = new SkinToggleButtonIndexModel();

    public void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
    }

    public void uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        Rectangle rectangle4 = abstractButton.getBounds();
        int n = rectangle4.height / 2 - 5;
        if (this.buttonIndexModel.getIndexForState() == 2) {
            return;
        }
        if (abstractButton.getClientProperty("JToolBar.isToolbarButton") != Boolean.TRUE && abstractButton.isFocusPainted()) {
            this.paintFocus(graphics, n);
        }
    }

    public void paintFocus(Graphics graphics, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics.setColor(new Color(196, 195, 194));
        graphics2D.drawLine(6, n, 11, n + 5);
        graphics.setColor(new Color(175, 174, 174));
        graphics2D.drawLine(6, n + 1, 6, n + 11);
        graphics2D.drawLine(6, n + 11, 11, n + 6);
    }

    public static ComponentUI createUI(final JComponent jComponent) {
        JButton jButton = (JButton)jComponent;
        jButton.setRolloverEnabled(true);
        jComponent.setOpaque(false);
        jComponent.addPropertyChangeListener("opaque", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                jComponent.setOpaque(false);
            }
        });
        return buttonUI;
    }

    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        if (jComponent instanceof JToggleButton) {
            super.paint(graphics, jComponent);
            return;
        }
        AbstractButton abstractButton = (AbstractButton)jComponent;
        if (abstractButton.getClientProperty("JToolBar.isToolbarButton") == Boolean.TRUE) {
            this.toolbarIndexModel.setButton(abstractButton);
            int n = this.toolbarIndexModel.getIndexForState();
            if (abstractButton.hasFocus() && n == 0) {
                n = 1;
            }
            this.getSkinToolbar().draw(graphics, n, abstractButton.getWidth(), abstractButton.getHeight());
        } else {
            this.buttonIndexModel.setButton(abstractButton);
            this.buttonIndexModel.setCheckForDefaultButton(abstractButton instanceof JButton);
            int n = this.buttonIndexModel.getIndexForState();
            if (n > 3) {
                n -= 4;
            }
            if (abstractButton.hasFocus() && n == 0) {
                n = 1;
            }
            if (abstractButton.getHeight() < 21 || abstractButton.getWidth() < 21) {
                this.getSkinSmallButton().draw(graphics, n, abstractButton.getWidth(), abstractButton.getHeight());
                abstractButton.setFocusPainted(false);
            } else {
                this.getSkinButton().draw(graphics, n, abstractButton.getWidth(), abstractButton.getHeight());
            }
            if (n == 4 && abstractButton.isFocusPainted()) {
                Rectangle rectangle = abstractButton.getBounds();
                this.paintFocus(graphics, rectangle.height / 2 - 5);
            }
        }
        super.paint(graphics, jComponent);
    }

    public Skin getSkinButton() {
        if (skinButton == null) {
            skinButton = new Skin("button.png", 5, 10, 10, 12, 12);
            skinButton.colourImage();
        }
        return skinButton;
    }

    public Skin getSkinToolbar() {
        if (skinToolbar == null) {
            skinToolbar = LiquidLookAndFeel.toolbarFlattedButtons ? new Skin("toolbar.png", 8, 4, 13, 4, 10) : new Skin("toolbar-nonflatted.png", 8, 4, 13, 4, 10);
        }
        return skinToolbar;
    }

    public Skin getSkinSmallButton() {
        if (skinSmallButton == null) {
            skinSmallButton = new Skin("toolbar-nonflatted.png", 8, 4, 13, 4, 10);
        }
        return skinSmallButton;
    }

    public void update(Graphics graphics, JComponent jComponent) {
        this.paint(graphics, jComponent);
    }

    static {
        focusStroke = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{1.0f, 1.0f}, 1.0f);
    }
}

