/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp2d.layout;

import de.grogra.imp2d.layout.Edge;
import de.grogra.imp2d.layout.ForceBasedLayout;
import de.grogra.imp2d.layout.Node;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import java.util.Random;
import javax.vecmath.Tuple2f;
import javax.vecmath.Vector2f;

public class DavidsonHarelLayout
extends ForceBasedLayout {
    private double attractionFactor = 5.0;
    private double repulsionFactor = 0.5;
    public static final Type $TYPE = new Type(DavidsonHarelLayout.class);
    public static final SCOType.Field attractionFactor$FIELD = Type._addManagedField($TYPE, "attractionFactor", 0x200002, de.grogra.reflect.Type.DOUBLE, null, 7);
    public static final SCOType.Field repulsionFactor$FIELD = Type._addManagedField($TYPE, "repulsionFactor", 0x200002, de.grogra.reflect.Type.DOUBLE, null, 8);

    protected void setRandomPosition(Node node, Random random) {
        node.x = random.nextFloat();
        node.y = random.nextFloat();
    }

    protected void computeForce(Node node, Node node2, Vector2f vector2f) {
        double d = node2.distance(node);
        if (d == 0.0) {
            d = 0.001;
        }
        float f = (float)(this.repulsionFactor / d);
        vector2f.sub((Tuple2f)node2, (Tuple2f)node);
        if (d > 0.0) {
            vector2f.scale((float)(1.0 / d));
        }
        vector2f.scale(f);
    }

    protected void computeForce(Edge edge, Vector2f vector2f) {
        double d = edge.source.distance(edge.target);
        if (d == 0.0) {
            d = 0.001;
        }
        float f = (float)(this.attractionFactor * Math.log(d * d));
        vector2f.sub((Tuple2f)edge.source, (Tuple2f)edge.target);
        if (d > 0.0) {
            vector2f.scale((float)(1.0 / d));
        }
        vector2f.scale(f);
    }

    public ManageableType getManageableType() {
        return $TYPE;
    }

    static {
        $TYPE.validate();
    }

    public static class Type
    extends ForceBasedLayout.Type {
        private static final int SUPER_FIELD_COUNT = 7;
        protected static final int FIELD_COUNT = 9;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(DavidsonHarelLayout davidsonHarelLayout, SCOType sCOType) {
            super(davidsonHarelLayout, sCOType);
        }

        Type(Class clazz) {
            super(clazz, (SCOType)ForceBasedLayout.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setDouble(Object object, int n, double d) {
            switch (n) {
                case 7: {
                    ((DavidsonHarelLayout)((Object)object)).attractionFactor = d;
                    return;
                }
                case 8: {
                    ((DavidsonHarelLayout)((Object)object)).repulsionFactor = d;
                    return;
                }
            }
            super.setDouble(object, n, d);
        }

        protected double getDouble(Object object, int n) {
            switch (n) {
                case 7: {
                    return ((DavidsonHarelLayout)((Object)object)).attractionFactor;
                }
                case 8: {
                    return ((DavidsonHarelLayout)((Object)object)).repulsionFactor;
                }
            }
            return super.getDouble(object, n);
        }

        public Object newInstance() {
            return new DavidsonHarelLayout();
        }
    }
}

