/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp2d.edit;

import de.grogra.graph.Attribute;
import de.grogra.graph.GraphState;
import de.grogra.graph.impl.Node;
import de.grogra.imp.edit.Tool;
import de.grogra.imp.edit.ToolRoot;
import de.grogra.imp2d.objects.Attributes;
import de.grogra.imp2d.objects.GlobalTransformation;
import de.grogra.imp2d.objects.Transformation;
import de.grogra.util.EventListener;
import de.grogra.vecmath.Math2;
import java.beans.PropertyChangeEvent;
import java.util.EventObject;
import javax.vecmath.Matrix3d;

public abstract class ToolRoot2D
extends ToolRoot
implements Transformation,
EventListener {
    private Matrix3d parentTransformation = new Matrix3d();
    private Matrix3d targetTransformation = new Matrix3d();
    private boolean valid = false;
    public static final Node.NType $TYPE = new Node.NType(ToolRoot2D.class);

    private static void initType() {
        $TYPE.addIdentityAccessor(Attributes.TRANSFORMATION);
    }

    protected boolean initialize(Tool tool) {
        boolean bl = super.initialize(tool);
        if (bl) {
            tool.getView().addEventListener((EventListener)this);
        }
        return bl;
    }

    public void dispose() {
        this.tool.getView().removeEventListener((EventListener)this);
    }

    public void eventOccured(EventObject eventObject) {
        if (eventObject instanceof PropertyChangeEvent && eventObject.getSource() == this.tool.getView() && "projection".equals(((PropertyChangeEvent)eventObject).getPropertyName())) {
            this.invalidate();
        }
    }

    protected void attributeChanged(Attribute[] attributeArray) {
        if (GlobalTransformation.ATTRIBUTE.isContained(attributeArray)) {
            this.invalidate();
        }
    }

    public void preTransform(Object object, boolean bl, Matrix3d matrix3d, Matrix3d matrix3d2, GraphState graphState) {
        Math2.mulAffine((Matrix3d)matrix3d2, (Matrix3d)matrix3d, (Matrix3d)this.getTargetTransformation());
    }

    public void postTransform(Object object, boolean bl, Matrix3d matrix3d, Matrix3d matrix3d2, Matrix3d matrix3d3, GraphState graphState) {
        matrix3d2.set(matrix3d);
    }

    public final Matrix3d getParentTransformation() {
        this.validate();
        return this.parentTransformation;
    }

    public final Matrix3d getTargetTransformation() {
        this.validate();
        return this.targetTransformation;
    }

    private void invalidate() {
        this.valid = false;
    }

    private void validate() {
        if (this.valid) {
            return;
        }
        GlobalTransformation.get(this.getToolTarget(), this.isTargetNode(), this.tool.getGraphState(), true);
        this.parentTransformation.set(GlobalTransformation.getParentValue(this.getToolTarget(), this.isTargetNode(), this.tool.getGraphState(), true));
        this.calculateTargetTransformation(this.targetTransformation, this.parentTransformation);
        this.valid = true;
    }

    protected abstract void calculateTargetTransformation(Matrix3d var1, Matrix3d var2);

    static {
        ToolRoot2D.initType();
        $TYPE.validate();
    }
}

