/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.tracing;

import de.grogra.ray.physics.Collector;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray2.ProgressMonitor;
import de.grogra.xl.util.ObjectList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RadiationModel
implements Cloneable {
    public static final int BUNDLE_SIZE = 1000;
    final Spectrum black;
    final ObjectList<Spectrum> radiantPowerSum;
    final ObjectList<Spectrum> sensedIrradianceSum;
    final int[] idToGroup;

    public RadiationModel(Spectrum spectrum, ObjectList<Spectrum> objectList, ObjectList<Spectrum> objectList2, int[] nArray) {
        this.black = spectrum.newInstance();
        this.black.setZero();
        this.radiantPowerSum = objectList;
        this.sensedIrradianceSum = objectList2;
        this.idToGroup = nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addAndClear(double d, ObjectList<Spectrum> objectList, ObjectList<Spectrum> objectList2) {
        ObjectList<Spectrum> objectList3 = objectList2;
        synchronized (objectList3) {
            for (int i = objectList.size - 1; i >= 0; --i) {
                Spectrum spectrum = (Spectrum)objectList.get(i);
                if (spectrum == null) continue;
                spectrum.scale(d);
                Spectrum spectrum2 = (Spectrum)objectList2.get(i);
                if (spectrum2 == null) {
                    spectrum2 = spectrum.clone();
                    objectList2.set(i, (Object)spectrum2);
                } else {
                    spectrum2.add(spectrum);
                }
                spectrum.setZero();
            }
        }
    }

    public abstract void compute(long var1, long var3, ProgressMonitor var5, int var6, double var7);

    public Spectrum getAbsorbedPower(int n) {
        Spectrum spectrum = (Spectrum)this.radiantPowerSum.get(n);
        if (spectrum == null) {
            spectrum = this.black;
        }
        return spectrum;
    }

    public Spectrum getSensedIrradiance(int n) {
        Spectrum spectrum = (Spectrum)this.sensedIrradianceSum.get(n);
        if (spectrum == null) {
            spectrum = this.black;
        }
        return spectrum;
    }

    public Collector getSensedIrradianceCollector(int n) {
        Spectrum spectrum = (Spectrum)this.sensedIrradianceSum.get(n);
        if (!(spectrum instanceof Collector)) {
            spectrum = this.black;
        }
        return (Collector)spectrum;
    }

    public Collector getAbsorbedPowerCollector(int n) {
        Spectrum spectrum = (Spectrum)this.radiantPowerSum.get(n);
        if (!(spectrum instanceof Collector)) {
            spectrum = this.black;
        }
        return (Collector)spectrum;
    }
}

