/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.tracing;

import de.grogra.ray.physics.Spectrum;
import de.grogra.ray2.Scene;
import de.grogra.ray2.metropolis.DirectLightingCalculator;
import de.grogra.ray2.metropolis.MetropolisPathMutator;
import de.grogra.ray2.metropolis.strategy.LensSubpathStrat;
import de.grogra.ray2.tracing.BiDirectionalProcessor;
import de.grogra.ray2.tracing.MetropolisRenderer;
import de.grogra.ray2.tracing.PixelwiseRenderer;
import de.grogra.ray2.tracing.RayProcessor;
import de.grogra.ray2.tracing.modular.CombinedPathValues;
import de.grogra.ray2.tracing.modular.MemoryHelper;
import de.grogra.vecmath.geom.Line;
import java.util.ArrayList;
import java.util.Random;
import javax.vecmath.Color4f;
import javax.vecmath.Tuple3d;

public class MetropolisProcessor
extends BiDirectionalProcessor {
    public static final String CORRECTION_FACTOR = "MetropolisPathTracer/correctionFactor";
    public static final String MUTATION_PP_COUNT = "MetropolisPathTracer/mutationPPCount";
    public int minimalPathLength;
    public int maximalPathLength;
    public static boolean stopped;
    public int imageWidth;
    public int imageHeight;
    private static float rendererBrightness;
    private static int zeroAcceptanceCount;
    private static int notAcceptanceCount;
    private static int overallCount;
    static int count_LoopAbort;
    private int renderedPixels;
    private int mutatedPixelFinish;
    private int processorID;
    protected int imageUpdateRate = 7000;
    protected long nextImageUpdateTime = 7000L;
    protected long timeDiff = 0L;
    private MetropolisRenderer.MetropolisResult result;
    private MemoryHelper memHelper;
    private MetropolisRenderer renderer;
    DirectLightingCalculator directLightCalc;
    boolean directLightingMode;
    boolean expectedValuesMode;
    private CombinedPathValues seedPath;
    private CombinedPathValues tmpCombPath1;
    private CombinedPathValues tmpCombPath2;
    private MetropolisPathMutator mutator;
    private boolean schalter = false;

    public RayProcessor dup(Scene scene) {
        MetropolisProcessor metropolisProcessor = (MetropolisProcessor)this.clone();
        metropolisProcessor.lightProcessor = this.lightProcessor.dup(scene);
        metropolisProcessor.scene = scene;
        metropolisProcessor.initLocals();
        metropolisProcessor.initialize(this.renderer, scene);
        return metropolisProcessor;
    }

    public void initialize(PixelwiseRenderer pixelwiseRenderer, Scene scene) {
        super.initialize(pixelwiseRenderer, scene);
        this.renderer = (MetropolisRenderer)pixelwiseRenderer;
        MetropolisRenderer cfr_ignored_0 = (MetropolisRenderer)pixelwiseRenderer;
        this.directLightingMode = MetropolisRenderer.directLightning_Ref;
        MetropolisRenderer cfr_ignored_1 = (MetropolisRenderer)pixelwiseRenderer;
        this.expectedValuesMode = MetropolisRenderer.expectedValues_Ref;
        this.isMetropolis = true;
        this.mutator = new MetropolisPathMutator(this);
        this.tmpCombPath1 = new CombinedPathValues();
        this.tmpCombPath1.initialize(this.eyePathDepth + this.lightPathDepth);
        this.tmpCombPath2 = new CombinedPathValues();
        this.tmpCombPath2.initialize(this.eyePathDepth + this.lightPathDepth);
        this.seedPath = new CombinedPathValues();
        this.seedPath.initialize(this.eyePathDepth + this.lightPathDepth);
        this.memHelper = new MemoryHelper(3 * (this.eyePathDepth + this.lightPathDepth), scene);
        this.tracingMediator.setMemHelper(this.memHelper);
        this.directLightCalc = new DirectLightingCalculator();
        this.directLightCalc.setLightProccessor(this.getLightProcessor());
        this.imageWidth = 0;
        this.imageHeight = 0;
        this.renderedPixels = 0;
        this.mutatedPixelFinish = 0;
        rendererBrightness = 0.0f;
        zeroAcceptanceCount = 0;
        notAcceptanceCount = 0;
        overallCount = 0;
        count_LoopAbort = 0;
        stopped = false;
        this.minimalPathLength = this.eyePathDepth + this.lightPathDepth;
        this.maximalPathLength = 0;
    }

    public synchronized void setMinMaxPathLength(int n) {
        this.maximalPathLength = Math.max(n, this.maximalPathLength);
        this.minimalPathLength = Math.min(n, this.minimalPathLength);
    }

    public void getColorFromRay(Line line, Spectrum spectrum, Color4f color4f, Random random) {
        this.renderedPixels = 0;
        this.lineTracer.setSafeMemoryMode(null);
        super.getColorFromRay(line, spectrum, color4f, random);
        this.lineTracer.setSafeMemoryMode(this.memHelper);
        if (this.bestS < 0) {
            return;
        }
        CombinedPathValues combinedPathValues = this.getNextPath2Mutate();
        this.complementTracer.complement2Paths(this.lightPathValues[this.bestLight], this.bestS, this.eyePathValues, this.bestT, false, combinedPathValues);
        if (!combinedPathValues.isValid()) {
            return;
        }
        CombinedPathValues combinedPathValues2 = this.getNextPath2Mutate();
        CombinedPathValues combinedPathValues3 = combinedPathValues;
        int n = 0;
        float f = 0.0f;
        do {
            f = this.mutator.mutatePath(combinedPathValues3, combinedPathValues2);
            if (combinedPathValues2.pathLength > 2 && this.directLightingMode && this.mutator.getLastStrategy() instanceof LensSubpathStrat) {
                Tuple3d tuple3d = this.directLightCalc.calculateDirectLight(combinedPathValues2, combinedPathValues2.pathLength - 2, random);
                this.recordColor(combinedPathValues2, tuple3d);
            }
            if (this.expectedValuesMode) {
                this.recordSample(combinedPathValues2, f > 0.0f ? f : 0.0f, combinedPathValues3);
            }
            this.memHelper.freeUnusedPathElements(combinedPathValues3, combinedPathValues2);
            if (this.isAccepted(f)) {
                this.setMinMaxPathLength(combinedPathValues2.pathLength);
                combinedPathValues3 = combinedPathValues2;
                combinedPathValues2 = this.getNextPath2Mutate();
            }
            if (!this.expectedValuesMode) {
                this.recordSample(combinedPathValues3);
            }
            ++n;
        } while (this.renderedPixels < this.mutatedPixelFinish && !stopped);
        this.mergeWithRenderer();
    }

    private boolean isAccepted(float f) {
        ++overallCount;
        if (f <= 0.0f) {
            ++notAcceptanceCount;
            ++zeroAcceptanceCount;
            return false;
        }
        float f2 = this.rand.nextFloat();
        if (f2 < f) {
            return true;
        }
        ++notAcceptanceCount;
        return false;
    }

    private void recordColor(CombinedPathValues combinedPathValues, Tuple3d tuple3d) {
        ++this.renderedPixels;
        float f = 1.0f;
        Line line = combinedPathValues.rayListEB.get(combinedPathValues.pathLength - 2);
        this.result.data.add(this.result.lastIndex * 4, (float)tuple3d.x / f);
        this.result.data.add(this.result.lastIndex * 4 + 1, (float)tuple3d.y / f);
        this.result.data.add(this.result.lastIndex * 4 + 2, (float)tuple3d.z / f);
        this.result.data.add(this.result.lastIndex * 4 + 3, 1.0f);
        this.result.lines.add(this.result.lastIndex, (int)line.y);
        this.result.cols.add(this.result.lastIndex, (int)line.x);
        ++this.result.lastIndex;
    }

    private void recordSample(CombinedPathValues combinedPathValues) {
        ++this.renderedPixels;
        this.tracingMediator.getMetropolisAntialiser().registerUsedLensEdge(combinedPathValues.rayListEB.get((int)(combinedPathValues.pathLength - 2)).x, combinedPathValues.rayListEB.get((int)(combinedPathValues.pathLength - 2)).y);
        Line line = combinedPathValues.rayListEB.get(combinedPathValues.pathLength - 2);
        float f = this.getI_0(combinedPathValues);
        this.result.data.add(this.result.lastIndex * 4, combinedPathValues.color.x * f);
        this.result.data.add(this.result.lastIndex * 4 + 1, combinedPathValues.color.y * f);
        this.result.data.add(this.result.lastIndex * 4 + 2, combinedPathValues.color.z * f);
        this.result.data.add(this.result.lastIndex * 4 + 3, combinedPathValues.color.w);
        this.result.lines.add(this.result.lastIndex, (int)line.y);
        this.result.cols.add(this.result.lastIndex, (int)line.x);
        if ((float)this.result.lastIndex >= 0.3f * (float)(this.imageHeight * this.imageWidth) || System.currentTimeMillis() >= this.nextImageUpdateTime) {
            this.renderer.merge(this.result);
            this.result.lines.setSize(0);
            this.result.data.setSize(0);
            this.result.cols.setSize(0);
            this.result.lastIndex = 0;
            this.timeDiff = this.nextImageUpdateTime;
            this.nextImageUpdateTime = System.currentTimeMillis() + (long)this.imageUpdateRate;
            this.timeDiff = this.nextImageUpdateTime - this.timeDiff;
        } else {
            ++this.result.lastIndex;
        }
    }

    private void recordSample(CombinedPathValues combinedPathValues, float f, CombinedPathValues combinedPathValues2) {
        Line line = null;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = f2;
        if (f > 0.0f && combinedPathValues.pathLength > 1) {
            this.tracingMediator.getMetropolisAntialiser().registerUsedLensEdge(combinedPathValues.rayListEB.get((int)(combinedPathValues.pathLength - 2)).x, combinedPathValues.rayListEB.get((int)(combinedPathValues.pathLength - 2)).y);
            line = combinedPathValues.rayListEB.get(combinedPathValues.pathLength - 2);
            f4 = f2 = this.getI_0(combinedPathValues);
            this.result.data.add(this.result.lastIndex * 4, combinedPathValues.color.x * f * f4);
            this.result.data.add(this.result.lastIndex * 4 + 1, combinedPathValues.color.y * f * f4);
            this.result.data.add(this.result.lastIndex * 4 + 2, combinedPathValues.color.z * f * f4);
            this.result.data.add(this.result.lastIndex * 4 + 3, combinedPathValues.color.w);
            this.result.lines.add(this.result.lastIndex, (int)line.y);
            this.result.cols.add(this.result.lastIndex, (int)line.x);
            if (this.result.data.get(this.result.lastIndex * 4) < 0.0f || this.result.data.get(this.result.lastIndex * 4 + 1) < 0.0f || this.result.data.get(this.result.lastIndex * 4 + 2) < 0.0f || this.result.data.get(this.result.lastIndex * 4 + 3) < 0.0f) {
                System.err.println(" MetroProc: recordSampl:     Negative Value!!!!  newColor=" + combinedPathValues.color + "   acceptance=" + f + "   I_0=" + f4);
                System.err.println("     lastStrat=" + this.mutator.getLastStrategy());
                System.exit(0);
            }
            ++this.renderedPixels;
            ++this.result.lastIndex;
        }
        if (f < 1.0f) {
            this.tracingMediator.getMetropolisAntialiser().registerUsedLensEdge(combinedPathValues2.rayListEB.get((int)(combinedPathValues2.pathLength - 2)).x, combinedPathValues2.rayListEB.get((int)(combinedPathValues2.pathLength - 2)).y);
            line = combinedPathValues2.rayListEB.get(combinedPathValues2.pathLength - 2);
            f4 = f3 = this.getI_0(combinedPathValues2);
            this.result.data.add(this.result.lastIndex * 4, combinedPathValues2.color.x * (1.0f - f) * f4);
            this.result.data.add(this.result.lastIndex * 4 + 1, combinedPathValues2.color.y * (1.0f - f) * f4);
            this.result.data.add(this.result.lastIndex * 4 + 2, combinedPathValues2.color.z * (1.0f - f) * f4);
            this.result.data.add(this.result.lastIndex * 4 + 3, combinedPathValues2.color.w);
            this.result.lines.add(this.result.lastIndex, (int)line.y);
            this.result.cols.add(this.result.lastIndex, (int)line.x);
            if (this.result.data.get(this.result.lastIndex * 4) < 0.0f || this.result.data.get(this.result.lastIndex * 4 + 1) < 0.0f || this.result.data.get(this.result.lastIndex * 4 + 2) < 0.0f || this.result.data.get(this.result.lastIndex * 4 + 3) < 0.0f) {
                System.err.println(" MetroProc: recordSampl:     Negative Value!!!!  oldColor=" + combinedPathValues2.color + "   acceptance=" + f + "   I_0=" + f4);
                System.err.println("     lastStrat=" + this.mutator.getLastStrategy());
                System.exit(0);
            }
            ++this.renderedPixels;
            ++this.result.lastIndex;
        }
        if ((float)this.result.lastIndex >= 0.4f * (float)(this.imageHeight * this.imageWidth) || System.currentTimeMillis() >= this.nextImageUpdateTime) {
            this.mergeWithRenderer();
            this.timeDiff = this.nextImageUpdateTime;
            this.nextImageUpdateTime = System.currentTimeMillis() + (long)this.imageUpdateRate;
            this.timeDiff = this.nextImageUpdateTime - this.timeDiff;
        }
    }

    public void mergeWithRenderer() {
        --this.result.lastIndex;
        this.renderer.merge(this.result);
        this.result.lines.setSize(0);
        this.result.data.setSize(0);
        this.result.cols.setSize(0);
        this.result.lastIndex = 0;
    }

    float getI_0(CombinedPathValues combinedPathValues) {
        MetropolisRenderer metropolisRenderer = (MetropolisRenderer)this.tracingMediator.getRenderer();
        if (MetropolisRenderer.twoStage_Ref) {
            if (MetropolisRenderer.actRenderingStage == 1) {
                int n = (int)combinedPathValues.rayListEB.get((int)(combinedPathValues.pathLength - 2)).x;
                int n2 = (int)combinedPathValues.rayListEB.get((int)(combinedPathValues.pathLength - 2)).y;
                float f = metropolisRenderer.getFirstStageImageValue(n, n2);
                if (f == 0.0f) {
                    System.err.println("  MetroProc: getI0:     return=" + f);
                }
                return f;
            }
        }
        return 1.0f;
    }

    CombinedPathValues getNextPath2Mutate() {
        boolean bl = this.schalter = !this.schalter;
        if (this.schalter) {
            return this.tmpCombPath1;
        }
        return this.tmpCombPath2;
    }

    public void resetAll() {
        this.minimalPathLength = this.eyePathDepth + this.lightPathDepth;
        this.maximalPathLength = 0;
        overallCount = 0;
        notAcceptanceCount = 0;
        zeroAcceptanceCount = 0;
        count_LoopAbort = 0;
        stopped = false;
        this.mutator.resetAll();
    }

    public void initializeLoop(float f, int n, int n2, int n3, MetropolisRenderer.MetropolisResult metropolisResult, int n4) {
        rendererBrightness = f;
        this.imageHeight = n2;
        this.imageWidth = n;
        this.mutatedPixelFinish = n3;
        this.processorID = n4;
        this.result = metropolisResult;
    }

    public PixelwiseRenderer.Result getResult() {
        return this.result;
    }

    public int getMutatedPixels() {
        return this.renderedPixels;
    }

    protected void appendStatisticsImpl(StringBuffer stringBuffer) {
        stringBuffer.append("Metropolis Light Transport Statistics: \n");
        stringBuffer.append("    Max. length of accepted paths=" + this.maximalPathLength + "\n");
        stringBuffer.append("    Min. length of accepted paths=" + this.minimalPathLength + "\n");
        stringBuffer.append("    mutation Loop=" + this.mutatedPixelFinish + "\n \n");
        stringBuffer.append("    total count of mutation  : " + overallCount + "\n");
        stringBuffer.append("    count of accepted mutation  : " + (overallCount - notAcceptanceCount) + "\n");
        stringBuffer.append("    count of rejected mutations: " + notAcceptanceCount + " (" + (float)notAcceptanceCount / (float)overallCount + ")" + "\n");
        stringBuffer.append("    count of rejected mutations with mutation errors: " + zeroAcceptanceCount + " (" + (float)zeroAcceptanceCount / (float)notAcceptanceCount + ")" + "\n \n");
        stringBuffer.append("    count of forced mutation loop abborts: " + count_LoopAbort + "\n \n");
        stringBuffer.append("    Strategy Statictics: \n");
        ArrayList<String> arrayList = this.mutator.getStatistics();
        for (String string : arrayList) {
            stringBuffer.append("     " + string);
        }
    }

    public void pathChanged() {
        this.mutator.pathChanged();
    }

    static {
        zeroAcceptanceCount = 0;
        notAcceptanceCount = 0;
        overallCount = 0;
    }
}

