/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.tracing;

import de.grogra.ray.physics.Environment;
import de.grogra.ray.physics.Sensor;
import de.grogra.ray2.Resources;
import de.grogra.ray2.Scene;
import de.grogra.ray2.antialiasing.Antialiasing;
import de.grogra.ray2.antialiasing.NoAntialiasing;
import de.grogra.ray2.tracing.BiDirectionalProcessor;
import de.grogra.ray2.tracing.PixelwiseRenderer;
import de.grogra.ray2.tracing.modular.CausticMap;
import de.grogra.xl.util.IntList;
import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import javax.vecmath.Color4f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple4f;

public class BidirectionalRenderer
extends PixelwiseRenderer {
    CausticMap globalCausticMap;

    public void render(Scene scene, Sensor sensor, Matrix4d matrix4d, int n, int n2, ImageObserver imageObserver) {
        Object object;
        long l = System.currentTimeMillis();
        this.originalScene = scene;
        this.camera = sensor;
        this.cameraTransformation = matrix4d;
        this.antialiasing.initialize(this, scene);
        this.width = n;
        this.height = n2;
        changedPixels = 0;
        this.maxColor = new Color4f();
        this.minColor = new Color4f(10.0f, 10.0f, 10.0f, 10.0f);
        this.globalCausticMap = new CausticMap(n, n2);
        this.lineState = new int[n2];
        if (this.hdr) {
            this.hdrPixels = new float[4][n * n2];
            DataBufferFloat dataBufferFloat = new DataBufferFloat(this.hdrPixels, this.hdrPixels[0].length);
            BandedSampleModel bandedSampleModel = new BandedSampleModel(dataBufferFloat.getDataType(), n, n2, 4);
            object = Raster.createWritableRaster(bandedSampleModel, dataBufferFloat, null);
            ColorSpace colorSpace = ColorSpace.getInstance(1000);
            ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, true, false, 3, dataBufferFloat.getDataType());
            this.image = new BufferedImage(componentColorModel, (WritableRaster)object, false, null);
        } else {
            this.image = new BufferedImage(n, n2, 2);
            this.rgbaPixels = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
        }
        this.observer = imageObserver;
        if (this.threadCount < 2) {
            this.addSolver(this.createLocalSolver(true));
        } else {
            for (int i = Math.min(32, this.threadCount); i > 0; --i) {
                this.addSolver(this.createLocalSolver(false));
            }
        }
        if (this.monitor != null) {
            this.monitor.setProgress(Resources.msg("renderer.rendering", new Float(0.0f)), 0.0f);
        }
        this.solve();
        this.removeSolvers();
        if (this.isStopped()) {
            this.observer.imageUpdate(this.image, 192, 0, 0, n, n2);
            if (this.monitor != null) {
                this.monitor.setProgress(Resources.msg("renderer.stopped"), 2.0f);
            }
        } else {
            this.mergeCaustic2Image();
            if (this.hdr) {
                if (this.removeOutliers) {
                    this.removeOutliers();
                }
                if (this.autoAdjust && this.maxValue > 0.0f) {
                    float f = this.autoAdjustMaxValue / this.maxValue;
                    for (int i = 0; i < 3; ++i) {
                        object = this.hdrPixels[i];
                        int n3 = ((Object)object).length - 1;
                        while (n3 >= 0) {
                            Object object2 = object;
                            int n4 = n3--;
                            object2[n4] = object2[n4] * f;
                        }
                    }
                }
            }
            long l2 = System.currentTimeMillis() - l;
            this.observer.imageUpdate(this.image, 32, 0, 0, n, n2);
            if (this.monitor != null) {
                this.monitor.setProgress(Resources.msg("renderer.done"), 2.0f);
                object = new StringBuffer("<html><pre>");
                ((StringBuffer)object).append(Resources.msg("raytracer.statistics", n, n2, this.threadCount, (int)(l2 / 60000L), Float.valueOf((float)(l2 % 60000L) * 0.001f)));
                ((StringBuffer)object).append("    Count of changed Pixels: " + changedPixels + "\n");
                ((StringBuffer)object).append("    maxColor " + this.maxColor + "\n");
                ((StringBuffer)object).append("    minColor " + this.minColor + "\n");
                this.originalScene.appendStatistics((StringBuffer)object);
                this.antialiasing.appendStatistics((StringBuffer)object);
                this.monitor.showMessage(((StringBuffer)object).append("</pre></html>").toString());
            }
        }
    }

    protected void renderLines(Antialiasing antialiasing, IntList intList, PixelwiseRenderer.Result result) {
        CausticMap causticMap;
        ((BiDirectionalProcessor)((NoAntialiasing)antialiasing).processor).loacalCausticMap = causticMap = new CausticMap(this.width, this.height);
        super.renderLines(antialiasing, intList, result);
        this.mergeCausticMap(causticMap);
    }

    public synchronized void mergeCausticMap(CausticMap causticMap) {
        for (int i = 0; i < causticMap.causticMap.length; ++i) {
            for (int j = 0; j < causticMap.causticMap[i].length; ++j) {
                this.globalCausticMap.causticMap[i][j].causticCounter += causticMap.causticMap[i][j].causticCounter;
                this.globalCausticMap.causticMap[i][j].nonCausticCounter += causticMap.causticMap[i][j].nonCausticCounter;
                if (causticMap.causticMap[i][j].color == null) continue;
                if (this.globalCausticMap.causticMap[i][j].color == null) {
                    this.globalCausticMap.causticMap[i][j].color = new Color4f(causticMap.causticMap[i][j].color);
                    continue;
                }
                this.globalCausticMap.causticMap[i][j].color.add((Tuple4f)causticMap.causticMap[i][j].color);
            }
        }
    }

    public void mergeCaustic2Image() {
        int n = 0;
        for (int i = 0; i < this.globalCausticMap.causticMap.length; ++i) {
            for (int j = 0; j < this.globalCausticMap.causticMap[i].length; ++j) {
                CausticMap.CausticElement causticElement = this.globalCausticMap.causticMap[i][j];
                if (causticElement.color != null) {
                    float f;
                    float f2;
                    causticElement.color.scale(1.0f / (float)causticElement.causticCounter);
                    float f3 = causticElement.color.w;
                    if (this.hdr) {
                        float f4 = this.brightness / Math.max(this.hdrPixels[3][n], 0.001f);
                        float[] fArray = this.hdrPixels[0];
                        int n2 = n;
                        fArray[n2] = fArray[n2] * (1.0f / f4);
                        float[] fArray2 = this.hdrPixels[1];
                        int n3 = n;
                        fArray2[n3] = fArray2[n3] * (1.0f / f4);
                        float[] fArray3 = this.hdrPixels[2];
                        int n4 = n;
                        fArray3[n4] = fArray3[n4] * (1.0f / f4);
                        f2 = this.brightness / Math.max(this.hdrPixels[3][n], 0.001f);
                        float[] fArray4 = this.hdrPixels[0];
                        int n5 = n;
                        fArray4[n5] = fArray4[n5] + causticElement.color.x;
                        float[] fArray5 = this.hdrPixels[1];
                        int n6 = n;
                        fArray5[n6] = fArray5[n6] + causticElement.color.y;
                        float[] fArray6 = this.hdrPixels[2];
                        int n7 = n;
                        fArray6[n7] = fArray6[n7] + causticElement.color.z;
                        float[] fArray7 = this.hdrPixels[0];
                        int n8 = n;
                        fArray7[n8] = fArray7[n8] * f2;
                        float[] fArray8 = this.hdrPixels[1];
                        int n9 = n;
                        fArray8[n9] = fArray8[n9] * f2;
                        float[] fArray9 = this.hdrPixels[2];
                        int n10 = n;
                        fArray9[n10] = fArray9[n10] * f2;
                        if (this.autoAdjust) {
                            f = this.hdrPixels[3][n];
                            if (f * this.hdrPixels[0][n] > this.maxValue) {
                                this.maxValue = f * this.hdrPixels[0][n];
                            }
                            if (f * this.hdrPixels[1][n] > this.maxValue) {
                                this.maxValue = f * this.hdrPixels[1][n];
                            }
                            if (f * this.hdrPixels[2][n] > this.maxValue) {
                                this.maxValue = f * this.hdrPixels[2][n];
                            }
                        }
                        if (this.luminance(this.hdrPixels[0][n], this.hdrPixels[1][n], this.hdrPixels[2][n]) > this.luminance(this.maxColor.x, this.maxColor.y, this.maxColor.z)) {
                            this.maxColor.x = this.hdrPixels[0][n];
                            this.maxColor.y = this.hdrPixels[1][n];
                            this.maxColor.z = this.hdrPixels[2][n];
                            this.maxColor.w = this.hdrPixels[3][n];
                        }
                        if (this.luminance(this.hdrPixels[0][n], this.hdrPixels[1][n], this.hdrPixels[2][n]) < this.luminance(this.minColor.x, this.minColor.y, this.minColor.z)) {
                            this.minColor.x = this.hdrPixels[0][n];
                            this.minColor.y = this.hdrPixels[1][n];
                            this.minColor.z = this.hdrPixels[2][n];
                            this.minColor.w = this.hdrPixels[3][n];
                        }
                    } else {
                        float[] fArray = BidirectionalRenderer.toRGBA(this.rgbaPixels[n]);
                        f2 = (fArray[0] * (float)causticElement.nonCausticCounter + causticElement.color.x) / (float)(causticElement.causticCounter + causticElement.nonCausticCounter);
                        f = (fArray[1] * (float)causticElement.nonCausticCounter + causticElement.color.y) / (float)(causticElement.causticCounter + causticElement.nonCausticCounter);
                        float f5 = (fArray[2] * (float)causticElement.nonCausticCounter + causticElement.color.z) / (float)(causticElement.causticCounter + causticElement.nonCausticCounter);
                        float f6 = (fArray[3] * (float)causticElement.nonCausticCounter + causticElement.color.w) / (float)(causticElement.causticCounter + causticElement.nonCausticCounter);
                        this.rgbaPixels[n] = BidirectionalRenderer.toIntColor(f2, f, f5, f6);
                    }
                }
                ++n;
            }
        }
    }

    public float[] getPixelsForLine2Vertex(Environment environment, Point3d point3d) {
        float[] fArray = new float[]{-1.0f, -1.0f};
        double d = 2.0 / (double)this.width;
        double d2 = 2.0 / (double)this.height;
        float[] fArray2 = this.getCamera().getUVForVertex(environment, point3d);
        if (fArray2[0] == -10.0f || fArray2[1] == -10.0f) {
            return fArray;
        }
        fArray[0] = Math.min((float)((double)(fArray2[0] + 1.0f) / d), (float)(this.width - 1));
        fArray[1] = (float)((double)(-fArray2[1]) / d + 0.5 * (double)this.height - 1.0);
        if (fArray[0] < 0.0f || fArray[0] >= (float)this.width) {
            return new float[]{-1.0f, -1.0f};
        }
        if (fArray[1] < 0.0f || fArray[1] >= (float)this.height) {
            return new float[]{-1.0f, -1.0f};
        }
        return fArray;
    }
}

