/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.radiosity;

import de.grogra.ray2.radiosity.FormFactor;
import de.grogra.ray2.radiosity.MyMeshVolume;
import de.grogra.ray2.radiosity.SubPatch;
import de.grogra.ray2.radiosity.Vector3d;
import de.grogra.ray2.radiosity.ViewCube;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatchGroup {
    private SubPatch[] fourPatches = new SubPatch[4];
    private Color3f reflectance;
    private Color3f[] fourEmittances = new Color3f[4];
    private int parentID = 0;
    private boolean visible = true;
    private static int mashid = 1;

    public PatchGroup(Vector3d[] vector3dArray, int n, Color3f color3f, Color3f color3f2, Color3f color3f3, boolean bl) {
        this.visible = bl;
        this.init(vector3dArray, n, color3f2, color3f, color3f3);
    }

    public PatchGroup(SubPatch subPatch, int n, Color3f color3f, Color3f color3f2, Color3f color3f3) {
        this.init(subPatch.getVertices(), n, color3f, color3f2, color3f3);
    }

    private void init(Vector3d[] vector3dArray, int n, Color3f color3f, Color3f color3f2, Color3f color3f3) {
        Vector3d vector3d;
        this.parentID = n;
        if (vector3dArray.length == 3) {
            vector3d = new Vector3d();
            vector3d.add((Tuple3d)vector3dArray[0], (Tuple3d)vector3dArray[1]);
            vector3d.scale(0.5);
            Vector3d vector3d2 = new Vector3d();
            vector3d2.add((Tuple3d)vector3dArray[1], (Tuple3d)vector3dArray[2]);
            vector3d2.scale(0.5);
            Vector3d vector3d3 = new Vector3d();
            vector3d3.add((Tuple3d)vector3dArray[2], (Tuple3d)vector3dArray[0]);
            vector3d3.scale(0.5);
            this.fourPatches[0] = new SubPatch((Vector3d)((Object)vector3dArray[0].clone()), (Vector3d)((Object)vector3d.clone()), (Vector3d)((Object)vector3d3.clone()));
            this.fourPatches[1] = new SubPatch((Vector3d)((Object)vector3dArray[1].clone()), (Vector3d)((Object)vector3d2.clone()), (Vector3d)((Object)vector3d.clone()));
            this.fourPatches[2] = new SubPatch((Vector3d)((Object)vector3dArray[2].clone()), (Vector3d)((Object)vector3d3.clone()), (Vector3d)((Object)vector3d2.clone()));
            this.fourPatches[3] = new SubPatch((Vector3d)((Object)vector3d.clone()), (Vector3d)((Object)vector3d2.clone()), (Vector3d)((Object)vector3d3.clone()));
        } else {
            vector3d = new Vector3d();
            vector3d.add((Tuple3d)vector3dArray[0], (Tuple3d)vector3dArray[2]);
            vector3d.scale(0.5);
            this.fourPatches[0] = new SubPatch((Vector3d)((Object)vector3dArray[0].clone()), (Vector3d)((Object)vector3dArray[1].clone()), (Vector3d)((Object)vector3d.clone()));
            this.fourPatches[1] = new SubPatch((Vector3d)((Object)vector3dArray[1].clone()), (Vector3d)((Object)vector3dArray[2].clone()), (Vector3d)((Object)vector3d.clone()));
            this.fourPatches[2] = new SubPatch((Vector3d)((Object)vector3dArray[2].clone()), (Vector3d)((Object)vector3dArray[3].clone()), (Vector3d)((Object)vector3d.clone()));
            this.fourPatches[3] = new SubPatch((Vector3d)((Object)vector3dArray[3].clone()), (Vector3d)((Object)vector3dArray[0].clone()), (Vector3d)((Object)vector3d.clone()));
        }
        for (int i = 0; i < 4; ++i) {
            this.fourEmittances[i] = color3f2;
            this.fourPatches[i].setRadiosity(color3f3);
        }
        this.reflectance = color3f;
    }

    public void project(Vector<PatchGroup> vector) {
        int n = vector.size();
        for (int i = 0; i < 4; ++i) {
            ViewCube viewCube = new ViewCube(this.fourPatches[i].getCenter(), this.fourPatches[i].getNormal());
            for (int j = 0; j < n; ++j) {
                PatchGroup patchGroup = vector.get(j);
                if (patchGroup.getParentPatchID() == this.parentID) continue;
                for (int k = 0; k < 4; ++k) {
                    SubPatch subPatch = patchGroup.getPatch(k);
                    viewCube.projPatchOnCube(subPatch);
                }
            }
            viewCube.computeFormFactorMap(this.fourPatches[i].getFFMap());
        }
    }

    public boolean needSubDevide(float f) {
        if (!this.visible) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < i; ++j) {
                float f2 = this.fourPatches[i].getMaxRadDifference(this.fourPatches[j]);
                if (!(f2 > f)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean subdivide(Vector<PatchGroup> vector, List<SubPatch> list, Vector<PatchGroup> vector2, float f) {
        if (this.needSubDevide(f)) {
            for (int i = 0; i < 4; ++i) {
                PatchGroup patchGroup = new PatchGroup(this.fourPatches[i], this.parentID, this.reflectance, this.fourEmittances[i], this.fourPatches[i].getRadiosity());
                vector.add(patchGroup);
                list.add(this.fourPatches[i]);
                vector2.add(patchGroup);
            }
            vector.remove(this);
            return true;
        }
        return false;
    }

    public void clearRadiosity() {
        for (int i = 0; i < 4; ++i) {
            this.fourPatches[i].setRadiosity(0.0f, 0.0f, 0.0f);
            this.fourPatches[i].clearFFMap();
        }
    }

    public SubPatch getPatch(int n) {
        return this.fourPatches[n];
    }

    public int getParentPatchID() {
        return this.parentID;
    }

    public Color3f getRadiosity(int n) {
        return this.fourPatches[n].getRadiosity();
    }

    public Map<SubPatch, FormFactor> getFormFactors(int n) {
        return this.fourPatches[n].getFFMap();
    }

    public Color3f getEmittance(int n) {
        return this.fourEmittances[n];
    }

    public Color3f getReflectance() {
        return this.reflectance;
    }

    public MyMeshVolume[] createMesh() {
        for (int i = 0; i < 4; ++i) {
            this.fourPatches[i].clearFFMap();
        }
        if (!this.visible) {
            return null;
        }
        MyMeshVolume[] myMeshVolumeArray = new MyMeshVolume[4];
        for (int i = 0; i < 4; ++i) {
            myMeshVolumeArray[i] = this.fourPatches[i].createMesh();
            myMeshVolumeArray[i].setMeshColor(this.fourPatches[i].getRadiosity());
            myMeshVolumeArray[i].setId(mashid++);
        }
        return myMeshVolumeArray;
    }

    public boolean ffMapContains(List<SubPatch> list) {
        for (int i = 0; i < 4; ++i) {
            if (!this.fourPatches[i].ffMapContains(list)) continue;
            return true;
        }
        return false;
    }
}

