/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.radiosity;

import de.grogra.ray2.Scene;
import de.grogra.ray2.tracing.PixelwiseRenderer;

public class OptionReader {
    private static final String CUBEWIDTH = "radiosity/hemisize";
    private static final String HEMICUBEWIDE = "radiosity/hemicubeworldwide";
    private static final String SUBDIVTHRESHOLD = "radiosity/subdivthreshold";
    private static final String MAXSUBDIVDEPTH = "radiosity/maxsubdivdepth";
    private static int oldCubeWidth = -1;
    private static float oldHemiWorldWide = -1.0f;
    private static float oldSubdivthreshold = -1.0f;
    private static int oldMaxsubdivdepth = -1;
    private static String oldUniqueName = null;
    private static int oldStamp = -1;
    private int cubeWidth;
    private float hemiWorldWide;
    private float subdivthreshold;
    private int maxsubdivdepth;
    private int threadcount;

    public OptionReader(PixelwiseRenderer pixelwiseRenderer) {
        this.cubeWidth = pixelwiseRenderer.getNumericOption(CUBEWIDTH, 100).intValue();
        assert (this.cubeWidth > 0);
        this.hemiWorldWide = pixelwiseRenderer.getNumericOption(HEMICUBEWIDE, Float.valueOf(1.0f)).floatValue();
        assert (this.hemiWorldWide > 0.0f);
        this.subdivthreshold = pixelwiseRenderer.getNumericOption(SUBDIVTHRESHOLD, Float.valueOf(5.0f)).floatValue();
        assert (this.subdivthreshold > 0.0f);
        this.maxsubdivdepth = pixelwiseRenderer.getNumericOption(MAXSUBDIVDEPTH, 7).intValue();
        assert (this.maxsubdivdepth > 0);
        this.threadcount = pixelwiseRenderer.getNumericOption("threadcount", 0).intValue();
        if (this.threadcount == 0) {
            this.threadcount = Runtime.getRuntime().availableProcessors();
        }
    }

    public boolean isHemicubeCalcNeeded() {
        return this.cubeWidth != oldCubeWidth;
    }

    public boolean isRadiosityCalcNeeded(Scene scene) {
        return scene.getStamp() != oldStamp || scene.getUniqueName() != oldUniqueName || this.subdivthreshold != oldSubdivthreshold || this.maxsubdivdepth != oldMaxsubdivdepth || this.hemiWorldWide != oldHemiWorldWide || this.isHemicubeCalcNeeded();
    }

    public void calcFinished(Scene scene) {
        oldCubeWidth = this.cubeWidth;
        oldSubdivthreshold = this.subdivthreshold;
        oldMaxsubdivdepth = this.maxsubdivdepth;
        oldHemiWorldWide = this.hemiWorldWide;
        oldUniqueName = scene.getUniqueName();
        oldStamp = scene.getStamp();
    }

    public int getCubeWidth() {
        return this.cubeWidth;
    }

    public float getHemiWorldWide() {
        return this.hemiWorldWide;
    }

    public int getMaxsubdivdepth() {
        return this.maxsubdivdepth;
    }

    public float getSubdivthreshold() {
        return this.subdivthreshold;
    }

    public int getThreadCount() {
        return this.threadcount;
    }
}

