/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.metropolis;

import de.grogra.ray2.metropolis.MetropolisStrategy;
import de.grogra.ray2.metropolis.strategy.BidirectionalMutationStrat;
import de.grogra.ray2.metropolis.strategy.CausticPerturbation;
import de.grogra.ray2.metropolis.strategy.LensPerturbationStrat;
import de.grogra.ray2.metropolis.strategy.LensSubpathStrat;
import de.grogra.ray2.tracing.MetropolisProcessor;
import de.grogra.ray2.tracing.modular.CombinedPathValues;
import java.util.ArrayList;
import net.goui.util.MTRandom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetropolisPathMutator {
    public static final String STRAT1 = "MetropolisPathTracer/Strategies/BidirectionalStrat";
    public static final String STRAT2 = "MetropolisPathTracer/Strategies/LensSubpathStrat";
    public static final String STRAT3 = "MetropolisPathTracer/Strategies/LensPerturbStrat";
    public static final String STRAT4 = "MetropolisPathTracer/Strategies/CausticPerturbStrat";
    MTRandom rnd;
    static int strat1Count;
    static int strat2Count;
    static int strat3Count;
    static int strat4Count;
    int lastStrategyNumber;
    ArrayList<MetropolisStrategy> stratList;
    ArrayList<String> mutatorStatistic = new ArrayList();

    public MetropolisPathMutator(MetropolisProcessor metropolisProcessor) {
        this.stratList = new ArrayList();
        if (metropolisProcessor.tracingMediator.getRenderer().getBooleanOption(STRAT1, true)) {
            this.stratList.add(new BidirectionalMutationStrat(metropolisProcessor));
        }
        if (metropolisProcessor.tracingMediator.getRenderer().getBooleanOption(STRAT2, true)) {
            this.stratList.add(new LensSubpathStrat(metropolisProcessor));
        }
        if (metropolisProcessor.tracingMediator.getRenderer().getBooleanOption(STRAT3, true)) {
            this.stratList.add(new LensPerturbationStrat(metropolisProcessor));
        }
        if (metropolisProcessor.tracingMediator.getRenderer().getBooleanOption(STRAT4, true)) {
            this.stratList.add(new CausticPerturbation(metropolisProcessor));
        }
        this.rnd = new MTRandom(metropolisProcessor.tracingMediator.getRenderer().getSeed());
    }

    public void resetAll() {
        strat1Count = 0;
        strat2Count = 0;
        strat3Count = 0;
        strat4Count = 0;
        for (MetropolisStrategy metropolisStrategy : this.stratList) {
            metropolisStrategy.resetAll();
        }
    }

    public float mutatePath(CombinedPathValues combinedPathValues, CombinedPathValues combinedPathValues2) {
        MetropolisStrategy metropolisStrategy = this.determineStrategy();
        if (metropolisStrategy == null) {
            return -1.0f;
        }
        return metropolisStrategy.mutatePath(combinedPathValues, combinedPathValues2);
    }

    private MetropolisStrategy determineStrategy() {
        int n;
        if (this.stratList.size() < 1) {
            System.err.println("MetroPathMutat: determinStrat:   NO Strategy to choose!");
            return null;
        }
        this.lastStrategyNumber = n = this.rnd.nextInt(this.stratList.size());
        MetropolisStrategy metropolisStrategy = this.stratList.get(n);
        if (metropolisStrategy instanceof BidirectionalMutationStrat) {
            ++strat1Count;
        } else if (metropolisStrategy instanceof LensSubpathStrat) {
            ++strat2Count;
        } else if (metropolisStrategy instanceof LensPerturbationStrat) {
            ++strat3Count;
        }
        if (metropolisStrategy instanceof CausticPerturbation) {
            ++strat4Count;
        }
        return metropolisStrategy;
    }

    public MetropolisStrategy getLastStrategy() {
        return this.stratList.get(this.lastStrategyNumber);
    }

    public int getMutationStrategyCount() {
        return this.stratList.size();
    }

    public ArrayList<String> getStatistics() {
        this.mutatorStatistic.clear();
        for (MetropolisStrategy metropolisStrategy : this.stratList) {
            if (metropolisStrategy instanceof BidirectionalMutationStrat) {
                this.mutatorStatistic.add("Count of Bidirection Strategy:" + strat1Count + "\n");
            } else if (metropolisStrategy instanceof LensSubpathStrat) {
                this.mutatorStatistic.add("Count of Lens Sub Path Strategy:" + strat2Count + "\n");
            } else if (metropolisStrategy instanceof LensPerturbationStrat) {
                this.mutatorStatistic.add("Count of Lens Perturbation Strategy:" + strat3Count + "\n");
            } else if (metropolisStrategy instanceof CausticPerturbation) {
                this.mutatorStatistic.add("Count of Caustic Perturbation Strategy:" + strat4Count + "\n");
            }
            if (metropolisStrategy.getStatistics() == null) continue;
            for (String string : metropolisStrategy.getStatistics()) {
                this.mutatorStatistic.add("   " + string);
            }
        }
        return this.mutatorStatistic;
    }

    public void pathChanged() {
        for (MetropolisStrategy metropolisStrategy : this.stratList) {
            metropolisStrategy.pathChanged();
        }
    }
}

