/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.light;

import de.grogra.ray.physics.Environment;
import de.grogra.ray.physics.Light;
import de.grogra.ray.physics.Shader;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.util.Ray;
import de.grogra.ray.util.RayList;
import de.grogra.ray2.Resources;
import de.grogra.ray2.Scene;
import de.grogra.ray2.light.LightProcessor;
import de.grogra.ray2.tracing.ProcessorBase;
import de.grogra.vecmath.Math2;
import de.grogra.vecmath.geom.Intersection;
import de.grogra.vecmath.geom.IntersectionList;
import de.grogra.vecmath.geom.Line;
import de.grogra.vecmath.geom.Volume;
import java.util.ArrayList;
import java.util.Random;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class DefaultLightProcessor
extends ProcessorBase
implements LightProcessor {
    private LightEntry[] lightEntries;
    private int samplesForAreaLight;
    private int samplesForSkyLight;
    private Scene scene;
    private IntersectionList list;
    private Line line;
    private long shadowTestCount = 0L;
    private long shadowedCount = 0L;
    private long shadowCacheSuccessCount = 0L;
    private Vector3f negatedDirection;
    private Spectrum tmpSpectrum;
    private Spectrum id;
    private boolean geometryTerm = false;
    private boolean alwaysOneSample = false;
    private RayList singleRay;
    private LightSample singleSample;
    private int raytracerType;
    private double totalPower;

    public void useGeometryTerm(boolean bl) {
        this.geometryTerm = bl;
    }

    public void useOneSamplePerLight(boolean bl) {
        this.alwaysOneSample = bl;
    }

    public LightProcessor dup(Scene scene) {
        DefaultLightProcessor defaultLightProcessor = (DefaultLightProcessor)this.clone();
        defaultLightProcessor.scene = scene;
        defaultLightProcessor.initLocals();
        LightEntry[] lightEntryArray = new LightEntry[this.lightEntries.length];
        for (int i = 0; i < lightEntryArray.length; ++i) {
            lightEntryArray[i] = this.lightEntries[i].dup();
        }
        defaultLightProcessor.lightEntries = lightEntryArray;
        return defaultLightProcessor;
    }

    public void initialize(Scene scene, int n, Random random) {
        this.scene = scene;
        this.id = scene.createSpectrum();
        this.id.setIdentity();
        this.initLocals();
        this.raytracerType = n;
        if (n == 0) {
            this.samplesForAreaLight = 50;
            this.samplesForSkyLight = 100;
        } else {
            this.samplesForAreaLight = 4;
            this.samplesForSkyLight = 8;
        }
        this.line.start = 0.0;
        this.totalPower = 0.0;
        Light[] lightArray = scene.getLights();
        RayList rayList = new RayList(this.id);
        ArrayList<LightSample> arrayList = new ArrayList<LightSample>();
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        ArrayList<LightEntry> arrayList2 = new ArrayList<LightEntry>();
        for (int i = 0; i < lightArray.length; ++i) {
            int n2 = lightArray[i].getLightType();
            if (n2 == 5 || n2 == 0) continue;
            Environment environment = new Environment(scene.getBoundingBox(), this.id, n);
            environment.localToGlobal.set(scene.getLightTransformation(i));
            environment.globalToLocal.set(scene.getInverseLightTransformation(i));
            arrayList.clear();
            double d = lightArray[i].getTotalPower(environment);
            if (!(d > 0.0)) continue;
            this.totalPower += d;
            LightEntry lightEntry = new LightEntry();
            lightEntry.light = lightArray[i];
            lightEntry.env = environment;
            vector3f.set(0.0f, 0.0f, 0.0f);
            vector3f2.set((Tuple3f)vector3f);
            boolean bl = n2 == 3 || n2 == 1;
            boolean bl2 = n2 == 3 || n2 == 4;
            double d2 = (bl2 ? 3.0 : Math.PI * environment.boundsRadius * environment.boundsRadius) * 1.0E-5;
            if (!bl && this.alwaysOneSample) {
                LightSample lightSample = new LightSample();
                lightSample.lightEntry = arrayList2.size();
                arrayList.add(lightSample);
            } else {
                int n3;
                float f;
                int n4 = bl ? 1 : 50;
                do {
                    rayList.setSize(n4);
                    if (bl2) {
                        lightArray[i].generateRandomRays(environment, null, this.id, rayList, true, random);
                    } else {
                        lightArray[i].generateRandomOrigins(environment, rayList, random);
                    }
                    for (int j = 0; j < n4; ++j) {
                        Point3f point3f;
                        LightSample lightSample = new LightSample();
                        lightSample.lightEntry = arrayList2.size();
                        lightSample.origin = new Point3d(rayList.rays[j].origin);
                        lightSample.color = rayList.rays[j].spectrum.clone();
                        if (bl2) {
                            lightSample.direction = new Vector3d(rayList.rays[j].direction);
                            point3f = rayList.rays[j].direction;
                        } else {
                            point3f = rayList.rays[j].origin;
                        }
                        vector3f.add((Tuple3f)point3f);
                        Math2.mul((Tuple3f)vector3f3, (Tuple3f)point3f, (Tuple3f)point3f);
                        vector3f2.add((Tuple3f)vector3f3);
                        arrayList.add(lightSample);
                    }
                    n3 = arrayList.size();
                    Math2.mul((Tuple3f)vector3f3, (Tuple3f)vector3f, (Tuple3f)vector3f);
                    vector3f3.scaleAdd(-1.0f / (float)n3, (Tuple3f)vector3f2);
                    vector3f3.scale(1.0f / (float)n3);
                } while ((n4 = (int)Math.min((double)(f = vector3f3.x + vector3f3.y + vector3f3.z) / d2, 500000.0) - n3) > n3 >> 2 && !bl);
            }
            lightEntry.power = d;
            lightEntry.samples = arrayList.toArray(new LightSample[arrayList.size()]);
            arrayList2.add(lightEntry);
        }
        this.lightEntries = arrayList2.toArray(new LightEntry[arrayList2.size()]);
    }

    protected void initLocals() {
        super.initLocals();
        this.list = new IntersectionList();
        this.line = new Line();
        this.negatedDirection = new Vector3f();
        this.tmpSpectrum = this.scene.createSpectrum();
        this.singleRay = new RayList(this.id);
        this.singleRay.setSize(1);
        this.singleSample = new LightSample();
        this.singleSample.direction = new Vector3d();
        this.singleSample.origin = new Point3d();
        this.singleSample.color = this.id.newInstance();
    }

    public void getLightRays(boolean bl, Intersection intersection, RayList rayList, ArrayList arrayList, Random random) {
        int n = rayList.size();
        int n2 = this.scene.getLight(intersection.solid);
        Light light = n2 >= 0 ? this.scene.getLights()[n2] : null;
        for (int i = 0; i < this.lightEntries.length; ++i) {
            int n3;
            LightEntry lightEntry = this.lightEntries[i];
            if (lightEntry.light == light) continue;
            if (this.alwaysOneSample) {
                n3 = 1;
            } else {
                switch (lightEntry.light.getLightType()) {
                    case 1: 
                    case 3: {
                        n3 = 1;
                        break;
                    }
                    case 2: {
                        n3 = Math.max((int)((double)this.samplesForAreaLight * lightEntry.power / this.totalPower), 1);
                        break;
                    }
                    case 4: {
                        n3 = Math.max((int)((double)this.samplesForSkyLight * lightEntry.power / this.totalPower), 1);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                if (n3 < 1 || lightEntry.samples.length == 1) {
                    n3 = 1;
                }
            }
            boolean bl2 = lightEntry.light.getLightType() == 3 || lightEntry.light.getLightType() == 4;
            block6: for (int j = 0; j < n3; ++j) {
                LightSample lightSample = lightEntry.samples.length == 1 ? lightEntry.samples[0] : (this.raytracerType == 0 ? lightEntry.samples[j % lightEntry.samples.length] : lightEntry.samples[random.nextInt(lightEntry.samples.length)]);
                LightEntry lightEntry2 = this.lightEntries[lightSample.lightEntry];
                if (lightSample.color == null) {
                    this.singleSample.lightEntry = lightSample.lightEntry;
                    lightSample = this.singleSample;
                    if (bl2) {
                        lightEntry2.light.generateRandomRays(lightEntry2.env, null, this.id, this.singleRay, true, random);
                    } else {
                        lightEntry2.light.generateRandomOrigins(lightEntry2.env, this.singleRay, random);
                    }
                    lightSample.origin.set((Tuple3f)this.singleRay.rays[0].origin);
                    lightSample.color.set(this.singleRay.rays[0].spectrum);
                    lightSample.direction.set((Tuple3f)this.singleRay.rays[0].direction);
                }
                rayList.setSize(n + 1);
                Ray ray = rayList.rays[n];
                this.line.start = 0.0;
                this.line.origin.set((Tuple3d)intersection.getPoint());
                if (bl2) {
                    this.line.direction.set((Tuple3d)lightSample.direction);
                    this.line.direction.negate();
                    this.line.end = Double.MAX_VALUE;
                } else {
                    this.line.direction.set((Tuple3d)lightSample.origin);
                    this.line.direction.sub(this.line.origin);
                    this.line.end = 1.0;
                }
                if (bl != intersection.getNormal().dot(this.line.direction) > 0.0) continue;
                ray.direction.set((Tuple3d)this.line.direction);
                ray.direction.normalize();
                this.negatedDirection.negate((Tuple3f)ray.direction);
                if (bl2) {
                    lightEntry2.light.computeExitance(lightEntry2.env, ray.spectrum);
                    ray.spectrum.mul(lightSample.color);
                } else {
                    lightEntry2.light.computeBSDF(lightEntry2.env, null, lightSample.color, this.negatedDirection, false, ray.spectrum);
                    if (this.geometryTerm) {
                        ray.spectrum.scale(1.0f / (float)this.line.lengthSquared());
                    }
                }
                ray.spectrum.scale(1.0 / (double)n3);
                if (ray.spectrum.integrate() <= (double)1.0E-10f) continue;
                if (!lightEntry2.light.isShadowless()) {
                    int n4;
                    Object object;
                    ++this.shadowTestCount;
                    while (arrayList.size() <= i) {
                        arrayList.add(new CacheEntry());
                    }
                    this.list.clear();
                    CacheEntry cacheEntry = (CacheEntry)arrayList.get(i);
                    if (cacheEntry.shading != null) {
                        cacheEntry.shading.computeIntersections(this.line, 2, this.list, intersection, null);
                        if (this.list.size > 0) {
                            Shader shader = this.scene.getShader(cacheEntry.shading);
                            object = cacheEntry.shadingEnvironment;
                            ((Environment)object).set(this.list.elements[0], shader.getFlags(), this.scene);
                            shader.computeBSDF((Environment)object, ray.direction, ray.spectrum, this.negatedDirection, false, this.tmpSpectrum);
                            if (this.tmpSpectrum.integrate() <= 1.0) {
                                ++this.shadowedCount;
                                ++this.shadowCacheSuccessCount;
                                continue;
                            }
                        }
                        cacheEntry.shading = null;
                    }
                    this.scene.computeIntersections(this.line, 0, this.list, intersection, null);
                    for (n4 = this.list.size - 1; n4 >= 0; --n4) {
                        object = this.list.elements[n4];
                        int n5 = this.scene.getLight(((Intersection)object).solid);
                        if (n5 < 0 || this.scene.getLights()[n5] != lightEntry2.light) continue;
                        this.list.remove(n4, n4 + 1);
                    }
                    while (cacheEntry.environments.size() < this.list.size) {
                        cacheEntry.environments.add(new Environment(this.scene.getBoundingBox(), this.scene.createSpectrum(), 0));
                    }
                    for (n4 = 0; n4 < this.list.size; ++n4) {
                        object = this.scene.getShader(this.list.elements[n4].solid);
                        Environment environment = cacheEntry.environments.get(n4);
                        environment.set(this.list.elements[n4], object.getFlags(), this.scene);
                        object.computeBSDF(environment, ray.direction, ray.spectrum, this.negatedDirection, false, this.tmpSpectrum);
                        if (this.tmpSpectrum.integrate() <= 1.0) {
                            ++this.shadowedCount;
                            cacheEntry.shadingEnvironment = environment;
                            cacheEntry.shading = this.list.elements[n4].solid;
                            continue block6;
                        }
                        this.tmpSpectrum.scale(1.0E-10f);
                        ray.spectrum.set(this.tmpSpectrum);
                    }
                }
                ++n;
            }
        }
        rayList.setSize(n);
    }

    protected void mergeStatistics(ProcessorBase processorBase) {
        super.mergeStatistics(processorBase);
        DefaultLightProcessor defaultLightProcessor = (DefaultLightProcessor)processorBase;
        this.shadowCacheSuccessCount += defaultLightProcessor.shadowCacheSuccessCount;
        this.shadowedCount += defaultLightProcessor.shadowedCount;
        this.shadowTestCount += defaultLightProcessor.shadowTestCount;
    }

    protected void appendStatisticsImpl(StringBuffer stringBuffer) {
        int n = 0;
        for (int i = 0; i < this.lightEntries.length; ++i) {
            n += this.lightEntries[i].samples.length;
        }
        stringBuffer.append(Resources.msg("lightprocessor.default.statistics", this.lightEntries.length, n, new Long(this.shadowTestCount), new Long(this.shadowedCount), new Float(this.shadowedCount == 0L ? 0.0f : (float)this.shadowCacheSuccessCount / (float)this.shadowedCount)));
    }

    private static class CacheEntry {
        Volume shading;
        Environment shadingEnvironment;
        ArrayList<Environment> environments = new ArrayList();

        private CacheEntry() {
        }
    }

    private static class LightSample {
        int lightEntry;
        Point3d origin;
        Spectrum color;
        Vector3d direction;

        private LightSample() {
        }
    }

    private static class LightEntry {
        double power;
        Light light;
        Environment env;
        LightSample[] samples;

        private LightEntry() {
        }

        LightEntry dup() {
            LightEntry lightEntry = new LightEntry();
            lightEntry.power = this.power;
            lightEntry.light = this.light;
            lightEntry.samples = this.samples;
            lightEntry.env = new Environment(this.env.bounds, this.env.tmpSpectrum0, this.env.type);
            lightEntry.env.globalToLocal.set(this.env.globalToLocal);
            lightEntry.env.localToGlobal.set(this.env.localToGlobal);
            return lightEntry;
        }
    }
}

