/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.antialiasing;

import de.grogra.ray.util.Ray;
import de.grogra.ray2.Resources;
import de.grogra.ray2.Scene;
import de.grogra.ray2.antialiasing.NoAntialiasing;
import de.grogra.ray2.tracing.PixelwiseRenderer;
import java.util.Random;
import javax.vecmath.Color4f;
import javax.vecmath.Point4d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4d;

public class StochasticSupersampling
extends NoAntialiasing {
    public static final String GRID_SIZE = "stochasticsupersampling.gridsize";
    private Color4f tmpColor4f;
    private Point4d sumColor;
    private int gridSize = 3;
    public static int DEBUG_I = -1;
    public static int DEBUG_J = -1;
    public static int CURRENT_I;
    public static int CURRENT_J;

    protected void initLocals() {
        super.initLocals();
        this.tmpColor4f = new Color4f();
        this.sumColor = new Point4d();
    }

    public void initialize(PixelwiseRenderer pixelwiseRenderer, Scene scene) {
        super.initialize(pixelwiseRenderer, scene);
        this.setGridSize(Math.min(Math.max(pixelwiseRenderer.getNumericOption(GRID_SIZE, this.gridSize).intValue(), 1), 200));
    }

    public void setGridSize(int n) {
        this.gridSize = n;
    }

    public void getColorOfRectangle(double d, double d2, double d3, double d4, Color4f color4f, Random random) {
        random.nextInt();
        this.processor.initializeBeforeTracing(random);
        Ray ray = this.list.rays[0];
        this.sumColor.set(0.0, 0.0, 0.0, 0.0);
        int n = 0;
        for (int i = 0; i < this.gridSize; ++i) {
            CURRENT_I = i;
            for (int j = 0; j < this.gridSize; ++j) {
                CURRENT_J = j;
                int n2 = random.nextInt();
                int n3 = (i << 16) + (char)n2;
                int n4 = (j << 16) + (char)(n2 >> 16);
                this.env.uv.set((float)(d + d3 * (double)n3 / (double)(65536 * this.gridSize)), (float)(d2 + d4 * (double)n4 / (double)(65536 * this.gridSize)));
                this.renderer.getCamera().generateRandomOrigins(this.env, this.list, random);
                this.tmpSpectrum.set(ray.spectrum);
                this.env.point.set((Tuple3f)ray.origin);
                this.env.globalToLocal.transform(this.env.point, this.env.localPoint);
                this.renderer.getCamera().generateRandomRays(this.env, null, this.tmpSpectrum, this.list, false, random);
                this.line.x = this.xPixel;
                this.line.y = this.yPixel;
                this.line.start = 0.0;
                this.line.end = Double.POSITIVE_INFINITY;
                this.line.origin.set((Tuple3f)ray.origin);
                this.line.direction.set((Tuple3f)ray.direction);
                this.processor.getColorFromRay(this.line, ray.spectrum, this.tmpColor4f, random);
                if (this.tmpColor4f.x != this.tmpColor4f.x || this.tmpColor4f.y != this.tmpColor4f.y || this.tmpColor4f.z != this.tmpColor4f.z || this.tmpColor4f.w != this.tmpColor4f.w) {
                    System.err.println("NaN at (" + d + ',' + d2 + ") + (" + i + ',' + j + ')');
                    continue;
                }
                this.sumColor.x += (double)this.tmpColor4f.x;
                this.sumColor.y += (double)this.tmpColor4f.y;
                this.sumColor.z += (double)this.tmpColor4f.z;
                this.sumColor.w += (double)this.tmpColor4f.w;
                ++n;
            }
        }
        color4f.set((Tuple4d)this.sumColor);
        if (n > 0) {
            color4f.scale(1.0f / (float)n);
        }
    }

    protected void appendStatisticsImpl(StringBuffer stringBuffer) {
        stringBuffer.append(Resources.msg("antialiasing.stochastic.statistics", this.gridSize, this.gridSize));
        super.appendStatisticsImpl(stringBuffer);
    }
}

