/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.antialiasing;

import de.grogra.ray.physics.Environment;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.util.Ray;
import de.grogra.ray.util.RayList;
import de.grogra.ray2.Scene;
import de.grogra.ray2.antialiasing.Antialiasing;
import de.grogra.ray2.tracing.DefaultRayProcessor;
import de.grogra.ray2.tracing.PixelwiseRenderer;
import de.grogra.ray2.tracing.ProcessorBase;
import de.grogra.ray2.tracing.RayProcessor;
import de.grogra.vecmath.Math2;
import de.grogra.vecmath.geom.Line;
import java.util.Random;
import javax.vecmath.Color4f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;

public class NoAntialiasing
extends ProcessorBase
implements Antialiasing {
    PixelwiseRenderer renderer;
    Scene scene;
    public RayProcessor processor;
    Environment env;
    RayList list;
    Line line;
    Spectrum tmpSpectrum;
    float xPixel;
    float yPixel;

    protected void initLocals() {
        this.line = new Line();
        this.tmpSpectrum = this.scene.createSpectrum();
        this.list = new RayList(this.tmpSpectrum);
        this.list.setSize(1);
        this.env = new Environment(this.scene.getBoundingBox(), this.tmpSpectrum, 0);
        this.env.localToGlobal.set(this.renderer.getCameraTransformation());
        this.env.globalToLocal.m33 = 1.0f;
        Math2.invertAffine((Matrix4f)this.env.localToGlobal, (Matrix4f)this.env.globalToLocal);
    }

    public Antialiasing dup(Scene scene) {
        NoAntialiasing noAntialiasing = (NoAntialiasing)this.clone();
        noAntialiasing.processor = this.processor.dup(scene);
        noAntialiasing.scene = scene;
        noAntialiasing.initLocals();
        return noAntialiasing;
    }

    public void initialize(PixelwiseRenderer pixelwiseRenderer, Scene scene) {
        this.renderer = pixelwiseRenderer;
        this.scene = scene;
        this.initLocals();
        this.processor = (RayProcessor)pixelwiseRenderer.getClassOption("rayprocessor", new DefaultRayProcessor());
        this.processor.initialize(pixelwiseRenderer, scene);
    }

    public void getColorOfRectangle(double d, double d2, double d3, double d4, Color4f color4f, Random random) {
        Ray ray = this.list.rays[0];
        this.env.uv.set((float)(d + d3 * 0.5), (float)(d2 + d4 * 0.5));
        this.renderer.getCamera().generateRandomOrigins(this.env, this.list, random);
        this.tmpSpectrum.set(ray.spectrum);
        this.env.point.set((Tuple3f)ray.origin);
        this.env.globalToLocal.transform(this.env.point, this.env.localPoint);
        this.renderer.getCamera().generateRandomRays(this.env, null, this.tmpSpectrum, this.list, false, random);
        this.line.x = this.xPixel;
        this.line.y = this.yPixel;
        this.line.start = 0.0;
        this.line.end = Double.POSITIVE_INFINITY;
        this.line.origin.set((Tuple3f)ray.origin);
        this.line.direction.set((Tuple3f)ray.direction);
        this.processor.initializeBeforeTracing(random);
        this.processor.getColorFromRay(this.line, ray.spectrum, color4f, random);
    }

    public void setPixelXY(float f, float f2) {
        this.xPixel = f;
        this.yPixel = f2;
    }

    protected void appendStatisticsImpl(StringBuffer stringBuffer) {
        this.processor.appendStatistics(stringBuffer);
    }
}

