/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray.tracing;

import de.grogra.ray.RTFakeObject;
import de.grogra.ray.RTLight;
import de.grogra.ray.RTObject;
import de.grogra.ray.RTScene;
import de.grogra.ray.Raytracer;
import de.grogra.ray.intersection.IntersectionDescription;
import de.grogra.ray.intersection.IntersectionProcessor;
import de.grogra.ray.light.DefaultLightProcessor;
import de.grogra.ray.light.LightProcessor;
import de.grogra.ray.shader.ShadingEnvironment;
import de.grogra.ray.tracing.RayProcessor;
import de.grogra.ray.util.Ray;
import de.grogra.ray.util.RayContext;
import de.grogra.ray.util.RayList;
import de.grogra.vecmath.Math2;
import edu.wlu.cs.levy.CG.KDTree;
import edu.wlu.cs.levy.CG.KeyDuplicateException;
import edu.wlu.cs.levy.CG.KeySizeException;
import javax.vecmath.Color3f;
import javax.vecmath.Color4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class PhotonMapping
implements RayProcessor {
    private int nr_photons = 0;
    private int recursionDepth = 5;
    private int range = 50;
    private int recursionDepth_eye = 5;
    private static final float LIGHT_WEIGHT_MIN = 0.02f;
    private RTScene scene = null;
    private static KDTree photonMap = null;
    private char seed;
    private Color3f[] photonColor = null;
    private RTLight[] lights = null;
    private float[] lightProp = null;
    private int selectedLight = 0;
    private boolean createMap = true;
    private IntersectionDescription m_desc = new IntersectionDescription();
    private IntersectionProcessor m_intersectionProcessor = null;
    private float m_lastIOR = 1.0f;
    private LightProcessor m_lightModel = null;
    private RayList tempRayList = new RayList(1);
    private Vector3f reflectedVariance = new Vector3f();
    private Vector3f refractedVariance = new Vector3f();
    private Ray reflectedRay = new Ray();
    private Ray refractedRay = new Ray();

    private static float sum(Tuple3f tuple3f) {
        return tuple3f.x + tuple3f.y + tuple3f.z;
    }

    public PhotonMapping() {
        if (photonMap == null) {
            photonMap = new KDTree(3);
        }
        this.seed = Math2.random((char)'\u0000');
        this.setLightProcessor(new DefaultLightProcessor());
    }

    public void createPhotonMap() {
        this.createMap = true;
        if (this.scene.getLightsCount() == 0) {
            return;
        }
        this.m_lastIOR = 1.0f;
        RayContext rayContext = new RayContext();
        rayContext.initializeContext();
        RTLight rTLight = this.selectLight(this.lights);
        Ray ray = this.generatePhoton(rTLight);
        this.shootPhoton(1, ray, rayContext, this.m_desc, null);
    }

    private void compluteLightProbs(RTLight[] rTLightArray) {
        this.lightProp = new float[rTLightArray.length];
        this.photonColor = new Color3f[rTLightArray.length];
        RayList rayList = new RayList(1);
        float f = 0.0f;
        for (int i = 0; i < rTLightArray.length; ++i) {
            this.seed = (char)(this.seed + '\u0001');
            rTLightArray[i].generateRandomOrigins(rayList, Math2.random((char)this.seed));
            this.photonColor[i] = new Color3f((Color3f)rayList.rays[0].color);
            f += PhotonMapping.sum((Tuple3f)this.photonColor[i]);
        }
        float f2 = f / (float)this.nr_photons;
        for (int i = 0; i < rTLightArray.length; ++i) {
            this.lightProp[i] = PhotonMapping.sum((Tuple3f)this.photonColor[i]) / f2;
            this.photonColor[i].scale(1.0f / this.lightProp[i]);
        }
    }

    private RTLight selectLight(RTLight[] rTLightArray) {
        if (this.lightProp[this.selectedLight] > 0.0f) {
            int n = this.selectedLight;
            this.lightProp[n] = this.lightProp[n] - 1.0f;
            return rTLightArray[this.selectedLight];
        }
        int n = ++this.selectedLight;
        this.lightProp[n] = this.lightProp[n] - 1.0f;
        return rTLightArray[this.selectedLight];
    }

    private Ray generatePhoton(RTLight rTLight) {
        RayList rayList = new RayList(1);
        Vector3f vector3f = new Vector3f();
        this.seed = (char)(this.seed + '\u0001');
        rTLight.generateRandomOrigins(rayList, Math2.random((char)this.seed));
        this.seed = (char)(this.seed + '\u0001');
        rTLight.generateRandomRays(vector3f, rayList, true, Math2.random((char)this.seed));
        Ray ray = new Ray(rayList.rays[0]);
        ray.color.set((Tuple3f)this.photonColor[this.selectedLight]);
        return ray;
    }

    private void shootPhoton(int n, Ray ray, RayContext rayContext, IntersectionDescription intersectionDescription, RTObject rTObject) {
        if (!this.m_intersectionProcessor.getFirstIntersectionDescription(ray, rayContext, intersectionDescription)) {
            return;
        }
        if (intersectionDescription.getRTObject() instanceof RTFakeObject) {
            return;
        }
        if (this.createMap) {
            this.insertPhoton(ray, this.m_desc.getPoint());
        }
        ShadingEnvironment shadingEnvironment = new ShadingEnvironment();
        this.refreshEnvironment(shadingEnvironment, ray, rayContext, intersectionDescription);
        if (n < this.recursionDepth) {
            Ray ray2 = new Ray();
            Ray ray3 = new Ray();
            Vector3f vector3f = new Vector3f();
            Vector3f vector3f2 = new Vector3f();
            intersectionDescription.getRTObject().getShader().computeMaxRays(shadingEnvironment, ray2, vector3f, ray3, vector3f2);
            if (PhotonMapping.sum((Tuple3f)ray3.color) > 0.0f) {
                Color3f color3f = new Color3f(ray3.getColor());
                color3f.x *= ray.getColor().x;
                color3f.y *= ray.getColor().y;
                color3f.z *= ray.getColor().z;
                ray3.getColor().set((Tuple3f)color3f);
                this.shootPhoton(n + 1, ray3, rayContext, intersectionDescription, null);
            } else {
                Color3f color3f = new Color3f(ray2.getColor());
                color3f.x *= ray.getColor().x;
                color3f.y *= ray.getColor().y;
                color3f.z *= ray.getColor().z;
                ray2.getColor().set((Tuple3f)color3f);
                float f = PhotonMapping.sum((Tuple3f)color3f);
                if (f > 0.0f) {
                    this.shootPhoton(n + 1, ray2, rayContext, intersectionDescription, intersectionDescription.getRTObject());
                }
            }
        }
    }

    private void insertPhoton(Ray ray, Point3f point3f) {
        double[] dArray = new double[]{point3f.x, point3f.y, point3f.z};
        Vector3f vector3f = new Vector3f(ray.direction);
        vector3f.negate();
        Node node = new Node(new Color3f((Color3f)ray.color), new Point3f(point3f), vector3f);
        try {
            photonMap.insert(dArray, (Object)node);
        }
        catch (KeySizeException keySizeException) {
            keySizeException.printStackTrace();
        }
        catch (KeyDuplicateException keyDuplicateException) {
            try {
                Node node2 = (Node)photonMap.search(dArray);
                photonMap.delete(dArray);
                node2.col.add((Tuple3f)ray.color);
                photonMap.insert(dArray, (Object)node2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void refreshEnvironment(ShadingEnvironment shadingEnvironment, Ray ray, RayContext rayContext, IntersectionDescription intersectionDescription) {
        if (intersectionDescription == null) {
            return;
        }
        shadingEnvironment.localPoint.set((Tuple3f)intersectionDescription.getLocalPoint());
        shadingEnvironment.point.set((Tuple3f)intersectionDescription.getPoint());
        shadingEnvironment.normal.set((Tuple3f)intersectionDescription.getNormal());
        shadingEnvironment.view.set((Tuple3f)ray.getDirection());
        shadingEnvironment.view.negate();
        shadingEnvironment.photonDirection = false;
        shadingEnvironment.solid = intersectionDescription.getRTObject().isSolid();
        if (intersectionDescription.getRTObject().getUserData().isInside) {
            if (rayContext.isLastMaterial(intersectionDescription.getRTObject())) {
                shadingEnvironment.iorRatio = rayContext.getExitingIORRation();
            }
        } else {
            shadingEnvironment.iorRatio = intersectionDescription.getRTObject().getMedium() == null ? 1.0f : rayContext.getCurrentIOR() / intersectionDescription.getRTObject().getMedium().getIndexOfRefraction();
        }
        shadingEnvironment.uv.set((Tuple2f)intersectionDescription.getUVCoordinate());
        shadingEnvironment.dpdu.set((Tuple3f)intersectionDescription.getTangenteU());
        shadingEnvironment.dpdv.set((Tuple3f)intersectionDescription.getTangenteV());
    }

    public boolean hasFixedLightProcessor() {
        return false;
    }

    public void setLightProcessor(LightProcessor lightProcessor) {
        this.m_lightModel = lightProcessor;
    }

    public LightProcessor getLightProcessor() {
        return this.m_lightModel;
    }

    public void setRecursionDepth(int n) {
        this.recursionDepth = n;
    }

    public int getRecursionDepth() {
        return this.recursionDepth;
    }

    public void setPhotonCount(int n) {
        this.nr_photons = n;
    }

    public void setRang(int n) {
        this.range = n;
    }

    public void clear() {
        photonMap = new KDTree(3);
    }

    public void prepareRayProcessor(RTScene rTScene, IntersectionProcessor intersectionProcessor) {
        this.scene = rTScene;
        this.m_intersectionProcessor = intersectionProcessor;
        this.m_lightModel.prepareLightProcessor(rTScene, intersectionProcessor);
        this.lights = Raytracer.getLights(rTScene);
        this.compluteLightProbs(this.lights);
    }

    public void getColorFromRay(Ray ray, Color4f color4f) {
        IntersectionDescription intersectionDescription = new IntersectionDescription();
        Color3f color3f = new Color3f();
        this.m_lastIOR = 1.0f;
        RayContext rayContext = new RayContext();
        rayContext.initializeContext();
        if (this.m_intersectionProcessor == null) {
            color4f.set(0.0f, 0.0f, 0.0f, 0.0f);
            return;
        }
        if (!this.m_intersectionProcessor.getFirstIntersectionDescription(ray, rayContext, intersectionDescription)) {
            color4f.set(0.0f, 0.0f, 0.0f, 0.0f);
            return;
        }
        if (intersectionDescription.getRTObject() instanceof RTFakeObject) {
            ((RTFakeObject)intersectionDescription.getRTObject()).getColor(ray, intersectionDescription, color3f);
            return;
        }
        ShadingEnvironment shadingEnvironment = new ShadingEnvironment();
        this.getRegionLight(intersectionDescription, color3f, ray, rayContext, shadingEnvironment);
        this.traceEyeRay(1, ray, rayContext, intersectionDescription, shadingEnvironment, intersectionDescription.getRTObject(), color3f);
        color4f.x = color3f.x;
        color4f.y = color3f.y;
        color4f.z = color3f.z;
        color4f.w = 1.0f;
    }

    private void getRegionLight(IntersectionDescription intersectionDescription, Color3f color3f, Ray ray, RayContext rayContext, ShadingEnvironment shadingEnvironment) {
        Object[] objectArray;
        float f = 0.0f;
        Node node = null;
        Point3f point3f = intersectionDescription.getPoint();
        double[] dArray = new double[]{point3f.x, point3f.y, point3f.z};
        try {
            objectArray = photonMap.nearest(dArray, this.range);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            return;
        }
        catch (KeySizeException keySizeException) {
            keySizeException.printStackTrace();
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            node = (Node)objectArray[i];
            if (!(node.dir.dot(intersectionDescription.getNormal()) >= 0.0f)) continue;
            color3f.add((Tuple3f)node.col);
        }
        if (node != null) {
            f = node.pos.distanceSquared(point3f);
        }
        color3f.scale(1.0f / (f * Math2.M_PI));
        this.refreshEnvironment(shadingEnvironment, ray, rayContext, intersectionDescription);
        Vector3f vector3f = new Vector3f(ray.direction);
        vector3f.normalize();
        vector3f.negate();
        Color3f color3f2 = new Color3f();
        intersectionDescription.getRTObject().getShader().computeBSDF(shadingEnvironment, vector3f, shadingEnvironment.normal, true, color3f2);
        color3f.x *= color3f2.x;
        color3f.y *= color3f2.y;
        color3f.z *= color3f2.z;
    }

    private void traceEyeRay(int n, Ray ray, RayContext rayContext, IntersectionDescription intersectionDescription, ShadingEnvironment shadingEnvironment, RTObject rTObject, Color3f color3f) {
        if (intersectionDescription.getRTObject() instanceof RTFakeObject) {
            ((RTFakeObject)intersectionDescription.getRTObject()).getColor(ray, intersectionDescription, color3f);
            return;
        }
        intersectionDescription.getRTObject().getShader().computeMaxRays(shadingEnvironment, this.reflectedRay, this.reflectedVariance, this.refractedRay, this.refractedVariance);
        if (PhotonMapping.sum((Tuple3f)this.reflectedVariance) < 0.02f) {
            IntersectionDescription intersectionDescription2 = new IntersectionDescription();
            Color3f color3f2 = new Color3f();
            if (!this.m_intersectionProcessor.getFirstIntersectionDescription(this.reflectedRay, rayContext, intersectionDescription2)) {
                color3f2.set(0.0f, 0.0f, 0.0f);
                return;
            }
            ShadingEnvironment shadingEnvironment2 = new ShadingEnvironment();
            this.getRegionLight(intersectionDescription2, color3f2, this.reflectedRay, rayContext, shadingEnvironment2);
            color3f2.x *= this.reflectedRay.color.x;
            color3f2.y *= this.reflectedRay.color.y;
            color3f2.z *= this.reflectedRay.color.z;
            color3f.add((Tuple3f)color3f2);
            if (n < this.recursionDepth_eye) {
                this.traceEyeRay(n + 1, this.reflectedRay, rayContext, intersectionDescription2, shadingEnvironment2, intersectionDescription2.getRTObject(), color3f);
            }
        } else if (PhotonMapping.sum((Tuple3f)this.refractedRay.color) > 0.0f) {
            IntersectionDescription intersectionDescription3 = new IntersectionDescription();
            Color3f color3f3 = new Color3f();
            if (!this.m_intersectionProcessor.getFirstIntersectionDescription(this.refractedRay, rayContext, intersectionDescription3)) {
                color3f3.set(0.0f, 0.0f, 0.0f);
                return;
            }
            ShadingEnvironment shadingEnvironment3 = new ShadingEnvironment();
            this.getRegionLight(intersectionDescription3, color3f3, this.refractedRay, rayContext, shadingEnvironment3);
            color3f3.x *= this.refractedRay.color.x;
            color3f3.y *= this.refractedRay.color.y;
            color3f3.z *= this.refractedRay.color.z;
            color3f.add((Tuple3f)color3f3);
            if (n < this.recursionDepth_eye) {
                this.traceEyeRay(n + 1, this.refractedRay, rayContext, intersectionDescription3, shadingEnvironment3, intersectionDescription3.getRTObject(), color3f);
            }
        }
    }

    private class Node {
        public Color3f col;
        public Point3f pos;
        public Vector3f dir;

        public Node(Color3f color3f, Point3f point3f, Vector3f vector3f) {
            this.col = color3f;
            this.pos = point3f;
            this.dir = vector3f;
        }
    }
}

