/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray.quality;

import java.lang.reflect.Method;

public class Timer {
    private static final Method timeMethod;
    private boolean m_hasStarted = false;
    private long m_startTime = 0L;
    private long m_lastMesurement = 0L;

    public static long nanoTime() {
        if (timeMethod == null) {
            return System.currentTimeMillis() * 1000000L;
        }
        try {
            return (Long)timeMethod.invoke(null, (Object[])null);
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public void start() {
        this.m_hasStarted = true;
        this.m_startTime = Timer.nanoTime();
    }

    public void stop() {
        if (!this.m_hasStarted) {
            return;
        }
        long l = Timer.nanoTime();
        this.m_hasStarted = false;
        this.m_lastMesurement += l - this.m_startTime;
    }

    public void reset() {
        this.m_hasStarted = false;
        this.m_lastMesurement = 0L;
    }

    public long getLastNanos() {
        return this.m_lastMesurement;
    }

    public long getLastMicros() {
        return Math.round((double)this.m_lastMesurement / 1000.0);
    }

    public long getLastMillis() {
        return Math.round((double)this.m_lastMesurement / 1000000.0);
    }

    static {
        Method method = null;
        try {
            method = System.class.getMethod("nanoTime", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method = null;
        }
        timeMethod = method;
    }
}

