/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray.light;

import de.grogra.ray.debug3d.Debug3d;
import de.grogra.ray.intersection.IntersectionDescription;
import de.grogra.ray.intersection.IntersectionProcessor;
import de.grogra.ray.light.ShadowProcessor;
import de.grogra.ray.util.Ray;
import de.grogra.ray.util.RayContext;

public class Shadows
implements ShadowProcessor {
    private IntersectionProcessor m_processor = null;
    private float m_nearestT;
    private float m_scalar1;
    private float m_scalar2;
    private final RayContext m_rayContext = new RayContext();

    public Shadows(IntersectionProcessor intersectionProcessor) {
        this.setIntersectionProcessor(intersectionProcessor);
    }

    public void setIntersectionProcessor(IntersectionProcessor intersectionProcessor) {
        if (intersectionProcessor == null) {
            System.err.println("Shadows: intersection processor should not be null");
        } else {
            this.m_processor = intersectionProcessor;
        }
    }

    public boolean shadowRay(Ray ray, float f, Ray ray2, IntersectionDescription intersectionDescription) {
        if (intersectionDescription.getRTObject().isSolid()) {
            this.m_scalar1 = intersectionDescription.getNormal().x * ray.getDirection().x + intersectionDescription.getNormal().y * ray.getDirection().y + intersectionDescription.getNormal().z * ray.getDirection().z;
            if (this.m_scalar1 > 0.0f) {
                return true;
            }
        } else {
            this.m_scalar1 = intersectionDescription.getNormal().x * ray.getDirection().x + intersectionDescription.getNormal().y * ray.getDirection().y + intersectionDescription.getNormal().z * ray.getDirection().z;
            this.m_scalar2 = intersectionDescription.getNormal().x * ray2.getDirection().x + intersectionDescription.getNormal().y * ray2.getDirection().y + intersectionDescription.getNormal().z * ray2.getDirection().z;
            if (this.m_scalar1 * this.m_scalar2 < 0.0f) {
                Debug3d.logInfiniteRay(ray2, 1.0f);
                Debug3d.logInfiniteRay(ray, 1.0f);
                return true;
            }
        }
        this.m_rayContext.excludeObject = intersectionDescription.getRTObject();
        this.m_nearestT = this.m_processor.getFirstIntersectionT(ray, this.m_rayContext);
        return this.m_nearestT < f;
    }
}

