/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray.intersection;

import de.grogra.ray.intersection.CellGenerator;
import de.grogra.ray.intersection.Intersections;
import de.grogra.ray.intersection.OctreeCell;
import de.grogra.ray.util.Ray;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class DefaultCellGenerator
implements CellGenerator {
    private OctreeCell m_root = null;
    private float[] m_lengthX = null;
    private float[] m_lengthY = null;
    private float[] m_lengthZ = null;
    private int m_maxDepth;
    private int m_maxDivisionX;
    private boolean m_hasNextCell = false;
    private boolean m_isFirstCell = true;
    private final BoxIntersectionInput m_intersectionInput = new BoxIntersectionInput();
    private final BoxIntersectionLocals m_intersectionLocals = new BoxIntersectionLocals();
    private final BoxIntersectionOutput m_intersectionOutput = new BoxIntersectionOutput();
    private final FirstCellLocals m_firstCellLocals = new FirstCellLocals();
    public int m_same = 0;
    public int m_different = 0;
    private OctreeCell m_lastCell = null;
    private final Point3f m_lastLeavingPoint = new Point3f();
    private int m_lastLeavingPart;

    public void initialize(OctreeCell octreeCell, int n) {
        this.m_root = octreeCell;
        this.m_maxDepth = n;
        this.m_lengthX = new float[n + 2];
        this.m_lengthY = new float[n + 2];
        this.m_lengthZ = new float[n + 2];
        float f = this.m_root.getMaxValues().x - this.m_root.getMinValues().x;
        float f2 = this.m_root.getMaxValues().y - this.m_root.getMinValues().y;
        float f3 = this.m_root.getMaxValues().z - this.m_root.getMinValues().z;
        for (int i = 0; i < n + 2; ++i) {
            this.m_lengthX[i] = f;
            this.m_lengthY[i] = f2;
            this.m_lengthZ[i] = f3;
            f /= 2.0f;
            f2 /= 2.0f;
            f3 /= 2.0f;
        }
        this.m_maxDivisionX = 1 << n;
    }

    public void setRay(Ray ray) {
        this.m_intersectionInput.origin.set((Tuple3f)ray.getOrigin());
        this.m_intersectionInput.direction.set((Tuple3f)ray.getDirection());
        if (Intersections.isPointInsideBox(this.m_intersectionInput.origin, this.m_root.getMinValues(), this.m_root.getMaxValues())) {
            this.m_hasNextCell = true;
            this.getFirstCellFromPoint(this.m_intersectionInput.origin);
        } else {
            this.m_intersectionInput.minValues.set((Tuple3f)this.m_root.getMinValues());
            this.m_intersectionInput.maxValues.set((Tuple3f)this.m_root.getMaxValues());
            DefaultCellGenerator.getBoxEnteringIntersection(this.m_intersectionInput, this.m_intersectionLocals, this.m_intersectionOutput);
            if (!this.m_intersectionOutput.hasIntersection) {
                this.m_hasNextCell = false;
                return;
            }
            this.m_hasNextCell = true;
            this.getFirstCellFromOutside();
        }
        this.m_intersectionInput.minValues.set((Tuple3f)this.m_firstCellLocals.cur_cell.getMinValues());
        this.m_intersectionInput.maxValues.set((Tuple3f)this.m_firstCellLocals.cur_cell.getMaxValues());
        this.getBoxLeavingIntersection(this.m_intersectionInput, this.m_intersectionLocals, this.m_intersectionOutput);
        this.m_lastCell = this.m_firstCellLocals.cur_cell;
        this.m_lastLeavingPoint.set((Tuple3d)this.m_intersectionOutput.leavingPoint);
        this.m_lastLeavingPart = this.m_intersectionOutput.leavingPart;
    }

    private void getFirstCellFromPoint(Point3d point3d) {
        this.m_firstCellLocals.x = (int)Math.floor((point3d.x - (double)this.m_root.getMinValues().x) / (double)this.m_lengthX[0] * (double)this.m_maxDivisionX);
        this.m_firstCellLocals.y = (int)Math.floor((point3d.y - (double)this.m_root.getMinValues().y) / (double)this.m_lengthY[0] * (double)this.m_maxDivisionX);
        this.m_firstCellLocals.z = (int)Math.floor((point3d.z - (double)this.m_root.getMinValues().z) / (double)this.m_lengthZ[0] * (double)this.m_maxDivisionX);
        if (this.m_firstCellLocals.x >= this.m_maxDivisionX) {
            this.m_firstCellLocals.x = this.m_maxDivisionX - 1;
        }
        if (this.m_firstCellLocals.y >= this.m_maxDivisionX) {
            this.m_firstCellLocals.y = this.m_maxDivisionX - 1;
        }
        if (this.m_firstCellLocals.z >= this.m_maxDivisionX) {
            this.m_firstCellLocals.z = this.m_maxDivisionX - 1;
        }
        this.getCellFromPoint(this.m_firstCellLocals.x, this.m_firstCellLocals.y, this.m_firstCellLocals.z);
    }

    private void getCellFromPoint(int n, int n2, int n3) {
        this.m_firstCellLocals.cur_cell = this.m_root;
        for (int i = 0; i < this.m_maxDepth && this.m_firstCellLocals.cur_cell.hasChildren(); ++i) {
            this.m_firstCellLocals.shift = this.m_maxDepth - 1 - i;
            this.m_firstCellLocals.bit_mask = 1 << this.m_firstCellLocals.shift;
            this.m_firstCellLocals.bit_x = (n & this.m_firstCellLocals.bit_mask) >> this.m_firstCellLocals.shift;
            this.m_firstCellLocals.bit_y = (n2 & this.m_firstCellLocals.bit_mask) >> this.m_firstCellLocals.shift;
            this.m_firstCellLocals.bit_z = (n3 & this.m_firstCellLocals.bit_mask) >> this.m_firstCellLocals.shift;
            this.m_firstCellLocals.child = (this.m_firstCellLocals.bit_x << 2) + (this.m_firstCellLocals.bit_y << 1) + this.m_firstCellLocals.bit_z;
            this.m_firstCellLocals.cur_cell = this.m_firstCellLocals.cur_cell.getChild(this.m_firstCellLocals.child);
        }
    }

    private void getFirstCellFromOutside() {
        this.m_isFirstCell = true;
        switch (this.m_intersectionOutput.enteringPart) {
            case 1: {
                this.m_firstCellLocals.y = 0;
                this.m_firstCellLocals.x = (int)Math.floor((this.m_intersectionOutput.enteringPoint.x - (double)this.m_root.getMinValues().x) / (double)this.m_lengthX[0] * (double)this.m_maxDivisionX);
                this.m_firstCellLocals.z = (int)Math.floor((this.m_intersectionOutput.enteringPoint.z - (double)this.m_root.getMinValues().z) / (double)this.m_lengthZ[0] * (double)this.m_maxDivisionX);
                if (this.m_firstCellLocals.x >= this.m_maxDivisionX) {
                    this.m_firstCellLocals.x = this.m_maxDivisionX - 1;
                }
                if (this.m_firstCellLocals.z < this.m_maxDivisionX) break;
                this.m_firstCellLocals.z = this.m_maxDivisionX - 1;
                break;
            }
            case 2: {
                this.m_firstCellLocals.y = this.m_maxDivisionX - 1;
                this.m_firstCellLocals.x = (int)Math.floor((this.m_intersectionOutput.enteringPoint.x - (double)this.m_root.getMinValues().x) / (double)this.m_lengthX[0] * (double)this.m_maxDivisionX);
                this.m_firstCellLocals.z = (int)Math.floor((this.m_intersectionOutput.enteringPoint.z - (double)this.m_root.getMinValues().z) / (double)this.m_lengthZ[0] * (double)this.m_maxDivisionX);
                if (this.m_firstCellLocals.x >= this.m_maxDivisionX) {
                    this.m_firstCellLocals.x = this.m_maxDivisionX - 1;
                }
                if (this.m_firstCellLocals.z < this.m_maxDivisionX) break;
                this.m_firstCellLocals.z = this.m_maxDivisionX - 1;
                break;
            }
            case 3: {
                this.m_firstCellLocals.z = this.m_maxDivisionX - 1;
                this.m_firstCellLocals.x = (int)Math.floor((this.m_intersectionOutput.enteringPoint.x - (double)this.m_root.getMinValues().x) / (double)this.m_lengthX[0] * (double)this.m_maxDivisionX);
                this.m_firstCellLocals.y = (int)Math.floor((this.m_intersectionOutput.enteringPoint.y - (double)this.m_root.getMinValues().y) / (double)this.m_lengthY[0] * (double)this.m_maxDivisionX);
                if (this.m_firstCellLocals.x >= this.m_maxDivisionX) {
                    System.err.println("***");
                    this.m_firstCellLocals.x = this.m_maxDivisionX - 1;
                }
                if (this.m_firstCellLocals.y < this.m_maxDivisionX) break;
                System.err.println("***");
                this.m_firstCellLocals.y = this.m_maxDivisionX - 1;
                break;
            }
            case 4: {
                this.m_firstCellLocals.z = 0;
                this.m_firstCellLocals.x = (int)Math.floor((this.m_intersectionOutput.enteringPoint.x - (double)this.m_root.getMinValues().x) / (double)this.m_lengthX[0] * (double)this.m_maxDivisionX);
                this.m_firstCellLocals.y = (int)Math.floor((this.m_intersectionOutput.enteringPoint.y - (double)this.m_root.getMinValues().y) / (double)this.m_lengthY[0] * (double)this.m_maxDivisionX);
                if (this.m_firstCellLocals.x >= this.m_maxDivisionX) {
                    this.m_firstCellLocals.x = this.m_maxDivisionX - 1;
                }
                if (this.m_firstCellLocals.y < this.m_maxDivisionX) break;
                this.m_firstCellLocals.y = this.m_maxDivisionX - 1;
                break;
            }
            case 5: {
                this.m_firstCellLocals.x = 0;
                this.m_firstCellLocals.y = (int)Math.floor((this.m_intersectionOutput.enteringPoint.y - (double)this.m_root.getMinValues().y) / (double)this.m_lengthY[0] * (double)this.m_maxDivisionX);
                this.m_firstCellLocals.z = (int)Math.floor((this.m_intersectionOutput.enteringPoint.z - (double)this.m_root.getMinValues().z) / (double)this.m_lengthZ[0] * (double)this.m_maxDivisionX);
                if (this.m_firstCellLocals.y >= this.m_maxDivisionX) {
                    this.m_firstCellLocals.y = this.m_maxDivisionX - 1;
                }
                if (this.m_firstCellLocals.z < this.m_maxDivisionX) break;
                this.m_firstCellLocals.z = this.m_maxDivisionX - 1;
                break;
            }
            case 6: {
                this.m_firstCellLocals.x = this.m_maxDivisionX - 1;
                this.m_firstCellLocals.y = (int)Math.floor((this.m_intersectionOutput.enteringPoint.y - (double)this.m_root.getMinValues().y) / (double)this.m_lengthY[0] * (double)this.m_maxDivisionX);
                this.m_firstCellLocals.z = (int)Math.floor((this.m_intersectionOutput.enteringPoint.z - (double)this.m_root.getMinValues().z) / (double)this.m_lengthZ[0] * (double)this.m_maxDivisionX);
                if (this.m_firstCellLocals.y >= this.m_maxDivisionX) {
                    this.m_firstCellLocals.y = this.m_maxDivisionX - 1;
                }
                if (this.m_firstCellLocals.z < this.m_maxDivisionX) break;
                this.m_firstCellLocals.z = this.m_maxDivisionX - 1;
            }
        }
        this.m_firstCellLocals.cur_cell = this.m_root;
        for (int i = 0; i < this.m_maxDepth && this.m_firstCellLocals.cur_cell.hasChildren(); ++i) {
            this.m_firstCellLocals.shift = this.m_maxDepth - 1 - i;
            this.m_firstCellLocals.bit_mask = 1 << this.m_firstCellLocals.shift;
            this.m_firstCellLocals.bit_x = (this.m_firstCellLocals.x & this.m_firstCellLocals.bit_mask) >> this.m_firstCellLocals.shift;
            this.m_firstCellLocals.bit_y = (this.m_firstCellLocals.y & this.m_firstCellLocals.bit_mask) >> this.m_firstCellLocals.shift;
            this.m_firstCellLocals.bit_z = (this.m_firstCellLocals.z & this.m_firstCellLocals.bit_mask) >> this.m_firstCellLocals.shift;
            this.m_firstCellLocals.child = (this.m_firstCellLocals.bit_x << 2) + (this.m_firstCellLocals.bit_y << 1) + this.m_firstCellLocals.bit_z;
            this.m_firstCellLocals.cur_cell = this.m_firstCellLocals.cur_cell.getChild(this.m_firstCellLocals.child);
        }
        this.m_firstCellLocals.lastFirstCellFromOutside = this.m_firstCellLocals.cur_cell;
        this.m_firstCellLocals.lastPart = this.m_intersectionOutput.enteringPart;
    }

    private boolean testLastFirstCellResult() {
        if (this.m_firstCellLocals.lastFirstCellFromOutside == null) {
            return false;
        }
        switch (this.m_firstCellLocals.lastPart) {
            case 1: 
            case 2: {
                if (!(this.m_intersectionOutput.enteringPoint.x >= (double)this.m_firstCellLocals.lastFirstCellFromOutside.getMinValues().x) || !(this.m_intersectionOutput.enteringPoint.x <= (double)this.m_firstCellLocals.lastFirstCellFromOutside.getMaxValues().x) || !(this.m_intersectionOutput.enteringPoint.z >= (double)this.m_firstCellLocals.lastFirstCellFromOutside.getMinValues().z) || !(this.m_intersectionOutput.enteringPoint.z <= (double)this.m_firstCellLocals.lastFirstCellFromOutside.getMaxValues().z)) break;
                this.m_firstCellLocals.cur_cell = this.m_firstCellLocals.lastFirstCellFromOutside;
                return true;
            }
            case 3: 
            case 4: {
                if (!(this.m_intersectionOutput.enteringPoint.x >= (double)this.m_firstCellLocals.lastFirstCellFromOutside.getMinValues().x) || !(this.m_intersectionOutput.enteringPoint.x <= (double)this.m_firstCellLocals.lastFirstCellFromOutside.getMaxValues().x) || !(this.m_intersectionOutput.enteringPoint.y >= (double)this.m_firstCellLocals.lastFirstCellFromOutside.getMinValues().y) || !(this.m_intersectionOutput.enteringPoint.y <= (double)this.m_firstCellLocals.lastFirstCellFromOutside.getMaxValues().y)) break;
                this.m_firstCellLocals.cur_cell = this.m_firstCellLocals.lastFirstCellFromOutside;
                return true;
            }
            case 5: 
            case 6: {
                if (!(this.m_intersectionOutput.enteringPoint.y >= (double)this.m_firstCellLocals.lastFirstCellFromOutside.getMinValues().y) || !(this.m_intersectionOutput.enteringPoint.y <= (double)this.m_firstCellLocals.lastFirstCellFromOutside.getMaxValues().y) || !(this.m_intersectionOutput.enteringPoint.z >= (double)this.m_firstCellLocals.lastFirstCellFromOutside.getMinValues().z) || !(this.m_intersectionOutput.enteringPoint.z <= (double)this.m_firstCellLocals.lastFirstCellFromOutside.getMaxValues().z)) break;
                this.m_firstCellLocals.cur_cell = this.m_firstCellLocals.lastFirstCellFromOutside;
                return true;
            }
        }
        return false;
    }

    public void nextCell(CellGenerator.NextCellOutput nextCellOutput) {
        if (!this.m_hasNextCell) {
            nextCellOutput.nextCell = null;
            return;
        }
        if (this.m_isFirstCell) {
            this.m_isFirstCell = false;
            nextCellOutput.nextCell = this.m_firstCellLocals.cur_cell;
            nextCellOutput.leavingT = this.m_intersectionOutput.leavingT;
        } else {
            this.m_intersectionLocals.point.set((Tuple3f)this.m_lastLeavingPoint);
            switch (this.m_lastLeavingPart) {
                case 1: {
                    this.m_intersectionLocals.point.y -= this.m_lengthY[this.m_maxDepth + 1];
                    if (!(this.m_intersectionLocals.point.y < this.m_root.getMinValues().y)) break;
                    this.m_hasNextCell = false;
                    nextCellOutput.nextCell = null;
                    return;
                }
                case 2: {
                    this.m_intersectionLocals.point.y += this.m_lengthY[this.m_maxDepth + 1];
                    if (!(this.m_intersectionLocals.point.y > this.m_root.getMaxValues().y)) break;
                    this.m_hasNextCell = false;
                    nextCellOutput.nextCell = null;
                    return;
                }
                case 3: {
                    this.m_intersectionLocals.point.z += this.m_lengthZ[this.m_maxDepth + 1];
                    if (!(this.m_intersectionLocals.point.z > this.m_root.getMaxValues().z)) break;
                    this.m_hasNextCell = false;
                    nextCellOutput.nextCell = null;
                    return;
                }
                case 4: {
                    this.m_intersectionLocals.point.z -= this.m_lengthZ[this.m_maxDepth + 1];
                    if (!(this.m_intersectionLocals.point.z < this.m_root.getMinValues().z)) break;
                    this.m_hasNextCell = false;
                    nextCellOutput.nextCell = null;
                    return;
                }
                case 5: {
                    this.m_intersectionLocals.point.x -= this.m_lengthX[this.m_maxDepth + 1];
                    if (!(this.m_intersectionLocals.point.x < this.m_root.getMinValues().x)) break;
                    this.m_hasNextCell = false;
                    nextCellOutput.nextCell = null;
                    return;
                }
                case 6: {
                    this.m_intersectionLocals.point.x += this.m_lengthX[this.m_maxDepth + 1];
                    if (!(this.m_intersectionLocals.point.x > this.m_root.getMaxValues().x)) break;
                    this.m_hasNextCell = false;
                    nextCellOutput.nextCell = null;
                    return;
                }
                default: {
                    this.m_hasNextCell = false;
                    nextCellOutput.nextCell = null;
                    return;
                }
            }
            this.m_firstCellLocals.x = (int)Math.floor((this.m_intersectionLocals.point.x - this.m_root.getMinValues().x) / this.m_lengthX[0] * (float)this.m_maxDivisionX);
            this.m_firstCellLocals.y = (int)Math.floor((this.m_intersectionLocals.point.y - this.m_root.getMinValues().y) / this.m_lengthY[0] * (float)this.m_maxDivisionX);
            this.m_firstCellLocals.z = (int)Math.floor((this.m_intersectionLocals.point.z - this.m_root.getMinValues().z) / this.m_lengthZ[0] * (float)this.m_maxDivisionX);
            if (this.m_firstCellLocals.x >= this.m_maxDivisionX) {
                System.err.println("###");
                this.m_firstCellLocals.x = this.m_maxDivisionX - 1;
            }
            if (this.m_firstCellLocals.y >= this.m_maxDivisionX) {
                System.err.println("###");
                this.m_firstCellLocals.y = this.m_maxDivisionX - 1;
            }
            if (this.m_firstCellLocals.z >= this.m_maxDivisionX) {
                System.err.println("###");
                this.m_firstCellLocals.z = this.m_maxDivisionX - 1;
            }
            this.getCellFromPoint(this.m_firstCellLocals.x, this.m_firstCellLocals.y, this.m_firstCellLocals.z);
            if (nextCellOutput.nextCell == this.m_firstCellLocals.cur_cell) {
                nextCellOutput.errorOccurred = true;
                this.m_hasNextCell = true;
                nextCellOutput.nextCell = null;
                return;
            }
            this.m_intersectionInput.minValues.set((Tuple3f)this.m_firstCellLocals.cur_cell.getMinValues());
            this.m_intersectionInput.maxValues.set((Tuple3f)this.m_firstCellLocals.cur_cell.getMaxValues());
            this.getBoxLeavingIntersection(this.m_intersectionInput, this.m_intersectionLocals, this.m_intersectionOutput);
            this.m_lastCell = this.m_firstCellLocals.cur_cell;
            this.m_lastLeavingPoint.set((Tuple3d)this.m_intersectionOutput.leavingPoint);
            this.m_lastLeavingPart = this.m_intersectionOutput.leavingPart;
            nextCellOutput.nextCell = this.m_firstCellLocals.cur_cell;
            nextCellOutput.leavingT = this.m_intersectionOutput.leavingT;
        }
    }

    public static void getBoxEnteringIntersection(BoxIntersectionInput boxIntersectionInput, BoxIntersectionLocals boxIntersectionLocals, BoxIntersectionOutput boxIntersectionOutput) {
        boxIntersectionOutput.hasIntersection = false;
        if (boxIntersectionInput.direction.x > 0.0 && boxIntersectionInput.origin.x < (double)boxIntersectionInput.minValues.x) {
            boxIntersectionOutput.enteringT = ((double)boxIntersectionInput.minValues.x - boxIntersectionInput.origin.x) / boxIntersectionInput.direction.x;
            boxIntersectionOutput.enteringPoint.scaleAdd(boxIntersectionOutput.enteringT, (Tuple3d)boxIntersectionInput.direction, (Tuple3d)boxIntersectionInput.origin);
            if (boxIntersectionOutput.enteringPoint.y >= (double)boxIntersectionInput.minValues.y && boxIntersectionOutput.enteringPoint.y <= (double)boxIntersectionInput.maxValues.y && boxIntersectionOutput.enteringPoint.z >= (double)boxIntersectionInput.minValues.z && boxIntersectionOutput.enteringPoint.z <= (double)boxIntersectionInput.maxValues.z) {
                boxIntersectionOutput.hasIntersection = true;
                boxIntersectionOutput.enteringPart = 5;
                return;
            }
        }
        if (boxIntersectionInput.direction.y > 0.0 && boxIntersectionInput.origin.y < (double)boxIntersectionInput.minValues.y) {
            boxIntersectionOutput.enteringT = ((double)boxIntersectionInput.minValues.y - boxIntersectionInput.origin.y) / boxIntersectionInput.direction.y;
            boxIntersectionOutput.enteringPoint.scaleAdd(boxIntersectionOutput.enteringT, (Tuple3d)boxIntersectionInput.direction, (Tuple3d)boxIntersectionInput.origin);
            if (boxIntersectionOutput.enteringPoint.x >= (double)boxIntersectionInput.minValues.x && boxIntersectionOutput.enteringPoint.x <= (double)boxIntersectionInput.maxValues.x && boxIntersectionOutput.enteringPoint.z >= (double)boxIntersectionInput.minValues.z && boxIntersectionOutput.enteringPoint.z <= (double)boxIntersectionInput.maxValues.z) {
                boxIntersectionOutput.hasIntersection = true;
                boxIntersectionOutput.enteringPart = 1;
                return;
            }
        }
        if (boxIntersectionInput.direction.z > 0.0 && boxIntersectionInput.origin.z < (double)boxIntersectionInput.minValues.z) {
            boxIntersectionOutput.enteringT = ((double)boxIntersectionInput.minValues.z - boxIntersectionInput.origin.z) / boxIntersectionInput.direction.z;
            boxIntersectionOutput.enteringPoint.scaleAdd(boxIntersectionOutput.enteringT, (Tuple3d)boxIntersectionInput.direction, (Tuple3d)boxIntersectionInput.origin);
            if (boxIntersectionOutput.enteringPoint.x >= (double)boxIntersectionInput.minValues.x && boxIntersectionOutput.enteringPoint.x <= (double)boxIntersectionInput.maxValues.x && boxIntersectionOutput.enteringPoint.y >= (double)boxIntersectionInput.minValues.y && boxIntersectionOutput.enteringPoint.y <= (double)boxIntersectionInput.maxValues.y) {
                boxIntersectionOutput.hasIntersection = true;
                boxIntersectionOutput.enteringPart = 4;
                return;
            }
        }
        if (boxIntersectionInput.direction.x < 0.0 && boxIntersectionInput.origin.x > (double)boxIntersectionInput.maxValues.x) {
            boxIntersectionOutput.enteringT = ((double)boxIntersectionInput.maxValues.x - boxIntersectionInput.origin.x) / boxIntersectionInput.direction.x;
            boxIntersectionOutput.enteringPoint.scaleAdd(boxIntersectionOutput.enteringT, (Tuple3d)boxIntersectionInput.direction, (Tuple3d)boxIntersectionInput.origin);
            if (boxIntersectionOutput.enteringPoint.y >= (double)boxIntersectionInput.minValues.y && boxIntersectionOutput.enteringPoint.y <= (double)boxIntersectionInput.maxValues.y && boxIntersectionOutput.enteringPoint.z >= (double)boxIntersectionInput.minValues.z && boxIntersectionOutput.enteringPoint.z <= (double)boxIntersectionInput.maxValues.z) {
                boxIntersectionOutput.hasIntersection = true;
                boxIntersectionOutput.enteringPart = 6;
                return;
            }
        }
        if (boxIntersectionInput.direction.y < 0.0 && boxIntersectionInput.origin.y > (double)boxIntersectionInput.maxValues.y) {
            boxIntersectionOutput.enteringT = ((double)boxIntersectionInput.maxValues.y - boxIntersectionInput.origin.y) / boxIntersectionInput.direction.y;
            boxIntersectionOutput.enteringPoint.scaleAdd(boxIntersectionOutput.enteringT, (Tuple3d)boxIntersectionInput.direction, (Tuple3d)boxIntersectionInput.origin);
            if (boxIntersectionOutput.enteringPoint.x >= (double)boxIntersectionInput.minValues.x && boxIntersectionOutput.enteringPoint.x <= (double)boxIntersectionInput.maxValues.x && boxIntersectionOutput.enteringPoint.z >= (double)boxIntersectionInput.minValues.z && boxIntersectionOutput.enteringPoint.z <= (double)boxIntersectionInput.maxValues.z) {
                boxIntersectionOutput.hasIntersection = true;
                boxIntersectionOutput.enteringPart = 2;
                return;
            }
        }
        if (boxIntersectionInput.direction.z < 0.0 && boxIntersectionInput.origin.z > (double)boxIntersectionInput.maxValues.z) {
            boxIntersectionOutput.enteringT = ((double)boxIntersectionInput.maxValues.z - boxIntersectionInput.origin.z) / boxIntersectionInput.direction.z;
            boxIntersectionOutput.enteringPoint.scaleAdd(boxIntersectionOutput.enteringT, (Tuple3d)boxIntersectionInput.direction, (Tuple3d)boxIntersectionInput.origin);
            if (boxIntersectionOutput.enteringPoint.x >= (double)boxIntersectionInput.minValues.x && boxIntersectionOutput.enteringPoint.x <= (double)boxIntersectionInput.maxValues.x && boxIntersectionOutput.enteringPoint.y >= (double)boxIntersectionInput.minValues.y && boxIntersectionOutput.enteringPoint.y <= (double)boxIntersectionInput.maxValues.y) {
                boxIntersectionOutput.hasIntersection = true;
                boxIntersectionOutput.enteringPart = 3;
                return;
            }
        }
    }

    public void getBoxLeavingIntersection(BoxIntersectionInput boxIntersectionInput, BoxIntersectionLocals boxIntersectionLocals, BoxIntersectionOutput boxIntersectionOutput) {
        if (boxIntersectionInput.direction.x > 0.0) {
            boxIntersectionOutput.leavingT = ((double)boxIntersectionInput.maxValues.x - boxIntersectionInput.origin.x) / boxIntersectionInput.direction.x;
            boxIntersectionOutput.leavingPoint.scaleAdd(boxIntersectionOutput.leavingT, (Tuple3d)boxIntersectionInput.direction, (Tuple3d)boxIntersectionInput.origin);
            if (boxIntersectionOutput.leavingPoint.y >= (double)boxIntersectionInput.minValues.y && boxIntersectionOutput.leavingPoint.y <= (double)boxIntersectionInput.maxValues.y && boxIntersectionOutput.leavingPoint.z >= (double)boxIntersectionInput.minValues.z && boxIntersectionOutput.leavingPoint.z <= (double)boxIntersectionInput.maxValues.z) {
                boxIntersectionOutput.leavingPart = 6;
                return;
            }
        }
        if (boxIntersectionInput.direction.x < 0.0) {
            boxIntersectionOutput.leavingT = ((double)boxIntersectionInput.minValues.x - boxIntersectionInput.origin.x) / boxIntersectionInput.direction.x;
            boxIntersectionOutput.leavingPoint.scaleAdd(boxIntersectionOutput.leavingT, (Tuple3d)boxIntersectionInput.direction, (Tuple3d)boxIntersectionInput.origin);
            if (boxIntersectionOutput.leavingPoint.y >= (double)boxIntersectionInput.minValues.y && boxIntersectionOutput.leavingPoint.y <= (double)boxIntersectionInput.maxValues.y && boxIntersectionOutput.leavingPoint.z >= (double)boxIntersectionInput.minValues.z && boxIntersectionOutput.leavingPoint.z <= (double)boxIntersectionInput.maxValues.z) {
                boxIntersectionOutput.leavingPart = 5;
                return;
            }
        }
        if (boxIntersectionInput.direction.y > 0.0) {
            boxIntersectionOutput.leavingT = ((double)boxIntersectionInput.maxValues.y - boxIntersectionInput.origin.y) / boxIntersectionInput.direction.y;
            boxIntersectionOutput.leavingPoint.scaleAdd(boxIntersectionOutput.leavingT, (Tuple3d)boxIntersectionInput.direction, (Tuple3d)boxIntersectionInput.origin);
            if (boxIntersectionOutput.leavingPoint.x >= (double)boxIntersectionInput.minValues.x && boxIntersectionOutput.leavingPoint.x <= (double)boxIntersectionInput.maxValues.x && boxIntersectionOutput.leavingPoint.z >= (double)boxIntersectionInput.minValues.z && boxIntersectionOutput.leavingPoint.z <= (double)boxIntersectionInput.maxValues.z) {
                boxIntersectionOutput.leavingPart = 2;
                return;
            }
        }
        if (boxIntersectionInput.direction.y < 0.0) {
            boxIntersectionOutput.leavingT = ((double)boxIntersectionInput.minValues.y - boxIntersectionInput.origin.y) / boxIntersectionInput.direction.y;
            boxIntersectionOutput.leavingPoint.scaleAdd(boxIntersectionOutput.leavingT, (Tuple3d)boxIntersectionInput.direction, (Tuple3d)boxIntersectionInput.origin);
            if (boxIntersectionOutput.leavingPoint.x >= (double)boxIntersectionInput.minValues.x && boxIntersectionOutput.leavingPoint.x <= (double)boxIntersectionInput.maxValues.x && boxIntersectionOutput.leavingPoint.z >= (double)boxIntersectionInput.minValues.z && boxIntersectionOutput.leavingPoint.z <= (double)boxIntersectionInput.maxValues.z) {
                boxIntersectionOutput.leavingPart = 1;
                return;
            }
        }
        if (boxIntersectionInput.direction.z > 0.0) {
            boxIntersectionOutput.leavingT = ((double)boxIntersectionInput.maxValues.z - boxIntersectionInput.origin.z) / boxIntersectionInput.direction.z;
            boxIntersectionOutput.leavingPoint.scaleAdd(boxIntersectionOutput.leavingT, (Tuple3d)boxIntersectionInput.direction, (Tuple3d)boxIntersectionInput.origin);
            if (boxIntersectionOutput.leavingPoint.x >= (double)boxIntersectionInput.minValues.x && boxIntersectionOutput.leavingPoint.x <= (double)boxIntersectionInput.maxValues.x && boxIntersectionOutput.leavingPoint.y >= (double)boxIntersectionInput.minValues.y && boxIntersectionOutput.leavingPoint.y <= (double)boxIntersectionInput.maxValues.y) {
                boxIntersectionOutput.leavingPart = 3;
                return;
            }
        }
        if (boxIntersectionInput.direction.z < 0.0) {
            boxIntersectionOutput.leavingT = ((double)boxIntersectionInput.minValues.z - boxIntersectionInput.origin.z) / boxIntersectionInput.direction.z;
            boxIntersectionOutput.leavingPoint.scaleAdd(boxIntersectionOutput.leavingT, (Tuple3d)boxIntersectionInput.direction, (Tuple3d)boxIntersectionInput.origin);
            if (boxIntersectionOutput.leavingPoint.x >= (double)boxIntersectionInput.minValues.x && boxIntersectionOutput.leavingPoint.x <= (double)boxIntersectionInput.maxValues.x && boxIntersectionOutput.leavingPoint.y >= (double)boxIntersectionInput.minValues.y && boxIntersectionOutput.leavingPoint.y <= (double)boxIntersectionInput.maxValues.y) {
                boxIntersectionOutput.leavingPart = 4;
                return;
            }
        }
        boxIntersectionOutput.leavingPart = 0;
    }

    public class BoxIntersectionLocals {
        public final Point3f point = new Point3f();
    }

    public class BoxIntersectionOutput {
        public boolean hasIntersection;
        public double enteringT;
        public final Point3d enteringPoint = new Point3d();
        public int enteringPart;
        public double leavingT;
        public final Point3d leavingPoint = new Point3d();
        public int leavingPart;
    }

    public class BoxIntersectionInput {
        public final Point3d origin = new Point3d();
        public final Vector3d direction = new Vector3d();
        public final Vector3f minValues = new Vector3f();
        public final Vector3f maxValues = new Vector3f();
    }

    public class FirstCellLocals {
        public int x;
        public int y;
        public int z;
        public int cur_depth;
        public OctreeCell cur_cell;
        public int bit_x;
        public int bit_y;
        public int bit_z;
        public int shift;
        public int bit_mask;
        public int child;
        public int lastPart;
        public OctreeCell lastFirstCellFromOutside;
    }
}

