/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray;

import de.grogra.ray.RTCamera;
import de.grogra.ray.RTResources;
import de.grogra.ray.RTScene;
import de.grogra.ray.Raytracer;
import de.grogra.ray.quality.Quality;
import de.grogra.ray.quality.Timer;
import de.grogra.ray.tracing.PhotonMapping;

public class PhotonMapRaytracer
extends Raytracer {
    private int m_imageUpdateDistance = 0;
    private int photonCount = 0;
    private int range = 0;
    private static int old_stamp = -1;
    private static int old_photonCount = -1;
    private static int old_raytracingDepth = -1;

    protected void prepareRaytracing(RTScene rTScene, RTCamera rTCamera) {
        this.m_imageUpdateDistance = this.photonCount / 100;
        Timer timer = Quality.getQualityKit().getTimer("timer.preparing");
        timer.reset();
        this.fire_progressChanged(0, 0.0, RTResources.getString("de.grogra.ray.progress.raytracer.preprocessing.prepareIntersection"), 0, 0, 0, 0);
        timer.start();
        this.m_intersectionProcessor.prepareProcessing(rTScene);
        timer.stop();
        this.fire_progressChanged(0, 0.1, RTResources.getString("de.grogra.ray.progress.raytracer.preprocessing.prepareRaytracing"), 0, 0, 0, 0);
        timer.start();
        if (!this.m_rayProcessor.hasFixedLightProcessor()) {
            this.m_rayProcessor.setLightProcessor(this.m_lightProcessor);
        }
        this.m_rayProcessor.setRecursionDepth(this.m_raytracingDepth);
        ((PhotonMapping)this.m_rayProcessor).setPhotonCount(this.photonCount);
        ((PhotonMapping)this.m_rayProcessor).setRang(this.range);
        this.m_rayProcessor.prepareRayProcessor(rTScene, this.m_intersectionProcessor);
        if (old_stamp != rTScene.getStamp() || old_photonCount != this.photonCount || old_raytracingDepth != this.m_raytracingDepth) {
            ((PhotonMapping)this.m_rayProcessor).clear();
            for (int i = 0; i < this.photonCount; ++i) {
                if (Thread.interrupted()) {
                    return;
                }
                ((PhotonMapping)this.m_rayProcessor).createPhotonMap();
                if (i % this.m_imageUpdateDistance != 0) continue;
                this.fire_progressChanged(0, (double)i / (double)this.photonCount, RTResources.getString("de.grogra.ray.progress.raytracer.preprocessing.prepareRaytracing") + " - " + super.percentToString((double)i / (double)this.photonCount * 100.0), 0, 0, 0, 0);
            }
            old_stamp = rTScene.getStamp();
            old_photonCount = this.photonCount;
            old_raytracingDepth = this.m_raytracingDepth;
        }
        this.m_antialising.initialize(rTCamera, this.m_rayProcessor);
        timer.stop();
        this.fire_progressChanged(0, 1.0, RTResources.getString("de.grogra.ray.progress.done"), 0, 0, 0, 0);
    }

    public void setPhotonCount(int n) {
        this.photonCount = n;
    }

    public void setRange(int n) {
        this.range = n;
    }
}

