/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.block;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.List;
import org.jfree.chart.block.Arrangement;
import org.jfree.chart.block.Block;
import org.jfree.chart.block.BlockContainer;
import org.jfree.chart.block.LengthConstraintType;
import org.jfree.chart.block.RectangleConstraint;
import org.jfree.ui.Size2D;

public class GridArrangement
implements Arrangement,
Serializable {
    private static final long serialVersionUID = -2563758090144655938L;
    private int rows;
    private int columns;

    public GridArrangement(int n, int n2) {
        this.rows = n;
        this.columns = n2;
    }

    public void add(Block block, Object object) {
    }

    public Size2D arrange(BlockContainer blockContainer, Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        LengthConstraintType lengthConstraintType = rectangleConstraint.getWidthConstraintType();
        LengthConstraintType lengthConstraintType2 = rectangleConstraint.getHeightConstraintType();
        if (lengthConstraintType == LengthConstraintType.NONE) {
            if (lengthConstraintType2 == LengthConstraintType.NONE) {
                return this.arrangeNN(blockContainer, graphics2D);
            }
            if (lengthConstraintType2 == LengthConstraintType.FIXED) {
                throw new RuntimeException("Not yet implemented.");
            }
            if (lengthConstraintType2 == LengthConstraintType.RANGE) {
                throw new RuntimeException("Not yet implemented.");
            }
        } else if (lengthConstraintType == LengthConstraintType.FIXED) {
            if (lengthConstraintType2 == LengthConstraintType.NONE) {
                return this.arrangeFN(blockContainer, graphics2D, rectangleConstraint);
            }
            if (lengthConstraintType2 == LengthConstraintType.FIXED) {
                return this.arrangeFF(blockContainer, graphics2D, rectangleConstraint);
            }
            if (lengthConstraintType2 == LengthConstraintType.RANGE) {
                return this.arrangeFR(blockContainer, graphics2D, rectangleConstraint);
            }
        } else if (lengthConstraintType == LengthConstraintType.RANGE) {
            if (lengthConstraintType2 == LengthConstraintType.NONE) {
                throw new RuntimeException("Not yet implemented.");
            }
            if (lengthConstraintType2 == LengthConstraintType.FIXED) {
                throw new RuntimeException("Not yet implemented.");
            }
            if (lengthConstraintType2 == LengthConstraintType.RANGE) {
                throw new RuntimeException("Not yet implemented.");
            }
        }
        return new Size2D();
    }

    protected Size2D arrangeNN(BlockContainer blockContainer, Graphics2D graphics2D) {
        double d = 0.0;
        double d2 = 0.0;
        List list = blockContainer.getBlocks();
        for (Block block : list) {
            Size2D size2D = block.arrange(graphics2D, RectangleConstraint.NONE);
            d = Math.max(d, size2D.width);
            d2 = Math.max(d2, size2D.height);
        }
        double d3 = (double)this.columns * d;
        double d4 = (double)this.rows * d2;
        RectangleConstraint rectangleConstraint = new RectangleConstraint(d3, d4);
        return this.arrangeFF(blockContainer, graphics2D, rectangleConstraint);
    }

    protected Size2D arrangeFF(BlockContainer blockContainer, Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        double d = rectangleConstraint.getWidth() / (double)this.columns;
        double d2 = rectangleConstraint.getHeight() / (double)this.rows;
        List list = blockContainer.getBlocks();
        for (int i = 0; i < this.columns; ++i) {
            int n;
            for (int j = 0; j < this.rows && (n = j * this.columns + i) != list.size(); ++j) {
                Block block = (Block)list.get(n);
                block.setBounds(new Rectangle2D.Double((double)i * d, (double)j * d2, d, d2));
            }
        }
        return new Size2D((double)this.columns * d, (double)this.rows * d2);
    }

    protected Size2D arrangeFR(BlockContainer blockContainer, Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        RectangleConstraint rectangleConstraint2 = rectangleConstraint.toUnconstrainedHeight();
        Size2D size2D = this.arrange(blockContainer, graphics2D, rectangleConstraint2);
        if (rectangleConstraint.getHeightRange().contains(size2D.getHeight())) {
            return size2D;
        }
        double d = rectangleConstraint.getHeightRange().constrain(size2D.getHeight());
        RectangleConstraint rectangleConstraint3 = rectangleConstraint.toFixedHeight(d);
        return this.arrange(blockContainer, graphics2D, rectangleConstraint3);
    }

    protected Size2D arrangeFN(BlockContainer blockContainer, Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        double d = rectangleConstraint.getWidth() / (double)this.columns;
        RectangleConstraint rectangleConstraint2 = rectangleConstraint.toFixedWidth(d);
        List list = blockContainer.getBlocks();
        double d2 = 0.0;
        for (int i = 0; i < this.rows; ++i) {
            int n;
            for (int j = 0; j < this.columns && (n = i * this.columns + j) != list.size(); ++j) {
                Block block = (Block)list.get(n);
                Size2D size2D = block.arrange(graphics2D, rectangleConstraint2);
                d2 = Math.max(d2, size2D.getHeight());
            }
        }
        RectangleConstraint rectangleConstraint3 = rectangleConstraint.toFixedHeight(d2 * (double)this.rows);
        return this.arrange(blockContainer, graphics2D, rectangleConstraint3);
    }

    public void clear() {
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GridArrangement)) {
            return false;
        }
        GridArrangement gridArrangement = (GridArrangement)object;
        if (this.columns != gridArrangement.columns) {
            return false;
        }
        return this.rows == gridArrangement.rows;
    }
}

