/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.block;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.block.Arrangement;
import org.jfree.chart.block.Block;
import org.jfree.chart.block.BlockContainer;
import org.jfree.chart.block.LengthConstraintType;
import org.jfree.chart.block.RectangleConstraint;
import org.jfree.data.Range;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.Size2D;
import org.jfree.util.ObjectUtilities;

public class BorderArrangement
implements Arrangement,
Serializable {
    private static final long serialVersionUID = 506071142274883745L;
    private Block centerBlock;
    private Block topBlock;
    private Block bottomBlock;
    private Block leftBlock;
    private Block rightBlock;

    public void add(Block block, Object object) {
        if (object == null) {
            this.centerBlock = block;
        } else {
            RectangleEdge rectangleEdge = (RectangleEdge)object;
            if (rectangleEdge == RectangleEdge.TOP) {
                this.topBlock = block;
            } else if (rectangleEdge == RectangleEdge.BOTTOM) {
                this.bottomBlock = block;
            } else if (rectangleEdge == RectangleEdge.LEFT) {
                this.leftBlock = block;
            } else if (rectangleEdge == RectangleEdge.RIGHT) {
                this.rightBlock = block;
            }
        }
    }

    public Size2D arrange(BlockContainer blockContainer, Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        RectangleConstraint rectangleConstraint2 = blockContainer.toContentConstraint(rectangleConstraint);
        Size2D size2D = null;
        LengthConstraintType lengthConstraintType = rectangleConstraint2.getWidthConstraintType();
        LengthConstraintType lengthConstraintType2 = rectangleConstraint2.getHeightConstraintType();
        if (lengthConstraintType == LengthConstraintType.NONE) {
            if (lengthConstraintType2 == LengthConstraintType.NONE) {
                size2D = this.arrangeNN(blockContainer, graphics2D);
            } else {
                if (lengthConstraintType2 == LengthConstraintType.FIXED) {
                    throw new RuntimeException("Not implemented.");
                }
                if (lengthConstraintType2 == LengthConstraintType.RANGE) {
                    throw new RuntimeException("Not implemented.");
                }
            }
        } else if (lengthConstraintType == LengthConstraintType.FIXED) {
            if (lengthConstraintType2 == LengthConstraintType.NONE) {
                size2D = this.arrangeFN(blockContainer, graphics2D, rectangleConstraint.getWidth());
            } else if (lengthConstraintType2 == LengthConstraintType.FIXED) {
                size2D = this.arrangeFF(blockContainer, graphics2D, rectangleConstraint);
            } else if (lengthConstraintType2 == LengthConstraintType.RANGE) {
                size2D = this.arrangeFR(blockContainer, graphics2D, rectangleConstraint);
            }
        } else if (lengthConstraintType == LengthConstraintType.RANGE) {
            if (lengthConstraintType2 == LengthConstraintType.NONE) {
                throw new RuntimeException("Not implemented.");
            }
            if (lengthConstraintType2 == LengthConstraintType.FIXED) {
                throw new RuntimeException("Not implemented.");
            }
            if (lengthConstraintType2 == LengthConstraintType.RANGE) {
                size2D = this.arrangeRR(blockContainer, rectangleConstraint.getWidthRange(), rectangleConstraint.getHeightRange(), graphics2D);
            }
        }
        return new Size2D(blockContainer.calculateTotalWidth(size2D.getWidth()), blockContainer.calculateTotalHeight(size2D.getHeight()));
    }

    protected Size2D arrangeNN(BlockContainer blockContainer, Graphics2D graphics2D) {
        Size2D size2D;
        double[] dArray = new double[5];
        double[] dArray2 = new double[5];
        if (this.topBlock != null) {
            size2D = this.topBlock.arrange(graphics2D, RectangleConstraint.NONE);
            dArray[0] = size2D.width;
            dArray2[0] = size2D.height;
        }
        if (this.bottomBlock != null) {
            size2D = this.bottomBlock.arrange(graphics2D, RectangleConstraint.NONE);
            dArray[1] = size2D.width;
            dArray2[1] = size2D.height;
        }
        if (this.leftBlock != null) {
            size2D = this.leftBlock.arrange(graphics2D, RectangleConstraint.NONE);
            dArray[2] = size2D.width;
            dArray2[2] = size2D.height;
        }
        if (this.rightBlock != null) {
            size2D = this.rightBlock.arrange(graphics2D, RectangleConstraint.NONE);
            dArray[3] = size2D.width;
            dArray2[3] = size2D.height;
        }
        dArray2[2] = Math.max(dArray2[2], dArray2[3]);
        dArray2[3] = dArray2[2];
        if (this.centerBlock != null) {
            size2D = this.centerBlock.arrange(graphics2D, RectangleConstraint.NONE);
            dArray[4] = size2D.width;
            dArray2[4] = size2D.height;
        }
        double d = Math.max(dArray[0], Math.max(dArray[1], dArray[2] + dArray[4] + dArray[3]));
        double d2 = Math.max(dArray2[2], Math.max(dArray2[3], dArray2[4]));
        double d3 = dArray2[0] + dArray2[1] + d2;
        if (this.topBlock != null) {
            this.topBlock.setBounds(new Rectangle2D.Double(0.0, 0.0, d, dArray2[0]));
        }
        if (this.bottomBlock != null) {
            this.bottomBlock.setBounds(new Rectangle2D.Double(0.0, d3 - dArray2[1], d, dArray2[1]));
        }
        if (this.leftBlock != null) {
            this.leftBlock.setBounds(new Rectangle2D.Double(0.0, dArray2[0], dArray[2], d2));
        }
        if (this.rightBlock != null) {
            this.rightBlock.setBounds(new Rectangle2D.Double(d - dArray[3], dArray2[0], dArray[3], d2));
        }
        if (this.centerBlock != null) {
            this.centerBlock.setBounds(new Rectangle2D.Double(dArray[2], dArray2[0], d - dArray[2] - dArray[3], d2));
        }
        return new Size2D(d, d3);
    }

    protected Size2D arrangeFR(BlockContainer blockContainer, Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        Size2D size2D = this.arrangeFN(blockContainer, graphics2D, rectangleConstraint.getWidth());
        if (rectangleConstraint.getHeightRange().contains(size2D.getHeight())) {
            return size2D;
        }
        double d = rectangleConstraint.getHeightRange().constrain(size2D.getHeight());
        RectangleConstraint rectangleConstraint2 = rectangleConstraint.toFixedHeight(d);
        return this.arrange(blockContainer, graphics2D, rectangleConstraint2);
    }

    protected Size2D arrangeFN(BlockContainer blockContainer, Graphics2D graphics2D, double d) {
        Object object;
        Object object2;
        double[] dArray = new double[5];
        double[] dArray2 = new double[5];
        RectangleConstraint rectangleConstraint = new RectangleConstraint(d, null, LengthConstraintType.FIXED, 0.0, null, LengthConstraintType.NONE);
        if (this.topBlock != null) {
            object2 = this.topBlock.arrange(graphics2D, rectangleConstraint);
            dArray[0] = object2.width;
            dArray2[0] = object2.height;
        }
        if (this.bottomBlock != null) {
            object2 = this.bottomBlock.arrange(graphics2D, rectangleConstraint);
            dArray[1] = object2.width;
            dArray2[1] = object2.height;
        }
        object2 = new RectangleConstraint(0.0, new Range(0.0, d), LengthConstraintType.RANGE, 0.0, null, LengthConstraintType.NONE);
        if (this.leftBlock != null) {
            object = this.leftBlock.arrange(graphics2D, (RectangleConstraint)object2);
            dArray[2] = object.width;
            dArray2[2] = object.height;
        }
        if (this.rightBlock != null) {
            double d2 = Math.max(d - dArray[2], 0.0);
            RectangleConstraint rectangleConstraint2 = new RectangleConstraint(0.0, new Range(Math.min(dArray[2], d2), d2), LengthConstraintType.RANGE, 0.0, null, LengthConstraintType.NONE);
            Size2D size2D = this.rightBlock.arrange(graphics2D, rectangleConstraint2);
            dArray[3] = size2D.width;
            dArray2[3] = size2D.height;
        }
        dArray2[2] = Math.max(dArray2[2], dArray2[3]);
        dArray2[3] = dArray2[2];
        if (this.centerBlock != null) {
            object = new RectangleConstraint(d - dArray[2] - dArray[3], null, LengthConstraintType.FIXED, 0.0, null, LengthConstraintType.NONE);
            Size2D size2D = this.centerBlock.arrange(graphics2D, (RectangleConstraint)object);
            dArray[4] = size2D.width;
            dArray2[4] = size2D.height;
        }
        double d3 = dArray2[0] + dArray2[1] + Math.max(dArray2[2], Math.max(dArray2[3], dArray2[4]));
        return this.arrange(blockContainer, graphics2D, new RectangleConstraint(d, d3));
    }

    protected Size2D arrangeRR(BlockContainer blockContainer, Range range, Range range2, Graphics2D graphics2D) {
        Object object;
        Object object2;
        Object object3;
        RectangleConstraint rectangleConstraint;
        double[] dArray = new double[5];
        double[] dArray2 = new double[5];
        if (this.topBlock != null) {
            rectangleConstraint = new RectangleConstraint(range, range2);
            object3 = this.topBlock.arrange(graphics2D, rectangleConstraint);
            dArray[0] = object3.width;
            dArray2[0] = object3.height;
        }
        if (this.bottomBlock != null) {
            rectangleConstraint = Range.shift((Range)range2, (double)(-dArray2[0]), (boolean)false);
            object3 = new RectangleConstraint(range, (Range)rectangleConstraint);
            object2 = this.bottomBlock.arrange(graphics2D, (RectangleConstraint)object3);
            dArray[1] = object2.width;
            dArray2[1] = object2.height;
        }
        rectangleConstraint = Range.shift((Range)range2, (double)(-(dArray2[0] + dArray2[1])));
        if (this.leftBlock != null) {
            object3 = new RectangleConstraint(range, (Range)rectangleConstraint);
            object2 = this.leftBlock.arrange(graphics2D, (RectangleConstraint)object3);
            dArray[2] = object2.width;
            dArray2[2] = object2.height;
        }
        object3 = Range.shift((Range)range, (double)(-dArray[2]), (boolean)false);
        if (this.rightBlock != null) {
            object2 = new RectangleConstraint((Range)object3, (Range)rectangleConstraint);
            object = this.rightBlock.arrange(graphics2D, (RectangleConstraint)object2);
            dArray[3] = object.width;
            dArray2[3] = object.height;
        }
        dArray2[2] = Math.max(dArray2[2], dArray2[3]);
        dArray2[3] = dArray2[2];
        object2 = Range.shift((Range)range, (double)(-(dArray[2] + dArray[3])), (boolean)false);
        if (this.centerBlock != null) {
            object = new RectangleConstraint((Range)object2, (Range)rectangleConstraint);
            Size2D size2D = this.centerBlock.arrange(graphics2D, (RectangleConstraint)object);
            dArray[4] = size2D.width;
            dArray2[4] = size2D.height;
        }
        double d = Math.max(dArray[0], Math.max(dArray[1], dArray[2] + dArray[4] + dArray[3]));
        double d2 = dArray2[0] + dArray2[1] + Math.max(dArray2[2], Math.max(dArray2[3], dArray2[4]));
        if (this.topBlock != null) {
            this.topBlock.setBounds(new Rectangle2D.Double(0.0, 0.0, d, dArray2[0]));
        }
        if (this.bottomBlock != null) {
            this.bottomBlock.setBounds(new Rectangle2D.Double(0.0, d2 - dArray2[1], d, dArray2[1]));
        }
        if (this.leftBlock != null) {
            this.leftBlock.setBounds(new Rectangle2D.Double(0.0, dArray2[0], dArray[2], dArray2[2]));
        }
        if (this.rightBlock != null) {
            this.rightBlock.setBounds(new Rectangle2D.Double(d - dArray[3], dArray2[0], dArray[3], dArray2[3]));
        }
        if (this.centerBlock != null) {
            this.centerBlock.setBounds(new Rectangle2D.Double(dArray[2], dArray2[0], d - dArray[2] - dArray[3], d2 - dArray2[0] - dArray2[1]));
        }
        return new Size2D(d, d2);
    }

    protected Size2D arrangeFF(BlockContainer blockContainer, Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        Size2D size2D;
        RectangleConstraint rectangleConstraint2;
        double[] dArray = new double[5];
        double[] dArray2 = new double[5];
        dArray[0] = rectangleConstraint.getWidth();
        if (this.topBlock != null) {
            rectangleConstraint2 = new RectangleConstraint(dArray[0], null, LengthConstraintType.FIXED, 0.0, new Range(0.0, rectangleConstraint.getHeight()), LengthConstraintType.RANGE);
            size2D = this.topBlock.arrange(graphics2D, rectangleConstraint2);
            dArray2[0] = size2D.height;
        }
        dArray[1] = dArray[0];
        if (this.bottomBlock != null) {
            rectangleConstraint2 = new RectangleConstraint(dArray[0], null, LengthConstraintType.FIXED, 0.0, new Range(0.0, rectangleConstraint.getHeight() - dArray2[0]), LengthConstraintType.RANGE);
            size2D = this.bottomBlock.arrange(graphics2D, rectangleConstraint2);
            dArray2[1] = size2D.height;
        }
        dArray2[2] = rectangleConstraint.getHeight() - dArray2[1] - dArray2[0];
        if (this.leftBlock != null) {
            rectangleConstraint2 = new RectangleConstraint(0.0, new Range(0.0, rectangleConstraint.getWidth()), LengthConstraintType.RANGE, dArray2[2], null, LengthConstraintType.FIXED);
            size2D = this.leftBlock.arrange(graphics2D, rectangleConstraint2);
            dArray[2] = size2D.width;
        }
        dArray2[3] = dArray2[2];
        if (this.rightBlock != null) {
            rectangleConstraint2 = new RectangleConstraint(0.0, new Range(0.0, rectangleConstraint.getWidth() - dArray[2]), LengthConstraintType.RANGE, dArray2[2], null, LengthConstraintType.FIXED);
            size2D = this.rightBlock.arrange(graphics2D, rectangleConstraint2);
            dArray[3] = size2D.width;
        }
        dArray2[4] = dArray2[2];
        dArray[4] = rectangleConstraint.getWidth() - dArray[3] - dArray[2];
        rectangleConstraint2 = new RectangleConstraint(dArray[4], dArray2[4]);
        if (this.centerBlock != null) {
            this.centerBlock.arrange(graphics2D, rectangleConstraint2);
        }
        if (this.topBlock != null) {
            this.topBlock.setBounds(new Rectangle2D.Double(0.0, 0.0, dArray[0], dArray2[0]));
        }
        if (this.bottomBlock != null) {
            this.bottomBlock.setBounds(new Rectangle2D.Double(0.0, dArray2[0] + dArray2[2], dArray[1], dArray2[1]));
        }
        if (this.leftBlock != null) {
            this.leftBlock.setBounds(new Rectangle2D.Double(0.0, dArray2[0], dArray[2], dArray2[2]));
        }
        if (this.rightBlock != null) {
            this.rightBlock.setBounds(new Rectangle2D.Double(dArray[2] + dArray[4], dArray2[0], dArray[3], dArray2[3]));
        }
        if (this.centerBlock != null) {
            this.centerBlock.setBounds(new Rectangle2D.Double(dArray[2], dArray2[0], dArray[4], dArray2[4]));
        }
        return new Size2D(rectangleConstraint.getWidth(), rectangleConstraint.getHeight());
    }

    public void clear() {
        this.centerBlock = null;
        this.topBlock = null;
        this.bottomBlock = null;
        this.leftBlock = null;
        this.rightBlock = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BorderArrangement)) {
            return false;
        }
        BorderArrangement borderArrangement = (BorderArrangement)object;
        if (!ObjectUtilities.equal((Object)this.topBlock, (Object)borderArrangement.topBlock)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.bottomBlock, (Object)borderArrangement.bottomBlock)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.leftBlock, (Object)borderArrangement.leftBlock)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.rightBlock, (Object)borderArrangement.rightBlock)) {
            return false;
        }
        return ObjectUtilities.equal((Object)this.centerBlock, (Object)borderArrangement.centerBlock);
    }
}

