/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.Tick;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.ValueTick;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.plot.Plot;
import org.jfree.data.Range;
import org.jfree.io.SerialUtilities;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public abstract class ValueAxis
extends Axis
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 3698345477322391456L;
    public static final Range DEFAULT_RANGE = new Range(0.0, 1.0);
    public static final boolean DEFAULT_AUTO_RANGE = true;
    public static final boolean DEFAULT_INVERTED = false;
    public static final double DEFAULT_AUTO_RANGE_MINIMUM_SIZE = 1.0E-8;
    public static final double DEFAULT_LOWER_MARGIN = 0.05;
    public static final double DEFAULT_UPPER_MARGIN = 0.05;
    public static final double DEFAULT_LOWER_BOUND = 0.0;
    public static final double DEFAULT_UPPER_BOUND = 1.0;
    public static final boolean DEFAULT_AUTO_TICK_UNIT_SELECTION = true;
    public static final int MAXIMUM_TICK_COUNT = 500;
    private boolean positiveArrowVisible = false;
    private boolean negativeArrowVisible = false;
    private transient Shape upArrow;
    private transient Shape downArrow;
    private transient Shape leftArrow;
    private transient Shape rightArrow;
    private boolean inverted = false;
    private Range range = DEFAULT_RANGE;
    private boolean autoRange = true;
    private double autoRangeMinimumSize = 1.0E-8;
    private double upperMargin = 0.05;
    private double lowerMargin = 0.05;
    private double fixedAutoRange = 0.0;
    private boolean autoTickUnitSelection = true;
    private TickUnitSource standardTickUnits;
    private int autoTickIndex;
    private boolean verticalTickLabels;

    protected ValueAxis(String string, TickUnitSource tickUnitSource) {
        super(string);
        this.standardTickUnits = tickUnitSource;
        Polygon polygon = new Polygon();
        polygon.addPoint(0, 0);
        polygon.addPoint(-2, 2);
        polygon.addPoint(2, 2);
        this.upArrow = polygon;
        Polygon polygon2 = new Polygon();
        polygon2.addPoint(0, 0);
        polygon2.addPoint(-2, -2);
        polygon2.addPoint(2, -2);
        this.downArrow = polygon2;
        Polygon polygon3 = new Polygon();
        polygon3.addPoint(0, 0);
        polygon3.addPoint(-2, -2);
        polygon3.addPoint(-2, 2);
        this.rightArrow = polygon3;
        Polygon polygon4 = new Polygon();
        polygon4.addPoint(0, 0);
        polygon4.addPoint(2, -2);
        polygon4.addPoint(2, 2);
        this.leftArrow = polygon4;
        this.verticalTickLabels = false;
    }

    public boolean isVerticalTickLabels() {
        return this.verticalTickLabels;
    }

    public void setVerticalTickLabels(boolean bl) {
        if (this.verticalTickLabels != bl) {
            this.verticalTickLabels = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public boolean isPositiveArrowVisible() {
        return this.positiveArrowVisible;
    }

    public void setPositiveArrowVisible(boolean bl) {
        this.positiveArrowVisible = bl;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public boolean isNegativeArrowVisible() {
        return this.negativeArrowVisible;
    }

    public void setNegativeArrowVisible(boolean bl) {
        this.negativeArrowVisible = bl;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Shape getUpArrow() {
        return this.upArrow;
    }

    public void setUpArrow(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'arrow' argument.");
        }
        this.upArrow = shape;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Shape getDownArrow() {
        return this.downArrow;
    }

    public void setDownArrow(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'arrow' argument.");
        }
        this.downArrow = shape;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Shape getLeftArrow() {
        return this.leftArrow;
    }

    public void setLeftArrow(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'arrow' argument.");
        }
        this.leftArrow = shape;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Shape getRightArrow() {
        return this.rightArrow;
    }

    public void setRightArrow(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'arrow' argument.");
        }
        this.rightArrow = shape;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    protected void drawAxisLine(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        Shape shape;
        AffineTransform affineTransform;
        Shape shape2;
        double d2;
        double d3;
        Line2D.Double double_ = null;
        if (rectangleEdge == RectangleEdge.TOP) {
            double_ = new Line2D.Double(rectangle2D.getX(), d, rectangle2D.getMaxX(), d);
        } else if (rectangleEdge == RectangleEdge.BOTTOM) {
            double_ = new Line2D.Double(rectangle2D.getX(), d, rectangle2D.getMaxX(), d);
        } else if (rectangleEdge == RectangleEdge.LEFT) {
            double_ = new Line2D.Double(d, rectangle2D.getY(), d, rectangle2D.getMaxY());
        } else if (rectangleEdge == RectangleEdge.RIGHT) {
            double_ = new Line2D.Double(d, rectangle2D.getY(), d, rectangle2D.getMaxY());
        }
        graphics2D.setPaint(this.getAxisLinePaint());
        graphics2D.setStroke(this.getAxisLineStroke());
        graphics2D.draw(double_);
        boolean bl = false;
        boolean bl2 = false;
        if (this.positiveArrowVisible) {
            if (this.inverted) {
                bl2 = true;
            } else {
                bl = true;
            }
        }
        if (this.negativeArrowVisible) {
            if (this.inverted) {
                bl = true;
            } else {
                bl2 = true;
            }
        }
        if (bl) {
            d3 = 0.0;
            d2 = 0.0;
            shape2 = null;
            if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
                d3 = rectangle2D.getMaxX();
                d2 = d;
                shape2 = this.rightArrow;
            } else if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
                d3 = d;
                d2 = rectangle2D.getMinY();
                shape2 = this.upArrow;
            }
            affineTransform = new AffineTransform();
            affineTransform.setToTranslation(d3, d2);
            shape = affineTransform.createTransformedShape(shape2);
            graphics2D.fill(shape);
            graphics2D.draw(shape);
        }
        if (bl2) {
            d3 = 0.0;
            d2 = 0.0;
            shape2 = null;
            if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
                d3 = rectangle2D.getMinX();
                d2 = d;
                shape2 = this.leftArrow;
            } else if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
                d3 = d;
                d2 = rectangle2D.getMaxY();
                shape2 = this.downArrow;
            }
            affineTransform = new AffineTransform();
            affineTransform.setToTranslation(d3, d2);
            shape = affineTransform.createTransformedShape(shape2);
            graphics2D.fill(shape);
            graphics2D.draw(shape);
        }
    }

    protected float[] calculateAnchorPoint(ValueTick valueTick, double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        RectangleInsets rectangleInsets = this.getTickLabelInsets();
        float[] fArray = new float[2];
        if (rectangleEdge == RectangleEdge.TOP) {
            fArray[0] = (float)this.valueToJava2D(valueTick.getValue(), rectangle2D, rectangleEdge);
            fArray[1] = (float)(d - rectangleInsets.getBottom() - 2.0);
        } else if (rectangleEdge == RectangleEdge.BOTTOM) {
            fArray[0] = (float)this.valueToJava2D(valueTick.getValue(), rectangle2D, rectangleEdge);
            fArray[1] = (float)(d + rectangleInsets.getTop() + 2.0);
        } else if (rectangleEdge == RectangleEdge.LEFT) {
            fArray[0] = (float)(d - rectangleInsets.getLeft() - 2.0);
            fArray[1] = (float)this.valueToJava2D(valueTick.getValue(), rectangle2D, rectangleEdge);
        } else if (rectangleEdge == RectangleEdge.RIGHT) {
            fArray[0] = (float)(d + rectangleInsets.getRight() + 2.0);
            fArray[1] = (float)this.valueToJava2D(valueTick.getValue(), rectangle2D, rectangleEdge);
        }
        return fArray;
    }

    protected AxisState drawTickMarksAndLabels(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        AxisState axisState = new AxisState(d);
        if (this.isAxisLineVisible()) {
            this.drawAxisLine(graphics2D, d, rectangle2D2, rectangleEdge);
        }
        double d2 = this.getTickMarkOutsideLength();
        double d3 = this.getTickMarkInsideLength();
        List list = this.refreshTicks(graphics2D, axisState, rectangle2D2, rectangleEdge);
        axisState.setTicks(list);
        graphics2D.setFont(this.getTickLabelFont());
        for (ValueTick valueTick : list) {
            if (this.isTickLabelsVisible()) {
                graphics2D.setPaint(this.getTickLabelPaint());
                float[] fArray = this.calculateAnchorPoint(valueTick, d, rectangle2D2, rectangleEdge);
                TextUtilities.drawRotatedString((String)valueTick.getText(), (Graphics2D)graphics2D, (float)fArray[0], (float)fArray[1], (TextAnchor)valueTick.getTextAnchor(), (double)valueTick.getAngle(), (TextAnchor)valueTick.getRotationAnchor());
            }
            if (!this.isTickMarksVisible()) continue;
            float f = (float)this.valueToJava2D(valueTick.getValue(), rectangle2D2, rectangleEdge);
            Line2D.Double double_ = null;
            graphics2D.setStroke(this.getTickMarkStroke());
            graphics2D.setPaint(this.getTickMarkPaint());
            if (rectangleEdge == RectangleEdge.LEFT) {
                double_ = new Line2D.Double(d - d2, f, d + d3, f);
            } else if (rectangleEdge == RectangleEdge.RIGHT) {
                double_ = new Line2D.Double(d + d2, f, d - d3, f);
            } else if (rectangleEdge == RectangleEdge.TOP) {
                double_ = new Line2D.Double(f, d - d2, f, d + d3);
            } else if (rectangleEdge == RectangleEdge.BOTTOM) {
                double_ = new Line2D.Double(f, d + d2, f, d - d3);
            }
            graphics2D.draw(double_);
        }
        double d4 = 0.0;
        if (this.isTickLabelsVisible()) {
            if (rectangleEdge == RectangleEdge.LEFT) {
                axisState.cursorLeft(d4 += this.findMaximumTickLabelWidth(list, graphics2D, rectangle2D, this.isVerticalTickLabels()));
            } else if (rectangleEdge == RectangleEdge.RIGHT) {
                d4 = this.findMaximumTickLabelWidth(list, graphics2D, rectangle2D, this.isVerticalTickLabels());
                axisState.cursorRight(d4);
            } else if (rectangleEdge == RectangleEdge.TOP) {
                d4 = this.findMaximumTickLabelHeight(list, graphics2D, rectangle2D, this.isVerticalTickLabels());
                axisState.cursorUp(d4);
            } else if (rectangleEdge == RectangleEdge.BOTTOM) {
                d4 = this.findMaximumTickLabelHeight(list, graphics2D, rectangle2D, this.isVerticalTickLabels());
                axisState.cursorDown(d4);
            }
        }
        return axisState;
    }

    public AxisSpace reserveSpace(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, RectangleEdge rectangleEdge, AxisSpace axisSpace) {
        Object object;
        if (axisSpace == null) {
            axisSpace = new AxisSpace();
        }
        if (!this.isVisible()) {
            return axisSpace;
        }
        double d = this.getFixedDimension();
        if (d > 0.0) {
            axisSpace.ensureAtLeast(d, rectangleEdge);
        }
        double d2 = 0.0;
        double d3 = 0.0;
        if (this.isTickLabelsVisible()) {
            graphics2D.setFont(this.getTickLabelFont());
            object = this.refreshTicks(graphics2D, new AxisState(), rectangle2D, rectangleEdge);
            if (RectangleEdge.isTopOrBottom((RectangleEdge)rectangleEdge)) {
                d2 = this.findMaximumTickLabelHeight((List)object, graphics2D, rectangle2D, this.isVerticalTickLabels());
            } else if (RectangleEdge.isLeftOrRight((RectangleEdge)rectangleEdge)) {
                d3 = this.findMaximumTickLabelWidth((List)object, graphics2D, rectangle2D, this.isVerticalTickLabels());
            }
        }
        object = this.getLabelEnclosure(graphics2D, rectangleEdge);
        double d4 = 0.0;
        double d5 = 0.0;
        if (RectangleEdge.isTopOrBottom((RectangleEdge)rectangleEdge)) {
            d4 = ((RectangularShape)object).getHeight();
            axisSpace.add(d4 + d2, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight((RectangleEdge)rectangleEdge)) {
            d5 = ((RectangularShape)object).getWidth();
            axisSpace.add(d5 + d3, rectangleEdge);
        }
        return axisSpace;
    }

    protected double findMaximumTickLabelHeight(List list, Graphics2D graphics2D, Rectangle2D rectangle2D, boolean bl) {
        RectangleInsets rectangleInsets = this.getTickLabelInsets();
        Font font = this.getTickLabelFont();
        double d = 0.0;
        if (bl) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            for (Tick tick : list) {
                Rectangle2D rectangle2D2 = TextUtilities.getTextBounds((String)tick.getText(), (Graphics2D)graphics2D, (FontMetrics)fontMetrics);
                if (!(rectangle2D2.getWidth() + rectangleInsets.getTop() + rectangleInsets.getBottom() > d)) continue;
                d = rectangle2D2.getWidth() + rectangleInsets.getTop() + rectangleInsets.getBottom();
            }
        } else {
            LineMetrics lineMetrics = font.getLineMetrics("ABCxyz", graphics2D.getFontRenderContext());
            d = (double)lineMetrics.getHeight() + rectangleInsets.getTop() + rectangleInsets.getBottom();
        }
        return d;
    }

    protected double findMaximumTickLabelWidth(List list, Graphics2D graphics2D, Rectangle2D rectangle2D, boolean bl) {
        RectangleInsets rectangleInsets = this.getTickLabelInsets();
        Font font = this.getTickLabelFont();
        double d = 0.0;
        if (!bl) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            for (Tick tick : list) {
                Rectangle2D rectangle2D2 = TextUtilities.getTextBounds((String)tick.getText(), (Graphics2D)graphics2D, (FontMetrics)fontMetrics);
                if (!(rectangle2D2.getWidth() + rectangleInsets.getLeft() + rectangleInsets.getRight() > d)) continue;
                d = rectangle2D2.getWidth() + rectangleInsets.getLeft() + rectangleInsets.getRight();
            }
        } else {
            LineMetrics lineMetrics = font.getLineMetrics("ABCxyz", graphics2D.getFontRenderContext());
            d = (double)lineMetrics.getHeight() + rectangleInsets.getTop() + rectangleInsets.getBottom();
        }
        return d;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean bl) {
        if (this.inverted != bl) {
            this.inverted = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public boolean isAutoRange() {
        return this.autoRange;
    }

    public void setAutoRange(boolean bl) {
        this.setAutoRange(bl, true);
    }

    protected void setAutoRange(boolean bl, boolean bl2) {
        if (this.autoRange != bl) {
            this.autoRange = bl;
            if (this.autoRange) {
                this.autoAdjustRange();
            }
            if (bl2) {
                this.notifyListeners(new AxisChangeEvent(this));
            }
        }
    }

    public double getAutoRangeMinimumSize() {
        return this.autoRangeMinimumSize;
    }

    public void setAutoRangeMinimumSize(double d) {
        this.setAutoRangeMinimumSize(d, true);
    }

    public void setAutoRangeMinimumSize(double d, boolean bl) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("NumberAxis.setAutoRangeMinimumSize(double): must be > 0.0.");
        }
        if (this.autoRangeMinimumSize != d) {
            this.autoRangeMinimumSize = d;
            if (this.autoRange) {
                this.autoAdjustRange();
            }
            if (bl) {
                this.notifyListeners(new AxisChangeEvent(this));
            }
        }
    }

    public double getLowerMargin() {
        return this.lowerMargin;
    }

    public void setLowerMargin(double d) {
        this.lowerMargin = d;
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getUpperMargin() {
        return this.upperMargin;
    }

    public void setUpperMargin(double d) {
        this.upperMargin = d;
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getFixedAutoRange() {
        return this.fixedAutoRange;
    }

    public void setFixedAutoRange(double d) {
        this.fixedAutoRange = d;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getLowerBound() {
        return this.range.getLowerBound();
    }

    public void setLowerBound(double d) {
        if (this.range.getUpperBound() > d) {
            this.setRange(new Range(d, this.range.getUpperBound()));
        } else {
            this.setRange(new Range(d, d + 1.0));
        }
    }

    public double getUpperBound() {
        return this.range.getUpperBound();
    }

    public void setUpperBound(double d) {
        if (this.range.getLowerBound() < d) {
            this.setRange(new Range(this.range.getLowerBound(), d));
        } else {
            this.setRange(d - 1.0, d);
        }
    }

    public Range getRange() {
        return this.range;
    }

    public void setRange(Range range) {
        this.setRange(range, true, true);
    }

    public void setRange(Range range, boolean bl, boolean bl2) {
        if (range == null) {
            throw new IllegalArgumentException("Null 'range' argument.");
        }
        if (bl) {
            this.autoRange = false;
        }
        this.range = range;
        if (bl2) {
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public void setRange(double d, double d2) {
        this.setRange(new Range(d, d2));
    }

    public void setRangeWithMargins(Range range) {
        this.setRangeWithMargins(range, true, true);
    }

    public void setRangeWithMargins(Range range, boolean bl, boolean bl2) {
        if (range == null) {
            throw new IllegalArgumentException("Null 'range' argument.");
        }
        this.setRange(Range.expand((Range)range, (double)this.getLowerMargin(), (double)this.getUpperMargin()), bl, bl2);
    }

    public void setRangeWithMargins(double d, double d2) {
        this.setRangeWithMargins(new Range(d, d2));
    }

    public void setRangeAboutValue(double d, double d2) {
        this.setRange(new Range(d - d2 / 2.0, d + d2 / 2.0));
    }

    public boolean isAutoTickUnitSelection() {
        return this.autoTickUnitSelection;
    }

    public void setAutoTickUnitSelection(boolean bl) {
        this.setAutoTickUnitSelection(bl, true);
    }

    public void setAutoTickUnitSelection(boolean bl, boolean bl2) {
        if (this.autoTickUnitSelection != bl) {
            this.autoTickUnitSelection = bl;
            if (bl2) {
                this.notifyListeners(new AxisChangeEvent(this));
            }
        }
    }

    public TickUnitSource getStandardTickUnits() {
        return this.standardTickUnits;
    }

    public void setStandardTickUnits(TickUnitSource tickUnitSource) {
        this.standardTickUnits = tickUnitSource;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public abstract double valueToJava2D(double var1, Rectangle2D var3, RectangleEdge var4);

    public double lengthToJava2D(double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d2 = this.valueToJava2D(0.0, rectangle2D, rectangleEdge);
        double d3 = this.valueToJava2D(d, rectangle2D, rectangleEdge);
        return Math.abs(d3 - d2);
    }

    public abstract double java2DToValue(double var1, Rectangle2D var3, RectangleEdge var4);

    protected abstract void autoAdjustRange();

    public void centerRange(double d) {
        double d2 = this.range.getCentralValue();
        Range range = new Range(this.range.getLowerBound() + d - d2, this.range.getUpperBound() + d - d2);
        this.setRange(range);
    }

    public void resizeRange(double d) {
        this.resizeRange(d, this.range.getCentralValue());
    }

    public void resizeRange(double d, double d2) {
        if (d > 0.0) {
            double d3 = this.range.getLength() * d / 2.0;
            Range range = new Range(d2 - d3, d2 + d3);
            this.setRange(range);
        } else {
            this.setAutoRange(true);
        }
    }

    public void zoomRange(double d, double d2) {
        double d3 = this.range.getLowerBound();
        double d4 = this.range.getLength();
        Range range = null;
        range = this.isInverted() ? new Range(d3 + d4 * (1.0 - d2), d3 + d4 * (1.0 - d)) : new Range(d3 + d4 * d, d3 + d4 * d2);
        this.setRange(range);
    }

    protected int getAutoTickIndex() {
        return this.autoTickIndex;
    }

    protected void setAutoTickIndex(int n) {
        this.autoTickIndex = n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ValueAxis)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ValueAxis valueAxis = (ValueAxis)object;
        if (this.positiveArrowVisible != valueAxis.positiveArrowVisible) {
            return false;
        }
        if (this.negativeArrowVisible != valueAxis.negativeArrowVisible) {
            return false;
        }
        if (this.inverted != valueAxis.inverted) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.range, (Object)valueAxis.range)) {
            return false;
        }
        if (this.autoRange != valueAxis.autoRange) {
            return false;
        }
        if (this.autoRangeMinimumSize != valueAxis.autoRangeMinimumSize) {
            return false;
        }
        if (this.upperMargin != valueAxis.upperMargin) {
            return false;
        }
        if (this.lowerMargin != valueAxis.lowerMargin) {
            return false;
        }
        if (this.fixedAutoRange != valueAxis.fixedAutoRange) {
            return false;
        }
        if (this.autoTickUnitSelection != valueAxis.autoTickUnitSelection) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.standardTickUnits, (Object)valueAxis.standardTickUnits)) {
            return false;
        }
        return this.verticalTickLabels == valueAxis.verticalTickLabels;
    }

    public Object clone() throws CloneNotSupportedException {
        ValueAxis valueAxis = (ValueAxis)super.clone();
        return valueAxis;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeShape((Shape)this.upArrow, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeShape((Shape)this.downArrow, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeShape((Shape)this.leftArrow, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeShape((Shape)this.rightArrow, (ObjectOutputStream)objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.upArrow = SerialUtilities.readShape((ObjectInputStream)objectInputStream);
        this.downArrow = SerialUtilities.readShape((ObjectInputStream)objectInputStream);
        this.leftArrow = SerialUtilities.readShape((ObjectInputStream)objectInputStream);
        this.rightArrow = SerialUtilities.readShape((ObjectInputStream)objectInputStream);
    }
}

